package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol;


import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.RevenueServerConst;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Optional;

/**
 * Created by ouyangshaocong on 2018/7/19.
 * <p>
 * YY.Inc
 */
public class ChargeCurrencyResponse implements IBaseJsonResponse {
    public int cmd = RevenueServerConst.ChargeCurrencyResponse;
    public int appid;
    public long uid;
    public String seq;
    public int usedChannel;
    public int result;
    public String orderId;
    public String payUrl;
    public String traceId;
    public String expand;
    public String payChannel;
    public String payMethod;
    public String closeRiskEnhance;

    /**
     * 构造函数
     *
     * @param jsonMsg
     */
    public ChargeCurrencyResponse(String jsonMsg) {
        parserResponse(jsonMsg);
    }

    @Override
    public void parserResponse(String jsonMsg) {
        if (null == jsonMsg || "".equals(jsonMsg.trim())) {
            RLog.error("ChargeCurrencyResponse", "parserResponse error, jsonMsg is empty.");
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonMsg);
            int cmd = jsonObject.optInt("cmd");
            if (this.cmd != cmd) {
                throw new Exception(this.cmd + " != " + cmd);
            }
            this.appid = jsonObject.optInt("appid");
            this.uid = jsonObject.optLong("uid");
            this.seq = jsonObject.optString("seq");
            this.usedChannel = jsonObject.optInt("usedChannel");
            this.result = jsonObject.optInt("result");
            this.orderId = jsonObject.optString("orderId");
            this.payUrl = jsonObject.optString("payUrl");
            this.traceId = jsonObject.optString("traceId");
            this.expand = jsonObject.optString("expand");
            this.payChannel = jsonObject.optString("payChannel");
            this.payMethod = jsonObject.optString("payMethod");
            this.closeRiskEnhance = jsonObject.optString("closeRiskEnhance");

            RLog.info("ChargeCurrencyResponse", "jsonObject", jsonObject);
        } catch (JSONException e) {
            RLog.error("ChargeCurrencyResponse", "parserResponse error.", e);
        } catch (Exception e) {
            RLog.error("ChargeCurrencyResponse", "parserResponse error.", e);
        }
    }
}
