package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.RevenueServerConst;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.request.IRequestProtocol;

import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by ouyangshaocong on 2018/7/19.
 * <p>
 * YY.Inc
 */
public class ChargeCurrencyRequest implements IRequestProtocol {
    public long uid;
    public int sid = 0; //不可为空，频道外传0
    public int appId;
    public int usedChannel = 10002; //暂定IOS：10001、Android：10002
    public int currencyType; //充值货币类型：1-紫水晶,13-钻石
    public String seq;
    //payChannel和payMethod说明：
    //支付宝渠道SDK方式：chId：Zfb, payMethod：WapApp
    //银联渠道方式：chId：Unionpay, payMethod：Wap / WapAdvance
    //微信SDK ：chId: Weixin , payMethod: WapApp
    //苹果：chId：Apple, payMethod：Balance
    //Y币： chId:YB ,payMethod: Balance
    public String payChannel; //支付渠道
    public String payMethod; //支付方式
    public double amount; //支付的人民币额度，以元为单位
    public int chargeCurrencyConfigId = 0; //充值配置id,不可为空,自定义充值金额时传0
    public boolean needUnicast = true; //是否在充值成功之后发送单播，默认为true
    public String returnUrl = ""; // 如果有自定，那么支付成功后从第三方支付（入支付宝）跳转展示的成功页面
    public String expand = "";
    //苹果充值需要传凭证过来，放在expand字段中，格式如：{"quantity":"1","unitPrice":30,"receipt-data":"****","product_id":"com.yy.mf.21000"}
    public String clientVersion = ""; // 客户端版本
    // public String ticket = "";

    /**
     * 构造函数
     *
     * @param appId
     * @param currencyType
     * @param seq
     * @param payChannel
     * @param payMethod
     * @param amount
     */
    public ChargeCurrencyRequest(int appId, int currencyType, String seq, String payChannel,
                                 String payMethod, double amount) {
        this(0, appId, currencyType, seq, payChannel, payMethod, amount);
    }

    /**
     * 构造函数
     *
     * @param uid
     * @param appId
     * @param currencyType
     * @param seq
     * @param payChannel
     * @param payMethod
     * @param amount
     */
    public ChargeCurrencyRequest(int uid, int appId, int currencyType, String seq,
                                 String payChannel, String payMethod, double amount) {
        this(uid, 0, appId, 10002, currencyType, seq, payChannel, payMethod, amount, 0, true, "",
                "", "1.0.0", "");
    }

    /**
     * 构造函数
     *
     * @param uid
     * @param sid
     * @param appId
     * @param usedChannel
     * @param currencyType
     * @param seq
     * @param payChannel
     * @param payMethod
     * @param amount
     * @param chargeCurrencyConfigId
     * @param needUnicast
     * @param returnUrl
     * @param expand
     */
    public ChargeCurrencyRequest(long uid, int sid, int appId, int usedChannel, int currencyType,
                                 String seq,
                                 String payChannel, String payMethod, double amount,
                                 int chargeCurrencyConfigId,
                                 boolean needUnicast, String returnUrl, String expand,
                                 String clientVersion, String ticket) {
        this.uid = uid;
        this.sid = sid;
        this.appId = appId;
        this.usedChannel = usedChannel;
        this.currencyType = currencyType;
        this.seq = seq;
        this.payChannel = payChannel;
        this.payMethod = payMethod;
        this.amount = amount;
        this.chargeCurrencyConfigId = chargeCurrencyConfigId;
        this.needUnicast = needUnicast;
        this.returnUrl = returnUrl;
        this.expand = expand;
        this.clientVersion = clientVersion;
        // this.ticket = ticket;
    }

    @NotNull
    @Override
    public String getProtocol() {
        String jsonMsg = "";
        JSONObject jMsg = new JSONObject();
        try {
            jMsg.put("cmd", RevenueServerConst.ChargeCurrencyRequest);
            jMsg.put("uid", uid);
            jMsg.put("sid", sid);
            jMsg.put("appId", appId);
            jMsg.put("usedChannel", usedChannel);
            jMsg.put("currencyType", currencyType);
            jMsg.put("seq", seq);
            jMsg.put("payChannel", payChannel);
            jMsg.put("payMethod", payMethod);
            jMsg.put("amount", amount);
            jMsg.put("chargeCurrencyConfigId", chargeCurrencyConfigId);
            jMsg.put("needUnicast", needUnicast);
            jMsg.put("returnUrl", returnUrl);
            jMsg.put("expand", expand);
            jMsg.put("clientVersion", clientVersion);
            // jMsg.put("ticket", ticket);
            jsonMsg = jMsg.toString();
        } catch (JSONException e) {
            RLog.error("ChargeCurrencyRequest", "constructPSCIMessageRequest", e);
        }
        return jsonMsg;
    }

    /**
     * expand字段构造
     */
    public static class ExpandBuilder {
        final int quantity;
        final Double unitPrice;
        final String product_id;
        final String hdid;
        final String srcCurrencySymbol;

        /**
         * 构造函数
         *
         * @param quantity
         * @param unitPrice
         * @param product_id
         * @param hdid
         */
        public ExpandBuilder(int quantity, Double unitPrice, String product_id, String hdid,
                             String srcCurrencySymbol) {
            this.quantity = quantity;
            this.unitPrice = unitPrice;
            this.product_id = product_id;
            this.hdid = hdid;
            this.srcCurrencySymbol = srcCurrencySymbol;
        }

        /**
         * 返回json字符串
         *
         * @return
         */
        public String toJson() {
            JSONObject expand = new JSONObject();
            try {
                expand.put("quantity", quantity);
                expand.put("unitPrice", unitPrice);
                expand.put("product_id", product_id);
                expand.put("hdid", hdid);
                expand.put("srcCurrencySymbol", srcCurrencySymbol);
            } catch (JSONException e) {
                RLog.error("ChargeCurrencyRequest", "ExpandBuilder.toJson", e);
            }
            return expand.toString();
        }
    }
}
