package com.yy.mobile.framework.revenuesdk.payservice;

import android.app.Activity;
import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;

import com.platform.riskcontrol.sdk.core.IVerifyResult;
import com.platform.riskcontrol.sdk.core.RiskImpl;
import com.platform.riskcontrol.sdk.core.constant.ErrorCode;
import com.platform.riskcontrol.sdk.core.log.ILog;
import com.yy.mobile.framework.revenuesdk.baseapi.IResult;
import com.yy.mobile.framework.revenuesdk.baseapi.IToken;
import com.yy.mobile.framework.revenuesdk.baseapi.PayCallBackBean;
import com.yy.mobile.framework.revenuesdk.baseapi.data.IRevenueDataReceiver;
import com.yy.mobile.framework.revenuesdk.baseapi.data.IRevenueDataSender;
import com.yy.mobile.framework.revenuesdk.baseapi.log.CloudLogHelper;
import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.PSCIMessageBroadcast;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.PSCIMessageResponse;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.PSCIMessageUnicast;
import com.yy.mobile.framework.revenuesdk.baseapi.reporter.EventAlias;
import com.yy.mobile.framework.revenuesdk.baseapi.reporter.EventType;
import com.yy.mobile.framework.revenuesdk.baseapi.reporter.HiidoReport;
import com.yy.mobile.framework.revenuesdk.baseapi.reporter.IReporter;
import com.yy.mobile.framework.revenuesdk.baseapi.router.RouterInfo;
import com.yy.mobile.framework.revenuesdk.baseapi.router.RouterInfoCenter;
import com.yy.mobile.framework.revenuesdk.baseapi.utils.PageIdUtil;
import com.yy.mobile.framework.revenuesdk.baseapi.utils.ThreadPool;
import com.yy.mobile.framework.revenuesdk.baseapi.utils.TraceIdUtil;
import com.yy.mobile.framework.revenuesdk.payapi.IAppPayService;
import com.yy.mobile.framework.revenuesdk.payapi.IAppPayServiceListener;
import com.yy.mobile.framework.revenuesdk.payapi.IHandPayCallBack;
import com.yy.mobile.framework.revenuesdk.payapi.IPayCallback;
import com.yy.mobile.framework.revenuesdk.payapi.PayType;
import com.yy.mobile.framework.revenuesdk.baseapi.PurchaseStatus;
import com.yy.mobile.framework.revenuesdk.payapi.PurchaseStatusImpl;
import com.yy.mobile.framework.revenuesdk.payapi.bean.AccountDelayMessage;
import com.yy.mobile.framework.revenuesdk.payapi.bean.ConsumeConfirmMessage;
import com.yy.mobile.framework.revenuesdk.payapi.bean.CurrencyChargeMessage;
import com.yy.mobile.framework.revenuesdk.payapi.bean.ProductInfo;
import com.yy.mobile.framework.revenuesdk.payapi.bean.PurchaseInfo;
import com.yy.mobile.framework.revenuesdk.payapi.bean.PurchaseStatusInfo;
import com.yy.mobile.framework.revenuesdk.payapi.bean.SkuDetailInfo;
import com.yy.mobile.framework.revenuesdk.payapi.callbackresult.CouponDiscountResult;
import com.yy.mobile.framework.revenuesdk.payapi.callbackresult.ExchangeResult;
import com.yy.mobile.framework.revenuesdk.payapi.callbackresult.HasChargeInActivityResult;
import com.yy.mobile.framework.revenuesdk.payapi.callbackresult.MyBalanceResult;
import com.yy.mobile.framework.revenuesdk.payapi.callbackresult.PayOrderResult;
import com.yy.mobile.framework.revenuesdk.payapi.callbackresult.ProductListResult;
import com.yy.mobile.framework.revenuesdk.payapi.callbackresult.RechargeHistoryResult;
import com.yy.mobile.framework.revenuesdk.payapi.callbackresult.ReportPurchaseResult;
import com.yy.mobile.framework.revenuesdk.payapi.callbackresult.RevenueRecordResult;
import com.yy.mobile.framework.revenuesdk.payapi.callbackresult.UserCouponStoreResult;
import com.yy.mobile.framework.revenuesdk.payapi.payservice.IPayMethod;
import com.yy.mobile.framework.revenuesdk.payapi.reporter.IPayReporter;
import com.yy.mobile.framework.revenuesdk.payapi.request.ChargeCurrencyReqParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.DoHangPayJobReqParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.ExchangeCurrencyReqParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.GetChargeCouponDiscountReqParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.GetHasChargeInActivityReqParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.GetUserCouponStoreParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.QueryCurrencyChannelsReqParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.QueryCurrencyReqParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.QueryRechargeHistoryReqParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.QueryUserAccountHistoryReqParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.ReportPurchaseReqParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.RequestParams;
import com.yy.mobile.framework.revenuesdk.payservice.reporter.DefaultPayReporter;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.IRevenueService;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.RevenueServerConst;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.RevenueService;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol.GetChargeCurrencyConfigResponse;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.request.IRequest;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.response.IResponse;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

/**
 * Created by lhf on 2018/7/9.
 * <p>
 * YY.Inc
 */
public class AppPayServiceImpl
        implements IAppPayService, IRevenueDataReceiver, IRevenueService.IRevenueServiceListener {
    private static final String TAG = "AppPayServiceImpl";
    int appId;
    int mUsedChannel;
    String mCountryCode = "";
    private String mDefalutServiceName = "";
    private String mDefalutFunctionName = "";
    //final private HandlerThread mHandlerThread = new HandlerThread("AppPayServiceImpl");
    private RevenueService revenueService;
    private IPayReporter iPayReporter;
    private List<IAppPayServiceListener> listeners = new ArrayList<>();
    private String mPageId = "";
    private boolean mIsOpenRisk = false;
    private String mClientVer = "";

    /**
     * 构造函数
     *
     * @param appId
     */
    public AppPayServiceImpl(int appId, int usedChannel, String country, String clientVer,
                             String serviceName, String functionName, boolean requestReuse,
                             boolean isOpenRisk,
                             IRevenueDataSender iDataSender, IReporter iReporter) {
        this.appId = appId;
        this.mUsedChannel = usedChannel;
        mCountryCode = country;
        mClientVer = clientVer;
        mDefalutServiceName = serviceName;
        mDefalutFunctionName = functionName;
        revenueService = new RevenueService(appId, iDataSender, this, requestReuse);
        iPayReporter = new DefaultPayReporter(iReporter, clientVer, country);
        mIsOpenRisk = isOpenRisk;
    }

    @Nullable
    private <T> T getResponseData(Class<T> klass, @NotNull IResponse response) {
        Object result = response.getResponseData();
        if (result != null) {
            return klass.cast(result);
        }
        return null;
    }

    //获取充值列表回调.
    private void onQueryProductList(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        ProductListResult result = getResponseData(ProductListResult.class, response);

        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();

        if (iRequest != null /*&& result != null*/) {
            RequestParams req = (RequestParams) iRequest.getExtParam();
            doQueryProductListHiidoCommon(reportResponse, iRequest, req);
            if (response.isSuccess() && result != null) {
                RLog.info(TAG, "onQueryProductList success");
                onSuccess(req, result, null);
                if (iPayReporter != null) {
                    reportResponse.mEventId = EventType.PayEventID.QUERY_PRODUCT_LIST_SUCCESS;
                    reportResponse.mEventaliae =
                            EventAlias.PayEventAlias.QUERY_PRODUCT_LIST_SUCCESS;
                    reportResponse.mErrCode = response.getResponseCode() + "";
                    reportResponse.mErrMsg = "queryProductList success!" + response.getMessage();
                    iPayReporter.onQueryProductList(reportResponse);
                }

            } else {
                RLog.error(TAG, "onQueryProductList fail code = %d, errMsg = %s",
                        response.getResponseCode(),
                        response.getMessage());
                onFail(iRequest.getReqSeq(), response.getResponseCode(), response.getMessage(),
                        req.getCallback(), null);
                if (iPayReporter != null) {
                    reportResponse.mEventId = EventType.PayEventID.QUERY_PRODUCT_LIST_FAIL;
                    reportResponse.mEventaliae =
                            EventAlias.PayEventAlias.QUERY_PRODUCT_LIST_FAIL;
                    reportResponse.mErrCode = response.getResponseCode() + "";
                    reportResponse.mErrMsg = "queryProductList fail!" + response.getMessage();
                    iPayReporter.onQueryProductList(reportResponse);
                }
            }
        }
    }

    //获取充值列表回调（批量）.
    private void onQueryProductListChannels(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        ProductListResult result = getResponseData(ProductListResult.class, response);
        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        if (iRequest != null /*&& result != null*/) {
            RequestParams req = (RequestParams) iRequest.getExtParam();
            doQueryProductListHiidoCommon(reportResponse, iRequest, req);
            if (response.isSuccess() && result != null) {
                RLog.info(TAG, "onQueryProductChannelsList success");
                onSuccess(req, result, null);
                if (iPayReporter != null) {
                    reportResponse.mEventId = EventType.PayEventID.QUERY_PRODUCT_LIST_SUCCESS;
                    reportResponse.mEventaliae =
                            EventAlias.PayEventAlias.QUERY_PRODUCT_LIST_SUCCESS;
                    reportResponse.mErrCode = response.getResponseCode() + "";
                    reportResponse.mErrMsg =
                            "onQueryProductListChannels success!" + response.getMessage();
                    iPayReporter.onQueryProductList(reportResponse);
                }
            } else {
                RLog.error(TAG, "onQueryProductChannelsList fail code = %d, errMsg = %s",
                        response.getResponseCode(),
                        response.getMessage());
                onFail(iRequest.getReqSeq(), response.getResponseCode(), response.getMessage(),
                        req.getCallback(), null);
                if (iPayReporter != null) {
                    reportResponse.mEventId = EventType.PayEventID.QUERY_PRODUCT_LIST_FAIL;
                    reportResponse.mEventaliae =
                            EventAlias.PayEventAlias.QUERY_PRODUCT_LIST_FAIL;
                    reportResponse.mErrCode = response.getResponseCode() + "";
                    reportResponse.mErrMsg =
                            "onQueryProductListChannels fail!" + response.getMessage();
                    iPayReporter.onQueryProductList(reportResponse);
                }
            }
        }
    }

    private void doQueryProductListHiidoCommon(
            HiidoReport.CReportResponse reportResponse, IRequest iRequest, RequestParams req) {
        if (reportResponse != null && iRequest != null && req != null) {
            long delay = System.currentTimeMillis() - req.getRequestTime();
            reportResponse.mDelay = delay + "";
            RouterInfo routerInfo = null;
            Context context = req.getContext();
            if (context != null) {
                int cmd = iRequest.getReqCommand();
                RLog.info("AppPayServiceImpl", "doQueryProductListHiidoReport---getRouterInfo  " +
                        "cmd:" + req.getCmd() + "iRequest.getReqCommand:" + cmd);
                routerInfo = RouterInfoCenter.getRouterInfo(context.getApplicationContext(),
                        cmd);
            } else {
                RLog.error("AppPayServiceImpl", "doQueryProductListHiidoReport---context = null:");
            }
            if (routerInfo == null) {
                reportResponse.mServiceName = mDefalutServiceName;
                reportResponse.mFunctionName = mDefalutFunctionName;
            } else {
                reportResponse.mServiceName = routerInfo.serviceName;
                reportResponse.mFunctionName = routerInfo.functionName;
            }
            reportResponse.mPageId = mPageId;
            reportResponse.mConfigTraceId = req.getTraceid();
        }
    }

    private void onGetUserCouponStore(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        UserCouponStoreResult result = getResponseData(UserCouponStoreResult.class, response);
        if (iRequest != null /*&& result != null*/) {
            RequestParams req = (RequestParams) iRequest.getExtParam();
            if (response.isSuccess() && result != null) {
                RLog.info(TAG, "onGetUserCouponStore success");
                onSuccess(req, result, null);
            } else {
                RLog.error(TAG, "onGetUserCouponStore fail code = %d, errMsg = %s",
                        response.getResponseCode(),
                        response.getMessage());
                onFail(iRequest.getReqSeq(), response.getResponseCode(), response.getMessage(),
                        req.getCallback(), null);
            }
        }
    }

    private void onGetChargeCouponDiscount(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        CouponDiscountResult result = getResponseData(CouponDiscountResult.class, response);
        if (iRequest != null /*&& result != null*/) {
            RequestParams req = (RequestParams) iRequest.getExtParam();
            if (response.isSuccess() && result != null) {
                RLog.info(TAG, "onGetChargeCouponDiscount success");
                onSuccess(req, result, null);
            } else {
                RLog.error(TAG, "onGetChargeCouponDiscount fail code = %d, errMsg = %s",
                        response.getResponseCode(),
                        response.getMessage());
                onFail(iRequest.getReqSeq(), response.getResponseCode(), response.getMessage(),
                        req.getCallback(), null);
            }
        }
    }

    private void onGetHasChargeInActivity(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        HasChargeInActivityResult result =
                getResponseData(HasChargeInActivityResult.class, response);
        if (iRequest != null /*&& result != null*/) {
            RequestParams req = (RequestParams) iRequest.getExtParam();
            if (response.isSuccess() && result != null) {
                RLog.info(TAG, "onGetHasChargeInActivity success");
                onSuccess(req, result, null);
            } else {
                RLog.error(TAG, "onGetHasChargeInActivity fail code = %d, errMsg = %s",
                        response.getResponseCode(),
                        response.getMessage());
                onFail(iRequest.getReqSeq(), response.getResponseCode(), response.getMessage(),
                        req.getCallback(), null);
            }
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
    }

    //下单成功回调.
    private void onOrderProduct(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        PayOrderResult result = getResponseData(PayOrderResult.class, response);
        if (iRequest != null /*&& result != null*/) {
            final ChargeCurrencyReqParams req = (ChargeCurrencyReqParams) iRequest.getExtParam();
            HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
            long delay = 0;
            if (req != null) {
                reportResponse.mPaysource = req.getFrom();
                reportResponse.mUid = req.getUid();
                delay = System.currentTimeMillis() - req.getRequestTime();
                reportResponse.mDelay = delay + "";

                RouterInfo routerInfo = null;
                Context context = req.getContext();
                if (context != null) {
                    int cmd = iRequest.getReqCommand();
                    RLog.info("AppPayServiceImpl", "onOrderProduct---getRouterInfo  " +
                            "cmd:" + req.getCmd() + "iRequest.getReqCommand:" + cmd);
                    if (cmd == 0) {
                        cmd = 1022;
                    }
                    routerInfo = RouterInfoCenter.getRouterInfo(context.getApplicationContext(),
                            cmd);
                } else {
                    RLog.error("AppPayServiceImpl", "onOrderProduct---context = null:");
                }
                if (routerInfo == null) {
                    reportResponse.mServiceName = mDefalutServiceName;
                    reportResponse.mFunctionName = mDefalutFunctionName;
                } else {
                    reportResponse.mServiceName = routerInfo.serviceName;
                    reportResponse.mFunctionName = routerInfo.functionName;
                }
            }

            RLog.info("AppPayServiceImpl",
                    "onOrderProduct---mDefalutServiceName:" + mDefalutServiceName
                            + "---mDefalutFunctionName:" + mDefalutFunctionName
                            + "---mRealFunctionName:" + reportResponse.mServiceName
                            + "---mRealFunctionName:" + reportResponse.mFunctionName
            );

            if (result != null) {
                reportResponse.mOrderId = result.getOrderId();
            }

            if (req != null && result != null) {
                String challengeExpand = getChallengeExtension(result.getExpand());
                if (challengeExpand != null && !challengeExpand.equals("")) {
                    final long delayInner = delay;
                    RiskImpl.getRiskImpl().showVerifyViewWithInfoString(
                            challengeExpand,
                            new IVerifyResult<String>() {
                                @Override
                                public void onVerifyResult(String verifytoken, int code) {
                                    //业务根据挑战结果自行处理
                                    if (code == ErrorCode.SDK.SUCCESS) {
                                        IRequest request =
                                                revenueService.obtainRequest(
                                                        RevenueServerConst.ChargeCurrencyRequest,
                                                        req);
                                        request.setExtParam(req);
                                        revenueService.sendRequest(request);
                                    } else {

                                        int riskFailCode;
                                        switch (code) {
                                            case ErrorCode.SDK.FAIL:
                                                riskFailCode =
                                                        com.yy.mobile.framework.revenuesdk.baseapi.ErrorCode.RISK_FAIL;
                                                break;
                                            case ErrorCode.SDK.CANCEL:
                                                riskFailCode =
                                                        com.yy.mobile.framework.revenuesdk.baseapi.ErrorCode.RISK_USER_CANCEL;
                                                break;
                                            case ErrorCode.SDK.PARAMS_ERROR:
                                                riskFailCode =
                                                        com.yy.mobile.framework.revenuesdk.baseapi.ErrorCode.RISK_PARAMS_ERROR;
                                                break;
                                            case ErrorCode.SDK.ALREADY_CHALLENGED:
                                                riskFailCode =
                                                        com.yy.mobile.framework.revenuesdk.baseapi.ErrorCode.RISK_ALREADY_CHALLENGED;
                                                break;
                                            default:
                                                riskFailCode =
                                                        com.yy.mobile.framework.revenuesdk.baseapi.ErrorCode.RISK_FAIL;
                                                break;
                                        }

                                        RLog.error(TAG, "onOrderProduc -- order fail！trigger " +
                                                        "risk,but verify fail! verify fail code = %d, " +
                                                        "code = %d, errMsg = %s",
                                                code,
                                                response.getResponseCode(),
                                                response.getMessage());

                                        PayCallBackBean backBean =
                                                new PayCallBackBean(null, req.getProductId(), null,
                                                        req.getRequestTime(), null,
                                                        null, null, null,
                                                        PurchaseStatus.ORDER_FAIL);

                                        onFail(iRequest.getReqSeq(), riskFailCode,
                                                "order fail！trigger risk,but verify fail! verify " +
                                                        "fail code:" + code,
                                                req.getCallback(), backBean);
                                    }
                                }
                            });
                } else {
                    dealOnOrderInter(response, req, result, iRequest,
                            reportResponse, delay);
                }
            }

        }
    }

    private void dealOnOrderInter(IResponse response, ChargeCurrencyReqParams req,
                                  PayOrderResult result, IRequest iRequest,
                                  HiidoReport.CReportResponse reportResponse, long delay) {

        if (response.isSuccess() && req != null && result != null) {
            RLog.info(TAG, "onOrderProduct --- order sucess! orderid = %s ,uid = %s , mDelay " +
                    "= %d" +
                    "", result.getOrderId(), req.getUid(), delay);
            String payload = result.getPayUrl();
            String chOrderid = getChOrderidByPayload(payload);
            PayCallBackBean backBean = new PayCallBackBean(result.getOrderId(),
                    req.getProductId(), null, req.getRequestTime(), chOrderid, payload,
                    null, null, PurchaseStatus.ORDER_SUCCESS);
            if (req.getPayType() == PayType.PAYTM_PAY) {  //payTm方式只需要下单返回payload交给h5处理
                if (Looper.myLooper() == Looper.getMainLooper()) {
                    ((IPayCallback<PayOrderResult>) req.getCallback())
                            .onSuccess(result, backBean);
                } else {
                    ThreadPool.getDefault().mainThreadIO().execute(() ->
                            ((IPayCallback<PayOrderResult>) req.getCallback())
                                    .onSuccess(result, backBean));
                }
            } else {

                //保存订单状态
                if (req.getPayType() == PayType.GOOGLE_PLAY) {
                    PurchaseStatusInfo purchaseStatusInfo = new PurchaseStatusInfo();
                    purchaseStatusInfo.uid = req.getUid();
                    purchaseStatusInfo.status = PurchaseStatus.ORDER_SUCCESS.getCode();
                    purchaseStatusInfo.chorderid = getCHOrderId(payload);
                    purchaseStatusInfo.productId = req.getProductId();
                    purchaseStatusInfo.orderId = result.getOrderId();
                    PurchaseStatusImpl
                            .savePurchaseStatus(req.getContext(), purchaseStatusInfo);
                }

                boolean isSetAccountId = true;
                String closeRiskEnhance = result.getCloseRiskEnhance();
                if (closeRiskEnhance != null && closeRiskEnhance.equals("true")) {
                    isSetAccountId = false;
                }
                IPayCallback callback = (IPayCallback) req.getCallback();
                if (callback != null) {
                    callback.onPayStatus(PurchaseStatus.ORDER_SUCCESS, backBean);
                }
                //GP支付完还得走上报逻辑 所以这里PayCallbackProxy打断下支付的回调
                //用来处理下接下来的上报逻辑.
                requestPay(req.getContext(), req, req.getPayType(),
                        req.getProductId(), payload, isSetAccountId,
                        new PayCallbackProxy(req.getPayType(), result.getOrderId(), req,
                                payload, callback));

            }
            if (iPayReporter != null) {
                reportResponse.mEventId = EventType.PayEventID.ORDER_SUCCESS;
                reportResponse.mEventaliae = EventAlias.PayEventAlias.ORDER_SUCCESS;
                reportResponse.mErrCode = response.getResponseCode() + "";
                reportResponse.mErrMsg = "order success!" + response.getMessage();
                iPayReporter.onOrderResult(reportResponse);
            }
        } else {

            if (req != null && result != null) {
                RLog.error(TAG, "onOrderProduct -- order fail! orderid = %s ,uid = %s , " +
                                "mDelay = %d, code = %d, errMsg = %s" +
                                "", result.getOrderId(), req.getUid(), delay,
                        response.getResponseCode(),
                        response.getMessage());
            } else {
                RLog.error(TAG, "onOrderProduc -- order fail ! code = %d, errMsg = %s",
                        response.getResponseCode(),
                        response.getMessage());
            }

            PayCallBackBean backBean =
                    new PayCallBackBean(null, req.getProductId(), null, req.getRequestTime(),
                            null, null, null, null, PurchaseStatus.ORDER_FAIL);
            if (req.getPayType() == PayType.PAYTM_PAY) {  //payTm方式只需要下单返回payload交给h5处理
                if (Looper.myLooper() == Looper.getMainLooper()) {
                    ((IPayCallback<PayOrderResult>) req.getCallback())
                            .onFail(response.getResponseCode(),
                                    "order fail, fialReason:" + response.getMessage(), null);
                } else {
                    ThreadPool.getDefault().mainThreadIO().execute(() ->
                            ((IPayCallback<PayOrderResult>) req.getCallback())
                                    .onFail(response.getResponseCode(),
                                            "order fail, fialReason:"
                                                    + response.getMessage(), backBean));
                }
            }

            if (req != null) {
                IPayCallback callback = (IPayCallback) req.getCallback();
                if (callback != null) {
                    callback.onPayStatus(PurchaseStatus.ORDER_FAIL, backBean);
                }
            }
            onFail(iRequest.getReqSeq(), response.getResponseCode(),
                    "order fial, fialReason:" + response.getMessage(),
                    req.getCallback(), backBean);
            if (iPayReporter != null) {
                reportResponse.mEventId = EventType.PayEventID.ORDER_FAIL;
                reportResponse.mEventaliae = EventAlias.PayEventAlias.ORDER_FAIL;
                reportResponse.mErrCode = response.getResponseCode() + "";
                reportResponse.mErrMsg = "order fial, fialReason:" + response.getMessage();
                iPayReporter.onOrderResult(reportResponse);
                reportResponse.mEventId = EventType.PaySummaryEventID.SUMMARY_PURCHASE_FAIL;
                reportResponse.mEventaliae =
                        EventAlias.PaySummaryEventAlias.SUMMARY_PURCHASE_FAIL;
                iPayReporter.onPurchaseSummaryResult(reportResponse);
            }
            String logCloud = "";
            if (result != null) {
                logCloud = combiCloudLogString(response.getResponseCode(),
                        "order fial, fialReason:" + response.getMessage(),
                        req.toString(), result.toString());
            } else {
                logCloud = combiCloudLogString(response.getResponseCode(),
                        "order fial, fialReason:" + response.getMessage(),
                        req.toString(), "");
            }
            CloudLogHelper.sendLog("onOrderProduct", logCloud);  //上报阿里云
        }
    }

    //查询个人账户信息回调.
    private void onQueryUserAccount(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        MyBalanceResult result = getResponseData(MyBalanceResult.class, response);
        if (iRequest != null /*&& result != null*/) {
            RequestParams req = (RequestParams) iRequest.getExtParam();
            if (response.isSuccess() && result != null) {
                onSuccess(req, result, null);
                RLog.info(TAG, "onQueryUserAccount success");
            } else {
                RLog.error(TAG, "onQueryUserAccount fail code = %d, errMsg = %s",
                        response.getResponseCode(),
                        response.getMessage());
                onFail("", response.getResponseCode(), response.getMessage(), req.getCallback(),
                        null);
            }
        }
    }

    //获取用户充值历史记录.
    private void onQueryUserAccountHistory(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        RevenueRecordResult result = getResponseData(RevenueRecordResult.class, response);
        if (iRequest != null /*&& result != null*/) {
            RequestParams req = (RequestParams) iRequest.getExtParam();
            if (response.isSuccess() && result != null) {
                RLog.info(TAG, "onQueryUserAccountHistory success");
                onSuccess(req, result, null);
            } else {
                RLog.error(TAG, "onQueryUserAccountHistory fail code = %d, errMsg = %s",
                        response.getResponseCode(),
                        response.getMessage());
                onFail("", response.getResponseCode(), response.getMessage(), req.getCallback(),
                        null);
            }
        }
    }

    private void onReportPurchase(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        ReportPurchaseResult result = getResponseData(ReportPurchaseResult.class, response);
        if (iRequest != null && result != null) {
            ReportPurchaseReqParams req = (ReportPurchaseReqParams) iRequest.getExtParam();
            HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
            long delay = 0L;
            String orderId = "";
            String chorderid = "";
            String payload = "";
            long uid = 0L;
            long purchaseTime = 0L;
            String gpOrderId = "";
            if (req != null) {
                purchaseTime = getPurchaseTime(req.getData());
                gpOrderId = getGPOrderId(req.getData());
                chorderid = getCHOrderId(req.getData());
                payload = getPayLoad(req.getData());

                delay = System.currentTimeMillis() - req.getRequestTime();
                reportResponse.mPurchaseTime = purchaseTime + "";
                reportResponse.mGPOrderId = gpOrderId;
                reportResponse.mPaysource = req.getFrom();
                reportResponse.mUid = req.getUid();
                reportResponse.mDelay = delay + "";
                reportResponse.mPayTraceId = req.getTraceid();
                reportResponse.mPageId = mPageId;
                orderId = req.getOrderId();
                uid = req.getUid();
                reportResponse.mOrderId = req.getOrderId();
                RouterInfo routerInfo = null;
                Context context = req.getContext();
                if (context != null) {
                    int cmd = iRequest.getReqCommand();
                    RLog.info("AppPayServiceImpl", "onReportPurchase---getRouterInfo  " +
                            "req.getCmd:" + req.getCmd() + "iRequest.getReqCommand:" + cmd);
                    if (cmd == 0) {
                        cmd = 1045;
                    }
                    routerInfo = RouterInfoCenter.getRouterInfo(context.getApplicationContext(),
                            cmd);
                }
                if (routerInfo == null) {
                    reportResponse.mServiceName = mDefalutServiceName;
                    reportResponse.mFunctionName = mDefalutFunctionName;
                } else {
                    reportResponse.mServiceName = routerInfo.serviceName;
                    reportResponse.mFunctionName = routerInfo.functionName;
                }
                RLog.info("AppPayServiceImpl",
                        "onReportPurchase---mDefalutServiceName:" + mDefalutServiceName
                                + "---mDefalutFunctionName:" + mDefalutFunctionName
                                + "---mRealFunctionName:" + reportResponse.mServiceName
                                + "---mRealFunctionName:" + reportResponse.mFunctionName
                );

                RLog.info(TAG, "onReportPurchase-reportResult - " +
                        "delay = %s, orderid = %s, uid = %s, purchaseTime = %s, gpOrderId = %s" +
                        "", delay, req.getOrderId(), req.getUid(), purchaseTime, gpOrderId);
            }
            final String orderIdReport = orderId;
            final long uidReport = uid;
            final String gpOrderIdReport = gpOrderId;
            final long purchaseTimeReport = purchaseTime;
            final String chorderidReport = chorderid;
            final String payloadReport = payload;

            if ((response.isSuccess() || response.getResponseCode() == -20) && result != null &&
                    req != null) {

                //保存订单状态
                if (req.getPayType() == PayType.GOOGLE_PLAY) {
                    PurchaseStatusInfo purchaseStatusInfo = new PurchaseStatusInfo();
                    purchaseStatusInfo.uid = req.getUid();
                    purchaseStatusInfo.status = PurchaseStatus.REPORT_SUCCESS.getCode();
                    purchaseStatusInfo.productId = req.getProductid();
                    purchaseStatusInfo.chorderid = chorderidReport;
                    purchaseStatusInfo.orderId = orderId;
                    purchaseStatusInfo.purchaseData = result.getPurchaseData();
                    purchaseStatusInfo.purchaseSign = result.getPurchaseSign();
                    PurchaseStatusImpl
                            .savePurchaseStatus(req.getContext(), purchaseStatusInfo);
                }

                PayCallBackBean payCallBackBean =
                        new PayCallBackBean(orderId, req.getProductid(), gpOrderId, purchaseTime,
                                chorderidReport, payloadReport, result.getPurchaseData(),
                                result.getPurchaseSign(),
                                PurchaseStatus.REPORT_SUCCESS);
                if (req.getCallback() instanceof IPayCallback) {
                    IPayCallback callback = (IPayCallback) req.getCallback();
                    callback.onPayStatus(PurchaseStatus.REPORT_SUCCESS, payCallBackBean);
                }
                RLog.info(TAG, "onReportPurchase-reportResult: success  " +
                                "orderid= %s ,delay = %s ,uid = %s, purchaseTime = %s, " +
                                "gpOrderId = %s ， SubscriptionType = %s",
                        req.getOrderId(), delay, req.getUid(), purchaseTime, gpOrderId,
                        req.getSubscriptionType());

                if (response.getResponseCode() == -20) {
                    //   onSuccess(req, "already reported! consumeOrder directly，code = -20!");
                    onFail("", response.getResponseCode(),
                            "already reported! consumeOrder directly，code = -20!",
                            req.getCallback(), payCallBackBean);
                } else {
                    onSuccess(req, "Report Purchase Success!", payCallBackBean);
                }

                if (req.getSubscriptionType() == 0) {  // 正常支付才去消耗、订阅和订阅升级不需要消耗
                    IPayMethod iPayMethod = req.getPayMethod();
                    long dohangRequestTime = System.currentTimeMillis();
                    final String hangjogorderid = orderId;
                    iPayMethod.doHangJob(
                            new PurchaseInfo(result.getPurchaseData(), result.getPurchaseSign()),
                            new IResult<String>() {
                                @Override
                                public void onSuccess(String resultJob,
                                                      PayCallBackBean payCallBackBean) {


                                    if (req.getPayType() == PayType.GOOGLE_PLAY) {
                                        PurchaseStatusImpl.deletePurchaseStatus(req.getContext(),
                                                req.getProductid(), req.getUid(), hangjogorderid);
                                    }

                                    long delay = System.currentTimeMillis() - dohangRequestTime;
                                    reportResponse.mServiceName = mDefalutServiceName;
                                    reportResponse.mFunctionName = mDefalutFunctionName;
                                    reportResponse.mPurchaseTime = purchaseTimeReport + "";
                                    reportResponse.mGPOrderId = gpOrderIdReport;
                                    reportResponse.mUid = uidReport;
                                    reportResponse.mDelay = delay + "";
                                    reportResponse.mEventId =
                                            EventType.PayEventID.DO_HANG_JOB_SUCCESS;
                                    reportResponse.mEventaliae =
                                            EventAlias.PayEventAlias.DO_HANG_JOB_SUCCESS;
                                    reportResponse.mErrCode = "0";
                                    reportResponse.mErrMsg = "dohangJob success" +
                                            "data:" + result.getPurchaseData() + "sign:" +
                                            result.getPurchaseSign();
                                    iPayReporter.onDoHangJob(reportResponse);
                                    RLog.info(TAG, "dohangJob success: " +
                                                    "delay= %s, orderid= %s, uid= %s, purchaseTime = %s, gpOrderId = %s",
                                            delay, orderIdReport, uidReport, purchaseTimeReport,
                                            gpOrderIdReport);
                                    //   AppPayServiceImpl.this.onSuccess(req, "dohangJob Success!");

                                    //删除本地订单号
                                    if (req.getPayType() == PayType.GOOGLE_PLAY) {
                                        PurchaseStatusImpl
                                                .deletePurchaseStatus(req.getContext(),
                                                        req.getProductid(),
                                                        req.getUid(),
                                                        hangjogorderid);
                                    }
                                }

                                @Override
                                public void onFail(int code, String failReason,
                                                   PayCallBackBean payCallBackBean) {
                                    long delay = System.currentTimeMillis() - dohangRequestTime;
                                    reportResponse.mServiceName = mDefalutServiceName;
                                    reportResponse.mFunctionName = mDefalutFunctionName;
                                    reportResponse.mPurchaseTime = purchaseTimeReport + "";
                                    reportResponse.mGPOrderId = gpOrderIdReport;
                                    reportResponse.mUid = uidReport;
                                    reportResponse.mDelay = delay + "";
                                    reportResponse.mEventId = EventType.PayEventID.DO_HANG_JOB_FAIL;
                                    reportResponse.mEventaliae =
                                            EventAlias.PayEventAlias.DO_HANG_JOB_FAIL;
                                    reportResponse.mErrCode = code + "";
                                    reportResponse.mErrMsg =
                                            "dohangJob fail,failReason:" + failReason
                                                    + "data:" + result.getPurchaseData() + "sign:" +
                                                    result.getPurchaseSign();
                                    iPayReporter.onDoHangJob(reportResponse);

                                    RLog.error(TAG,
                                            "dohangJob fail code = %d, errMsg = %s, orderid= %s, " +
                                                    "uid= %s, delay= %s, purchaseTime = %s, gpOrderId = %s",
                                            code, failReason, orderIdReport, uidReport, delay,
                                            purchaseTimeReport, gpOrderIdReport);
                                    if (req != null && response != null && result != null) {
                                        String logCloud = combiCloudLogString(code,
                                                "dohangJob fail! failReason:" + failReason,
                                                req.toString(), "");
                                        CloudLogHelper.sendLog("onDoHandJob", logCloud);  //上报阿里云
                                    }
                                    // AppPayServiceImpl.this
                                    //         .onFail(code + "", response.getResponseCode(),
                                    //                 "dohangJob fail,failReason:" + failReason,
                                    //                 req.getCallback());
                                }
                            });
                }

                if (iPayReporter != null) {
                    reportResponse.mEventId = EventType.PayEventID.PURCHASE_REPORT_SUCCESS;
                    reportResponse.mEventaliae = EventAlias.PayEventAlias.PURCHASE_REPORT_SUCCESS;
                    reportResponse.mErrCode = response.getResponseCode() + "";
                    if (response.getResponseCode() == -20) {
                        reportResponse.mErrMsg =
                                "already report success,consumeOrder directly，code = -20!:" +
                                        response.getMessage();
                    } else {
                        reportResponse.mErrMsg = "purchase report success:" + response.getMessage();
                    }
                    iPayReporter.onPurchaseReportResult(reportResponse);
                    reportResponse.mEventId = EventType.PaySummaryEventID.SUMMARY_PURCHASE_SUCCESS;
                    reportResponse.mEventaliae =
                            EventAlias.PaySummaryEventAlias.SUMMARY_PURCHASE_SUCCESS;
                    iPayReporter.onPurchaseSummaryResult(reportResponse); //购买汇总上报：购买成功

                }
            } else {
                RLog.error(TAG, "onReportPurchase fail code = %d, errMsg = %s," +
                                " orderid= %s, uid= %s, delay= %s, purchaseTime = %s, gpOrderId = %s",
                        response.getResponseCode(), response.getMessage(),
                        orderId, uidReport, delay, purchaseTime, gpOrderId);
                PayCallBackBean payCallBackBean = null;
                if (result != null) {
                    payCallBackBean = new PayCallBackBean(orderId, req.getProductid(), gpOrderId,
                            purchaseTime, chorderidReport, payload, result.getPurchaseData(),
                            result.getPurchaseSign(),
                            PurchaseStatus.REPORT_FAIL);

                    //保存订单状态
                    if (req.getPayType() == PayType.GOOGLE_PLAY) {
                        PurchaseStatusInfo purchaseStatusInfo = new PurchaseStatusInfo();
                        purchaseStatusInfo.uid = req.getUid();
                        purchaseStatusInfo.status = PurchaseStatus.REPORT_FAIL.getCode();
                        purchaseStatusInfo.productId = req.getProductid();
                        purchaseStatusInfo.chorderid = chorderidReport;
                        purchaseStatusInfo.orderId = orderId;
                        purchaseStatusInfo.purchaseData = result.getPurchaseData();
                        purchaseStatusInfo.purchaseSign = result.getPurchaseSign();
                        PurchaseStatusImpl
                                .savePurchaseStatus(req.getContext(), purchaseStatusInfo);
                    }

                } else {
                    payCallBackBean = new PayCallBackBean(orderId, req.getProductid(), gpOrderId,
                            purchaseTime, null, payload, null, null, PurchaseStatus.REPORT_FAIL);
                }


                onFail("", response.getResponseCode(),
                        "purchase report fail:" + response.getMessage(),
                        req.getCallback(), payCallBackBean);  //获取req的回调
                if (iPayReporter != null) {
                    reportResponse.mEventId = EventType.PayEventID.PURCHASE_REPORT_FAIL;
                    reportResponse.mEventaliae = EventAlias.PayEventAlias.PURCHASE_REPORT_FAIL;
                    reportResponse.mErrCode = response.getResponseCode() + "";
                    reportResponse.mErrMsg = "purchase report fail:" + response.getMessage();
                    iPayReporter.onPurchaseReportResult(reportResponse);

                    reportResponse.mEventId = EventType.PaySummaryEventID.SUMMARY_PURCHASE_FAIL;
                    reportResponse.mEventaliae =
                            EventAlias.PaySummaryEventAlias.SUMMARY_PURCHASE_FAIL;
                    iPayReporter.onPurchaseSummaryResult(reportResponse); //购买汇总上报：购买失败
                }
                if (req != null && response != null && result != null) {
                    String logCloud = combiCloudLogString(response.getResponseCode(),
                            "reportPurchase fail! failReason:" + response.getMessage(),
                            req.toString(), result.toString());
                    CloudLogHelper.sendLog("onReportPurchase", logCloud);  //上报阿里云
                }

                if (req != null && req.getCallback() instanceof IPayCallback) {
                    IPayCallback callback = (IPayCallback) req.getCallback();
                    callback.onPayStatus(PurchaseStatus.REPORT_FAIL, payCallBackBean);
                }
            }
        }
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    //充值后，发货成功单播.
    private void onCurrencyChargeMessage(@NotNull IResponse response) {
        CurrencyChargeMessage result = getResponseData(CurrencyChargeMessage.class, response);
        if (result == null) {
            return;
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            onCurrencyChargeMessage(result);
        } else {
            ThreadPool.getDefault().mainThreadIO().execute(() -> onCurrencyChargeMessage(result));
        }
    }

    //充值后，发货成功单播.
    private void onCurrencyChargeMessage(@NotNull CurrencyChargeMessage result) {
        Iterator<IAppPayServiceListener> iterator = listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onCurrencyChargeMessage(result);
        }
    }

    //Y币二次确认 购买成功 确认单播
    private void onConsumeConfirmMessage(@NotNull IResponse response) {
        ConsumeConfirmMessage result = getResponseData(ConsumeConfirmMessage.class, response);
        if (result == null) {
            return;
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            onConsumeConfirmMessage(result);
        } else {
            ThreadPool.getDefault().mainThreadIO().execute(() -> onConsumeConfirmMessage(result));
        }
    }

    //延时到账单播
    private void onAccountDelayMessage(@NotNull IResponse response) {
        AccountDelayMessage result = getResponseData(AccountDelayMessage.class, response);
        if (result == null) {
            return;
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            onAccountDelayMessage(result);
        } else {
            ThreadPool.getDefault().mainThreadIO().execute(() -> onAccountDelayMessage(result));
        }
    }

    //延时到账单播
    private void onAccountDelayMessage(@NotNull AccountDelayMessage result) {
        Iterator<IAppPayServiceListener> iterator = listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onAccountDelayMessage(result);
        }
    }

    //货币兑换.
    private void onExchangeCurrency(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        ExchangeResult result = getResponseData(ExchangeResult.class, response);
        if (iRequest != null /*&& result != null*/) {
            RequestParams req = (RequestParams) iRequest.getExtParam();
            if (response.isSuccess() && result != null) {
                onSuccess(req, result, null);
                RLog.info(TAG, "onExchangeCurrency success");
            } else {
                RLog.error(TAG, "onExchangeCurrency fail code = %d, errMsg = %s",
                        response.getResponseCode(),
                        response.getMessage());
                onFail("", response.getResponseCode(), response.getMessage(), req.getCallback(),
                        null);
            }
        }
    }

    //查询充值历史记录（最多能查最近1个月数据）.
    private void onQueryRechargeHistory(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        RechargeHistoryResult result = getResponseData(RechargeHistoryResult.class, response);
        if (iRequest != null /*&& result != null*/) {
            RequestParams req = (RequestParams) iRequest.getExtParam();
            if (response.isSuccess() && result != null) {
                onSuccess(req, result, null);
                RLog.info(TAG, "onQueryRechargeHistory success");
            } else {
                RLog.error(TAG, "onQueryRechargeHistory fail code = %d, errMsg = %s",
                        response.getResponseCode(),
                        response.getMessage());
                onFail("", response.getResponseCode(), response.getMessage(), req.getCallback(),
                        null);
            }
        }
    }

    //Y币二次确认 购买成功 确认单播
    private void onConsumeConfirmMessage(@NotNull ConsumeConfirmMessage result) {
        Iterator<IAppPayServiceListener> iterator = listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onConsumeConfirmMessage(result);
        }
    }

    @Override
    public void onRevenueResponse(int command, @NotNull IResponse response) {
        RLog.info(TAG, "onRevenueResponse command = %d", command);
        switch (command) {
            case RevenueServerConst.GetChargeCurrencyConfigRequest:
                onQueryProductList(response);
                break;
            case RevenueServerConst.GetChargeCurrencyConfigByChannelsRequest:
                onQueryProductListChannels(response);
                break;
            case RevenueServerConst.ChargeCurrencyRequest:
                onOrderProduct(response);
                break;
            case RevenueServerConst.GetUserAccountRequest:
                onQueryUserAccount(response);
                break;
            case RevenueServerConst.GetUserAccountHistoryRequest:
                onQueryUserAccountHistory(response);
                break;
            case RevenueServerConst.GetUserCouponStoreRequest:
                onGetUserCouponStore(response);
                break;
            case RevenueServerConst.GetChargeCouponDiscountRequest:
                onGetChargeCouponDiscount(response);
                break;
            case RevenueServerConst.GetHasChargeInActivityRequest:
                onGetHasChargeInActivity(response);
                break;
            case RevenueServerConst.ReportPurchaseRequest:
                onReportPurchase(response);
                break;
            case RevenueServerConst.CurrencyChargeMessage:
                onCurrencyChargeMessage(response);
                break;
            case RevenueServerConst.ConsumeConfirmMessage:
                onConsumeConfirmMessage(response);
                break;
            case RevenueServerConst.AccountDelayMessage:
                onAccountDelayMessage(response);
                break;
            case RevenueServerConst.ExchangeCurrencyRequest:
                onExchangeCurrency(response);
                break;
            case RevenueServerConst.ChargeCurrencyHistoryRequest:
                onQueryRechargeHistory(response);
                break;
            default:
                onErrorRespone(response);
                break;
        }
    }

    private void onErrorRespone(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        RLog.info("AppPayServiceImpl", "---onErrorRespone---");
        if (iRequest != null /*&& result != null*/) {
            RLog.info("AppPayServiceImpl",
                    "---onErrorRespone---onFail：" + response.getResponseCode());
            RequestParams req = (RequestParams) iRequest.getExtParam();
            onFail("", response.getResponseCode(), response.getMessage(), req.getCallback(), null);
        }
    }

    @Override
    public void queryProductList(@NonNull QueryCurrencyReqParams params,
                                 IResult<ProductListResult> callback) {
        if (!checkNotNull(params, callback)) {
            return;
        }
        params.setCallback(callback);
        params.setRequestTime(System.currentTimeMillis());
        params.setTraceid(TraceIdUtil.newTraceId());
        IRequest req = revenueService
                .obtainRequest(RevenueServerConst.GetChargeCurrencyConfigRequest, params);
        req.setExtParam(params);
        revenueService.sendRequest(req);
    }

    @Override
    public void queryLocalProductList(@NonNull String fileName, Context context,
                                      IResult<ProductListResult> callback) {
        if (callback == null) {
            RLog.error(TAG, "queryLocalProductList: callback is null, return.");
            return;
        }

        if (context == null || fileName.isEmpty()) {
            RLog.error(TAG, "params is illegal");
            callback.onFail(-1, "params is illegal.", null);
            return;
        }

        String result = "";
        try {
            InputStream mAssets = context.getAssets().open(fileName);
            int length = mAssets.available();
            byte[] buffer = new byte[length];
            mAssets.read(buffer);
            mAssets.close();
            result = new String(buffer);
            GetChargeCurrencyConfigResponse response = new GetChargeCurrencyConfigResponse(result);
            ProductListResult productListResult =
                    new ProductListResult(response.currencyType, response.confList);
            callback.onSuccess(productListResult, null);
        } catch (IOException e) {
            RLog.error(TAG, "queryLocalProductList: read local file IOException:", e);
            callback.onFail(-1, e.getMessage(), null);
        } catch (Exception e) {
            RLog.error(TAG, "queryLocalProductList: read local file error:", e);
            callback.onFail(-1, e.getMessage(), null);
        }
    }

    @Override
    public void queryProductListChannels(@NonNull QueryCurrencyChannelsReqParams params,
                                         IResult<ProductListResult> callback) {
        if (!checkNotNull(params, callback)) {
            return;
        }
        params.setCallback(callback);
        params.setRequestTime(System.currentTimeMillis());
        params.setTraceid(TraceIdUtil.newTraceId());
        IRequest req = revenueService
                .obtainRequest(RevenueServerConst.GetChargeCurrencyConfigByChannelsRequest, params);
        req.setExtParam(params);
        revenueService.sendRequest(req);
    }

    @Override
    public void GetUserCouponStore(@NonNull GetUserCouponStoreParams params,
                                   IResult<UserCouponStoreResult> callback) {
        if (!checkNotNull(params, callback)) {
            return;
        }
        params.setCallback(callback);
        IRequest req = revenueService
                .obtainRequest(RevenueServerConst.GetUserCouponStoreRequest, params);
        req.setExtParam(params);
        revenueService.sendRequest(req);
    }

    @Override
    public void GetChargeCouponDiscount(@NonNull GetChargeCouponDiscountReqParams params,
                                        IResult<CouponDiscountResult> callback) {
        if (!checkNotNull(params, callback)) {
            return;
        }
        params.setCallback(callback);
        IRequest req = revenueService
                .obtainRequest(RevenueServerConst.GetChargeCouponDiscountRequest, params);
        req.setExtParam(params);
        revenueService.sendRequest(req);
    }

    @Override
    public void GetHasChargeInActivity(@NonNull GetHasChargeInActivityReqParams params,
                                       IResult<HasChargeInActivityResult> callback) {
        if (!checkNotNull(params, callback)) {
            return;
        }
        params.setCallback(callback);
        IRequest req = revenueService
                .obtainRequest(RevenueServerConst.GetHasChargeInActivityRequest, params);
        req.setExtParam(params);
        revenueService.sendRequest(req);
    }

    @Override
    public void payWithProductInfo(@NonNull Activity act,
                                   @NonNull ChargeCurrencyReqParams params,
                                   @NonNull ProductInfo product,
                                   @NonNull PayType payType,
                                   IPayCallback<String> callback) {
        payWithProductInfo(act, params, product, payType, 0, 0, 0, callback);
    }

    //充值请求
    @Override
    public void payWithProductInfo(@NonNull Activity act,
                                   @NonNull ChargeCurrencyReqParams params,
                                   @NonNull ProductInfo product,
                                   @NonNull PayType payType,
                                   int retryCount,
                                   int intervalMs,
                                   int timeOutMs,
                                   IPayCallback<String> callback) {
        RLog.info("AppPayServiceImpl", "---payWithProductInfo---");

        // 从中间件提取判断卡单和处理卡单流程，简化中间件的代码
        hasHangPayJobAndDoHangPayJob(
                act,
                payType,
                params.getProductId(),
                params.getUid(),
                params.getToken(),
                params.getUsedChannel(),
                params.getCurrencyType(),
                params.getSubscriptionType(),
                params.getTokenCallback(),
                new IResult<String>() {

                    @Override
                    public void onSuccess(String result, PayCallBackBean payCallBackBean) {
                        //callback.onSuccess(result,payCallBackBean);
                        doOrderRequest(act, params, product, payType,
                                retryCount,
                                intervalMs, timeOutMs, callback);
                    }

                    @Override
                    public void onFail(int code, String failReason,
                                       PayCallBackBean payCallBackBean) {
                        doOrderRequest(act, params, product, payType,
                                retryCount,
                                intervalMs, timeOutMs, callback);
                    }
                }
        );

    }

    @Override
    public void hasHangPayJobAndDoHangPayJob(
            Activity act,
            PayType payType,
            String productId,
            Long uid,
            String token,
            int useChannel,
            int currencyType,
            int subscriptionType,
            IToken tokenCallback,
            IResult<String> callback
    ) {
        if (payType == PayType.GOOGLE_PLAY) {   //如果是谷歌支付，需要有订单消耗判断机制
            hasHangPayJobs(act, PayType.GOOGLE_PLAY, new IResult<List<PurchaseInfo>>() {

                @Override
                public void onSuccess(List<PurchaseInfo> result, PayCallBackBean payCallBackBean) {
                    PurchaseInfo purchaseInfo =
                            getPurchaseInfoByProductId(productId, result);
                    if (purchaseInfo != null) {
                        RLog.info(TAG, "有未消耗的订单，purchaseInfo=" + purchaseInfo);

                        ReportPurchaseReqParams reportPurchaseReqParams =
                                getReportRequestParams(
                                        act,
                                        uid,
                                        token,
                                        useChannel,
                                        currencyType,
                                        purchaseInfo,
                                        payType,
                                        subscriptionType,
                                        tokenCallback
                                );

                        ThreadPool.getDefault().mainThreadIO().postDelay(new Runnable() {
                            @Override
                            public void run() {
                                doHangJob(act, reportPurchaseReqParams, PayType.GOOGLE_PLAY,
                                        new IResult<String>() {

                                            @Override
                                            public void onSuccess(String result,
                                                                  PayCallBackBean payCallBackBean) {
                                                RLog.info(
                                                        TAG,
                                                        "doHangJobAndPayProduct onSuccess result=$result"
                                                );
                                                if (callback != null) {
                                                    callback.onSuccess(result, payCallBackBean);
                                                }
                                            }

                                            @Override
                                            public void onFail(int code, String failReason,
                                                               PayCallBackBean payCallBackBean) {
                                                RLog.error(
                                                        TAG,
                                                        "doHangJobAndPayProduct onFail code=$code,failReason=$failReason"
                                                );
                                                if (callback != null) {
                                                    callback.onFail(code, failReason,
                                                            payCallBackBean);
                                                }
                                            }
                                        });
                            }
                        }, 0);

                    } else {
                        RLog.info(TAG, "该商品没有未消耗的订单");
                        if (callback != null) {
                            callback.onFail(-1, "该商品没有未消耗的订单",
                                    payCallBackBean);
                        }
                    }
                }

                @Override
                public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                    RLog.error(TAG,
                            "没有未消耗的订单,=$code, failReason=$failReason"
                    );
                    // if (code != 0 && code != 301) {  // 301 代表查询列表为空
                    //     callback.onFail(code, failReason, payCallBackBean);
                    //     return;
                    // }
                    if (callback != null) {
                        callback.onFail(code, failReason,
                                payCallBackBean);
                    }
                }
            });

        } else {
            RLog.info(TAG, "该支付方式没有处理卡单流程");
            if (callback != null) {
                callback.onFail(-1, "该支付方式没有处理卡单流程",
                        null);
            }
        }
    }

    /**
     * 组合上报参数（主要用于卡单处理流程）
     *
     * @param act
     * @param uid
     * @param token
     * @param useChannel
     * @param currencyType
     * @param purchaseInfo
     * @param payType
     * @param subscriptionType
     * @param tokenCallback
     * @return
     */
    private ReportPurchaseReqParams getReportRequestParams(
            Activity act,
            Long uid,
            String token,
            int useChannel,
            int currencyType,
            PurchaseInfo purchaseInfo,
            PayType payType,
            int subscriptionType,
            IToken tokenCallback
    ) {
        ReportPurchaseReqParams params = new ReportPurchaseReqParams();
        params.setUid(uid);
        params.setToken(token);
        params.setAppId(appId);
        params.setSid(0);
        params.setUsedChannel(useChannel);
        params.setCurrencyType(currencyType);
        params.setClientVersion(mClientVer);
        params.setPurchaseInfo(purchaseInfo);
        params.setPayType(payType);
        params.setSubscriptionType(subscriptionType);
        params.setTokenCallback(tokenCallback);
        return params;
    }

    /**
     * 根据产品ID获取支付信息
     *
     * @param productId
     * @param result
     * @return
     */
    private PurchaseInfo getPurchaseInfoByProductId(String productId, List<PurchaseInfo> result) {
        PurchaseInfo purchaseInfo = null;
        for (PurchaseInfo purchase : result) {
            try {
                JSONObject jsonObject = new JSONObject(purchase.data);
                if (jsonObject != null && productId == jsonObject.optString("productId")) {
                    purchaseInfo = purchase;
                    break;
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return purchaseInfo;
    }

    @Override
    public void payWithProductId(@NonNull Activity act,
                                 @NonNull ProductInfo info,
                                 @NonNull ChargeCurrencyReqParams params,
                                 String payload,
                                 PayType payType,
                                 IPayCallback<String> callback) {
        payWithProductId(act, info, params, payload, payType, 0, 0, 0, callback);
    }

    @Override
    public void payWithProductId(@NonNull Activity act,
                                 @NonNull ProductInfo info,
                                 @NonNull ChargeCurrencyReqParams params,
                                 String payload,
                                 PayType payType,
                                 int retryCount,
                                 int intervalMs,
                                 int timeOutMs,
                                 IPayCallback<String> callback) {
        //pay.requestPay(act, params.uid, info, payload, callback);
        requestPayWithRetry(act, params, payType, info.productId, payload, retryCount, intervalMs,
                timeOutMs, callback);

        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        reportResponse.mPaysource = params.getFrom();
        reportResponse.mUid = params.getUid();
        if (iPayReporter != null) {
            reportResponse.mEventId = EventType.PayEventID.REQUUEST_PAY;
            reportResponse.mEventaliae = EventAlias.PayEventAlias.REQUUEST_PAY;
            reportResponse.mErrCode = "0";
            reportResponse.mErrMsg = "payWithProductId-doOrderRequest(发起下单请求)";
            iPayReporter.onRequestPay(reportResponse);
        }

        RLog.info("AppPayServiceImpl",
                "doOrderRequest(下单请求)---reqParams:" + params.getPayType() + " "
                        + params.getSubscriptionType() + " " + params.getCid() +
                        "requestTime:" + params + "--uid:" + params.getUid() +
                        "--productId:" + params.getProductId());
    }

    @Override
    public void orderWithProductInfo(@NonNull Activity act, @NonNull ChargeCurrencyReqParams params,
                                     @NonNull ProductInfo product, @NonNull PayType payType,
                                     IPayCallback<PayOrderResult> callback) {
        orderWithProductInfo(act, params, product, payType, 0, 0, 0, callback);
    }

    @Override
    public void orderWithProductInfo(@NonNull Activity act, @NonNull ChargeCurrencyReqParams params,
                                     @NonNull ProductInfo product, @NonNull PayType payType,
                                     int retryCount, int intervalMs, int timeOutMs,
                                     IPayCallback<PayOrderResult> callback) {
        doOrderRequest(act, params, product, payType, retryCount, intervalMs, timeOutMs, callback);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    private void doOrderRequest(@NonNull Activity act, @NonNull ChargeCurrencyReqParams params,
                                @NonNull ProductInfo product, @NonNull PayType payType,
                                int retryCount, int intervalMs, int timeOutMs,
                                IPayCallback callback) {


        RLog.info("AppPayServiceImpl", "---doOrderRequest---");
        if (!checkNotNull(params, callback)) {
            return;
        }

        final long requestTime = System.currentTimeMillis();

        if (!isSupported(act, payType)) {
            //todo review here
            PayCallBackBean payCallBackBean = new PayCallBackBean(null, product.productId,
                    null, requestTime, null, null, null, null,
                    PurchaseStatus.ORDER_FAIL);
            callback.onFail(IPayMethod.Status.NOT_SUPPORT.getCode(),
                    IPayMethod.Status.NOT_SUPPORT.getMessage(), payCallBackBean);
            return;
        }

        params.setContext(act);
        params.setCallback(callback);
        params.setPayChannel(payType.getChannel());
        params.setPayMethod(payType.getMethod());
        params.setSrcAmount(product.srcAmount);
        params.setProductId(product.productId);
        params.setCid(product.cid);
        params.setTraceid(TraceIdUtil.newTraceId());


        ChargeCurrencyReqParams reqParams = ChargeCurrencyReqParams.Companion.clone(params);
        // 风控二次请求需要用到  --- start
        reqParams.setPayChannel(payType.getChannel());
        reqParams.setPayMethod(payType.getMethod());
        reqParams.setSrcAmount(product.srcAmount);
        reqParams.setProductId(product.productId);
        reqParams.setCid(product.cid);
        //--- end
        reqParams.setRetryCount(retryCount);
        reqParams.setIntervalMs(intervalMs);
        reqParams.setTimeOutMs(timeOutMs);
        reqParams.setPayType(payType);
        reqParams.setProductId(params.getProductId());
        reqParams.setFrom(params.getFrom());
        reqParams.setSubscriptionType(params.getSubscriptionType());
        reqParams.setOldProductId(params.getOldProductId());
        reqParams.setProrationMode(params.getProrationMode());
        reqParams.setReturnUrl(params.getReturnUrl());
        reqParams.setExpand(params.getExpand());
        reqParams.setRequestTime(requestTime);
        reqParams.setTokenCallback(params.getTokenCallback());
        reqParams.setTraceid(params.getTraceid());
        reqParams.setFrom(params.getFrom());
        IToken iToken = params.getTokenCallback();
        if (iToken != null) {
            String newToken = iToken.onUpdateToken();
            if (newToken != null) {
                reqParams.setToken(newToken);
                RLog.info("AppPayServiceImpl",
                        "doOrderRequest---newToken:" + newToken);
            }
        }
        reqParams.setCid(params.getCid());

        if (payType == PayType.GOOGLE_PLAY && params.getSubscriptionType() != 0) {
            int channel = params.getUsedChannel();
            // 之前写这块代码的人写死10006,考虑到可能出现马甲包，所以这里判断，以免旧的业务不传该值
            // if (channel == 10002 || channel == 0) {
            //     params.setUsedChannel(10006);
            //     reqParams.setUsedChannel(10006);
            // } else {
            params.setUsedChannel(channel);
            reqParams.setUsedChannel(channel);
            // }
        }
        reqParams.setCurrencyType(params.getCurrencyType());

        reqParams.setCurrencyType(params.getCurrencyType());

        RLog.info("AppPayServiceImpl",
                "doOrderRequest---reqParams:" + reqParams.getPayType() + " "
                        + reqParams.getSubscriptionType() + " " + reqParams.getCid() +
                        "requestTime:" + requestTime + "--uid:" + reqParams.getUid() +
                        "--productId:" + reqParams.getProductId());
        PayCallBackBean payCallBackBean =
                new PayCallBackBean(null, reqParams.getProductId(), null,
                        reqParams.getRequestTime(), null, null,
                        null, null, PurchaseStatus.ORDER_START);

        callback.onPayStatus(PurchaseStatus.ORDER_START, payCallBackBean); // 回调开始下单状态

        IRequest req =
                revenueService.obtainRequest(RevenueServerConst.ChargeCurrencyRequest, params);
        req.setExtParam(reqParams);
        revenueService.sendRequest(req);

        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        reportResponse.mPaysource = params.getFrom();
        reportResponse.mUid = params.getUid();
        reportResponse.mPayTraceId = params.getTraceid();
        reportResponse.mPageId = mPageId;
        RouterInfo routerInfo = RouterInfoCenter.getRouterInfo(act.getApplicationContext(),
                reqParams.getCmd());
        if (routerInfo == null) {
            reportResponse.mServiceName = mDefalutServiceName;
            reportResponse.mFunctionName = mDefalutFunctionName;
        } else {
            reportResponse.mServiceName = routerInfo.serviceName;
            reportResponse.mFunctionName = routerInfo.functionName;
        }

        RLog.info("AppPayServiceImpl",
                "doOrderRequest---mServiceName:" + reportResponse.mServiceName
                        + "---mFunctionName" + reportResponse.mFunctionName);

        if (iPayReporter != null) {
            reportResponse.mEventId = EventType.PayEventID.REQUUEST_PAY;
            reportResponse.mEventaliae = EventAlias.PayEventAlias.REQUUEST_PAY;
            reportResponse.mErrCode = "0";
            reportResponse.mErrMsg = "doOrderRequest";
            iPayReporter.onRequestPay(reportResponse);
        }
    }

    @Override
    public void queryMyBalance(@NonNull QueryCurrencyReqParams params,
                               IResult<MyBalanceResult> callback) {
        if (!checkNotNull(params, callback)) {
            return;
        }
        params.setCallback(callback);
        IRequest req =
                revenueService.obtainRequest(RevenueServerConst.GetUserAccountRequest, params);
        req.setExtParam(params);
        revenueService.sendRequest(req);
    }

    @Override
    public void queryRevenueRecordByUid(@NonNull QueryUserAccountHistoryReqParams params,
                                        IResult<RevenueRecordResult> callback) {
        if (!checkNotNull(params, callback)) {
            return;
        }
        //发送请求
        params.setCallback(callback);
        IRequest req = revenueService
                .obtainRequest(RevenueServerConst.GetUserAccountHistoryRequest, params);
        req.setExtParam(params);
        revenueService.sendRequest(req);
    }

    @Override
    public void exchangeCurrency(@NonNull ExchangeCurrencyReqParams params,
                                 IResult<ExchangeResult> iResult) {
        if (!checkNotNull(params, iResult)) {
            return;
        }
        //发送请求
        params.setCallback(iResult);
        IRequest req =
                revenueService.obtainRequest(RevenueServerConst.ExchangeCurrencyRequest, params);
        req.setExtParam(params);
        revenueService.sendRequest(req);
    }

    @Override
    public void queryRechargeHistory(@NonNull QueryRechargeHistoryReqParams params,
                                     IResult<RechargeHistoryResult> iResult) {
        if (!checkNotNull(params, iResult)) {
            return;
        }
        //发送请求
        params.setCallback(iResult);
        IRequest req = revenueService
                .obtainRequest(RevenueServerConst.ChargeCurrencyHistoryRequest, params);
        req.setExtParam(params);
        revenueService.sendRequest(req);
    }

    @Override
    public boolean isSupported(Activity act, PayType payType) {
        final IPayMethod pay = PayMethodFactory.valueOf(payType);
        if (pay != null) {
            return pay.isSupported(act);
        }
        return false;
    }

    @Override
    public boolean hasHangPayJob(Activity act, PayType payType, IResult<PurchaseInfo> iResult) {
        return hasHangPayJobs(act, payType, new IResult<List<PurchaseInfo>>() {
            @Override
            public void onSuccess(List<PurchaseInfo> result, PayCallBackBean payCallBackBean) {

                iResult.onSuccess(result.get(0), null);

            }

            @Override
            public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                iResult.onFail(code, failReason, null);
            }
        });
    }

    @Override
    public boolean hasHangSubscribeJob(Activity act, PayType payType,
                                       IResult<PurchaseInfo> iResult) {
        return hasHangSubscribeJobs(act, payType, new IResult<List<PurchaseInfo>>() {
            @Override
            public void onSuccess(List<PurchaseInfo> result, PayCallBackBean payCallBackBean) {
                iResult.onSuccess(result.get(0), null);
            }

            @Override
            public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                iResult.onFail(code, failReason, null);
            }
        });
    }

    @Override
    public boolean hasHangPayJobs(Activity act, PayType payType,
                                  IResult<List<PurchaseInfo>> iResult) {
        if (iResult == null) {
            return false;
        }
        if (!isSupported(act, payType)) {
            iResult.onFail(IPayMethod.Status.NOT_SUPPORT.getCode(),
                    IPayMethod.Status.NOT_SUPPORT.getMessage(), null);
            return false;
        }

        IPayMethod pay = PayMethodFactory.valueOf(payType);
        if (pay != null) {
            pay.hasHangPayJobs(act, new IResult<List<PurchaseInfo>>() {
                @Override
                public void onSuccess(List<PurchaseInfo> result, PayCallBackBean payCallBackBean) {
                    RLog.info(TAG, "hasHangPayJobs result =%s", result);
                    iResult.onSuccess(result, payCallBackBean);
                }

                @Override
                public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                    RLog.error(TAG, "hasHangPayJobs fail code = %d, failReason = %s", code,
                            failReason);
                    iResult.onFail(code, failReason, payCallBackBean);
                }
            });
        }
        return false;
    }

    @Override
    public boolean hasHangSubscribeJobs(Activity act, PayType payType,
                                        IResult<List<PurchaseInfo>> iResult) {
        if (iResult == null) {
            return false;
        }
        if (!isSupported(act, payType)) {
            iResult.onFail(-1, "not support", null);
            return false;
        }
        IPayMethod pay = PayMethodFactory.valueOf(payType);

        if (pay != null) {
            HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();

            pay.hasHangSubscribeJobs(act, new IResult<List<PurchaseInfo>>() {
                @Override
                public void onSuccess(List<PurchaseInfo> result, PayCallBackBean payCallBackBean) {
                    RLog.info(TAG, "hasHangSubscribeJob result =%s", result);
                    iResult.onSuccess(result, payCallBackBean);
                }

                @Override
                public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                    RLog.error(TAG, "hasHangSubscribeJob fail code = %d, failReason = %s", code,
                            failReason);
                    iResult.onFail(code, failReason, payCallBackBean);
                    reportResponse.mEventId = EventType.PaySummaryEventID.SUMMARY_PURCHASE_FAIL;
                    reportResponse.mErrCode = code + "";
                    reportResponse.mErrMsg = failReason;
                    iPayReporter.onPurchaseSummaryResult(reportResponse); //购买汇总上报：处理订阅Job失败
                }
            });
        }
        return false;
    }

    @Override
    public boolean queryHangJobsByLocalCache(@NonNull Activity act, PayType payType,
                                             IResult<List<PurchaseStatusInfo>> iResult) {

        PurchaseStatusImpl.readAllPurchaseStatus(act, new IResult<List<PurchaseStatusInfo>>() {
            @Override
            public void onSuccess(List<PurchaseStatusInfo> result,
                                  PayCallBackBean payCallBackBean) {
                if (result != null && result.size() > 0) {
                    hasHangPayJobs(act, payType, new IResult<List<PurchaseInfo>>() {
                        @Override
                        public void onSuccess(List<PurchaseInfo> listPurchaseInfo,
                                              PayCallBackBean payCallBackBean) {
                            for (PurchaseStatusInfo purchaseStatusInfo : result) {
                                if ((purchaseStatusInfo.status ==
                                        PurchaseStatus.PAY_START.getCode())
                                        || purchaseStatusInfo.status ==
                                        PurchaseStatus.ORDER_SUCCESS.getCode()) {
                                    for (PurchaseInfo purchaseInfo : listPurchaseInfo) {
                                        String chorderid = getCHOrderId(purchaseInfo.data);
                                        if (chorderid.equals(purchaseStatusInfo.chorderid)) {
                                            purchaseStatusInfo.purchaseData = purchaseInfo.data;
                                            purchaseStatusInfo.purchaseSign =
                                                    purchaseInfo.signature;
                                        }
                                    }
                                }
                            }
                            iResult.onSuccess(result, null);
                        }

                        @Override
                        public void onFail(int code, String failReason,
                                           PayCallBackBean payCallBackBean) {
                            iResult.onFail(-1, "queryHangJobsByLocalCache fail，result is null or " +
                                    "result.size is 0", payCallBackBean);
                        }
                    });

                } else {
                    iResult.onFail(-1,
                            "queryHangJobsByLocalCache fail，result is null or result.size = 0",
                            payCallBackBean);
                }
            }

            @Override
            public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                iResult.onFail(code, failReason, payCallBackBean);
            }
        });

        return true;
    }

    @Override
    public boolean doHangJobByLocalCache(@NonNull Activity act,
                                         ReportPurchaseReqParams params,
                                         IResult<String> iResult) {
        if (params == null) {
            iResult.onFail(-1, "ReportPurchaseReqParams is null", null);
            return false;
        }

        PurchaseStatusImpl.readPurchaseStatus(act, params.getProductid(),
                String.valueOf(params.getUid()),
                params.getOrderId(),
                new IResult<PurchaseStatusInfo>() {
                    @Override
                    public void onSuccess(PurchaseStatusInfo purchaseStatusInfo,
                                          PayCallBackBean payCallBackBean) {
                        hasHangPayJobs(act, params.getPayType(), new IResult<List<PurchaseInfo>>() {
                            @Override
                            public void onSuccess(List<PurchaseInfo> listPurchaseInfo,
                                                  PayCallBackBean payCallBackBean) {
                                for (PurchaseInfo purchaseInfo : listPurchaseInfo) {
                                    String productId = getProductId(purchaseInfo.data);
                                    if (productId.equals(purchaseStatusInfo.productId)) {
                                        doHangJob(act, params, params.getPayType(),
                                                new IResult<String>() {
                                                    @Override
                                                    public void onSuccess(String result,
                                                                          PayCallBackBean payCallBackBean) {
                                                        iResult.onSuccess(result, payCallBackBean);
                                                    }

                                                    @Override
                                                    public void onFail(int code, String failReason,
                                                                       PayCallBackBean payCallBackBean) {
                                                        iResult.onFail(code, failReason,
                                                                payCallBackBean);
                                                    }
                                                });
                                    }
                                }
                            }

                            @Override
                            public void onFail(int code, String failReason,
                                               PayCallBackBean payCallBackBean) {
                                iResult.onFail(code, failReason, payCallBackBean);
                            }
                        });

                    }

                    @Override
                    public void onFail(int code, String failReason,
                                       PayCallBackBean payCallBackBean) {
                        iResult.onFail(code, failReason, payCallBackBean);
                    }
                }
        );

        return true;
    }

    @Override
    public boolean doHangJobsByLocalCache(@NonNull Activity act, PayType payType,
                                          IResult<List<PurchaseStatusInfo>> iResult) {
        return true;
    }

    @Override
    public boolean queryHistoryPurchaseBySkuType(@NonNull Activity act, @NonNull PayType payType,
                                                 String skuType,
                                                 IResult<List<PurchaseInfo>> iResult) {
        if (iResult == null) {
            return false;
        }
        if (!isSupported(act, payType)) {
            iResult.onFail(-1, "not support payType", null);
            return false;
        }
        IPayMethod pay = PayMethodFactory.valueOf(payType);

        if (pay != null) {
            pay.queryHistoryPurchaseBySkuType(act, skuType, iResult);
        }
        return false;
    }

    @Override
    public boolean doHangJob(@NonNull Activity act,
                             @NonNull ReportPurchaseReqParams params,
                             PayType payType,
                             IResult<String> callback) {
        return doHangJob(act, params, payType, 0, 0, 0, callback);
    }

    @Override
    public boolean doHangJob(@NonNull Activity act,
                             @NonNull ReportPurchaseReqParams params,
                             @NonNull PayType payType,
                             int retryCount,
                             int intervalMs,
                             int timeOutMs,
                             IResult<String> callback) {

        RLog.info(TAG, "---doHangJob---");
        if (!checkNotNull(params, callback)) {
            return false;
        }
        IPayMethod pay = PayMethodFactory.valueOf(payType);

        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        reportResponse.mPaysource = params.getFrom();
        reportResponse.mUid = params.getUid();
        reportResponse.mOrderId = params.getOrderId();

        if (pay == null || !pay.isSupported(act)) {
            if (callback != null) {
                callback.onFail(-1, "doHangJob fail : not support pay method", null);
                reportResponse.mErrCode = -1 + "";
                reportResponse.mErrMsg = "doHangJob fail : not support pay method";
                reportResponse.mEventId = EventType.PaySummaryEventID.SUMMARY_PURCHASE_FAIL;
                iPayReporter.onPurchaseSummaryResult(reportResponse); //购买汇总上报：购买失败
                reportResponse.mEventId = EventType.PayEventID.DO_HANG_JOB_FAIL;
                reportResponse.mEventaliae = EventAlias.PayEventAlias.DO_HANG_JOB_FAIL;
                iPayReporter.onDoHangJob(reportResponse);

                RLog.error(TAG, "doHangJob fail : not support pay method. code = %d, OrderId = " +
                                "%s ,  uid = %s ", -1,
                        params.getOrderId(), params.getUid());
            }
            return false;
        }
        if (params.getPurchaseInfo() == null) {
            callback.onFail(-1, "doHangJob fail: please call hasHangPayJob first", null);
            reportResponse.mErrCode = -1 + "";
            reportResponse.mErrMsg = "doHangJob fail: please call hasHangPayJob first";
            reportResponse.mEventId = EventType.PaySummaryEventID.SUMMARY_PURCHASE_FAIL;
            iPayReporter.onPurchaseSummaryResult(reportResponse); //购买汇总上报：购买失败
            reportResponse.mEventId = EventType.PayEventID.DO_HANG_JOB_FAIL;
            reportResponse.mEventaliae = EventAlias.PayEventAlias.DO_HANG_JOB_FAIL;
            iPayReporter.onDoHangJob(reportResponse);

            RLog.error(TAG, "doHangJob fail: please call hasHangPayJob first. code = %d, OrderId " +
                            "= " +
                            "%s ,  uid = %s ", -1,
                    params.getOrderId(), params.getUid());

            return false;
        }
        params.setContext(act);
        params.setRetryCount(retryCount);
        params.setIntervalMs(intervalMs);
        params.setTimeOutMs(timeOutMs);
        params.setPayMethod(pay);
        params.setCallback(new DoHangJobProxy(params, params.getPurchaseInfo(), payType, callback));
        params.setRequestTime(System.currentTimeMillis());

        reportPurchase(params, params.getPurchaseInfo().data, params.getPurchaseInfo().signature);

        // reportResponse.mErrCode = 0 + "";
        // reportResponse.mErrMsg = "继续完成未完成的订单请求成功";
        // reportResponse.mEventId = EventType.PayEventID.DO_HANG_JOB_SUCCESS;
        // reportResponse.mEventaliae = EventAlias.PayEventAlias.DO_HANG_JOB_SUCCESS;
        // iPayReporter.onDoHangJob(reportResponse);
        return true;
    }

    @Override
    public void clearHangJob(Activity act, PayType payType, int type,
                             IResult<PurchaseInfo> callback) {
        if (callback == null) {
            return;
        }
        if (!isSupported(act, payType)) {
            callback.onFail(-1, "not support", null);
        }
        IPayMethod pay = PayMethodFactory.valueOf(payType);
        if (pay != null) {
            pay.clearHangPayJob(act, type, callback);
        }
    }

    @Override
    public boolean doHangJobByProductId(@NotNull Activity act,
                                        @NotNull DoHangPayJobReqParams params,
                                        PayType payType,
                                        int retryCount,
                                        int intervalMs,
                                        int timeOutMs,
                                        IResult<String> callback) {
        RLog.info("AppPayServiceImpl", "---doHangJobByProductId---");
        if (callback == null) {
            return false;
        }
        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        reportResponse.mPaysource = params.getFrom();
        reportResponse.mUid = params.getUid();

        final IPayMethod pay = PayMethodFactory.valueOf(payType);
        if (pay == null || !pay.isSupported(act)) {
            callback.onFail(IPayMethod.Status.NOT_SUPPORT.getCode(),
                    IPayMethod.Status.NOT_SUPPORT.getMessage(), null);

        } else {
            pay.queryHistoryPurchaseByProductId(params.getProductId(), new IResult<PurchaseInfo>() {
                @Override
                public int hashCode() {
                    return super.hashCode();
                }

                @Override
                public void onSuccess(PurchaseInfo result, PayCallBackBean payCallBackBean) {
                    params.setContext(act);
                    params.setRetryCount(retryCount);
                    params.setIntervalMs(intervalMs);
                    params.setTimeOutMs(timeOutMs);
                    params.setPayMethod(pay);
                    params.setRequestTime(System.currentTimeMillis());
                    params.setProductid(params.getProductId());
                    params.setCallback(new DoHangJobProxy(params, result, payType, callback));
                    String data = result.data;
                    try {
                        JSONObject json = new JSONObject(data);
                        json.put("packageName", params.getPackageName());
                        data = json.toString();
                    } catch (JSONException e) {
                        RLog.error(TAG, "doHangJobByProductId fail errMsg = %s", e.getMessage());
                    }
                    reportPurchase(params, data, result.signature);

                    reportResponse.mErrCode = 0 + "";
                    reportResponse.mErrMsg = "处理卡单成功";
                    reportResponse.mEventId =
                            EventType.PaySummaryEventID.SUMMARY_DOHANGDJOB_SUCCESS;
                    reportResponse.mEventaliae =
                            EventAlias.PaySummaryEventAlias.SUMMARY_DOHANGDJOB_SUCCESS;
                    iPayReporter.onDoHangJobByProductId(reportResponse);

                }

                @Override
                public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                    callback.onFail(code, failReason, payCallBackBean);
                    reportResponse.mErrCode = code + "";
                    reportResponse.mErrMsg = failReason;
                    reportResponse.mEventId = EventType.PaySummaryEventID.SUMMARY_DOHANGDJOB_FAIL;
                    reportResponse.mEventaliae =
                            EventAlias.PaySummaryEventAlias.SUMMARY_DOHANGDJOB_FAIL;
                    iPayReporter.onDoHangJobByProductId(reportResponse);
                }
            });
        }
        return true;
    }

    @Override
    public void querySkuDetails(Activity act, PayType payType, List<String> skusList,
                                String skuType, IResult<List<SkuDetailInfo>> iResult) {
        final IPayMethod pay = PayMethodFactory.valueOf(payType);
        if (pay == null || !pay.isSupported(act)) {
            iResult.onFail(IPayMethod.Status.NOT_SUPPORT.getCode(),
                    IPayMethod.Status.NOT_SUPPORT.getMessage(), null);
            RLog.info(TAG, "querySkuDetails onFail no support ");
        } else {
            pay.querySkuDetails(act, skusList, skuType, new IResult<List<SkuDetailInfo>>() {

                @Override
                public void onSuccess(List<SkuDetailInfo> result, PayCallBackBean payCallBackBean) {
                    RLog.info(TAG, "querySkuDetails onSuccess result = %s", result.toString());
                    iResult.onSuccess(result, payCallBackBean);
                }

                @Override
                public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                    RLog.info(TAG, "querySkuDetails onFail code = %s, failReason = %s",
                            code, failReason);
                    iResult.onFail(code, failReason, payCallBackBean);
                }
            });
        }
    }

    @Override
    public void reportPayEntrancePage(int from) {
        mPageId = PageIdUtil.newPageId();  //每次进来都要更新，便于其他环节使用
        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        reportResponse.mEventId = EventType.PayEventID.ENTRANCE_PAGE;
        reportResponse.mEventaliae = EventAlias.PayEventAlias.ENTRANCE_PAGE;
        reportResponse.mPageId = mPageId;
        reportResponse.mPaysource = from;
        reportResponse.mErrCode = "0";
        reportResponse.mErrMsg = "pay-entrance-page（支付入口页面）";

        if (iPayReporter != null) {
            iPayReporter.onPayEntrancePage(reportResponse);
        }
    }

    @Override
    public boolean isPayingStatus(PayType payType) {
        final IPayMethod pay = PayMethodFactory.valueOf(payType);
        if (pay != null) {
            return pay.isPayingStatus();
        }
        return false;
    }

    @Override
    public void onWxPayResult(int code, String msg) {
        final IPayMethod pay = PayMethodFactory.valueOf(PayType.WECHAT_PAY);
        if (pay != null) {
            pay.onWxPayResult(code, msg);
        }
    }

    @Override
    public void addPayListener(IAppPayServiceListener listener) {
        if (listener != null) {
            listeners.add(listener);
        }
    }

    @Override
    public void removePayListener(IAppPayServiceListener listener) {
        Iterator<IAppPayServiceListener> iterator = listeners.iterator();
        while (iterator.hasNext()) {
            if (listener == iterator.next()) {
                iterator.remove();
                break;
            }
        }
    }

    @Override
    public void registerPayReporter(IPayReporter iPayReporter) {
        this.iPayReporter = iPayReporter;
    }

    @Override
    public void setCountryCode(String countryCode) {
        mCountryCode = countryCode;
    }

    @Override
    public void onResponseData(int appId, PSCIMessageResponse responseData) {
        revenueService.onResponseData(appId, responseData);
    }

    @Override
    public void onUnicastData(int appId, PSCIMessageUnicast unicastData) {
        revenueService.onUnicastData(appId, unicastData);
    }

    @Override
    public void onBroadcastData(int appId, PSCIMessageBroadcast broadcastData) {

    }

    @Override
    public void onRequestError(int appId, String seq, int cmd, int srvErrorCode, String message) {
        revenueService.onRequestError(appId, seq, cmd, srvErrorCode, message);
    }

    @Override
    public void requestPay(Activity act, PayType payType, String productId, String payload,
                           boolean isSetAccountId, IPayCallback<PurchaseInfo> callback) {
        RLog.info("AppPayServiceImpl",
                "requstPay,payType:" + payType + ",productId:" + productId + "," +
                        "payload:" + payload);
        final IPayMethod pay = PayMethodFactory.valueOf(payType);
        pay.requestPay(act, 0, productId, payload, isSetAccountId, callback);
    }

    @Override
    public void requestSubscription(Activity act, PayType payType, String productId, String payload,
                                    boolean isSetAccountId, IPayCallback<PurchaseInfo> callback) {
        RLog.info("AppPayServiceImpl",
                "requestSubscription,payType:" + payType + ",productId:" + productId + "," +
                        "payload:" + payload);
        final IPayMethod pay = PayMethodFactory.valueOf(payType);
        pay.requestSubscription(act, 0, productId, payload, isSetAccountId, callback);
    }

    @Override
    public void consumeProduct(PayType payType, PurchaseInfo info, IResult<String> result) {
        RLog.info("AppPayServiceImpl",
                "consumeProduct, payType:" + payType + ",info:" + info);
        final IPayMethod pay = PayMethodFactory.valueOf(payType);
        pay.doHangJob(info, result);
    }

    private void requestPayWithRetry(Activity act,
                                     ChargeCurrencyReqParams params,
                                     PayType payType,
                                     String productId,
                                     String payload,
                                     int retryCount,
                                     int intervalMs,
                                     int timeOutMs,
                                     IPayCallback<String> callback) {
        RLog.info("AppPayServiceImpl",
                String.format("---requestPayWithRetry productId = %s, payload = %s---", productId,
                        payload));
        if (!checkNotNull(params, callback)) {
            return;
        }
        params.setContext(act);
        params.setRetryCount(retryCount);
        params.setIntervalMs(intervalMs);
        params.setTimeOutMs(timeOutMs);
        params.setPayType(payType);
        params.setCallback(callback);
        requestPay(act, params, payType, productId, payload, true,
                new PayCallbackProxy(payType, "", params, payload, callback));
    }

    public AppPayServiceImpl() {
        super();
    }

    private void requestPay(Activity act,
                            ChargeCurrencyReqParams params,
                            PayType payType,
                            String productId,
                            String payload,
                            boolean isSetAccountId,
                            IPayCallback callback) {
        final IPayMethod pay = PayMethodFactory.valueOf(payType);

        // final long requestTime = System.currentTimeMillis();
        // params.setRequestTime(requestTime); //设置请求支付时间点，用于统计上报

        RLog.debug("AppPayServiceImpl",
                String.format("---requestPay SubscriptionType=%s ProductId = %s",
                        params.getSubscriptionType(), params.getProductId()));

        if (params.getPayType() == PayType.GOOGLE_PLAY && params.getSubscriptionType() == 1) { //订阅
            pay.requestSubscription(act, params.getUid(), productId, payload, isSetAccountId,
                    callback);
        } else if (params.getPayType() == PayType.GOOGLE_PLAY &&
                params.getSubscriptionType() == 2) { //订阅升级
            pay.updateSubscription(act, params.getUid(), params.getOldProductId(), productId,
                    params.getProrationMode(), payload, isSetAccountId, callback);
        } else { //正常支付
            pay.requestPay(act, params.getUid(), productId, payload, isSetAccountId, callback);
        }

    }

    /**
     * 该方法是在购买成功的时候使用
     *
     * @param params
     * @param purchaseData
     * @param purchaseSign
     * @param orderId
     */
    private void reportPurchase(@NonNull ChargeCurrencyReqParams params,
                                @NonNull String purchaseData,
                                @NonNull String purchaseSign,
                                @NonNull String orderId,
                                @NonNull IPayCallback callback) {

        long requestTime = System.currentTimeMillis();
        RLog.info("AppPayServiceImpl",
                String.format(
                        "---reportPurchase purchaseData = %s, purchaseSign = %s, requestTime = %s---",
                        purchaseData, purchaseSign, requestTime));

        ReportPurchaseReqParams reqParams = new ReportPurchaseReqParams();
        reqParams.clone(params);
        reqParams.setCurrencyType(params.getCurrencyType());
        reqParams.setData(purchaseData);
        reqParams.setSign(purchaseSign);
        reqParams.setOrderId(orderId);
        reqParams.setFrom(params.getFrom());
        reqParams.setPayMethod(PayMethodFactory.valueOf(params.getPayType()));
        reqParams.setPayType(params.getPayType());
        reqParams.setSubscriptionType(params.getSubscriptionType());
        reqParams.setRetryType(1);
        reqParams.setIntervalMs(5000);
        reqParams.setRetryCount(50);
        reqParams.setRequestTime(requestTime);
        reqParams.setToken(params.getToken());
        reqParams.setTokenCallback(params.getTokenCallback());
        reqParams.setTraceid(params.getTraceid());
        reqParams.setProductid(params.getProductId());
        reqParams.setCallback(callback);

        IToken iToken = params.getTokenCallback();
        if (iToken != null) {
            String newToken = iToken.onUpdateToken();
            if (newToken != null) {
                reqParams.setToken(newToken);
                RLog.info("AppPayServiceImpl",
                        "reportPurchase--1-newToken:" + newToken);
            }
        }

        if (callback != null) {
            String gpOrderId = getGPOrderId(purchaseData);
            String chOrderId = getCHOrderId(purchaseData);
            String payload = getPayLoad(purchaseData);
            PayCallBackBean payCallBackBean = new PayCallBackBean(orderId, reqParams.getProductid(),
                    gpOrderId, reqParams.getRequestTime(), chOrderId, payload, purchaseData, purchaseSign,
                    PurchaseStatus.REPORT_START);

            callback.onPayStatus(PurchaseStatus.REPORT_START, payCallBackBean);
        }

        IRequest req =
                revenueService.obtainRequest(RevenueServerConst.ReportPurchaseRequest, reqParams);
        req.setExtParam(reqParams);
        revenueService.sendRequest(req);
    }

    /**
     * 该方法在dohangjob（消耗）的时候使用
     *
     * @param params
     * @param purchaseData
     * @param purchaseSign
     */
    private void reportPurchase(@NonNull ReportPurchaseReqParams params,
                                @NonNull String purchaseData,
                                @NonNull String purchaseSign) {
        long requestTime = System.currentTimeMillis();
        RLog.info("AppPayServiceImpl",
                String.format(
                        "--start-reportPurchase, purchaseData = %s, purchaseSign = %s, " +
                                "requestTime = %s" +
                                " ，uid = %s，oderid = %s",
                        purchaseData, purchaseSign, requestTime, params.getUid(),
                        params.getOrderId()));
        params.setData(purchaseData);
        params.setSign(purchaseSign);
        params.setRetryType(1);
        params.setIntervalMs(5000);
        params.setRetryCount(50);
        params.setRequestTime(requestTime);

        IToken iToken = params.getTokenCallback();
        if (iToken != null) {
            String newToken = iToken.onUpdateToken();
            if (newToken != null) {
                params.setToken(newToken);
                RLog.info("AppPayServiceImpl",
                        "reportPurchase--1-newToken:" + newToken);
            }
        }

        IRequest req =
                revenueService.obtainRequest(RevenueServerConst.ReportPurchaseRequest, params);
        req.setExtParam(params);
        revenueService.sendRequest(req);
    }

    private boolean checkNotNull(RequestParams params, IResult iResult) {
        return params != null && iResult != null;
    }

    /**
     * 成功
     *
     * @param params
     * @param data
     */
    @SuppressWarnings("unchecked")
    public <T> void onSuccess(RequestParams params, final T data, PayCallBackBean payCallBackBean) {
        if (null == params) {
            return;
        }
        final IResult callback = params.getCallback();
        if (null == callback) {
            return;
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            callback.onSuccess(data, payCallBackBean);
        } else {
            ThreadPool.getDefault().mainThreadIO()
                    .execute(() -> callback.onSuccess(data, payCallBackBean));
        }
    }

    /**
     * 失败回调
     *
     * @param seq
     * @param code
     * @param message
     */
    public void onFail(String seq, int code, String message, IResult callback,
                       PayCallBackBean payCallBackBean) {
        if (null == callback) {
            return;
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            callback.onFail(code, message, payCallBackBean);
        } else {
            ThreadPool.getDefault().mainThreadIO()
                    .execute(() -> callback.onFail(code, message, payCallBackBean));
        }
    }

    private class PayCallbackProxy implements IPayCallback<PurchaseInfo> {

        private IPayCallback iPayCallback;
        private ChargeCurrencyReqParams params;
        private PayType payType;
        private String orderId = "";
        private HiidoReport.CReportResponse reportResponse;
        private long requestTime;
        private String payLoad;

        public PayCallbackProxy(PayType payType, String orderId, ChargeCurrencyReqParams params,
                                String payLoad, IPayCallback iPayCallback) {
            this.payType = payType;
            if (orderId != null) {
                this.orderId = orderId;
            }
            requestTime = System.currentTimeMillis();
            this.params = params;
            this.iPayCallback = iPayCallback;
            this.payLoad = payLoad;
            reportResponse = new HiidoReport.CReportResponse();
            reportResponse.mPaysource = params.getFrom();
            reportResponse.mUid = params.getUid();
            reportResponse.mOrderId = this.orderId;
            reportResponse.mServiceName = mDefalutServiceName;
            reportResponse.mFunctionName = mDefalutFunctionName;
            reportResponse.mPayTraceId = params.getTraceid();
            reportResponse.mPageId = mPageId;
        }

        @Override
        public void onSuccess(PurchaseInfo result, PayCallBackBean payCallBackBean) {

            long delay = System.currentTimeMillis() - requestTime;

            long purchaseTime = 0L;
            String gpOrderId = "";

            if (result != null) {
                if (payType == PayType.GOOGLE_PLAY) {

                    //保存订单状态
                    if (params.getPayType() == PayType.GOOGLE_PLAY) {
                        PurchaseStatusInfo purchaseStatusInfo = new PurchaseStatusInfo();
                        purchaseStatusInfo.uid = params.getUid();
                        purchaseStatusInfo.status = PurchaseStatus.PAY_SUCCESS.getCode();
                        purchaseStatusInfo.productId = params.getProductId();
                        purchaseStatusInfo.orderId = orderId;
                        purchaseStatusInfo.purchaseData = result.data;
                        purchaseStatusInfo.purchaseSign = result.signature;
                        PurchaseStatusImpl
                                .savePurchaseStatus(params.getContext(), purchaseStatusInfo);
                    }

                    reportPurchase(params, result.data, result.signature, orderId, iPayCallback);
                    RLog.info(TAG,
                            String.format(Locale.ENGLISH,
                                    "pay success, start to reportPurchase! ---PayCallbackProxy " +
                                            "requestTime =%s , Uid =%s, OrderId =%s"
                                    , requestTime, params.getUid(), this.orderId));

                    purchaseTime = getPurchaseTime(result.data);
                    gpOrderId = getGPOrderId(result.data);

                    if (payCallBackBean == null) {
                        payCallBackBean =
                                new PayCallBackBean(orderId, params.getProductId(), gpOrderId,
                                        purchaseTime, null, payLoad, result.data, result.signature,
                                        PurchaseStatus.PAY_SUCCESS);
                    }

                } else {
                    if (payCallBackBean == null) {
                        payCallBackBean = new PayCallBackBean(orderId, params.getProductId(), "",
                                requestTime, null, payLoad, null, null,
                                PurchaseStatus.PAY_SUCCESS);
                    }

                    iPayCallback.onSuccess("pay success!", payCallBackBean);

                    RLog.info(TAG,
                            String.format(Locale.ENGLISH,
                                    "---PayCallbackProxy-pay-onSuccess: " +
                                            "requestTime = %s, delay = %s, Uid =%s, OrderId =%s",
                                    requestTime, delay + "", params.getUid(), this.orderId));
                }
            }

            if (iPayCallback != null) {
                iPayCallback.onPayStatus(PurchaseStatus.PAY_SUCCESS, payCallBackBean);
            }

            if (iPayReporter != null) {
                reportResponse.mGPOrderId = gpOrderId;
                reportResponse.mPurchaseTime = purchaseTime + "";
                reportResponse.mDelay = delay + "";
                reportResponse.mEventId = EventType.PayEventID.PAY_SUCCESS;
                reportResponse.mEventaliae = EventAlias.PayEventAlias.PAY_SUCCESS;
                reportResponse.mErrCode = "0";
                reportResponse.mErrMsg = "pay success!";
                iPayReporter.onPayResult(reportResponse);
            }

        }

        @Override
        public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {

            int payResponeCode = code;
            String payResponeFailReason = failReason;

            if (payType == PayType.GOOGLE_PLAY) {
                long delay = System.currentTimeMillis() - requestTime;
                boolean isHasHangPayJob =
                        hasHangPayJob(params.getContext(), payType, new IResult<PurchaseInfo>() {
                            @Override
                            public void onSuccess(PurchaseInfo result,
                                                  PayCallBackBean payCallBackBean) {

                                String dohangProductId = getProductId(result.data);

                                RLog.info(TAG,
                                        String.format(Locale.ENGLISH,
                                                "---PayCallbackProxy, pay onFail--hasHangPayJob: " +
                                                        "requestTime = %s, delay = %s, uid = %s, orderid = %s, dohangProductId = %s",
                                                requestTime, delay + "", params.getUid(),
                                                orderId, dohangProductId));

                                if (dohangProductId.equals(params.getProductId())) {
                                    RLog.info(TAG,
                                            String.format(Locale.ENGLISH,
                                                    "---PayCallbackProxy, pay " +
                                                            "onFail--hasHangPayJob, " +
                                                            "dohangProductId = productId, " +
                                                            "start to reportPurchase"));


                                    long purchaseTimeHas = getPurchaseTime(result.data);
                                    String gpOrderIdHas = getGPOrderId(result.data);

                                    if (iPayReporter != null) {
                                        reportResponse.mGPOrderId = gpOrderIdHas;
                                        reportResponse.mPurchaseTime = purchaseTimeHas + "";
                                        reportResponse.mDelay = delay + "";
                                        reportResponse.mEventId = EventType.PayEventID.PAY_FAIL;
                                        reportResponse.mEventaliae =
                                                EventAlias.PayEventAlias.PAY_FAIL;
                                        reportResponse.mErrCode = code + "";
                                        reportResponse.mErrMsg =
                                                "pay Fail! but hasHangPayJob, dohangProductId=" +
                                                        dohangProductId + ",current productId="
                                                        + params.getProductId() + ",orderid:" +
                                                        orderId + ", gpOrderIdHas:" + gpOrderIdHas +
                                                        ",failReason" + failReason;
                                        iPayReporter.onPayResult(reportResponse);
                                    }

                                    reportPurchase(params, result.data, result.signature, orderId,
                                            iPayCallback);  //上报凭证，这个阶段当成功

                                } else {

                                    RLog.info(TAG,
                                            String.format(Locale.ENGLISH,
                                                    "---PayCallbackProxy, pay " +
                                                            "onFail--no hasHangPayJob: " +
                                                            "requestTime = %s, delay = %s, uid = %s, orderid = %s, dohangProductId = %s",
                                                    requestTime, delay + "", params.getUid(),
                                                    orderId, dohangProductId));

                                    failCallBackInternal(payResponeCode, payResponeFailReason,
                                            payCallBackBean);
                                    ThreadPool.getDefault().mainThreadIO().postDelay(
                                            new Runnable() {
                                                @Override
                                                public void run() {

                                                    hasHangPayJob(params.getContext(), payType,
                                                            new IResult<PurchaseInfo>() {

                                                                @Override
                                                                public void onSuccess(
                                                                        PurchaseInfo result,
                                                                        PayCallBackBean payCallBackBean) {
                                                                    String dohangProductId2 =
                                                                            getProductId(
                                                                                    result.data);
                                                                    if (dohangProductId2
                                                                            .equals(params
                                                                                    .getProductId())) {

                                                                        long purchaseTimeHas =
                                                                                getPurchaseTime(
                                                                                        result.data);
                                                                        String gpOrderIdHas =
                                                                                getGPOrderId(
                                                                                        result.data);

                                                                        if (iPayReporter != null) {
                                                                            reportResponse.mGPOrderId =
                                                                                    gpOrderIdHas;
                                                                            reportResponse.mPurchaseTime =
                                                                                    purchaseTimeHas +
                                                                                            "";
                                                                            reportResponse.mDelay =
                                                                                    delay + "";
                                                                            reportResponse.mEventId =
                                                                                    EventType.PayEventID.PAY_FAIL;
                                                                            reportResponse.mEventaliae =
                                                                                    EventAlias.PayEventAlias.PAY_FAIL;
                                                                            reportResponse.mErrCode =
                                                                                    code + "";
                                                                            reportResponse.mErrMsg =
                                                                                    "pay Fail! but hasHangPayJob-- 60s retry!, " +
                                                                                            "dohangProductId=" +
                                                                                            dohangProductId +
                                                                                            ",current productId="
                                                                                            +
                                                                                            params.getProductId() +
                                                                                            ",orderid:" +
                                                                                            orderId +
                                                                                            ", gpOrderIdHas:" +
                                                                                            gpOrderIdHas +
                                                                                            ",failReason" +
                                                                                            failReason;
                                                                            iPayReporter
                                                                                    .onPayResult(
                                                                                            reportResponse);
                                                                        }

                                                                        reportPurchase(params,
                                                                                result.data,
                                                                                result.signature,
                                                                                orderId,
                                                                                iPayCallback);
                                                                    }
                                                                }

                                                                @Override
                                                                public void onFail(int code,
                                                                                   String failReason,
                                                                                   PayCallBackBean payCallBackBean) {

                                                                }
                                                            });
                                                }
                                            }, 60000);
                                }
                            }

                            @Override
                            public void onFail(int code, String failReason,
                                               PayCallBackBean payCallBackBean) {
                                failCallBackInternal(payResponeCode, payResponeFailReason,
                                        payCallBackBean);
                            }
                        });
            } else {
                failCallBackInternal(payResponeCode, payResponeFailReason, payCallBackBean);
            }

        }

        @Override
        public void onPayStart() {
            if (iPayCallback != null) {
                String chOrderid = getChOrderidByPayload(payLoad);
                PayCallBackBean payCallBackBean =
                        new PayCallBackBean(orderId, params.getProductId(), "", requestTime, chOrderid,
                                payLoad, null, null, PurchaseStatus.PAY_START);
                iPayCallback.onPayStatus(PurchaseStatus.PAY_START, payCallBackBean);
                iPayCallback.onPayStart();
            }

            //保存订单状态
            if (params.getPayType() == PayType.GOOGLE_PLAY) {
                PurchaseStatusInfo purchaseStatusInfo = new PurchaseStatusInfo();
                purchaseStatusInfo.uid = params.getUid();
                purchaseStatusInfo.status = PurchaseStatus.PAY_START.getCode();
                purchaseStatusInfo.productId = params.getProductId();
                purchaseStatusInfo.orderId = orderId;
                PurchaseStatusImpl
                        .savePurchaseStatus(params.getContext(), purchaseStatusInfo);
            }

            long delay = System.currentTimeMillis() - requestTime;
            RLog.info(TAG,
                    String.format(Locale.ENGLISH,
                            "---PayCallbackProxy-onPayStart: " +
                                    "requestTime = %s, delay = %s, uid = %s, orderid = %s",
                            requestTime, delay + "", params.getUid(), this.orderId));
            if (iPayReporter != null) {
                reportResponse.mDelay = delay + "";
                reportResponse.mEventId = EventType.PayEventID.PAY_START;
                reportResponse.mEventaliae = EventAlias.PayEventAlias.PAY_START;
                reportResponse.mErrCode = "0";
                reportResponse.mErrMsg = "start pay---Pull up the payment page";
                iPayReporter.onPayStart(reportResponse);
            }
        }

        @Override
        public void onPayStatus(PurchaseStatus status, PayCallBackBean callBackBean) {
            iPayCallback.onPayStatus(status, callBackBean);
        }

        private void failCallBackInternal(int code, String failReason,
                                          PayCallBackBean payCallBackBean) {
            if (payCallBackBean == null) {
                payCallBackBean =
                        new PayCallBackBean(orderId, params.getProductId(), "", requestTime, null,
                                payLoad, null, null, PurchaseStatus.PAY_FAIL);
            }
            if (iPayCallback != null) {
                if ((payType == PayType.GOOGLE_PLAY) && code == 1) {  // 谷歌字符返回码为1的取消
                    payCallBackBean =
                            new PayCallBackBean(orderId, params.getProductId(), "", requestTime,
                                    null,
                                    payLoad, null, null, PurchaseStatus.PAY_CANCEL);
                    iPayCallback.onPayStatus(PurchaseStatus.PAY_CANCEL, payCallBackBean);
                } else {
                    payCallBackBean =
                            new PayCallBackBean(orderId, params.getProductId(), "", requestTime,
                                    null,
                                    payLoad, null, null, PurchaseStatus.PAY_FAIL);
                    iPayCallback.onPayStatus(PurchaseStatus.PAY_FAIL, payCallBackBean);
                }
                iPayCallback.onFail(code, "pay fail! failReason:" + failReason, payCallBackBean);
            }


            long delay = System.currentTimeMillis() - requestTime;

            RLog.info(TAG,
                    String.format(Locale.ENGLISH,
                            "---PayCallbackProxy, pay onFail: " +
                                    "requestTime = %s, delay = %s, uid = %s, orderid = %s",
                            requestTime, delay + "", params.getUid(), this.orderId));

            if (iPayReporter != null) {
                reportResponse.mDelay = delay + "";
                reportResponse.mEventId = EventType.PayEventID.PAY_FAIL;
                reportResponse.mEventaliae = EventAlias.PayEventAlias.PAY_FAIL;
                reportResponse.mErrCode = code + "";
                reportResponse.mErrMsg = "pay fail! failReason:" + failReason;
                iPayReporter.onPayResult(reportResponse);
                reportResponse.mEventId = EventType.PaySummaryEventID.SUMMARY_PURCHASE_FAIL;
                iPayReporter.onPurchaseSummaryResult(reportResponse); //购买汇总上报：购买失败
            }
            if (params != null) {
                if (code != 1) {
                    String logCloud = combiCloudLogString(code,
                            "pay fail! failReason:" + failReason,
                            params.toString(), "");
                    CloudLogHelper.sendLog("onRequestPay", logCloud);  //上报阿里云
                }
            }
        }
    }

    private String getGPOrderId(String data) {
        String tagObject = "";
        if (data != null) {
            try {
                JSONObject json = new JSONObject(data);
                tagObject = json.getString("orderId");
                if (tagObject == null) {
                    tagObject = "";
                }
            } catch (JSONException e) {
                e.printStackTrace();
                RLog.error(TAG,
                        String.format(Locale.ENGLISH,
                                "data parser fail --getPurchaseTime--PayCallbackProxy " +
                                        "data =%s , Exception =%s"
                                , data, e.getMessage()));
            }
        }

        RLog.info(TAG,
                String.format(Locale.ENGLISH,
                        "data parser success ---PayCallbackProxy " +
                                "data =%s , orderId =%s"
                        , data, tagObject));

        return tagObject;
    }

    private String getProductId(String data) {
        String tagObject = "";
        if (data != null) {
            try {
                JSONObject json = new JSONObject(data);
                tagObject = json.getString("productId");
                if (tagObject == null) {
                    tagObject = "";
                }
            } catch (JSONException e) {
                e.printStackTrace();
                RLog.error(TAG,
                        String.format(Locale.ENGLISH,
                                "data parser fail --productId--PayCallbackProxy " +
                                        "data =%s , Exception =%s"
                                , data, e.getMessage()));
            }
        }

        RLog.info(TAG,
                String.format(Locale.ENGLISH,
                        "data parser success ---PayCallbackProxy " +
                                "data =%s , orderId =%s"
                        , data, tagObject));

        return tagObject;
    }

    private String getChOrderidByPayload(String payload) {
        String tagObject = "";
        if (payload != null) {
            try {
                JSONObject json = new JSONObject(payload);
                String payloadString = json.getString("chOrderId");
                if (payloadString == null || payloadString.equals("")) {
                    tagObject = "";
                    RLog.error(TAG,
                            String.format(Locale.ENGLISH,
                                    "data parser fail --getChOrderidByPayload =null "));
                } else {
                    tagObject = payloadString;
                }
                return tagObject;
            } catch (JSONException e) {
                e.printStackTrace();
                RLog.error(TAG,
                        String.format(Locale.ENGLISH,
                                "data parser fail --getPayLoad--getChOrderidByPayload " +
                                        "data =%s , Exception =%s"
                                , payload, e.getMessage()));
            }
        }

        RLog.info(TAG,
                String.format(Locale.ENGLISH,
                        "data parser success ---getChOrderidByPayload " +
                                "data =%s , getPayLoad =%s"
                        , payload, tagObject));

        return tagObject;
    }

    private String getCHOrderId(String data) {
        String tagObject = "";
        if (data != null) {
            try {
                JSONObject json = new JSONObject(data);
                String payloadString = json.getString("developerPayload");
                if (payloadString == null || payloadString.equals("")) {
                    tagObject = "";
                } else {
                    JSONObject payloadJson = new JSONObject(payloadString);
                    tagObject = payloadJson.getString("chOrderId");
                    if (tagObject == null) {
                        tagObject = "";
                    }
                }

            } catch (JSONException e) {
                e.printStackTrace();
                RLog.error(TAG,
                        String.format(Locale.ENGLISH,
                                "data parser fail --getCHOrderId--PayCallbackProxy " +
                                        "data =%s , Exception =%s"
                                , data, e.getMessage()));
            }
        }

        RLog.info(TAG,
                String.format(Locale.ENGLISH,
                        "data parser success ---PayCallbackProxy " +
                                "data =%s , chorderId =%s"
                        , data, tagObject));

        return tagObject;
    }

    private String getPayLoad(String data) {
        String tagObject = "";
        if (data != null) {
            try {
                JSONObject json = new JSONObject(data);
                String payloadString = json.getString("developerPayload");
                if (payloadString == null || payloadString.equals("")) {
                    tagObject = "";
                    RLog.error(TAG,
                            String.format(Locale.ENGLISH,
                                    "data parser fail --getPayLoad =null "));
                } else {
                    tagObject = payloadString;
                }
                return tagObject;
            } catch (JSONException e) {
                e.printStackTrace();
                RLog.error(TAG,
                        String.format(Locale.ENGLISH,
                                "data parser fail --getPayLoad--PayCallbackProxy " +
                                        "data =%s , Exception =%s"
                                , data, e.getMessage()));
            }
        }

        RLog.info(TAG,
                String.format(Locale.ENGLISH,
                        "data parser success ---PayCallbackProxy " +
                                "data =%s , getPayLoad =%s"
                        , data, tagObject));

        return tagObject;
    }

    private long getPurchaseTime(String data) {
        long tagObject = 0L;
        if (data != null) {
            try {
                JSONObject json = new JSONObject(data);
                tagObject = json.getLong("purchaseTime");

            } catch (JSONException e) {
                e.printStackTrace();
                RLog.error(TAG,
                        String.format(Locale.ENGLISH,
                                "data parser fail --getPurchaseTime--PayCallbackProxy " +
                                        "data =%s , Exception =%s"
                                , data, e.getMessage()));
            }
        }
        RLog.info(TAG,
                String.format(Locale.ENGLISH,
                        "data parser success ---PayCallbackProxy " +
                                "data =%s , purchaseTime =%s"
                        , data, tagObject));
        return tagObject;
    }

    private String getChallengeExtension(String expand) {
        String tagObject = "";
        if (expand != null) {
            try {
                JSONObject json = new JSONObject(expand);
                String riskObject = json.getString("riskData");
                if (riskObject != null && !riskObject.equals("")) {
                    JSONObject riskJson = new JSONObject(riskObject);
                    tagObject = riskJson.getString("challengeExtension");
                }
            } catch (JSONException e) {
                e.printStackTrace();
                RLog.error(TAG,
                        String.format(Locale.ENGLISH,
                                "data parser fail --getChallengeExtension--PayCallbackProxy " +
                                        "data =%s , Exception =%s"
                                , expand, e.getMessage()));
            }
        }
        RLog.info(TAG,
                String.format(Locale.ENGLISH,
                        "data parser success ---getChallengeExtension " +
                                "data =%s , purchaseTime =%s"
                        , expand, tagObject));
        return tagObject;
    }

    private class DoHangJobProxy implements IResult<String> {

        private IResult<String> iResult;
        private PurchaseInfo mPurchaseInfo;
        private PayType payType;
        private ReportPurchaseReqParams params;

        public DoHangJobProxy(ReportPurchaseReqParams params, PurchaseInfo purchaseInfo,
                              PayType payType, IResult<String> iResult) {
            this.mPurchaseInfo = purchaseInfo;
            this.payType = payType;
            this.iResult = iResult;
            this.params = params;
        }

        @Override
        public void onSuccess(String result, PayCallBackBean payCallBackBean) {
            iResult.onSuccess(result, payCallBackBean);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
            if (code == -20) { //出现已上报过标志，直接进行消耗
                if (params != null && params.getSubscriptionType() == 0) {
                    consumeProduct(PayType.GOOGLE_PLAY, mPurchaseInfo, null);
                    iResult.onFail(code, "DoHangJobProxy, already reported! consumeOrder " +
                            "directly", null);
                } else {
                    iResult.onFail(code, "DoHangJobProxy, already reported!", payCallBackBean);
                }
            } else {
                iResult.onFail(code, failReason, payCallBackBean);
            }
        }

    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    private String combiCloudLogString(int code, String errorMsg, String request, String respone) {
        return "{"
                + "cdoe:" + code
                + ",errorMsg:" + errorMsg
                + ",request:" + request
                + ",respone:" + respone
                + "}";
    }

}
