//
// Created by HuTao on 2019/5/3.
//

#ifndef YYSERVICESDK_PARENT_CODEDEF_H
#define YYSERVICESDK_PARENT_CODEDEF_H
#include <stdint.h>
#include <stdlib.h>
#include <string.h>

namespace Service{
    struct CString
    {
        //浅拷贝，申请谁释放，接口使用时都要memcopy一份
        const char* pStr;
        int mSize;
        CString():pStr(NULL),mSize(0){}
        CString(const char* cstring){
            mSize = strlen(cstring);
            pStr = cstring;
        }
        CString(const char* data,int size):pStr(data),mSize(size){}
        
        CString(const CString& rhs){
            if(this == &rhs){
                return;
            }
            this->pStr = rhs.pStr;
            this->mSize = rhs.mSize;
        }
        CString operator=(const CString& rhs){
            if(this == &rhs){
                return *this;
            }
            pStr = rhs.pStr;
            mSize = rhs.mSize;
            return *this;
        }
    };
    enum SvcStatus {
        /**
         * 初始化
         */
        Init = 0,
        /**
         * 正在连接服务器...
         */
        OnConnecting = 1,
        /**
         * 连接超时!
         */
        OnConnecttimeout = 2,
        /**
         * 连接成功!
         */
        OnConnected = 3,
        /**
         * 连接断开了!
         */
        OnClosed = 4,
        /**
         * 关闭连接
         */
        Closed = 5,
        /**
         * 连接绑定ID状态!
         */
        Binded = 6,
    };
    CString SvcStatusDesc(int code);

    enum SvcCommonResCode {
        /**
         * 客户端请求超时(请求已发送出去但未在超时时间内收到响应)
         */
        SVC_TIMEOUT = -3,
        /**
         * 客户端请求超时(连接还未成功)
         */
        SVC_TIMEOUT_SEND = SVC_TIMEOUT -1,
        
        /**
         * 未知错误
         */
        SVC_UNKNOW = -255,
        
        /**
		 * 请求发送成功
		 */
        SVC_SEND_SUCCESS = 0,
        
        /**
		rescode    resMsg    desc    notice
		200    "OK"    返回成功    业务后台有响应，至于业务层面的错误异常需在业务data里定义
		400    "Bad Request"    上行消息解析失败
		401    "Unauthorized"    上行消息uid未验证    需要使用实名认证的票据登入
		402    "Payment Required"    你懂的    该请service组吃顿饭了
		403    "Forbidden"    预留
		404    "Not Found"    预留
		408    "Request Timeout"    后端超时
        453    "Request OverTimes"  请求超过次数限制
		500    "Internal Server Error"
		502    "Bad Gateway"    预留
		503    "Service Unavailable"    找不到后端服务    路由规则匹配失败
		504    "Gateway Timeout"    预留
		*/
        SVC_SUCCESS = 200,
        SVC_ONEWAY = 208, //单向请求成功完成
        SVC_BADREQUEST = 400,
        SVC_UNAUTHORIZED = 401,
        SVC_PAYMENTREQUIRED = 402,
        SVC_FAIL = 403,
        SVC_NOTFOUND = 404,
        SVC_REQUEST_TIMEOUT = 408,
        SVC_EOVERTIMES = 453,
        SVC_INTERNALSERVERERROR = 500,
        SVC_BADGATEWAY = 502,
        SVC_SERVICEUNAVAILABLE = 503,
        SVC_GATEWAYTIMEOUT = 504,
    };
    CString SvcCommonDesc(int code);
    
    enum SvcBindResCode{
        /**
		* 客户端请求超时(请求已发送出去但未在超时时间内收到响应)
		*/
        CLI_TIMEOUT = -3,
        /**
         * 客户端请求超时(连接还未成功)
         */
        CLI_TIMEOUT_SEND = CLI_TIMEOUT -1,
        /**
		* 绑定Service时uid=0非法
		*/
        CLI_BIND_UID_0 = CLI_TIMEOUT_SEND -1,
        /**
         * 绑定Service时token为空
         */
        CLI_BIND_TOKEN_NIL = CLI_BIND_UID_0 -1,
        
        /**
		* 未知错误
		*/
        CLI_UNKNOW = -255,
        
        /**
		 * 请求发送成功
		 */
        CLI_SEND_SUCCESS = 0,
        
        /*
		rescode	resMsg	desc	notice
		200	""	登入成功
		300	""	未就绪，请重试其他接入ap
		403	"OTP_APPID_ERR(53)"	Otp票据验证失败
		408	""	Otp票据验证超时，请重试
		406	""	负载满，请重试其他接入ap
		409	""	资源冲突，请重试其他接入ap
		*/
        SVC_BIND_SUCCESS = 200,
        SVC_BIND_NOTREADY_TORETRY = 300,
        SVC_BIND_OTP_FAIL = 403,
        SVC_BIND_OTP_TIMEOUT = 408,
        SVC_BIND_LOAD_FULL = 406,
        SVC_BIND_RESOURCE_CONFLICT = 409,
    };

    CString SvcBindDesc(int code);
}

#endif //YYSERVICESDK_PARENT_CODEDEF_H
