﻿//
// Created by HUTAO on 2017/8/29.
//
#ifndef YYPROTO_BASEMOD_H
#define YYPROTO_BASEMOD_H
#include "commondefine.h"
#include "ITaskThread.h"
#include "IProtoPacket.h"
#include "LogFile.h"

NAMESPACE_BASEMOD_BEGIN
enum NetworkType
{
    NetworkType_NONE,
    NetworkType_WIFI,
    NetworkType_4G
};

enum EAppID
{
	ENUM_APP_TEST    = (1 << 8 | 0),     // test
	ENUM_APP_IM      = (1 << 8 | 1),     // yyim
	ENUM_APP_PUSHAP  = (1 << 8 | 2),     // push
	ENUM_APP_SESSION = (1 << 8 | 3),     // yysession
	ENUM_APP_SERVICE = (1 << 8 | 4),
	ENUM_APP_CIM = 261, //云im
	ENUM_APP_CIM2 = 262, //云im
	ENUM_APP_CSE = 263, //欢聚云
	ENUM_APP_CSE2 = 264, //欢聚云
	ENUM_APP_UNISVC = 265, // service 统一通道
};
	struct NetworkArea
	{
		uint32_t areaType; // 区域编号
		uint32_t ispType; // isp编号
		uint32_t userIp; // 用户出口ip
		NetworkArea():areaType(0),ispType(0),userIp(0)
		{}
	};
    class ConnectedQuality
    {
    public:

        uint32_t mLbsDnsCost;//LBS 域名解析耗时
		uint32_t mLbsCost;//LBS阶段耗时
		std::set<std::string> mLbsIps;//失败（6s未取得ap ip）的lbsip或成功的lbsip
        uint32_t mApCost;//AP阶段耗时
		std::set<std::string> mApIps;//失败(6s未连接成功)的apip或成功的apip
		int mCode;

        std::string mMyIp;
//        bool mIsOptimizeTrans = false;
        enum OptimizeCode{
//            UNKNOWN = -1,
//            OPTIMIZE_TRANS_FALSE = 0,
//            OPTIMIZE_TRANS_TRUE = 1,
			
			UNKNOWN_NEW = 10,//未拿到ap ip ，对应QualityCode 3，4，5
			ENABLE_TRANS = 11,//拿到ap ip，并且允许使用弱网但2种方式都连不上，对应QualityCode 1，2
			DISABLE_TRANS = 12,//拿到ap ip，并且不使用弱网，对应QualityCode 0，1，2
			TRANS_SUCC = 13,//拿到ap ip，允许使用弱网并且使用弱网连上，对应QualityCode 0
			TCP_SUCC = 14//拿到ap ip，允许使用弱网但使用TCP连上，对应QualityCode 0
        };
        int mOptimizeCode;
	
		uint64_t mCost;//上报总耗时（成功时为成功的总耗时，失败时大约为open及上报周期1分钟）
		int mRetryCount;//所属的重试周期
		
		enum QualityCode{
			NONETWORK = -1,
            SUCC = 0,
			AP_FAIL = 1,
			LBS_SUCC = 2,
			LBS_FAIL = 3,
			DNS_SUCC = 4,
			DNS_FAIL = 5,
		};
		void reset(){
			mCode = ConnectedQuality::SUCC;
			mOptimizeCode = ConnectedQuality::UNKNOWN_NEW;
		
			mLbsDnsCost = 0;//清除上次失败的统计
			mLbsIps.clear();
			mApIps.clear();
		}
		ConnectedQuality():mLbsDnsCost(0),mLbsCost(0),mApCost(0),mCode(0),mMyIp(""),mOptimizeCode(UNKNOWN_NEW)
		{}
    };

class IChannelWatcher
{
public:
	/**
	 * 与服务器的建立链接超时
	 * 被观察的通道不可用
	 */
	virtual void onOpenTimeout() = 0;
	/**
	 * 正在尝试链接
	 * 被观察的通道不可用
	 */
	virtual void onConnecting() = 0;
	
	virtual void onConnecting(ConnectedQuality& quality) = 0;
	/**
	 * 链接创建成功
	 * 被观察的通道可以收发数据了
	 */
	virtual void onConnected(ConnectedQuality& quality) = 0;
	/**
	 * 链接被动关闭（由网络事件触发）
	 * 被观察的通道被断开关闭了
	 */
	virtual void onClosed() = 0;

	/**
	 * 从链接上收到了数据包
	 * @param proto
	 * 			数据包
	 */
	virtual void onData(IProtoPacket* proto) = 0;

	/**
	 * 建立通道链接时，获取到的自己的外网IP
	 * @param myWanIP
	 * 				外网IPv4
	 */
	virtual void onWanArea(NetworkArea& myWanArea) = 0;
};
	enum LinkType {
		RELEASE = 0,
		LOCAL_UDP = 10,

		TEST_AP = 65, //AP TCP
		TEST_APTRANS = 66,//AP TRANS
		TEST_LBS_AP = 67,//LBS IP-AP TCP
		TEST_LBS_APTRANS = 68,//LBS IP-AP TRANS
		TEST_HOST_AP = 69,//LBS HOST-AP TCP
		TEST_HOST_APTRANS = 70,//LBS HOST-AP TRANS
	};
/**
 * 一条与服务器的网络通道, 可以收发数据、监听通道状态
 */
class IChannel
{
public:
    virtual ~IChannel(){}
    
	/**
	 * 打开与服务器的连接通道，由{@link IChannelWatcher}通知链接状态和接收数据
	 * @param linkType
	 * 			TCP or UDP 取值枚举{@link ConnType}
	 */
	virtual bool open(int linkType,NetworkType netStatus) = 0;
	/**
	 * 指定ip和端口打开与服务器的连接通道，由{@link IChannelWatcher}通知链接状态和接收数据
	 * @param linkType
	 * 			TCP or UDP 取值枚举{@link ConnType}
	 * @param ipv4
	 * 			AP的IPv4地址
	 * @param ports
	 * 			AP的端口
	 */
	virtual bool open(int linkType,NetworkType netStatus,uint32_t ipv4, std::vector<uint16_t >& ports) = 0;
	/**
	 * 断开与服务器的连接
	 * 给业务使用的接口，内部实现不要触发IChannelWatcher中的回调，否则容易造成业务逻辑混乱
	 */
	virtual bool close() = 0;

    /**
     * 获取ip地址
     */
	virtual std::string getIpStr(std::string& srvIp,std::string& srvPort) = 0;
	virtual uint64_t getPingTime() = 0;
	virtual const ConnectedQuality& getApQos() = 0;//获取连接过程中的一些统计指标
	/**
	 * 发送协议数据
	 */
	virtual bool send(uint32_t uri, const Marshallable& req) = 0;
	virtual bool send(const std::string& data) = 0;
	/**
	 * 注册状态和数据接收监听器
	 */
	virtual void watch(IChannelWatcher *w) = 0;
    
	/**
	 * 注销状态和数据接收监听器
	 */
	virtual void revoke() = 0;
};
class IBaseProvider{
public:
	virtual ~IBaseProvider(){};
	virtual std::string hdid() = 0;
	virtual std::vector<std::string> dnsResolve(std::string& host) = 0;
	virtual std::vector<std::string> dnsStoreLoad() = 0;
	virtual int dnsStoreFlush(std::vector<std::string>& ips) = 0;
	
	virtual bool getUseTrans() = 0;
	virtual int getABTest() = 0;
	
	virtual uint32_t getAppId() = 0;
	virtual std::string getRegion() = 0;
	
	virtual void jniRelease() = 0;
};
extern volatile bool gToExit;//全局退出

class IBaseMod
{
public:
	/**
	 * 创建BaseMod 模块实例句柄
	 * @param logCtrl
	 * 			业务模块new的Log实例，basenet中日志最终也是通过此实例打印
	 */

	static IBaseMod* createInstance(Log* logCtrl,int netStatus,
									IBaseProvider* baseProvider);
	/**
	 * 释放BaseMod 模块实例句柄
	 */

	static void releaseInstance(IBaseMod* pInstance);
	
	/**
	 * 停止运转，先stop thread再释放实例句柄，这期间还可以进行一些托管资源的清理工作
	 */
	virtual void stopInstance() = 0;
	
	/**
	 * 获取业务和BaseMod 交互运转的工作线程
	 */
	virtual ITaskThread* getTaskThread() = 0;
    
    /**
     * 设置系统参数
     */
    virtual void setUid(uint64_t uid) = 0;

	/**
	 * 创建一条通道-----------------------不用的时候需调用deleteChannel 删除
	 * @param channeId
	 * 			通道的AppId类型，取自EAppID
	 */
	virtual IChannel* createChannel(uint32_t appId,std::string& region) = 0;

	virtual IChannel* createLocalChannel() = 0;
	/**
	 * 删除一条通道链接----------------------不用的时候需调用deleteChannel 删除
	 */
	virtual void deleteChannel(IChannel* p) = 0;
	
	virtual MutexLock* getLock() = 0;
	/**
	 * 系统网络变化
	 * @param type
	 * 			网络类型
	 */
	virtual void onSystemNetworkChanged(NetworkType type) = 0;

protected:
	IBaseMod(){}
	virtual ~IBaseMod(){}
};

NAMESPACE_BASEMOD_END
#endif
