//
// Created by HuTao on 2019/4/13.
//

#ifndef YYSERVICESDK_PARENT_DOWNLINKNOTIFY_H
#define YYSERVICESDK_PARENT_DOWNLINKNOTIFY_H

#include "RequestResponse.h"

NAMESPACE_SERVICE_BEGIN
    class ForceOutNotify : public NotifyTask
    {
    public:
        enum {URI = 20};
        uint64_t mUid;
        uint32_t mCode;
        std::string mDesc;

        virtual uint32_t uri(){ return URI;}
        ForceOutNotify(uint64_t& uid,uint32_t& code,std::string& desc)
        :mUid(uid),mCode(code),mDesc(desc)
        {
        }
        virtual ~ForceOutNotify() {}
        virtual void marshal(Pack& pk) const
        {
            pk << mUid << mCode << mDesc;
        }
    };

    class BrocastNotify : public NotifyTask
    {
    public:
        enum {URI = 21};
        uint64_t mUid;

        uint32_t mAppid; // [必填] 应用标识
        uint64_t mUserGrpType; // [必填] 广播组
        uint64_t mUserGrpId; // [必填] 广播组

        std::string mServiceName; // [必填]业务路由配置依据(大类)(合法字符[0-9a-zA-Z])
        std::string mFunctionName; // [可选]业务路由配置依据(小类)(合法字符[0-9a-zA-Z])
        std::string mProtoType; // [可选]协议类型
        std::string mData; // [必填]业务包
        uint32_t mDataCRC; // [必填]业务包32位CRC校验

        // 多路去重
        uint64_t mServerId; // 发起广播进程标识
        uint64_t mSeqId; // 序号
        std::string mTraceId; // [必填]追踪监控用

        virtual uint32_t uri(){ return URI;}
        BrocastNotify(uint64_t& uid,uint32_t& appid,uint64_t& userGroupType,uint64_t& userGroupId,
                std::string& serviceName,std::string& functionName,std::string& protoType,std::string& data,
                uint32_t& dataCRC,uint64_t& serverId,uint64_t& seqId,std::string& traceId)
        {
            mUid = uid;
            mAppid = appid;
            mUserGrpType = userGroupType;
            mUserGrpId = userGroupId;
            mServiceName = serviceName;
            mFunctionName = functionName;
            mProtoType = protoType;
            mData = data;
            mDataCRC = dataCRC;
            mServerId = serverId;
            mSeqId = seqId;
            mTraceId = traceId;
        }
        virtual ~BrocastNotify() {}
        virtual void marshal(Pack& pk) const
        {
            pk << mUid << mAppid << mUserGrpType << mUserGrpId;
            pk << mServiceName << mFunctionName;
            pk << mProtoType << mData;
            pk << mTraceId;
        }
    };
    class BrocastV2Notify : public NotifyTask
    {
    public:
        enum {URI = 22};
        uint64_t mUid;
        
        uint32_t mAppid; // [必填] 应用标识
        std::string mUserGrp; // [必填] 广播组
        
        std::string mServiceName; // [必填]业务路由配置依据(大类)(合法字符[0-9a-zA-Z])
        std::string mFunctionName; // [可选]业务路由配置依据(小类)(合法字符[0-9a-zA-Z])
        std::string mProtoType; // [可选]协议类型
        std::string mData; // [必填]业务包
        uint32_t mDataCRC; // [必填]业务包32位CRC校验
        
        // 多路去重
        uint64_t mServerId; // 发起广播进程标识
        uint64_t mSeqId; // 序号
        std::string mTraceId; // [必填]追踪监控用
        
        virtual uint32_t uri(){ return URI;}
        BrocastV2Notify(uint64_t& uid,uint32_t& appid,std::string& userGroup,
                      std::string& serviceName,std::string& functionName,std::string& protoType,std::string& data,
                      uint32_t& dataCRC,uint64_t& serverId,uint64_t& seqId,std::string& traceId)
        {
            mUid = uid;
            mAppid = appid;
            mUserGrp = userGroup;
            mServiceName = serviceName;
            mFunctionName = functionName;
            mProtoType = protoType;
            mData = data;
            mDataCRC = dataCRC;
            mServerId = serverId;
            mSeqId = seqId;
            mTraceId = traceId;
        }
        virtual ~BrocastV2Notify() {}
        virtual void marshal(Pack& pk) const
        {
            pk << mUid << mAppid << mUserGrp;
            pk << mServiceName << mFunctionName;
            pk << mProtoType << mData;
            pk << mTraceId;
        }
    };
    class UnicastNotify : public NotifyTask
    {
    public:
        enum {URI = 23};
        uint64_t mUid; // [可选] 日志统计，客户端校验
        uint32_t mAppid; // [可选]
        uint32_t mInstid; // [可选]

        std::string mServiceName; // [必填]业务路由配置依据(大类)(合法字符[0-9a-zA-Z])
        std::string mFunctionName; // [可选]业务路由配置依据(小类)(合法字符[0-9a-zA-Z])
        std::string mProtoType; // [可选]协议类型
        std::string mData; // [必填]业务包
        uint32_t mDataCRC; // [必填]业务包32位CRC校验
        // 多路去重
        uint64_t mServerId; // 发起单播进程标识
        uint64_t mSeqId; // 序号
        std::string mTraceId; // [必填]追踪监控用

        virtual uint32_t uri(){ return URI;}
        UnicastNotify(uint64_t& uid,uint32_t& appid,uint32_t& instid,
                std::string& serviceName,std::string& functionName,std::string& protoType,std::string& data,
                uint32_t& dataCRC,uint64_t& serverId,uint64_t& seqId,std::string& traceId)
        {
            mUid = uid;
            mAppid = appid;
            mInstid = instid;
            mServiceName = serviceName;
            mFunctionName = functionName;
            mProtoType = protoType;
            mData = data;
            mDataCRC = dataCRC;
            mServerId = serverId;
            mSeqId = seqId;
            mTraceId = traceId;
        }
        virtual ~UnicastNotify() {}
        virtual void marshal(Pack& pk) const
        {
            pk << mUid << mAppid;
            pk << mServiceName << mFunctionName;
            pk << mProtoType << mData;
            pk << mTraceId;
        }
    };
NAMESPACE_SERVICE_END

#endif //YYSERVICESDK_PARENT_DOWNLINKNOTIFY_H
