//
// Created by HUTAO on 2017/6/27.
//

#ifndef YYPROTO_PACKET_CPP_H
#define YYPROTO_PACKET_CPP_H
#include <stdexcept>
#include <assert.h>

#include "commondefine.h"
#include "blockbuffer.h"

#ifdef ANDROID
//#define HAS_EXCEPTION
//#undef NO_EXCEPTION
#undef HAS_EXCEPTION
#define NO_EXCEPTION
#endif

NAMESPACE_BASEMOD_BEGIN
	
#define XHTONS
#define XHTONL
#define XHTONLL
#define XHTONF
#define XHTOND
#define XHTONS_SIGN
#define XHTONL_SIGN
#define XHTONLL_SIGN
	
#define XNTOHS XHTONS
#define XNTOHL XHTONL
#define XNTOHLL XHTONLL

#define XNTOHS_SIGN XHTONS_SIGN
#define XNTOHL_SIGN XHTONL_SIGN
#define XNTOHLL_SIGN XHTONLL_SIGN
#define XNTOHF XHTONF
	
#ifdef HAS_EXCEPTION
	struct PacketError : public std::runtime_error
	{
		PacketError(const std::string & w) : std::runtime_error(w) {}
	};

	struct PackError : public PacketError
	{
		PackError(const std::string & w) :PacketError(w) {	}
	};

	struct UnpackError : public PacketError
	{
		UnpackError(const std::string & w) : PacketError(w) {	}
	};
#endif

#define PACK_LEN_U32()
#define PACK_STR_L32(_pk, _s) _pk.push_varstr32(_s.data(), _s.size())
#define UNPACK_STR_L32(_up, _s) _s = _up.pop_varstr32();
	
	class PackBuffer {
	public:
		char * data() {
			return bb.data();
		}
		size_t size() const {
			return bb.size();
		}
		
		bool resize(size_t n) {
			return bb.resize(n);
		}
		bool append(const char * data, size_t size) {
		    return bb.append(data, size);
		}
		bool append(const char * data) {
			return append(data,:: strlen(data));
		}
		bool replace(size_t pos, const char * rep, size_t n) {
			return bb.replace(pos, rep, n) ;
		}
		bool reserve(size_t n) {
			return bb.reserve(n);
		}
		
		friend class PackBufferX;
	
	private:
		// use big-block. more BIG? MAX 64K*4k = 256M
		typedef BlockBuffer<def_block_alloc_4k, 65536> BB;
		BB bb;
	};
	
	struct Varstr {
		const char * m_data;
		size_t m_size;
		
		Varstr() : m_data(NULL), m_size(0){}
		
		//Varstr(const char * data = "", size_t size = 0) VARSTR_FORCE_INLINE{
		Varstr(const char * data, size_t size) {
			set(data, size);
		}
		void set(const char * data, size_t size) {
			m_data = data;
			m_size = size;
		}
		void assign(const char * data, size_t size) {
			m_data = data;
			m_size = size;
		}
		void clear() {
			m_data = NULL;
			m_size = 0;
		}
		bool empty() const {
			return m_size == 0;
		}
		
		const char * data() const {
			return m_data;
		}
		size_t size() const {
			return m_size;
		}
		size_t length() const {
			return m_size;
		}
		
		 std::string GetSTLString() const
		{
			return std::string(m_data, m_size);
		}
		
		std::wstring GetSTLWString() const
		{
			return std::wstring((wchar_t *)m_data, m_size / 2);
		}
		
		template<class T> // std::string cstr blockbuffer
		explicit Varstr(T & s) {
			*this = s;
		}
		
		template<class T>
		Varstr& operator =(T & s) {
			m_data = s.data();
			m_size = s.size();
			return *this;
		}
	};
	
	//替代std::string，避免拷贝（string的assign是有成本的）
	//改为跟NAMESPACE_PROTOCOL_IM::Varstr
	struct RawBasicString : public Varstr
	{
		RawBasicString() : Varstr(NULL, 0)
		{}
		RawBasicString(const char* pData, const size_t uSize) : Varstr(pData, uSize)
		{}
		
		RawBasicString& operator = (const std::string& o)
		{
			m_data = o.data();
			m_size = o.size();
			return *this;
		}
	};
	
	inline std::ostream & operator <<(std::ostream & os, const Varstr & vs) {
		return os.write(vs.data(), std::streamsize(vs.size()));
	}
	
	class Pack
	{
	private:
		Pack (const Pack & o);
		Pack & operator = (const Pack& o);
	public:
		uint16_t xhtons(uint16_t i16) { return XHTONS(i16); }
		uint32_t xhtonl(uint32_t i32) { return XHTONL(i32); }
		uint64_t xhtonll(uint64_t i64) { return XHTONLL(i64); }
		inline float xhtonf(float f) {
			return XHTONF(f);
			/*char tmp[4];
			tmp[0] = (uint32_t)f & 0x000000ff;
			tmp[1] = (uint32_t)f & 0x0000ff00;
			tmp[2] = (uint32_t)f & 0x00ff0000;
			tmp[3] = (uint32_t)f & 0xff000000;
			return *(float*)tmp;*/
		}
		inline double xhtond(double d) {
			return XHTOND(d);
		}
		// IMPORTANT remember the buffer-size before pack. see data(), size()
		// reserve a space to replace packet header after pack parameter
		// sample below: OffPack. see data(), size()
		Pack(PackBuffer & pb, size_t off = 0)
		: m_buffer(pb),m_bPackError(false)
		{
			m_offset = pb.size() + off;
			if(!m_buffer.resize(m_offset))
			{
				m_bPackError = true;
			}
		}
		
		// access this packet.
		char * data()       { return m_buffer.data() + m_offset; }
		const char * data()  const { return m_buffer.data() + m_offset; }
		size_t size() const { return m_buffer.size() - m_offset; }
		
		size_t bufsize() const { return m_buffer.size();}
		
		Pack & push(const void * s, size_t n) {
            if(!m_buffer.append((const char *)s, n)){
                m_bPackError = true;
            }
            return *this;
        }
		Pack & push(const void * s){
            if(!m_buffer.append((const char *)s))
            {
                m_bPackError = true;
            }
            return *this;
        }
		
		Pack & push_uint8(uint8_t u8)	 { return push(&u8, 1); }
		Pack & push_uint16(uint16_t u16) { u16 = xhtons(u16); return push(&u16, 2); }
		Pack & push_uint32(uint32_t u32) { u32 = xhtonl(u32); return push(&u32, 4); }
		Pack & push_uint64(uint64_t u64) { u64 = xhtonll(u64); return push(&u64, 8); }
		Pack & push_float(float f)       { f = xhtonf(f); return push(&f, sizeof(float)); }
		Pack & push_double(double d)       { d = xhtond(d); return push(&d, sizeof(double)); }
		
		Pack & push_varstr(const Varstr & vs)     { return push_varstr(vs.data(), vs.size()); }
		Pack & push_varstr(const void * s)        { return push_varstr(s, strlen((const char *)s)); }
		Pack & push_varstr(const std::string & s) { return push_varstr(s.data(), s.size()); }
		Pack & push_varstr(const void * s, size_t len)
		{
			if (len > 0xFFFF)
			{
				len = 0;
				m_bPackError = true;
			}
			return push_uint16(uint16_t(len)).push(s, len);
		}
		Pack & push_varstr32(const void * s, size_t len)
		{
			if (len > 0xFFFFFFFF)
			{
				len = 0;
				m_bPackError = true;
			}
			return push_uint32(uint32_t(len)).push(s, len);
		}
#if defined(WIN32) || defined(__SYMBIAN32__)
		Pack & push_varwstring32(const std::wstring &ws){
		size_t len = ws.size() * 2;
		return push_uint32((uint32_t)len).push(ws.data(), len);
	}
#else // wchar_t is 4 bytes!!
		Pack & push_varwstring32(const std::wstring &ws)
		{
			size_t len = ws.size() * 2;
			unsigned short * buf = new unsigned short[ws.size()];
			for ( size_t i = 0; i < ws.size(); i++ )
			{
#ifdef __IM__
				//使用0xFF截取时，wstring的汉字会只截取到一半，出现乱码，但是不了解原设计者的意图，所以IM这边先改为0xFFFF
			buf[i] = (unsigned short)(ws[i] & 0xFFFF);
#else
				buf[i] = (unsigned short)(ws[i] & 0xFF);
#endif
			}
			Pack &tempPack = push_uint32((uint32_t)len).push(buf, len);
			delete[] buf;
			return tempPack;
		}
#endif
		
		virtual ~Pack() {}
	public:
		// replace. pos is the buffer offset, not this Pack m_offset
		size_t replace(size_t pos, const void * data, size_t rplen) {
			if (m_buffer.replace(pos, (const char*)data, rplen) == false)
			{
				m_bPackError = true;
			}
			return pos + rplen;
		}
		size_t replace_uint8(size_t pos, uint8_t u8)    { return replace(pos, &u8, 1); }
		size_t replace_uint16(size_t pos, uint16_t u16) {
			u16 = xhtons(u16);
			return replace(pos, &u16, 2);
		}
		size_t replace_uint32(size_t pos, uint32_t u32) {
			u32 = xhtonl(u32);
			return replace(pos, &u32, 4);
		}
		// replace_offset. pos is a relative offset of the buffer:
		// real pos of m_buffer = pos + original offset of this Pack (m_offset)
		size_t replace_offset(size_t pos, const void * data, size_t rplen) {
			if (m_buffer.replace(pos + m_offset, (const char*)data, rplen) == false)
			{
				m_bPackError = true;
			}
			return pos + rplen;
		}
		size_t replace_offset_uint8(size_t pos, uint8_t u8)    {
			return replace_offset(pos, &u8, 1);
		}
		size_t replace_offset_uint16(size_t pos, uint16_t u16) {
			u16 = xhtons(u16);
			return replace_offset(pos, &u16, 2);
		}
		size_t replace_offset_uint32(size_t pos, uint32_t u32) {
			u32 = xhtonl(u32);
			return replace_offset(pos, &u32, 4);
		}
		bool isPackError() const
		{
			return m_bPackError;
		}
		void setPackError() const
		{
			m_bPackError = true;
		}
	protected:
		PackBuffer & m_buffer;
		size_t m_offset;
		mutable bool m_bPackError;

		friend class PackX;
	};
	
	class Unpack
	{
		friend class UnpackX;
	public:
		uint16_t xntohs(uint16_t i16) const { return XNTOHS(i16); }
		uint32_t xntohl(uint32_t i32) const { return XNTOHL(i32); }
		uint64_t xntohll(uint64_t i64) const { return XNTOHLL(i64); }
		inline float xhtonf(float f) const {
			char tmp[4];
			tmp[0] = (uint32_t)f & 0x000000ff;
			tmp[1] = (uint32_t)f & 0x0000ff00;
			tmp[2] = (uint32_t)f & 0x00ff0000;
			tmp[3] = (uint32_t)f & 0xff000000;
			return *(float*)tmp;
		}
		Unpack(const void * data, size_t size)
        : m_bUnpackError(false)
		{
			reset(data, size);
		}
		void reset(const void * data, size_t size) const
		{
			m_data = (const char *)data;
			m_size = size;
            m_bUnpackError = false;
		}
		
		virtual ~Unpack() { m_data = NULL;  }
		
		operator const void *() const { return m_data; }
		bool operator!() const  { return (NULL == m_data); }
		
		std::string pop_varstr() const {
			Varstr vs = pop_varstr_ptr();
            if(m_bUnpackError)
            {
                return "";
            }
			return std::string(vs.data(), vs.size());
		}
		
		std::string pop_varstr32() const {
			Varstr vs = pop_varstr32_ptr();
            if(m_bUnpackError)
            {
                return "";
            }
			return std::string(vs.data(), vs.size());
		}

#if defined(WIN32) || defined(__SYMBIAN32__)
		std::wstring pop_varwstring32() const{
		Varstr vs = pop_varstr32_ptr();
        if(m_bUnpackError)
        {
            return L"";
        }
		return std::wstring((wchar_t *)vs.data(), vs.size() / 2);
	}
#else // wchar_t is 4 bytes on linux!
		std::wstring pop_varwstring32() const
		{
			Varstr vs = pop_varstr32_ptr();
            if(m_bUnpackError)
            {
                return L"";
            }
			std::wstring ws;
			size_t len = vs.size() / 2;
			for ( size_t i = 0; i < len; i++)
			{
				unsigned short * buf = (unsigned short *)vs.data();
				ws.push_back((wchar_t)buf[i]);
			}
			return ws;
		}
#endif
		
		std::string pop_fetch(size_t k) const {
            if(m_bUnpackError)
            {
                return "";
            }
			return std::string(pop_fetch_ptr(k), k);
		}
		
		void finish() const {
			if (!empty())
			{
                m_bUnpackError = true;
			}
		}
		float pop_float() const {
			size_t len = sizeof(float);
			if (m_size < len)
			{
                m_bUnpackError = true;
                return 0.0;
			}
			
			float f = 0;
			memcpy(&f, m_data, sizeof(float));
			m_data += len; m_size -= len;
			return f;
		}
		double pop_double() const {
			size_t len = sizeof(double);
			if (m_size < len)
			{
                m_bUnpackError = true;
                return 0.0;
			}
			
			double d = 0;
			memcpy(&d, m_data, sizeof(double));
			m_data += len; m_size -= len;
			return d;
		}
		uint8_t pop_uint8() const {
			if (m_size < 1u)
			{
                m_bUnpackError = true;
                return 0;
			}

			uint8_t i8 = 0;
			memcpy(&i8, m_data, sizeof(uint8_t));
			m_data += 1u; m_size -= 1u;
			return i8;
		}
		
		uint16_t pop_uint16() const {
			if (m_size < 2u)
			{
                m_bUnpackError = true;
                return 0;
			}

			uint16_t i16 = 0;
			memcpy(&i16, m_data, sizeof(uint16_t));
			i16 = xntohs(i16);
			m_data += 2u; m_size -= 2u;
			return i16;
		}
		
		uint32_t pop_uint32() const {
			if (m_size < 4u)
			{
                m_bUnpackError = true;
                return 0;
			}
			uint32_t i32 = 0;
			memcpy(&i32, m_data, sizeof(uint32_t));
			i32 = xntohl(i32);
			m_data += 4u; m_size -= 4u;
			return i32;
		}
		
		uint32_t peek_uint32() const {
			if (m_size < 4u)
			{
                m_bUnpackError = true;
                return 0;
			}
			uint32_t i32 = 0;
			memcpy(&i32, m_data, sizeof(uint32_t));
			i32 = xntohl(i32);
			return i32;
		}
		
		uint64_t pop_uint64() const {
			if (m_size < 8u)
			{
                m_bUnpackError = true;
                return 0;
			}
			uint64_t i64 = 0;
			memcpy(&i64, m_data, sizeof(uint64_t));
			i64 = xntohll(i64);
			m_data += 8u; m_size -= 8u;
			return i64;
		}
		
		Varstr pop_varstr_ptr() const {
			// Varstr { uint16_t size; const char * data; }
			Varstr vs;
			vs.m_size = pop_uint16();
			vs.m_data = pop_fetch_ptr(vs.m_size);
			return vs;
		}
		
		Varstr pop_varstr32_ptr() const {
			Varstr vs;
			vs.m_size = pop_uint32();
			vs.m_data = pop_fetch_ptr(vs.m_size);
			return vs;
		}
		
		const char * pop_fetch_ptr(size_t& k) const {
			if (m_size < k)
			{
                m_bUnpackError = true;
                k = m_size;
			}
			
			const char * p = m_data;
			m_data += k; m_size -= k;
			return p;
		}
		
		bool empty() const	  { return m_size == 0; }
		const char * data() const { return m_data; }
		size_t size() const	  { return m_size; }
        bool isUnpackError() const
        {
            return m_bUnpackError;
        }
        
        void setUnpackError() const
        {
            m_bUnpackError = true;
        }
	private:
		mutable const char * m_data;
		mutable size_t m_size;
        mutable bool m_bUnpackError;
	};
	
	struct Marshallable
	{
		virtual void marshal(Pack &) const {};
		virtual void unmarshal(const Unpack &) {};
		virtual ~Marshallable() {}
		virtual std::ostream & trace(std::ostream & os) const
		{ return os << "trace Marshallable [ not immplement ]"; }
	};
	
	// Marshallable helper
	inline std::ostream & operator << (std::ostream & os, const Marshallable & m)
	{
		return m.trace(os);
	}
	
	inline Pack & operator << (Pack & p, const Marshallable & m)
	{
		m.marshal(p);
		return p;
	}
	
	inline const Unpack & operator >> (const Unpack & p, const Marshallable & m)
	{
		const_cast<Marshallable &>(m).unmarshal(p);
		return p;
	}
	
	// base type helper
	inline Pack & operator << (Pack & p, bool sign)
	{
		p.push_uint8(sign ? 1 : 0);
		return p;
	}
	
	inline Pack & operator << (Pack & p, uint8_t  i8)
	{
		p.push_uint8(i8);
		return p;
	}
	
	inline Pack & operator << (Pack & p, uint16_t  i16)
	{
		p.push_uint16(i16);
		return p;
	}
	
	inline Pack & operator << (Pack & p, uint32_t  i32)
	{
		p.push_uint32(i32);
		return p;
	}
	inline Pack & operator << (Pack & p, uint64_t  i64)
	{
		p.push_uint64(i64);
		return p;
	}
	
	inline Pack& operator << (Pack & p, int64_t  i64)
	{
		p.push_uint64(i64);
		return p;
	}
	inline Pack & operator << (Pack & p, int8_t i8)
	{
		p.push_uint8((uint8_t)i8);
		return p;
	}
	
	inline Pack & operator << (Pack & p, const std::string & str)
	{
		p.push_varstr(str);
		return p;
	}
	
	inline Pack & operator << (Pack & p, const std::wstring & str)
	{
		p.push_varwstring32(str);
		return p;
	}
	inline Pack & operator << (Pack & p, float  f)
	{
		p.push_float(f);
		return p;
	}
	
	inline Pack & operator << (Pack & p, double  d)
	{
		p.push_double(d);
		return p;
	}
	
	inline Pack & operator << (Pack & p, const Varstr & pstr)
	{
		p.push_varstr(pstr);
		return p;
	}
	
	inline const Unpack & operator >> (const Unpack & p, Varstr & pstr)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		pstr = p.pop_varstr_ptr();
		return p;
	}
	
	inline const Unpack & operator >> (const Unpack & p, uint32_t & i32)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		i32 =  p.pop_uint32();
		return p;
	}
	
	inline const Unpack & operator >> (const Unpack & p, uint64_t & i64)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		i64 =  p.pop_uint64();
		return p;
	}
	
	inline const Unpack & operator >> (const Unpack & p, int64_t & i64)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		i64 = p.pop_uint64();
		return p;
	}
	
	inline const Unpack & operator >> (const Unpack & p, std::string & str)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		str = p.pop_varstr();
		return p;
	}
	
	inline const Unpack & operator >> (const Unpack & p, std::wstring & str)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		str = p.pop_varwstring32();
		return p;
	}
	
	inline const Unpack & operator >> (const Unpack & p, uint16_t & i16)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		i16 =  p.pop_uint16();
		return p;
	}
	
	inline const Unpack & operator >> (const Unpack & p, uint8_t & i8)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		i8 =  p.pop_uint8();
		return p;
	}
	
	inline const Unpack & operator >> (const Unpack & p, int8_t & i8)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		i8 = (int8_t)p.pop_uint8();
		return p;
	}
	inline const Unpack & operator >> (const Unpack & p, float & f)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		f = p.pop_float();
		return p;
	}
	inline const Unpack & operator >> (const Unpack & p, double & d)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		d = p.pop_double();
		return p;
	}
	inline const Unpack & operator >> (const Unpack & p, bool & sign)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		sign =  (p.pop_uint8() == 0) ? false : true;
		return p;
	}
	
	template <class T1, class T2>
	inline std::ostream& operator << (std::ostream& s, const std::pair<T1, T2>& p)
	{
		s << p.first << '=' << p.second;
		return s;
	}
	
	template <class T1, class T2>
	inline Pack& operator << (Pack& s, const std::pair<T1, T2>& p)
	{
		s << p.first << p.second;
		return s;
	}
	
	template <class T1, class T2>
	inline const Unpack& operator >> (const Unpack& s, std::pair<const T1, T2>& p)
	{
        if (s.isUnpackError())
        {
            return s;
        }
		const T1& m = p.first;
		T1 & m2 = const_cast<T1 &>(m);
		s >> m2 >> p.second;
		return s;
	}
	
	template <class T1, class T2>
	inline const Unpack& operator >> (const Unpack& s, std::pair<T1, T2>& p)
	{
        if (s.isUnpackError())
        {
            return s;
        }
		s >> p.first >> p.second;
		return s;
	}
	
	// container marshal helper
	template < typename ContainerClass >
	inline void marshal_container(Pack & p, const ContainerClass & c)
	{
		p.push_uint32(uint32_t(c.size())); // use uint32 ...
		for (typename ContainerClass::const_iterator i = c.begin(); i != c.end(); ++i)
			p << *i;
	}
	
	template < typename OutputIterator >
	inline void unmarshal_container(const Unpack & p, OutputIterator i)
	{
        if (p.isUnpackError())
        {
            return;
        }
        uint32_t count = p.pop_uint32();
        if(p.isUnpackError())
        {
            return;
        }
        
        for (; count > 0; --count)
        {
            if(p.isUnpackError())
                return;
            typename OutputIterator::container_type::value_type tmp;
            p >> tmp;
            *i = tmp;
            ++i;
        }
	}
	
	template <class T>
	inline Pack& operator << (Pack& p, const std::vector<T>& vec)
	{
		marshal_container(p, vec);
		return p;
	}
	
	template <class T>
	inline const Unpack& operator >> (const Unpack& p, std::vector<T>& vec)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		unmarshal_container(p, std::back_inserter(vec));
		return p;
	}
	
	template <class T>
	inline Pack& operator << (Pack& p, const std::set<T>& set)
	{
		marshal_container(p, set);
		return p;
	}
	
	template <class T>
	inline const Unpack& operator >> (const Unpack& p, std::set<T>& set)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		unmarshal_container(p, std::inserter(set, set.begin()));
		return p;
	}
	
	template <class T1, class T2>
	inline Pack& operator << (Pack& p, const std::map<T1, T2>& map)
	{
		marshal_container(p, map);
		return p;
	}
	
	template <class T1, class T2>
	inline const Unpack& operator >> (const Unpack& p, std::map<T1, T2>& map)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		unmarshal_container(p, std::inserter(map, map.begin()));
		return p;
	}
	
	template < typename OutputIterator >
	inline void unmarshal_container_pair(const Unpack &p, OutputIterator i )
	{
        if (p.isUnpackError())
        {
            return;
        }
        uint32_t count = p.pop_uint32();
        if(p.isUnpackError())
        {
            return;
        }
        
        for (; count > 0; --count)
        {
            if(p.isUnpackError())
                return;
            typename OutputIterator::container_type::value_type::second_type d;
            typename OutputIterator::container_type::value_type tmp(0,d);
            p >> tmp;
            *i = tmp;
            ++i;
        }
	}
	
	template < typename OutputContainer>
	inline void unmarshal_containerEx(const Unpack & p, OutputContainer & c)
	{
        if (p.isUnpackError())
        {
            return;
        }
        uint32_t count = p.pop_uint32();
        if(p.isUnpackError())
        {
            return;
        }
        
        for( ; count >0 ; --count)
        {
            if(p.isUnpackError())
                return;
            typename OutputContainer::value_type tmp;
            tmp.unmarshal(p);
            c.push_back(tmp);
        }
	}
	
	template < typename ContainerClass >
	inline std::ostream & trace_container(std::ostream & os, const ContainerClass & c, char div='\n')
	{
		for (typename ContainerClass::const_iterator i = c.begin(); i != c.end(); ++i)
			os << *i << div;
		return os;
	}
	inline uint32_t peeklen(const void* d)
	{
		uint32_t l = XHTONL(*((uint32_t *) d));
		uint32_t len = 0;
		if ((l & 0x80000000) == 0)//old packet
		{
			len = l;
		} else //new audio packet
		{
			len = (l & 0x0000FFF0) >> 4;
		}
		return len;
	}
	inline void PacketToString(const Marshallable &objIn, std::string &strOut)
	{
		PackBuffer buffer;
		Pack pack(buffer);
		objIn.marshal(pack);
		strOut.assign(pack.data(), pack.size());
	}

#ifdef HAS_EXCEPTION
	inline bool StringToPacket(const std::string &strIn, Marshallable &objOut)
	{
        bool unpackError = false;
		try {
			Unpack unpack(strIn.data(), strIn.length());
			objOut.unmarshal(unpack);
            unpackError = unpack.isUnpackError();
		} catch (UnpackError e) {
			return false;
		}
		return !unpackError;
	}
#else
	inline bool StringToPacket(const std::string &strIn, Marshallable &objOut)
	{
		Unpack unpack(strIn.data(), strIn.length());
		objOut.unmarshal(unpack);
        return !unpack.isUnpackError();
	}
#endif
	
	struct Voidmable : public Marshallable
	{
		virtual void marshal(Pack &) const {}
		virtual void unmarshal(const Unpack &) {}
	};
	
	struct Mulmable : public Marshallable
	{
		Mulmable(const Marshallable & m1, const Marshallable & m2)
				: mm1(m1), mm2(m2) { }
		
		const Marshallable & mm1;
		const Marshallable & mm2;
		
		virtual void marshal(Pack &p) const          { p << mm1 << mm2; }
		virtual void unmarshal(const Unpack &p) { (void)p;assert(false); }
		virtual std::ostream & trace(std::ostream & os) const { return os << mm1 << mm2; }
	};
	
	struct Mulumable : public Marshallable
	{
		Mulumable(Marshallable & m1, Marshallable & m2)
				: mm1(m1), mm2(m2) { }
		
		Marshallable & mm1;
		Marshallable & mm2;
		
		virtual void marshal(Pack &p) const          { p << mm1 << mm2; }
		virtual void unmarshal(const Unpack &p) { p >> mm1 >> mm2; }
		virtual std::ostream & trace(std::ostream & os) const { return os << mm1 << mm2; }
	};
	
	struct Rawmable : public Marshallable
	{
		Rawmable(const char * data, size_t size) : m_data(data), m_size(size) {}
		
		template < class T >
		explicit Rawmable(T & t ) : m_data(t.data()), m_size(t.size()) { }
		
		const char * m_data;
		size_t m_size;
		
		virtual void marshal(Pack & p) const   { p.push(m_data, m_size); }
		virtual void unmarshal(const Unpack &) { assert(false); }
		//virtual std::ostream & trace(std::ostream & os) const { return os.write(m_data, m_size); }
	};
	
	struct Marshallable2: public Marshallable
	{
		virtual void marshal2(Pack &pk) const = 0;
		virtual void unmarshal2(const Unpack &up) = 0;
		
		virtual void marshal(Pack &pk) const
		{
			size_t pos = pk.size();
			pk.push_uint32(0);
			marshal2(pk);
			uint32_t len = (uint32_t)pk.size() - (uint32_t)pos - sizeof(uint32_t);
			pk.replace_offset_uint32(pos, len);
		}
		
		virtual void unmarshal(const Unpack &up)
		{
			size_t len = up.pop_uint32();
			if(len > up.size()) len = up.size();
			Unpack inner(up.pop_fetch_ptr(len), len);
			unmarshal2(inner);
		}
	};

NAMESPACE_BASEMOD_END
#endif //YYPROTO_PACKET_CPP_H
