﻿#ifndef _PROTOBASE_H
#define _PROTOBASE_H

#include "packet.h"
NAMESPACE_BASEMOD_BEGIN
    enum MOD_TYPE
    {
        MOD_TYPE_LOGIN = 0,
        MOD_TYPE_SESSION = 1,
        MOD_TYPE_MEDIA = 2,
        MOD_TYPE_REPORT = 3,
        MOD_TYPE_SVC = 4,
        MOD_TYPE_CHANNEL_REPORT = 5,
        MOD_TYPE_QOS_REPORT = 7,
        MOD_TYPE_IM_CHANNEL = 100  // add for im channel
    };
    struct RequestBase: public Marshallable
    {
        uint32_t                modType;
        std::string context;
        virtual RequestBase*    clone(){return NULL;};
        
        virtual void marshal(Pack &) const {};
        virtual void unmarshal(const Unpack &){};
    };
    
    struct EventBase: public Marshallable
    {
        uint32_t modType;
        std::string context;
    };
    
    struct IWatcher
    {
        virtual void onEvent(EventBase*) = 0;

#ifdef __IM__IOS__
		virtual std::string getToken() = 0;
#endif
    };
NAMESPACE_BASEMOD_END
#endif
