﻿#ifndef CROSS_PLANTFORM_CONST_H_
#define CROSS_PLANTFORM_CONST_H_

#include "commondefine.h"

#define MAX_SVID_NUM 20
#define SOCKET_TIMEOUT 60000
#define MYCOLLECTION_FOLDER 1000000000
#define PUBLICCHANNEL_FOLDER 1000000001
#define RECEMMONDCHANNEL_FOLDER 1000000002
#define HOT_FOLDER 1000000003
#define UDP_OFFSET 10000

#define NONE_SERVER_ID 0xffffffff

#define MAX_CHANNEL_SIZE 3
#ifdef WIN32
#define FAV_FOLDER		_T("1000000000")
#define FAV_PUBLIC		_T("1000000001")
#define FAV_RECOMMEND	_T("1000000002")
#define FAV_HOT			_T("1000000003")
#define KICKOUT_PID _T("")
#endif

#define SEQPAGE					1000
#define SEQORIGINAL				1000

#define DEF_SESSIONKEY_LENGTH 16

#define ADMIN_CHANNEL 0

#define NO_IMID -1

NAMESPACE_BASEMOD_BEGIN
	
	enum EAppMainType
	{
		TEST = 0,
		IM = 1,
		PUSHAP = 2,
		SESSION = 3,
		SERVICE = 4
	};
	
	enum SourceType
	{
		IP_SRC_DNS     = 1,
		IP_SRC_CACHE   = 2,
		IP_SRC_DEFAULT = 4,
		IP_SRC_DYN_DEF = 8,
#if !defined(_WIN32)
		IP_SRC_GSLB_DNS = 16,
#endif
	};
	
enum ISPType{
    AUTO_DETECT = 0,
    CTL  = 1,	 //电信
    CNC  = 2,	 //联通
    MUTIL= 3,    //双线
    CNII = 4,	 //铁通
    EDU  = 8,	 //教育网
    WBN  = 16,   //长城宽带
    MOB  = 32,   //移动
    BGP  = 64,   //BGP
    HK   = 128,  //香港
    BRA  = 256,  //巴西
    EU   = 512,  //欧洲
    NA   = 1024, //北美
    MAX_ISP   = 1024,  //THIS MUST BE THE MAXIMUM NUMBER AMONG AVAILABLE ISPS!!!
    
    SPEC_DEPLOY = 49, //used for free charge deployment
};

enum AreaType{//同网络类型的定义数字必需连续(分配的时候会用)
	AREA_UNKNOWN = 0,
	CTL_EAST = 16,  //电信东区     10000  (1<<4) + 0
	CTL_WEST = 17,  //电信西区     10001  (1<<4) + 1
    CTL_SOUTH=18,   //电信南区. 
	CNC_NE = 32,    //网通东北    100000 (2<<4) + 0
	CNC_NC = 33,    //网通华北    100001 (2<<4) + 1
	CNII_AREA = 64, //铁通       1000000 (4<<4) + 1
	EDU_AREA = 128, //教育网    10000000 (8<<4) +0
	WBN_AREA = 256,          //长城宽带 100000000 (16<<4) +0
	MOB_AREA = 512, //移动    1000000000 (32<<4) + 0

};

enum ChannelDeploy {
	UNKNOWN_SESSION = 0,
	GENERAL_SESSION = 3,	// general session, main deploy type
	SIFU_SESSION = 45,		
	PIP_SESSION = 46,
	IM_SESSION = 47,
	MAFIA_SESSION = 48,
};

NAMESPACE_BASEMOD_END
#endif /*CROSS_PLANTFORM_CONST_H_*/
