﻿#pragma once 

#include "commondefine.h"
#include <stdint.h>
#ifdef __APPLE__
#include <iconv.h>
#endif

NAMESPACE_BASEMOD_BEGIN

	class CCodeConvert
	{
	public:
#ifdef __APPLE__
		//°±°Ã°±?linux°Í?GBK?°ß??°Í°ß°‹a?°≠£§®≤°±°„°Í? -> UTF8°Í??°≠£§®≤°±°„°Í?
		static std::string GBKToUTF8(const std::string &str);
		//°±°Ã°±?windows?®¨?°¬°∆? -> UTF8
		static std::string UCSToUTF8(const std::wstring &wstr);
        
        //UTF32 -> UTF8
		static std::string UTF32ToUTF8(const std::wstring &wstr);
        
		//°±°Ã°±?UTF8 -> windows?®¨?°¬°∆?
		static std::wstring UTF8ToUCS(const std::string &str);
        // UTF8 To UTF32
        static std::wstring UTF8ToUTF32(const std::string &str);
        // UCS To UTF32
        static std::wstring UCSStringToUTF32(const std::string &str);
		//°±°Ã°±?linux °¬°¿¶∏°±-> windows?®¨?°¬°∆?
		static std::wstring GBKToUCS(const std::string &str);
		static std::string UCSToGBK(const std::wstring &wstr);

		static std::string UTF8ToGBK(const std::string &str);

		//
		static std::string ToStringUTF8(const std::string &str);
		static std::string ToStringUCS(const std::string &str);
        
        static std::wstring UTF8ToUTF16(const std::string &str);
        
        static int HexBinToInt(char hexbin);
        static std::wstring UTF8ToUTF16WString(const std::string &str);
        static std::string WStringUTF16ToUTF8(const std::wstring &wstr);
#endif
        static inline std::string  ToBase64String(const std::string &inStr);
	};
#ifdef __APPLE__
	inline std::string CCodeConvert::GBKToUTF8(const std::string &str)
	{
		iconv_t m_iconv = iconv_open("UTF-8//IGNORE", "GBK");
		size_t uInnerLen = str.size();
		char *pInner = new char[uInnerLen];
		memcpy(pInner, str.data(), str.size());

		size_t uOuterLen = uInnerLen * 2 + 2;
		char *pOuter = new char[uOuterLen];
		size_t uOuterLenBak = uOuterLen;
		memset(pOuter, 0, uOuterLen);

		char *pp1 = pInner;
		char *pp2 = pOuter;

		iconv(m_iconv, &pp1, &uInnerLen, &pp2, &uOuterLen);
		std::string strto((char *)(pOuter), (uOuterLenBak - uOuterLen));

		iconv_close(m_iconv);

		delete [] pInner;
		delete [] pOuter;
		return strto;
	}

	inline std::string CCodeConvert::UCSToUTF8(const std::wstring &wstr)
	{
		iconv_t m_iconv = iconv_open("UTF-8//IGNORE", "UCS-2LE");
        //iconv_t m_iconv = iconv_open("UTF-16LE", "UCS-2LE");

		size_t uSizeIn = wstr.size()*2;
		size_t uSizeOut = uSizeIn*2 + 1;

		char *pBuffIn = new char[uSizeIn];
		char *pBuffOut = new char[uSizeOut];
		memset(pBuffIn, 0, uSizeIn);
		memset(pBuffOut, 0, uSizeOut);

		memcpy(pBuffIn, (char*)wstr.data(), wstr.size()*2);

		char *ppIn = pBuffIn;
		char *ppOut = pBuffOut;
		size_t uInLeft = uSizeIn;
		size_t uOutLeft = uSizeOut;

		iconv(m_iconv, &ppIn, &uInLeft, &ppOut, &uOutLeft);
		iconv_close(m_iconv);

		std::string strRet(pBuffOut, uSizeOut - uOutLeft);
		delete[] pBuffIn;
		delete[] pBuffOut;

		return strRet;
	}

	inline std::wstring CCodeConvert::UTF8ToUCS(const std::string &str)
	{
		iconv_t m_iconv = iconv_open("UCS-2LE//IGNORE", "UTF8");
		size_t uInnerLen = str.size();
		char *pInner = new char[uInnerLen];
		memcpy(pInner, str.data(), str.size());

		size_t uOuterLen = uInnerLen * 2 + 2;
		char *pOuter = new char[uOuterLen];
		size_t uOuterLenBak = uOuterLen;
		memset(pOuter, 0, uOuterLen);

		char *pp1 = pInner;
		char *pp2 = pOuter;

		iconv(m_iconv, &pp1, &uInnerLen, &pp2, &uOuterLen);
#ifdef __APPLE__
        // in ios platform wstring is 4 byte so need two buyte blank
        // 0x4e2d       unicode
        // 0x00004e2d   Wstring
        size_t effectLen = (uOuterLenBak - uOuterLen);
        size_t toWstringSize = (effectLen / 2) * 4;
        char *transBuf = new char[toWstringSize];
        memset(transBuf, 0, toWstringSize);
        for (size_t indx = 0; indx < effectLen; ++indx)
        {
            transBuf[(indx/2)*4 + (indx % 2)] = pOuter[indx];
        }
        std::wstring wstr((wchar_t *)(transBuf), effectLen / 2);
#else
		std::wstring wstr((wchar_t *)(pOuter), (uOuterLenBak - uOuterLen) / 2);
#endif
		iconv_close(m_iconv);

		delete [] pInner;
		delete [] pOuter;
        delete [] transBuf;
		return wstr;
	}

	inline std::wstring CCodeConvert::GBKToUCS(const std::string &str)
	{
		iconv_t m_iconv = iconv_open("UCS-2LE//IGNORE", "GBK");

		size_t uInnerLen = str.size();
		char *pInner = new char[uInnerLen];
		memcpy(pInner, str.data(), str.size());

		size_t uOuterLen = uInnerLen * 2 + 2;
		char *pOuter = new char[uOuterLen];
		size_t uOuterLenBak = uOuterLen;
		memset(pOuter, 0, uOuterLen);

		char *pp1 = pInner;
		char *pp2 = pOuter;

		iconv(m_iconv, &pp1, &uInnerLen, &pp2, &uOuterLen);
		std::wstring wstr((wchar_t *)(pOuter), (uOuterLenBak - uOuterLen) / 2);

		iconv_close(m_iconv);

		delete [] pInner;
		delete [] pOuter;
		return wstr;
	}

	inline std::string CCodeConvert::UCSToGBK(const std::wstring &wstr)
	{
		iconv_t m_iconv = iconv_open("GBK//IGNORE", "UCS-2LE");

		size_t uSizeIn = wstr.size()*2;
		size_t uSizeOut = uSizeIn*2 + 1;

		char *pBuffIn = new char[uSizeIn];
		char *pBuffOut = new char[uSizeOut];
		memset(pBuffIn, 0, uSizeIn);
		memset(pBuffOut, 0, uSizeOut);

		memcpy(pBuffIn, (char*)wstr.data(), wstr.size()*2);

		char *ppIn = pBuffIn;
		char *ppOut = pBuffOut;
		size_t uInLeft = uSizeIn;
		size_t uOutLeft = uSizeOut;

		iconv(m_iconv, &ppIn, &uInLeft, &ppOut, &uOutLeft);
		iconv_close(m_iconv);

		std::string strRet(pBuffOut, uSizeOut - uOutLeft);
		delete[] pBuffIn;
		delete[] pBuffOut;

		return strRet;
	}

	inline std::string CCodeConvert::UTF8ToGBK(const std::string &str)
	{
		iconv_t m_iconv = iconv_open("GBK//IGNORE", "UTF-8");
		size_t uInnerLen = str.size();
		char *pInner = new char[uInnerLen];
		memcpy(pInner, str.data(), str.size());

		size_t uOuterLen = uInnerLen * 2 + 2;
		char *pOuter = new char[uOuterLen];
		size_t uOuterLenBak = uOuterLen;
		memset(pOuter, 0, uOuterLen);

		char *pp1 = pInner;
		char *pp2 = pOuter;

		iconv(m_iconv, &pp1, &uInnerLen, &pp2, &uOuterLen);
		std::string strto((char *)(pOuter), (uOuterLenBak - uOuterLen));

		iconv_close(m_iconv);

		delete [] pInner;
		delete [] pOuter;
		return strto;
	}

	inline std::string CCodeConvert::ToStringUTF8(const std::string &str)
	{
		iconv_t m_iconv = iconv_open("UTF-8//IGNORE", "UCS-2LE");

		size_t uSizeIn = str.size();
		size_t uSizeOut = uSizeIn*2 + 1;

		char *pBuffIn = new char[uSizeIn];
		char *pBuffOut = new char[uSizeOut];
		memset(pBuffIn, 0, uSizeIn);
		memset(pBuffOut, 0, uSizeOut);

		memcpy(pBuffIn, (char*)str.data(), str.size());

		char *ppIn = pBuffIn;
		char *ppOut = pBuffOut;
		size_t uInLeft = uSizeIn;
		size_t uOutLeft = uSizeOut;

		/*int ret1 = */iconv(m_iconv, &ppIn, &uInLeft, &ppOut, &uOutLeft);
		/*int ret2 = */iconv_close(m_iconv);

		std::string strRet(pBuffOut, uSizeOut - uOutLeft);
		delete[] pBuffIn;
		delete[] pBuffOut;

		return strRet;
	}

	inline std::string CCodeConvert::ToStringUCS(const std::string &str)
	{
		iconv_t m_iconv = iconv_open("UCS-2LE//IGNORE", "UTF8");

		size_t uInnerLen = str.size();
		char *pInner = new char[uInnerLen];
		memcpy(pInner, str.data(), str.size());

		size_t uOuterLen = uInnerLen * 2 + 2;
		char *pOuter = new char[uOuterLen];
		size_t uOuterLenBak = uOuterLen;
		memset(pOuter, 0, uOuterLen);

		char *pp1 = pInner;
		char *pp2 = pOuter;

		iconv(m_iconv, &pp1, &uInnerLen, &pp2, &uOuterLen);
		//std::wstring wstr((wchar_t *)(pOuter), (uOuterLenBak - uOuterLen) / 2);
		std::string strTo(pOuter, uOuterLenBak - uOuterLen);

		iconv_close(m_iconv);

		delete [] pInner;
		delete [] pOuter;
		return strTo;
	}
    
    inline std::wstring CCodeConvert::UTF8ToUTF16(const std::string &str)
    {
        size_t uInnerLen = str.size();
        char *pInner = new char[uInnerLen];
        memcpy(pInner, str.data(), str.size());
        
        size_t uOuterLen = uInnerLen * 2 + 2;
        char *pOuter = new char[uOuterLen];
        size_t uOuterLenBak = uOuterLen;
        memset(pOuter, 0, uOuterLen);
        
        char *pp1 = pInner;
        char *pp2 = pOuter;
        iconv_t m_iconv = iconv_open("UTF-16LE", "UTF-8");
        iconv(m_iconv, &pp1, &uInnerLen, &pp2, &uOuterLen);
        std::wstring wstr((wchar_t *)(pOuter), (uOuterLenBak - uOuterLen) / 2);
        
        delete [] pInner;
        delete [] pOuter;
        return wstr;
    }
    
    inline std::wstring CCodeConvert::UTF8ToUTF32(const std::string &str)
    {
        iconv_t m_iconv = iconv_open("UTF-32LE//IGNORE", "UTF8");
		size_t uInnerLen = str.size();
		char *pInner = new char[uInnerLen];
		memcpy(pInner, str.data(), str.size());
        
		size_t uOuterLen = uInnerLen * 4 + 4;
		char *pOuter = new char[uOuterLen];
		size_t uOuterLenBak = uOuterLen;
		memset(pOuter, 0, uOuterLen);
        
		char *pp1 = pInner;
		char *pp2 = pOuter;
        
		iconv(m_iconv, &pp1, &uInnerLen, &pp2, &uOuterLen);

		std::wstring wstr((wchar_t *)(pOuter), (uOuterLenBak - uOuterLen) / 4);
        
		iconv_close(m_iconv);
        
		delete [] pInner;
		delete [] pOuter;

		return wstr;
    }
    
    inline std::wstring CCodeConvert::UCSStringToUTF32(const std::string &str)
	{
		iconv_t m_iconv = iconv_open("UTF-32LE//IGNORE", "UCS-2LE");
        
		size_t uSizeIn = str.size();
		size_t uSizeOut = (uSizeIn/2)*4 + 1;
        
		char *pBuffIn = new char[uSizeIn];
		char *pBuffOut = new char[uSizeOut];
		memset(pBuffIn, 0, uSizeIn);
		memset(pBuffOut, 0, uSizeOut);
        
		memcpy(pBuffIn, (char*)str.data(), str.size());
        
		char *ppIn = pBuffIn;
		char *ppOut = pBuffOut;
		size_t uInLeft = uSizeIn;
		size_t uOutLeft = uSizeOut;
        
		iconv(m_iconv, &ppIn, &uInLeft, &ppOut, &uOutLeft);
		iconv_close(m_iconv);
        
//		std::string strRet(pBuffOut, uSizeOut - uOutLeft);
        std::wstring wstr((wchar_t *)(pBuffOut), (uSizeOut - uOutLeft) / 4);
		delete[] pBuffIn;
		delete[] pBuffOut;
        
		return wstr;
	}
    
    inline std::string CCodeConvert::UTF32ToUTF8(const std::wstring &wstr)
	{
		iconv_t m_iconv = iconv_open("UTF-8//IGNORE", "UTF-32LE");
        // UTF32 4 byte for eache simble
		size_t uSizeIn = wstr.size()*4;
		size_t uSizeOut = uSizeIn + 1;
        
		char *pBuffIn = new char[uSizeIn];
		char *pBuffOut = new char[uSizeOut];
		memset(pBuffIn, 0, uSizeIn);
		memset(pBuffOut, 0, uSizeOut);
        
		memcpy(pBuffIn, (char*)wstr.data(), uSizeIn);
        
		char *ppIn = pBuffIn;
		char *ppOut = pBuffOut;
		size_t uInLeft = uSizeIn;
		size_t uOutLeft = uSizeOut;
        
		iconv(m_iconv, &ppIn, &uInLeft, &ppOut, &uOutLeft);
		iconv_close(m_iconv);
        
		std::string strRet(pBuffOut, uSizeOut - uOutLeft);
		delete[] pBuffIn;
		delete[] pBuffOut;
        
		return strRet;
    }
    //跟Android端同样的处理std::string 与std::wstring的转换
    // 消息发送
    inline std::wstring CCodeConvert::UTF8ToUTF16WString(const std::string &str)
    {
        //转换为UTF16的char buf
        size_t uInnerLen = str.size();
        char *pInner = new char[uInnerLen];
        memcpy(pInner, str.data(), str.size());
        
        size_t uOuterLen = uInnerLen * 2 + 2;
        char *pOuter = new char[uOuterLen];
        size_t uOuterLenBak = uOuterLen;
        memset(pOuter, 0, uOuterLen);
        
        char *pp1 = pInner;
        char *pp2 = pOuter;
        iconv_t m_iconv = iconv_open("UTF-16LE", "UTF-8");
        iconv(m_iconv, &pp1, &uInnerLen, &pp2, &uOuterLen);
        iconv_close(m_iconv);
        //将UTF16的char buf 存放在wstring中
        //std::wstring wstr((wchar_t *)(pOuter), (uOuterLenBak - uOuterLen) / 2);
        std::wstring ws;
        size_t len = (uOuterLenBak - uOuterLen) / 2;
        unsigned short * buf = (unsigned short *)pOuter;
        for ( size_t i = 0; i < len; i++)
        {
            ws.push_back((wchar_t)buf[i]);
        }
        delete [] pInner;
        delete [] pOuter;
        
        return ws;
    }
    inline int CCodeConvert::HexBinToInt(char hexbin)
    {
        unsigned char hi = hexbin & 0xf0;
        unsigned char l = hexbin & 0x0f;
        unsigned char h = hi >> 4 & 0x0f;
        int ret = h * 16;
        ret = ret + l;
        return ret;
    }
    //消息接收 支持emoji
    inline std::string CCodeConvert::WStringUTF16ToUTF8(const std::wstring &wstr)
    {
        size_t len = wstr.size() * 4;
        char *pBuff = new char[len];
        
        memset(pBuff, 0, len);
        memcpy(pBuff, (char*)wstr.c_str(), len);
        //从wstring中取出UTF16编码的char buf
        size_t uSizeIn = wstr.size();
        unsigned short * buf = new unsigned short[uSizeIn * 2];
        memset(buf,0, uSizeIn * 2 * 2);
        for ( size_t i = 0; i < uSizeIn; i++ )
        {
//#ifdef __IM__
            buf[i] = (unsigned short)(wstr[i] & 0xFFFF);
//#else
//            buf[i] = (unsigned short)(wstr[i] & 0xFF);
//#endif
        }
        
        //转换为UTF-8 编码的char 并存储在string中
        iconv_t m_iconv = iconv_open("UTF-8//IGNORE", "UTF-16LE");
        // UTF16 2 byte for eache simble
        size_t bufInSize = uSizeIn * 4 ;
        size_t bufOutSize = bufInSize + 1;
        
        char *pBuffIn = new char[bufInSize];
        char *pBuffOut = new char[bufOutSize];
        memset(pBuffIn, 0, bufInSize);
        memset(pBuffOut, 0, bufOutSize);
        
        memcpy(pBuffIn, (char*)buf, bufInSize);
        
        char *ppIn = pBuffIn;
        char *ppOut = pBuffOut;
        size_t uInLeft = bufInSize;
        size_t uOutLeft = bufOutSize;
        
        size_t i = iconv(m_iconv, &ppIn, &uInLeft, &ppOut, &uOutLeft);
        iconv_close(m_iconv);
        //此时为UTF-8编码，单字节编码的第一字节为[00-7F]，双字节编码的第一字节为[C0-DF]，
        //三字节编码的第一字节为[E0-EF],四字节编码的第一字节[F0-F7]
        char* pOut = pBuffOut;
        size_t destSize = 0;
        while(*pOut!='\0')
        {
            int first = HexBinToInt(*pOut);
            if(first >=0 && first <= 128)
            {
                destSize = destSize + 1;
                pOut++;
            }else if(first >= 192 && first <= 223){
                destSize = destSize + 2;
                pOut = pOut + 2;
            }else if(first >= 224 && first <= 239){
                destSize = destSize + 3;
                pOut = pOut + 3;
            }else if(first >= 240 && first <= 247){
                destSize = destSize + 4;
                pOut = pOut + 4;
            }else {
                break;
            }
        }
        
        std::string strRet(pBuffOut, destSize);
        
        delete[] pBuffIn;
        delete[] pBuffOut;
        
        return strRet;
    }
    
    
#endif
    static const char KBase64Chars[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    inline std::string  CCodeConvert::ToBase64String(const std::string &inStr)
    {
        const unsigned char *inputData = (const unsigned char*)inStr.data();
        size_t size = inStr.length();
        /* valid output size ? */
        size_t len2 = 4 * ((size + 2) / 3) + 1;
        char *pBuffOut = new char[len2];
        char *p = pBuffOut;
        
        size_t leven = 3 * (size / 3);
        size_t i = 0;
        for ( i = 0; i < leven; i += 3)
        {
            *p++ = KBase64Chars[(inputData[0] >> 2) & 0x3F];
            *p++ = KBase64Chars[(((inputData[0] & 3) << 4) + (inputData[1] >> 4)) & 0x3F];
            *p++ = KBase64Chars[(((inputData[1] & 0xf) << 2) + (inputData[2] >> 6)) & 0x3F];
            *p++ = KBase64Chars[inputData[2] & 0x3F];
            inputData += 3;
        }
        /* Pad it if necessary...  */
        if (i < size)
        {
            unsigned a = inputData[0];
            unsigned b = (i+1 < size) ? inputData[1] : 0;
            
            *p++ = KBase64Chars[(a >> 2) & 0x3F];
            *p++ = KBase64Chars[(((a & 3) << 4) + (b >> 4)) & 0x3F];
            *p++ = (i+1 < size) ? KBase64Chars[(((b & 0xf) << 2)) & 0x3F] : L'=';
            *p++ = L'=';
        }
        
        /* append a NULL byte */
        *p = '\0';
        std::string strRet(pBuffOut, (p - pBuffOut + 1));
        delete[] pBuffOut;
        return strRet;
    }

NAMESPACE_BASEMOD_END
