package com.yy.platform.baseservice.task;

import android.os.Bundle;
import android.os.Handler;

import com.yy.platform.baseservice.IRPCChannel;
import com.yy.platform.baseservice.marshal.ProtoPacket;
import com.yy.platform.baseservice.utils.UserGroupTypeString;

import java.nio.ByteBuffer;
import java.util.Set;

public class BroadSubOrUnSubTaskV2 extends AbstractTask<BroadSubOrUnSubTaskV2.ResponseParam> {

    private BroadSubOrUnSubTaskV2.RequestParam mSrvReq;

    public static final long URI = 14;

    public BroadSubOrUnSubTaskV2(int reqId, BroadSubOrUnSubTaskV2.RequestParam requestParam,
                               IRPCChannel.RPCCallback<BroadSubOrUnSubTaskV2.ResponseParam> callback,
                               Bundle options, Handler scheduler) {
        super(URI, reqId, callback, options, scheduler);

        mSrvReq = requestParam;
    }

    @Override
    public byte[] marshall() {
        pushMarshallable(mSrvReq);
        return super.marshall();
    }

    @Override
    public void unmarshall(byte[] buf) {
        super.unmarshall(buf);
        mSrvRes = (BroadSubOrUnSubTaskV2.ResponseParam) popMarshallable(BroadSubOrUnSubTaskV2.ResponseParam.class);
    }

    public static class RequestParam extends ProtoPacket {
        private String mContext;
        private Set<UserGroupTypeString> mUserGrps;
        private byte mOptype;

        public RequestParam(String ctx, Set<UserGroupTypeString> userGrps, byte optype) {
            mContext = ctx;
            mUserGrps = userGrps;
            mOptype = optype;
        }

        @Override
        public void marshall(ByteBuffer byteBuffer) {
            super.marshall(byteBuffer);
            this.pushBytes(mContext.getBytes());
            this.pushCollection(mUserGrps, UserGroupTypeString.class);
            this.pushByte(mOptype);
        }

    }

    public static class ResponseParam extends ProtoPacket {
        public String mContext;
        public int mResCode;
        public String mErrMsg;

        public ResponseParam() {
        }

        @Override
        public void unmarshall(ByteBuffer buf) {
            super.unmarshall(buf);
            mContext = this.popString16("UTF-8");
            mResCode = this.popInt();
            mErrMsg = this.popString16("UTF-8");
        }
    }

    @Override
    public void onResponseSuccess(final int requestId, final int sdkResCode) {
        mScheduler.post(new Runnable() {
            @Override
            public void run() {
                mCallback.onSuccess(requestId, mSrvRes);
            }
        });
    }

    @Override
    public void onResponseFail(final int requestId, final int sdkResCode) {
        mScheduler.post(new Runnable() {
            @Override
            public void run() {
                mCallback.onFail(requestId, sdkResCode, mSrvRes.mResCode,
                        new Exception(mSrvRes.mErrMsg));
            }
        });
    }
}
