package com.yy.platform.baseservice.statis;

import android.net.NetworkInfo;

import com.yy.platform.baseservice.IChannelListener;
import com.yy.platform.baseservice.YYServiceCore;
import com.yy.platform.baseservice.notify.ReportItem;
import com.yy.platform.baseservice.notify.ReportServiceAct;
import com.yy.platform.baseservice.notify.ReportServiceActRtt;
import com.yy.platform.baseservice.notify.ReportServiceCount;
import com.yy.platform.baseservice.notify.ReportServiceRtt;
import com.yy.platform.baseservice.storage.ShareStore;
import com.yy.platform.baseservice.threads.ThreadManager;

public final class StatisReporter {

    private static StatisReporter sInstance = null;
    private boolean mDefaultHiidoApi = true;
    private IChannelListener.IServiceHiidoMetricsStatisApi mMetricsHiidoApi = null;
    private long mStatisUid = 0L;
    private int mABTest = -1;
    private YYServiceCore.BroadcastReceiverImpl mNetworkUtil = null;

    public synchronized static StatisReporter instance() {
        if (sInstance == null) {
            sInstance = new StatisReporter();
        }
        return sInstance;
    }

    private StatisReporter() {
    }

    public void init(int abTest, YYServiceCore.BroadcastReceiverImpl networkUtil) {
        mNetworkUtil = networkUtil;
        mABTest = abTest;

        mMetricsHiidoApi = new HiidoApiImpl(HiidoApiImpl.Region.Overseas);
        mDefaultHiidoApi = true;
    }

    public void deInit() {
        try {
            mMetricsHiidoApi = null;
            mDefaultHiidoApi = true;
        } catch (Throwable e) {
            YYServiceCore.log("ex:" + e.getLocalizedMessage());
        }
    }

    public void setMetricsHiidoApi(IChannelListener.IServiceHiidoMetricsStatisApi api) {
        if (api != null) {
            mMetricsHiidoApi = api;
            mDefaultHiidoApi = false;
        }
    }

    public void setStatisUid(long uid) {
        mStatisUid = uid;
    }

    public long getStaticUid() {
        return mStatisUid;
    }

    public void onServiceAct(final ReportServiceAct reportItem) {
        final String hdid = ShareStore.INSTANCE.getHdId();
        ThreadManager.executeOnSubThread(new Runnable() {
            @Override
            public void run() {
                try {
                    if ("ystinit".equals(reportItem.mAct)) {
                        //实时获取一次
                        int nt = mNetworkUtil.checkCurrentNetwork();
                        int ns = mNetworkUtil.getNetWorkState();
                        final long realt = System.currentTimeMillis() / 1000;
                        reportWithNetwork(reportItem, nt, ns, realt, hdid);
                    } else {
                        for (ReportItem.ServiceActKeyItem item : reportItem.mKeyFields) {
                            item.mStringFields.put("hdid", hdid);
                            item.mIntFields.put("ab", mABTest);
                            YYServiceCore.log("report act=" + reportItem.mAct
                                    + ",code=" + item.mIntFields.get("code") + ",num=" + item.mIntFields.get("num"));
                            mMetricsHiidoApi.reportStatisticContentTemporary(reportItem.mAct,
                                    item.mIntFields, item.mLongFields,
                                    item.mStringFields);
                        }

                    }
                } catch (Throwable e) {
                    YYServiceCore.log("report act ex:" + e.getMessage());
                    return;
                }
            }
        });
    }

    private void reportWithNetwork(ReportServiceAct reportItem, int nt, int ns, long realt, String hdid) {
        final int ncn = mNetworkUtil.getNetworkChangedCount();
        final long nct = mNetworkUtil.getLastNetworkChangedTs();
        for (ReportItem.ServiceActKeyItem item : reportItem.mKeyFields) {
            item.mStringFields.put("hdid", hdid);
            item.mIntFields.put("ab", mABTest);
            item.mIntFields.put("nt", nt);
            item.mIntFields.put("ns", ns);
            item.mIntFields.put("ncn", ncn);

            item.mLongFields.put("nct", nct);
            item.mLongFields.put("rdt", realt);

            mMetricsHiidoApi.reportStatisticContentTemporary(reportItem.mAct,
                    item.mIntFields, item.mLongFields,
                    item.mStringFields);
        }
        YYServiceCore.log("report act=" + reportItem.mAct + ",rdt=" + realt + ",nt=" + nt + ",ns=" + ns);
    }

    public void onServiceActRtt(final ReportServiceActRtt reportActItem) {
        final String hdid = ShareStore.INSTANCE.getHdId();
        final long realt = System.currentTimeMillis() / 1000;
        ThreadManager.executeOnSubThread(new Runnable() {
            @Override
            public void run() {
                try {
                    ReportServiceRtt reportItem = reportActItem.mRtt;
                    if ("ystap".equals(reportActItem.mAct.mAct)
                            || "ystsvclogin".equals(reportActItem.mAct.mAct)) {
                        //实时获取一次
                        int nt = mNetworkUtil.checkCurrentNetwork();
                        int ns = mNetworkUtil.getNetWorkState();

                        if (ns == NetworkInfo.State.CONNECTED.ordinal()) {
                            if (mDefaultHiidoApi) {
                                ((HiidoApiImpl) mMetricsHiidoApi).reportReturnCodeTemporary(reportItem.mScode,
                                        reportItem.mRttUri, reportItem.mRtt, reportItem.mRttCode);
                            } else {
                                mMetricsHiidoApi.reportReturnCode(reportItem.mScode, reportItem.mRttUri,
                                        reportItem.mRtt, reportItem.mRttCode);
                            }
                        }

                        reportWithNetwork(reportActItem.mAct, nt, ns, realt, hdid);
                    } else if ("ystrpc".equals(reportActItem.mAct.mAct)) {
                        //量较多，不实时检测
                        int nt = mNetworkUtil.getNetWorkType();
                        int ns = mNetworkUtil.getNetWorkState();
                        if (ns == NetworkInfo.State.CONNECTED.ordinal()) {
                            if (mDefaultHiidoApi) {
                                ((HiidoApiImpl) mMetricsHiidoApi).reportReturnCodeTemporary(reportItem.mScode,
                                        reportItem.mRttUri, reportItem.mRtt, reportItem.mRttCode);
                            } else {
                                mMetricsHiidoApi.reportReturnCode(reportItem.mScode, reportItem.mRttUri,
                                        reportItem.mRtt, reportItem.mRttCode);
                            }
                        }
                        reportWithNetwork(reportActItem.mAct, nt, ns, realt, hdid);
                    } else {
                        int ns = mNetworkUtil.getNetWorkState();
                        if (ns == NetworkInfo.State.CONNECTED.ordinal()) {
                            if (mDefaultHiidoApi) {
                                ((HiidoApiImpl) mMetricsHiidoApi).reportReturnCodeTemporary(reportItem.mScode,
                                        reportItem.mRttUri, reportItem.mRtt, reportItem.mRttCode);
                            } else {
                                mMetricsHiidoApi.reportReturnCode(reportItem.mScode, reportItem.mRttUri,
                                        reportItem.mRtt, reportItem.mRttCode);
                            }
                        }
                        for (ReportItem.ServiceActKeyItem item : reportActItem.mAct.mKeyFields) {
                            item.mStringFields.put("hdid", hdid);
                            item.mIntFields.put("ab", mABTest);

                            mMetricsHiidoApi.reportStatisticContentTemporary(reportActItem.mAct.mAct,
                                    item.mIntFields, item.mLongFields,
                                    item.mStringFields);
                        }
                        YYServiceCore.log("report act rtt=" + reportActItem.mAct.mAct + ",rdt=" + realt);
                    }
                } catch (Throwable e) {
                    YYServiceCore.log("report act rtt ex:" + e.getMessage());
                    return;
                }
            }
        });
    }

    public void onServiceRtt(final ReportServiceRtt reportItem) {
        ThreadManager.executeOnSubThread(new Runnable() {
            @Override
            public void run() {
                try {
                    if (mNetworkUtil.getNetWorkState() != NetworkInfo.State.CONNECTED.ordinal()) {
                        YYServiceCore.log("report rtt not network connected:" + reportItem.mRttUri);
                        return;
                    }
                    mMetricsHiidoApi.reportReturnCode(reportItem.mScode,
                            reportItem.mRttUri, reportItem.mRtt, reportItem.mRttCode);
                } catch (Throwable e) {
                    YYServiceCore.log("report rtt ex:" + e.getMessage());
                    return;
                }
            }
        });
    }

    public void onServiceCount(final ReportServiceCount reportItem) {
        ThreadManager.executeOnSubThread(new Runnable() {
            @Override
            public void run() {
                try {
                    if (mNetworkUtil.getNetWorkState() != NetworkInfo.State.CONNECTED.ordinal()) {
                        YYServiceCore.log("report count not network connected:" + reportItem.mCountUri);
                        return;
                    }
                    for (int i = 0; i < reportItem.mCountImtems.length; i++) {
                        mMetricsHiidoApi.reportCount(reportItem.mScode, reportItem.mCountUri,
                                reportItem.mCountImtems[i].mCountName,
                                reportItem.mCountImtems[i].mCount);
                    }
                } catch (Throwable e) {
                    YYServiceCore.log("report count ex:" + e.getMessage());
                    return;
                }

            }
        });
    }
}
