package com.yy.platform.baseservice.statis;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 * Created by WuWangchun on 2017/6/30.
 */

public class MetricsResult implements IJsonSerialize {
    private int scode;
    private String uri;
    private long reqTime;
    private String ret;
    private long rtime;

    public MetricsResult(int scode, String uri, long reqTime, String ret) {
        this.scode = scode;
        this.uri = uri;
        this.reqTime = reqTime;
        this.ret = ret;
        rtime = System.currentTimeMillis();
    }

    @Override
    public JSONObject toJson() {
        try {
            JSONObject obj = new JSONObject();
            obj.put("scode", scode);
            obj.put("uri", URLEncoder.encode(uri, "utf-8"));
            obj.put("reqtime", reqTime);
            obj.put("ret", URLEncoder.encode(ret, "utf-8"));
            obj.put("rtime", rtime);
            return obj;
        } catch (JSONException e) {
            return null;
        } catch (UnsupportedEncodingException e) {
            return null;
        } catch (Throwable e) {
            return null;
        }
    }

}