package com.yy.platform.baseservice.notify;

import com.yy.platform.baseservice.marshal.ProtoPacket;

import java.nio.ByteBuffer;

public class ReportServiceAct extends ProtoPacket {

    public String mAct;

    public ReportItem.ServiceActKeyItem[] mKeyFields;

    public static final long URI = 55;

    public ReportServiceAct() {
    }

    @Override
    public void unmarshall(byte[] buf) {
        super.unmarshall(buf);

        mAct = popString16("UTF-8");

        int len = popInt();
        mKeyFields = new ReportItem.ServiceActKeyItem[len];
        for (int i = 0; i < len; i++) {
            mKeyFields[i] = new ReportItem.ServiceActKeyItem();
            mKeyFields[i].mIntFields = popMap(String.class, Integer.class);
            mKeyFields[i].mLongFields = popMap(String.class, Long.class);
            mKeyFields[i].mStringFields = popMap(String.class, String.class);
        }
    }

    @Override
    public void unmarshall(ByteBuffer buf) {
        super.unmarshall(buf);

        mAct = popString16("UTF-8");

        int len = popInt();
        mKeyFields = new ReportItem.ServiceActKeyItem[len];
        for (int i = 0; i < len; i++) {
            mKeyFields[i] = new ReportItem.ServiceActKeyItem();
            mKeyFields[i].mIntFields = popMap(String.class, Integer.class);
            mKeyFields[i].mLongFields = popMap(String.class, Long.class);
            mKeyFields[i].mStringFields = popMap(String.class, String.class);
        }
    }
}
