package com.yy.platform.baseservice.statis;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Random;

public class Util {

    public static boolean empty(String s) {
        return s == null || s.length() == 0;
    }

    public static String asEmptyOnNull(String s) {
        return s == null ? "" : s;
    }

    public static String parseParam(String content, String param) {
        try {
            String[] params = content.split("&");
            String[] kv = null;
            for (String oneParam : params) {
                kv = oneParam.split("=");
                if (param.equals(kv[0])) {
                    return kv[1];
                }
            }
        } catch (Throwable e) {
            return "";
        }
        return "";
    }

    /**
     * 获取随机字符串
     *
     * @param length
     * @return
     */
    public static String getRandStringEx(int length) {
        byte[] charList = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
                'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
                'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
                'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
                'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        byte[] rev = new byte[length];
        Random f = new Random();
        for (int i = 0; i < length; i++) {
            rev[i] = charList[f.nextInt(charList.length - 1)];
        }
        return new String(rev);
    }

    public static long wallTimeSec() {
        return millisToSec(wallTimeMillis());
    }

    public static long wallTimeMillis() {
        return System.currentTimeMillis();
    }

    public static long millisToSec(long millis) {
        return (millis / 1000);
    }

    /**
     * MD5加密,且转成hexString
     *
     * @param data
     * @return
     * @throws Exception
     */
    public static String encryptMD5(String data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        return bytesToHexString(md5.digest(stringToBytes(data)));
    }

    /**
     * @param b to hexstring
     * @return
     * @throws UnsupportedEncodingException
     */
    public static String bytesToHexString(byte[] b) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (b != null) {
            for (int i = 0; i < b.length; i++) {
                sb.append(Integer.toString((b[i] & 0xff) + 0x100, 16)
                        .substring(1));
            }
        }
        return sb.toString();
    }

    /**
     * string to byte use UTF-8
     *
     * @param data
     * @return
     * @throws UnsupportedEncodingException
     */
    public static byte[] stringToBytes(String data) throws UnsupportedEncodingException {
        return data.getBytes("UTF-8");
    }
}
