package com.yy.platform.baseservice.statis;

import com.yy.platform.baseservice.YYServiceCore;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;

/**
 * Created by WuWangchun on 2017/6/30.
 */

public class MetricsPkg {
    private ConcurrentLinkedQueue<IJsonSerialize> reqData = new ConcurrentLinkedQueue<IJsonSerialize>();
    private HashMap<String, MetricsCount> counterData = new HashMap<String, MetricsCount>();
    private int maxCount;

    public MetricsPkg(int maxCount) {
        this.maxCount = maxCount;
    }

    public boolean addCounter(MetricsCount counter) {
        String key = counter.getKey();
        MetricsCount c = counterData.get(key);
        boolean ret = false;
        if (c == null) {
            synchronized (counterData) {
                MetricsCount one = counterData.get(key);
                if (one == null) {
                    counterData.put(key, (MetricsCount) counter.clone());
                    ret = true;
                } else {
                    one.count(counter.getValue(), counter.getInvokeCount());
                }
            }
        } else {
            c.count(counter.getValue(), counter.getInvokeCount());
        }
        return ret;
    }

    public void addMetricsResult(MetricsResult req) {
        reqData.add(req);
    }

    public List<JSONObject> toJson() {
        List<JSONObject> arr = new ArrayList<JSONObject>();
        long time = System.currentTimeMillis();
        int count = 0;

        Iterator<IJsonSerialize> iterator1 = reqData.iterator();
        JSONArray reqs = new JSONArray();
        while (iterator1.hasNext()) {
            reqs.put(iterator1.next().toJson());
            count++;
            if (count >= maxCount) {
                JSONObject obj = cutPiece(reqs, null, time);
                if (obj != null) {
                    arr.add(obj);
                }
                reqs = new JSONArray();
                count = 0;
            }
        }

        Iterator<MetricsCount> iterator2 = counterData.values().iterator();
        JSONArray cs = new JSONArray();
        while (iterator2.hasNext()) {
            cs.put(iterator2.next().toJson());
            count++;
            if (count >= maxCount) {
                JSONObject obj = cutPiece(reqs, cs, time);
                if (obj != null) {
                    arr.add(obj);
                }
                reqs = new JSONArray();
                cs = new JSONArray();
                count = 0;
            }
        }

        if (reqs.length() + cs.length() > 0) {
            JSONObject obj = cutPiece(reqs, cs, time);
            if (obj != null) {
                arr.add(obj);
            }
        }
        return arr;
    }

    private JSONObject cutPiece(JSONArray reqs, JSONArray counts, long time) {
        JSONObject ret = new JSONObject();
        try {
            if (reqs != null) {
                ret.put("reqdata", reqs);
            }
            if (counts != null) {
                ret.put("counterdata", counts);
            }

            ret.put("clienttime", time);
            return ret;
        } catch (JSONException e) {
            YYServiceCore.log(String.format(Locale.US, "report ex:%s", e.getLocalizedMessage()));
        }
        return null;
    }
}

