package com.yy.platform.baseservice.statis;

import com.yy.platform.baseservice.YYServiceCore;

import java.io.ByteArrayInputStream;
import java.util.Locale;

/**
 * http post请求，加密内容
 *
 * @author wsq
 * @date Aug 25, 2014 5:52:26 PM
 */
public class MetricsHttpEncryptUtil extends AbstractStatisHttpUtil {

    private static final String RSA_PUB_KEY = "MCwwDQYJKoZIhvcNAQEBBQADGwAwGAIRAMRSvSVZEbyQwtFwNtNiZKkCAwEAAQ==";

    private static final String URL_PARAM = "act=mmetric&smkdata=$smkdata&EC=$EC&appkey=$appkey&item=$item";

    private static final String URL_FORMAT = "http://%s/c.gif";

    private static final String DEFAULT_URL_HOST = "mlog.hiido.com";

    //新 20160801
    private static final String[] ADDRESSES = new String[]
    {
        "14.17.112.232", "14.17.112.233", "14.17.112.234",
        "14.17.112.235", "14.17.112.236", "14.17.112.237"
    };

    private String mUrlHost;

    private String mUrlService;

    private String[] mUrlAddress;

    public MetricsHttpEncryptUtil(String urlHost, String[] urlAddress) {
        this.mUrlAddress = urlAddress == null ? ADDRESSES : urlAddress;
        this.mUrlHost = urlHost == null ? DEFAULT_URL_HOST : urlHost;
        mUrlService = String.format(URL_FORMAT, mUrlHost);
    }

    @Override
    protected String[] getUrlAddress() {
        return mUrlAddress;
    }

    @Override
    protected String getUrlFormat() {
        return URL_FORMAT;
    }

    @Override
    protected String getUrlService() {
        return mUrlService;
    }

    private RsaCipher mRsaCipher = null;

    private RsaCipher getRsaCipher() throws Exception {
        if (mRsaCipher == null) {
            byte[] keyBytes = Base64Util.decode(RSA_PUB_KEY);
            ByteArrayInputStream bis = new ByteArrayInputStream(keyBytes);
            RsaCipher rc = new RsaCipher();
            rc.loadPublicKey(bis);
            mRsaCipher = rc;
        }
        return mRsaCipher;
    }

    @Override
    protected boolean sendContent(final String url, final String content,
                                  int tryTimes) {
        mThrowable = null;

        int initialTimes = tryTimes;

        String encryptUrl = String.format("%s?%s", url, URL_PARAM);
        String encryptContent = content;

// YYServiceCore.Log(String.format(Locale.US, "report to Metrics encryptUrl=%s,content=%s",
// encryptUrl,encryptContent));
        //===========加密数据与key begin
        try {
            String aesKey = "";
            String data = encryptContent;

            //随机生成一个AES密钥
            aesKey = Util.getRandStringEx(4);

            //AES加密数据
            AesCipher aesCipher = new AesCipher(aesKey.getBytes());
            data = aesCipher.encryptTlogBytesBase64(data.getBytes("UTF-8"));
            aesCipher = null;
            encryptUrl = String.format("%s&enc=b64", encryptUrl);

            //RSA加密密钥
            aesKey = getRsaCipher().encryptTlogAesKey(aesKey.getBytes());

            //赋值
            encryptContent = data;
            encryptUrl = encryptUrl.replace("$smkdata", aesKey);
            encryptUrl = encryptUrl.replace("$appkey", Util.parseParam(content, "appkey"));
            encryptUrl = encryptUrl.replace("$item", Util.parseParam(content, "act"));
        } catch (Throwable e) {
            YYServiceCore.log(String.format(Locale.US, "report encrypt exception = %s,statusCode=%s",
                    e, String.valueOf(getLastStatusCode())));
            //加密失败，直接返回false，不然就算成功发给服务器也解密失败
            mThrowable = e;
            return false;
        }
        //===========加密数据与key end

        final String tmpEncryptUrl = encryptUrl;

        do {
            try {
                //失败重发时
                // ==========重试次数 begin
                encryptUrl = tmpEncryptUrl.replace("$EC", lastTryTimes + "");
                //==========重试次数 end

                // 当前url尝试次数
                if (initialTimes != tryTimes) {
                    YYServiceCore.log(String.format(Locale.US,
                            "report Try again to send %s with url %s, tried times %d.",
                            encryptContent, encryptUrl, initialTimes - tryTimes));
                }
                //总重试次数
                lastTryTimes++;
                if (!post(encryptUrl, encryptContent)) {
                    YYServiceCore.log(String.format(Locale.US,
                            "report Failed to send %s to %s.", encryptContent, encryptUrl));
                    continue;
                }
                mThrowable = null;
// YYServiceCore.Log(String.format(Locale.US, "report Metrics Successfully sent %s to %s",
// encryptContent, encryptUrl));
                return true;
            } catch (Throwable e) {
                mThrowable = e;
                YYServiceCore.log(String.format(Locale.US, "report guid:%s. http statis exception %s",
                        Util.parseParam(content, "guid"), e));
            }
        } while (tryTimes-- > 0);
        return false;
    }
}
