package com.yy.platform.baseservice.statis;

import android.annotation.SuppressLint;
import android.text.TextUtils;

import com.yy.platform.baseservice.IChannelListener;
import com.yy.platform.baseservice.YYServiceCore;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SuppressWarnings({"WeakerAccess", "unused", "SameParameterValue"})
public final class HiidoApiImpl implements IChannelListener.IServiceHiidoMetricsStatisApi {

    public static String TAG = "ServiceReporterImpl";

    public enum Region {
        China, Overseas,
    }

    public static class Field {

        public static Field from(final Integer intValue) {
            return new Field(String.valueOf(intValue));
        }

        public static Field from(final Long longValue) {
            return new Field(String.valueOf(longValue));
        }

        public static Field from(final String stringValue) {
            return new Field(stringValue);
        }

        @Override
        public String toString() {
            return value;
        }

        private Field(String value) {
            this.value = value;
        }

        private String value;
    }

    // 目前主要服务于海外市场，因此默认使用海外域名
    private String mHiidoHost;
    private String mMetricsHost;

    private void setRegion(Region region) {
        switch (region) {
            case China:
                //默认 "mlog.hiido.com"
                mHiidoHost = "ylog.hiido.com";
                mMetricsHost = "klog.hiido.com";
                break;
            case Overseas:
                //默认 "mlog.hiido.com"
                mHiidoHost = "hlog.hiido.com";
                mMetricsHost = "klog.hiido.com";
                break;
            default:
                YYServiceCore.log("hiido.Reporter | Unknown region: " + region);
        }
    }

    public HiidoApiImpl(Region region) {
        setRegion(region);

        mMetricsWorker = new MetricsWorker(
                "44b8f2b988e258e1d036acd459afaacc",
                new MetricsHttpEncryptUtil(mMetricsHost, null),
                new StatisHttpEncryptUtil(mHiidoHost, null));
    }

    private void doGetReport(final String act, final Map<String, Field> fields) {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(String.format(Locale.US, "https://%s/c.gif?%s",
                    mHiidoHost,
                    queryString(act, fields)));

            conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("GET");
            conn.setReadTimeout(6000);
            conn.setConnectTimeout(10000);

            // 调用此方法就不必再使用conn.connect()方法
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                YYServiceCore.log(String.format(Locale.US, "report | Success"));
            } else {
                String failure = getStringFromInputStream(conn.getErrorStream());
                YYServiceCore.log(String.format(Locale.US, "report | Failed: [" + responseCode + "] " + failure));
            }
        } catch (Exception e) {
            YYServiceCore.log(String.format(Locale.US, "report | Exception: " + e.getLocalizedMessage()));
        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    @SuppressLint("DefaultLocale")
    private String queryString(String act, Map<String, Field> fields) throws InvalidParameterException {
        long ts = System.currentTimeMillis() / 1000;
        String key = actionKey(act, ts);
        if (key == null) {
            throw new InvalidParameterException("Can't log action key with act");
        }

        List<String> components = new ArrayList<>();
        components.add(String.format(Locale.US, "act=%s", act));
        components.add(String.format(Locale.US, "time=%d", ts));
        components.add(String.format(Locale.US, "key=%s", key));  // PC和移动端(Act)上报必须同时携带校验key

        for (Map.Entry<String, Field> entry : fields.entrySet()) {
            Field field = entry.getValue();
            if (!isAcceptableField(field)) {
                YYServiceCore.log(String.format(Locale.US, "Null Field: %s", entry.getKey()));
                continue;
            }

            try {
                String encodedValue = URLEncoder.encode(entry.getValue().toString(), "utf-8");
                components.add(String.format(Locale.US, "%s=%s", entry.getKey(), encodedValue));
            } catch (UnsupportedEncodingException e) {
                YYServiceCore.log(String.format(Locale.US, "Invalid Field: %s = %s", entry.getKey(), field));
            }
        }

        return TextUtils.join("&", components);
    }

    private String getStringFromInputStream(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len;
        while ((len = is.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
        is.close();
        String state = os.toString();
        os.close();

        return state;
    }

    public String actionKey(String act, long ts) {

        // 具体算法请参阅：
        // https://cloud.hiido.com/document/act

        String content = act + String.valueOf(ts) + "HiidoYYSystem";
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] bytes = md5.digest(content.getBytes());
            StringBuilder sb = new StringBuilder();
            for (byte b : bytes) {
                String temp = Integer.toHexString(b & 0xff);
                if (temp.length() == 1) {
                    temp = "0" + temp;
                }
                sb.append(temp);
            }
            return sb.toString().toLowerCase();
        } catch (NoSuchAlgorithmException e) {
            YYServiceCore.log(String.format(Locale.US, "report ex:%s", e.getLocalizedMessage()));
            return null;
        }
    }

    private boolean isAcceptableField(Field field) {
        return field != null;
    }

    private MetricsWorker mMetricsWorker;

    public void reportReturnCodeTemporary(int scode, String uri, long timeConsumption, String code) {
        YYServiceCore.log(String.format("report rtt tempory,uri=%s,rtt=%d,code=%s", uri, timeConsumption, code));
        mMetricsWorker.reportReturnCodeTemporary(scode, uri, timeConsumption, code);
    }

    @Override
    public void reportReturnCode(int scode, String uri, long timeConsumption, String code) {
//        YYServiceCore.log(String.format("report rtt,uri=%s,rtt=%d,code=%s", uri, timeConsumption, code));
        mMetricsWorker.reportReturnCode(scode, uri, timeConsumption, code);
    }

    @Override
    public void reportCount(int scode, String uri, String countName, long count) {
//        YYServiceCore.log(String.format("report count uri=%s,countName=%s,count=%d", uri, countName, count));
        mMetricsWorker.reportCount(scode, uri, countName, count);
    }

    @Override
    public void reportCount(int scode, String uri, String countName, long count, int times) {
//        YYServiceCore.log(String.format("report count uri=%s,countName=%s,count=%d", uri, countName, count));
        mMetricsWorker.reportCount(scode, uri, countName, count, times);
    }

    @Override
    public void reportStatisticContentTemporary(String act, Map<String, Integer> intFields,
                                                Map<String, Long> longFields, Map<String, String> stringFields) {

        mMetricsWorker.reportHiidoTemporary(act, intFields, longFields, stringFields);
//        HashMap<String, Field> fieldsMap = new HashMap<>();
//        for (Map.Entry<String, Integer> entry : intFields.entrySet()) {
//            YYServiceCore.log(String.format(Locale.US, "report act=%s,key=%s,value=%s", act,
//                    entry.getKey(), entry.getValue()));
//            fieldsMap.put(entry.getKey(), HiidoApiImpl.Field.from(entry.getValue()));
//        }
//        for (Map.Entry<String, Long> entry : longFields.entrySet()) {
//            YYServiceCore.log(String.format(Locale.US, "report act=%s,key=%s,value=%s", act,
//                    entry.getKey(), entry.getValue()));
//            fieldsMap.put(entry.getKey(), HiidoApiImpl.Field.from(entry.getValue()));
//        }
//        for (Map.Entry<String, String> entry : stringFields.entrySet()) {
//            YYServiceCore.log(String.format(Locale.US, "report act=%s,key=%s,value=%s", act,
//                    entry.getKey(), entry.getValue()));
//            fieldsMap.put(entry.getKey(), HiidoApiImpl.Field.from(entry.getValue()));
//        }
//        doGetReport(act, fieldsMap);
    }
}
