package com.yy.platform.baseservice.marshal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ProtoPacket extends Marshallable {
    private int mUri = 0;
    private int mLen = 0;
    private short mRes = 200;

    public ProtoPacket() {
        mBuffer.order(ByteOrder.LITTLE_ENDIAN);
        mBuffer.position(10);
    }

    public void setUri(int uri) {
        this.mUri = uri;
    }

    public int getUri() {
        return mUri;
    }

    public int getRes() {
        return mRes;
    }

    public int getLen() {
        return mLen;
    }

    @Override
    public byte[] marshall() {
        mLen = mBuffer.position();

        mBuffer.putInt(0, mLen);
        mBuffer.putInt(4, mUri);
        mBuffer.putShort(8, mRes);

        byte[] data = new byte[mLen];
        data = super.marshall();
        //mBuffer.position(0);
        //mBuffer.get(data);
        return data;
    }

    public byte[] marshall2() {
        return super.marshall();
    }

    @Override
    public void marshall(ByteBuffer buf) {
        mBuffer = buf;
    }

    @Override
    public void unmarshall(byte[] buf) {
        //mBuffer = ByteBuffer.wrap(buf);
        //mBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if (buf.length < 10) {
            return;
        }

        super.unmarshall(buf);
        this.mLen = popInt();
        this.mUri = popInt();
        this.mRes = popShort();
    }

    @Override
    public void unmarshall(ByteBuffer buf) {
        this.mBuffer = buf;
    }

    public void parseHeader() {
        this.mLen = popInt();
        this.mUri = popInt();
        this.mRes = popShort();
    }

    public void clear() {
        mBuffer.position(10);
    }
}
