//
// Created by HuTao on 2019/5/3.
//

#ifndef YYSERVICESDK_PARENT_CODEDEF_H
#define YYSERVICESDK_PARENT_CODEDEF_H

#include "commondefine.h"
#include "packet.h"
USING_NAMESPACE_BASEMOD

NAMESPACE_SERVICE_BEGIN

    static std::string OPT_NEEDBIND = "needbind";
    static std::string OPT_NEVERBIND = "neverbind";//永不需要bind，比如udb 的协议

    static std::string OPT_TIMOUTTS = "timeout";
    static std::string OPT_RETRYSTRATEGY = "retrystrategy";
    //上行请求放在routeArgs中作key，value为"true",告知AP返回一个假的Response带上下文且sn/fn与上行请求一样，
    // 等AP之后收到真的Response再下发一个不带context的包，不确定的情况下不要使用OneWay
    static std::string OPT_ONEWAY = "oneway";

    enum Status {
        Init = 0,
        OnConnecting = 1,
        OnConnecttimeout = 2,
        OnConnected = 3,
        OnClosed = 4,

        Closed = 5,
        Binded = 6,
//#if defined(_WIN32)
//		BindTokenInvalid = 254,//PC端回调Token无效时的状态，移动端通过OnRequestToken重新获取
//#endif
                ReConnecting = 255,//需换AP重试，但不让业务感知（内部使用）
    };

// 上行ServiceRouteRequest 和LoginRequest 要遵循如下原则
// case 1:先发service loginAp包，再发uid=0 或uid!=0的RPC请求，则RPC响应可能401(上行uid未验证)
// case 2:先发uid!=0的RPC请求，再发service loginAp包，则RPC响应一定是401
// case 3:先发uid=0的RPC请求，再发service loginAp包，则RPC响应一定是成功的（AP不验证）
// UDB的协议要保证未登录之前上行uid为0，不然发不出去登录不了
    enum SdkResCode{
        RECV_RESPONSE = 1,
        SEND_SUCCESS = 0,
        NO_CONNECTED = -1,
        NEED_BIND = -2,
        TIMEOUT = -3,
        TIMEOUT_SEND = TIMEOUT -1,
   
        BIND_UID_0 = TIMEOUT_SEND -1,
        BIND_TOKEN_NIL = BIND_UID_0 -1,
        
        UNKNOW = -255,
    };
    enum SrvResCode {
        /**
         rescode    resMsg    desc    notice
         200    "OK"    返回成功    业务后台有响应，至于业务层面的错误异常需在业务data里定义
         400    "Bad Request"    上行消息解析失败
         401    "Unauthorized"    上行消息uid未验证    需要使用实名认证的票据登入
         402    "Payment Required"    你懂的    该请service组吃顿饭了
         403    "Forbidden"    预留
         404    "Not Found"    预留
         408    "Request Timeout"    后端超时
         500    "Internal Server Error"
         502    "Bad Gateway"    预留
         503    "Service Unavailable"    找不到后端服务    路由规则匹配失败
         504    "Gateway Timeout"    预留
         */
        SVC_SUCCESS = 200,
        SVC_ONEWAY = 208, //单向请求成功完成
        SVC_BADREQUEST = 400,
        SVC_UNAUTHORIZED = 401,
        SVC_PAYMENTREQUIRED = 402,
        SVC_FAIL = 403,
        SVC_NOTFOUND = 404,
        SVC_REQUEST_TIMEOUT = 408,
        SVC_EOVERTIMES = 453,
        SVC_INTERNALSERVERERROR = 500,
        SVC_BADGATEWAY = 502,
        SVC_SERVICEUNAVAILABLE = 503,
        SVC_GATEWAYTIMEOUT = 504,
    };
    enum BindResCode{
        /*
            rescode	resMsg	desc	notice
            200	""	登入成功
            300	""	未就绪，请重试其他接入ap
            403	"OTP_APPID_ERR(53)"	Otp票据验证失败
            408	""	Otp票据验证超时，请重试
            406	""	负载满，请重试其他接入ap
            409	""	资源冲突，请重试其他接入ap
         */
        SVC_BIND_SUCCESS = 200,
        SVC_BIND_NOTREADY_TORETRY = 300,
        SVC_BIND_OTP_FAIL = 403,
        SVC_BIND_OTP_TIMEOUT = 408,
        SVC_BIND_LOAD_FULL = 406,
        SVC_BIND_RESOURCE_CONFLICT = 409,
    };

static std::string StatusDesc(int code){
    if(Init == code){
        return "初始化";
    }else if(OnConnecting == code){
        return "正在连接服务器...";
    }else if(OnConnecttimeout == code){
        return "连接超时!";
    }else if(OnConnected == code){
        return "连接成功!";
    }else if(OnClosed == code){
        return "连接断开了!";
    }else if(Closed == code){
        return "关闭连接";
    }else if(Binded == code){
        return "连接绑定ID状态!";
    }
    return "UNKNOW-未知状态";
}

static std::string SdkDesc(int code){
    std::stringstream retStr;
    if(RECV_RESPONSE == code){
        retStr << "成功收到服务响应(" << code << ")";
        return retStr.str();
    }else if(SEND_SUCCESS == code){
        retStr << "发送请求成功(" << code << ")";
        return retStr.str();
    }else if(NO_CONNECTED == code){
        retStr << "未连接(" << code << ")";
        return retStr.str();
    }else if(NEED_BIND == code){
        retStr << "需要绑定ID(" << code << ")";
        return retStr.str();
    }else if(TIMEOUT == code){
        retStr << "客户端请求超时-请求已发送出去但未收到响应(" << code << ")";
        return retStr.str();
    }else if(TIMEOUT_SEND == code){
        retStr << "客户端请求超时-连接还未成功(" << code << ")";
        return retStr.str();
    }else if(BIND_UID_0 == code){
        retStr << "绑定UID=0非法(" << code << ")";
        return retStr.str();
    }else if(BIND_TOKEN_NIL == code){
        retStr << "绑定Token为空非法(" << code << ")";
        return retStr.str();
    }
    retStr << "UNKNOW-客户端未知错误(" << code << ")";
    return retStr.str();
}

static std::string SrvDesc(int code){
    std::stringstream retStr;
    if(SVC_SUCCESS == code){
        retStr << "请求业务服务成功(" << code << ")";
        return retStr.str();
    }else if(SVC_BADREQUEST == code){
        retStr << "上行消息解析失败(" << code << ")";
        return retStr.str();
    }else if(SVC_UNAUTHORIZED == code){
        retStr << "上行消息uid未验证(" << code << ")";
        return retStr.str();
    }else if(SVC_PAYMENTREQUIRED == code){
        retStr << "你懂的,该请service组吃顿饭了(" << code << ")";
        return retStr.str();
    }else if(SVC_FAIL == code){
        retStr << "请求业务服务失败(" << code << ")";
        return retStr.str();
    }else if(SVC_NOTFOUND == code){
        retStr << "找不到服务(" << code << ")";
        return retStr.str();
    }else if(SVC_REQUEST_TIMEOUT == code){
        retStr << "请求业务服务超时(" << code << ")";
        return retStr.str();
    }else if(SVC_INTERNALSERVERERROR == code){
        retStr << "内部服务错误(" << code << ")";
        return retStr.str();
    }else if(SVC_BADGATEWAY == code){
        retStr << "网关错误(" << code << ")";
        return retStr.str();
    }else if(SVC_SERVICEUNAVAILABLE == code){
        retStr << "找不到后端服务(" << code << ")";
        return retStr.str();
    }else if(SVC_GATEWAYTIMEOUT == code){
        retStr << "网关超时(" << code << ")";
        return retStr.str();
    }
    retStr << "UNKNOW-未知服务错误(" << code << ")";
    return retStr.str();
}

static std::string BindDesc(int code){
    std::stringstream retStr;
    if(SVC_BIND_SUCCESS == code){
        retStr << "绑定成功(" << code << ")";
        return retStr.str();
    } else if(SVC_BIND_NOTREADY_TORETRY == code){
        retStr << "未就绪，请重试(" << code << ")";
        return retStr.str();
    }else if(SVC_BIND_OTP_FAIL == code){
        retStr << "票据验证失败(" << code << ")";
        return retStr.str();
    }else if(SVC_BIND_OTP_TIMEOUT == code){
        retStr << "票据验证超时(" << code << ")";
        return retStr.str();
    }else if(SVC_BIND_LOAD_FULL == code){
        retStr << "负载满，请重试(" << code << ")";
        return retStr.str();
    }else if(SVC_BIND_RESOURCE_CONFLICT == code){
        retStr << "资源冲突，请重试(" << code << ")";
        return retStr.str();
    }
    retStr << "UNKNOW-未知绑定错误(" << code << ")";
    return retStr.str();
}

class TaskOption : public Marshallable{
        class OptionObject : public Marshallable{
        public:
            std::vector<uint32_t > mExtraIntList;
            virtual ~OptionObject() {}
            virtual void marshal(Pack &pk) const {}
            virtual void unmarshal(const Unpack &up);
        };

    public:
        std::map<std::string,bool> mExtraBool;
        std::map<std::string,uint64_t> mExtraLong;
        std::map<std::string,std::string> mExtraString;
        std::map<std::string,OptionObject> mExtraObject;

        virtual ~TaskOption() {}
        virtual void marshal(Pack& pk) const {}
        virtual void unmarshal(const Unpack &up);
    };

NAMESPACE_SERVICE_END
#endif //YYSERVICESDK_PARENT_CODEDEF_H
