package com.yy.platform.baseservice;

import android.os.Handler;

import com.yy.platform.baseservice.task.BindTask;
import com.yy.platform.baseservice.task.UnBindTask;
import com.yy.platform.baseservice.task.BroadSubOrUnSubTask;
import com.yy.platform.baseservice.utils.UserGroupType;

import java.util.ArrayList;

public interface IChannel extends IRPCChannel {
    /**
     * 同步服务器时间，获取服务器与本地时间差，单位ms
     *
     * @return 时间差，单位ms
     */
    long getServerTimeStampDiff();

    /**
     * 设置断线重连需要重新取Token 登录绑定Service的委托
     *
     * @param tokenProvider 上层(App或UDB SDK)实现并返回有效的票据
     */
    @Deprecated
    void setTokenProvider(IChannelListener.ITokenProvider tokenProvider);

    /**
     * 绑定用户标识与Service长连接，目前用于单播需要
     *
     * @param uid           用户标识ID
     * @param token         OTP票据，调用YYLoginliteSDK 中getServiceToken 获取 或者getOtp("signap")取得
     * @param callback      本次绑定的回调，可查看{@link ConstCode.SrvResCode}和{@link ConstCode.BindResCode} 说明
     *                      a.仅当sdkResCode返回RECV_RESPONSE时，参数srvResCode值有效，
     *                      srvResCode非200时需要重新走UDB手机号或第三方号登录
     *                      b.如果sdkResCode为SDK_TIMEOUT或SDK_TIMEOUT_SEND请继续调用bind重试，
     *                      如果sdkResCode为SDK_BIND_UID_0或SDK_BIND_TOKEN_NIL，请检查uid或token
     * @return 请求发起成功同步返回一个RequestId标识，请求失败同步返回-1
     */
    @Deprecated
    int bind(long uid, byte[] token,
             IRPCChannel.RPCCallback<BindTask.ResponseParam> callback);

    /**
     * 绑定用户标识与Service长连接，目前用于单播等需要，请使用带tokenType参数的重载方法
     *
     * @param uid           用户标识ID
     * @param tokenProvider 提供该用户UID的bind 票据，参看{@link IChannelListener.ITokenProvider} 说明,
     *                      调用该接口默认tokenType 为0，使用国际版YYLoginlitesdk取token
     * @param callback      本次绑定的回调，可查看{@link ConstCode.SrvResCode}和{@link ConstCode.BindResCode} 说明
     *                      a.仅当sdkResCode返回RECV_RESPONSE时，参数srvResCode值有效，
     *                      srvResCode非200时需要重新走UDB手机号或第三方号登录
     *                      b.如果sdkResCode为SDK_TIMEOUT或SDK_TIMEOUT_SEND请继续调用bind重试，
     *                      如果sdkResCode为SDK_BIND_UID_0或SDK_BIND_TOKEN_NIL，请检查uid或token
     * @return 请求发起成功同步返回一个RequestId标识，请求失败同步返回-1
     */
    @Deprecated
    int bind(long uid, IChannelListener.ITokenProvider tokenProvider,
             IRPCChannel.RPCCallback<BindTask.ResponseParam> callback);

    /**
     * 绑定用户标识与Service长连接，目前用于单播等需要
     *
     * @param uid           用户标识ID
     * @param tokenType     请看{@link ConstCode.ServiceTokenType}和tokenProvider 参数说明
     * @param tokenProvider 提供该用户UID的bind 票据，参看{@link IChannelListener.ITokenProvider} 说明
     * @param callback      本次绑定的回调，可查看{@link ConstCode.SrvResCode}和{@link ConstCode.BindResCode} 说明
     *                      a.仅当sdkResCode返回RECV_RESPONSE时，参数srvResCode值有效，
     *                      srvResCode非200时需要重新走UDB手机号或第三方号登录
     *                      b.如果sdkResCode为SDK_TIMEOUT或SDK_TIMEOUT_SEND请继续调用bind重试，
     *                      如果sdkResCode为SDK_BIND_UID_0或SDK_BIND_TOKEN_NIL，请检查uid或token
     * @return 请求发起成功同步返回一个RequestId标识，请求失败同步返回-1
     */
    int bind(long uid, int tokenType, IChannelListener.ITokenProvider tokenProvider,
             IRPCChannel.RPCCallback<BindTask.ResponseParam> callback);

    /**
     * 解绑用户标识与Service长连接
     *
     * @param callback 本次解绑的回调
     * @return 请求发起成功同步返回一个RequestId标识，请求失败同步返回-1
     */
    int unBind(IRPCChannel.RPCCallback<UnBindTask.ResponseParam> callback);

    /**
     * 订阅广播组，用于接收广播
     *
     * @param grps     广播组列表
     * @param callback 订阅的回调
     * @return 请求发起成功同步返回一个RequestId标识，请求失败同步返回-1
     */
    int subscribeBroadcast(ArrayList<UserGroupType> grps,
                           IRPCChannel.RPCCallback<BroadSubOrUnSubTask.ResponseParam> callback);

    /**
     * 取消订阅广播
     *
     * @param grps     广播组列表
     * @param callback 取消订阅的回调
     * @return 请求发起成功同步返回一个RequestId标识，请求失败同步返回-1
     */
    int unSubscribeBroadcast(ArrayList<UserGroupType> grps,
                             IRPCChannel.RPCCallback<BroadSubOrUnSubTask.ResponseParam> callback);

    /**
     * 设置接收被服务端解除绑定的Listener
     *
     * @param listener 解除绑定时的通知Listener
     */
    void setForceUnBindListener(IChannelListener.IForceUnBindNotify listener);

    /**
     * 注册单播接收器，可注册多个
     *
     * @param listener 服务端下发单播通知时的接收器，默认在主线程
     */
    void registUnicastListener(IChannelListener.IServiceUnicastNotify listener);

    void registUnicastListener(IChannelListener.IServiceUnicastNotify listener,
                               Handler listenerThread);

    /**
     * 注销单播接收器
     *
     * @param listener 服务端下发单播通知时的接收器
     */
    void unregistUnicastListener(IChannelListener.IServiceUnicastNotify listener);

    /**
     * 注册广播接收器，可注册多个
     *
     * @param listener 服务端下发广播通知时的接收器，默认在主线程
     */
    void registBroadcastListener(IChannelListener.IServiceBroadcastNotify listener);

    void registBroadcastListener(IChannelListener.IServiceBroadcastNotify listener,
                                 Handler listenerThread);

    /**
     * 注销广播接收器，可注册多个
     *
     * @param listener 服务端下发广播通知时的接收器
     */
    void unregistBroadcastListener(IChannelListener.IServiceBroadcastNotify listener);

    /**
     * 取当前App的实例ID，一般是当前进程ID，业务后台和前端可能会使用
     *
     * @return
     */
    int getInstId();

    /**
     * HiidoSDK由APP层引入，设置接收统计数据的回调
     *
     * @param listener
     */
    void setHiidoMetricsApi(String hdid, IChannelListener.IServiceHiidoMetricsStatisApi listener);

    /**
     * 特殊需要，注册更多的Service 通道状态监听器
     * 如：IM 需要灵敏接收到Serivce 登录(bind)成功的通知
     *
     * @param listener 通道状态监听器，默认在主线程
     */
    void registChannelStatusListener(IChannelListener.IChannelStatusNotify listener,
                                     Handler listenerThread);

    /**
     * 注销上述Service 通道状态监听器
     *
     * @param listener
     */
    void unregistChannelStatusListener(IChannelListener.IChannelStatusNotify listener);

    /**
     * 设置接收错包的回调
     *
     * @param listener
     */
    void setReportPktApi(IChannelListener.IReportPktApi listener);

    /**
     * 获取是否使用了弱网优化，-1 未知情况，未获取到AP的IP，不能确定是否使用弱网，0 默认tcp链路，1 弱网优化链路
     *
     * @return
     */
    int getNetOptimizeSwitch();
}
