/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud.video.serviceConfig;

import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;
import com.yy.yylivesdk4cloud.video.serviceConfig.IVideoPlayerInterface;
import com.yy.yylivesdk4cloud.video.serviceConfig.VideoLiveConfig;

public class VideoPlayerImp
implements IVideoPlayerInterface {
    private static final String TAG = "cfg_VideoPlayerImp";
    private boolean mH265Support = false;

    @Override
    public void performVideoConfig(VideoLiveConfig[] configs) {
        if (configs == null || configs.length == 0) {
            ThunderLog.warn(TAG, "VideoConfig is null!");
            return;
        }
        if (configs[0].playType == 9) {
            if (configs[0].decodeType == 1) {
                ThunderLog.info(TAG, "player enable hardware h264");
                ThunderNative.enableHardwareDecoder(true, 1);
            } else {
                ThunderLog.info(TAG, "player disable hardware h264");
                ThunderNative.enableHardwareDecoder(false, 1);
            }
        }
        if (configs[0].playType == 10) {
            if (configs[0].decodeType == 2) {
                ThunderLog.info(TAG, "player enable hardware h265");
                ThunderNative.enableHardwareDecoder(true, 2);
                this.mH265Support = true;
            } else if (configs[0].decodeType == 1) {
                ThunderLog.info(TAG, "player enable soft h265");
                ThunderNative.enableHardwareDecoder(false, 2);
                this.mH265Support = true;
            } else {
                ThunderLog.info(TAG, "player no support 265 dec  ");
            }
        }
    }

    @Override
    public boolean H265PlaySupport() {
        return this.mH265Support;
    }
}

