/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud.video.serviceConfig;

import com.yy.mediaframework.CameraPreviewConfig;
import com.yy.mediaframework.YYVideoCodec;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.video.serviceConfig.IJsonParseInterface;
import com.yy.yylivesdk4cloud.video.serviceConfig.IVideoConfigCallbackInterface;
import com.yy.yylivesdk4cloud.video.serviceConfig.IVideoPlayerInterface;
import com.yy.yylivesdk4cloud.video.serviceConfig.JsonParseImp;
import com.yy.yylivesdk4cloud.video.serviceConfig.VideoLiveConfig;
import com.yy.yylivesdk4cloud.video.serviceConfig.VideoPlayerImp;
import java.util.HashMap;
import java.util.List;

public class VideoConfigManager
implements IVideoConfigCallbackInterface {
    private static final String TAG = "cfg_VideoConfigManage";
    private static final String ARGO_CONFIG_KEY_SINGLE = "Android_single";
    private static final String ARGO_CONFIG_KEY_PLAYER_H265 = "h265Support";
    private static final String ARGO_CONFIG_KEY_PLAYER_H264 = "h264Support";
    private static final String ARGO_CONFIG_KEY_LIANMAI = "Android_lianmai";
    private static final String ARGO_CONFIG_KEY_LIANMAI_ACROSS = "Android_across";
    private static final String ARGO_CONFIG_KEY_BEAUTIFYLEVEL = "Android_beautifyLevel";
    private static final String ARGO_CONFIG_KEY_BLACKCODEC = "Android_blackCodec";
    private static final String ARGO_CONFIG_KEY_HAMO_SCREENRECORD = "Android_ScreenRecord";
    private static final String ARGO_CONFIG_KEY_HAMO_PLAYTRANSCODING_MAP = "PlayTranscodingMap";
    public static final String[] ARGO_CONFIG_KEYS = new String[]{"Android_single", "h265Support", "h264Support", "Android_lianmai", "Android_across", "Android_beautifyLevel", "Android_blackCodec", "Android_ScreenRecord", "PlayTranscodingMap"};
    private IJsonParseInterface mJsonParseImp;
    private IVideoPlayerInterface mVideoPlayerImp;
    private VideoLiveConfig mCurrentConfig = null;
    private int mBeautifyLevel = 0;
    private boolean mDisableHardEncode = false;
    private boolean mDisableHardDecode = false;
    private HashMap<Integer, HashMap<Integer, String>> mModeList = new HashMap();
    private HashMap<Integer, VideoLiveConfig[]> mVideoConfigsList = new HashMap();
    private HashMap<Integer, Integer> mDecodeVideoTranscodingMap = null;

    public static VideoConfigManager instance() {
        return SingletonHolder.INSTANCE;
    }

    private VideoConfigManager() {
        this.mJsonParseImp = new JsonParseImp(this);
        this.mVideoPlayerImp = new VideoPlayerImp();
    }

    private VideoLiveConfig[] getVideoLiveConfigByPlayType(int playType) {
        VideoLiveConfig[] tmpConfigs = this.mVideoConfigsList.get(playType);
        return tmpConfigs;
    }

    public CameraPreviewConfig getCameraPreviewConfigByType(int playType, int mode) {
        VideoLiveConfig[] tmpConfigs = this.getVideoLiveConfigByPlayType(playType);
        CameraPreviewConfig result = this.analyzeCameraPreviewConfig(tmpConfigs, mode);
        ThunderLog.info(TAG, "getCameraPreviewConfigByType playtype:" + playType + " mode:" + mode + "->" + result.toString());
        return result;
    }

    private CameraPreviewConfig analyzeCameraPreviewConfig(VideoLiveConfig[] configs, int mode) {
        CameraPreviewConfig result = new CameraPreviewConfig();
        if (configs == null || configs.length == 0) {
            ThunderLog.error(TAG, " analyzeCameraPreviewConfig failed because no VideoConfig, return default!");
            return result;
        }
        for (int i = 0; i < configs.length; ++i) {
            if (mode == -1 && configs[i].isDefault == 1) {
                result.mCaptureFrameRate = configs[i].cameraFrameRate == 0 ? result.mCaptureFrameRate : configs[i].cameraFrameRate;
                result.mCaptureResolutionWidth = configs[i].cameraWidth == 0 ? result.mCaptureResolutionWidth : configs[i].cameraWidth;
                result.mCaptureResolutionHeight = configs[i].cameraHeight == 0 ? result.mCaptureResolutionHeight : configs[i].cameraHeight;
                this.mCurrentConfig = configs[i];
                break;
            }
            if (configs[i].videoLevel != mode) continue;
            result.mCaptureFrameRate = configs[i].cameraFrameRate == 0 ? result.mCaptureFrameRate : configs[i].cameraFrameRate;
            result.mCaptureResolutionWidth = configs[i].cameraWidth == 0 ? result.mCaptureResolutionWidth : configs[i].cameraWidth;
            result.mCaptureResolutionHeight = configs[i].cameraHeight == 0 ? result.mCaptureResolutionHeight : configs[i].cameraHeight;
            this.mCurrentConfig = configs[i];
            break;
        }
        return result;
    }

    public VideoEncoderConfig getVideoEncodeConfigByType(int playType, int mode) {
        VideoLiveConfig[] tmpConfigs = this.getVideoLiveConfigByPlayType(playType);
        VideoEncoderConfig result = this.analyzeVideoEncoderConfig(tmpConfigs, mode);
        if (this.mDisableHardEncode) {
            if (result.mEncodeType == VideoEncoderType.HARD_ENCODER_H264) {
                result.mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
            } else if (result.mEncodeType == VideoEncoderType.HARD_ENCODER_H265) {
                result.mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
            }
        }
        ThunderLog.info(TAG, "getVideoEncodeConfigByType :" + playType + " mode:" + mode + "->" + result.toString());
        return result;
    }

    @Override
    public void notifyJsonPlayModeMap(HashMap<Integer, Integer> map) {
        this.mDecodeVideoTranscodingMap = map;
        ThunderLog.info(TAG, "notifyJsonPlayModeMap :" + this.mDecodeVideoTranscodingMap.toString());
    }

    public int getVideoDecodeTranscoding(int transcoding) {
        if (this.mDecodeVideoTranscodingMap == null) {
            ThunderLog.info(TAG, "getVideoDecodeTranscoding mDecodeVideoTranscodingMap:null");
            return transcoding;
        }
        int result = this.mDecodeVideoTranscodingMap.get(transcoding) == null ? transcoding : this.mDecodeVideoTranscodingMap.get(transcoding);
        ThunderLog.info(TAG, "getVideoDecodeTranscoding  " + transcoding + ":" + result);
        return result;
    }

    public int getVideoEncodeTranscoding(int playType, int mode) {
        VideoLiveConfig[] tmpConfigs = this.getVideoLiveConfigByPlayType(playType);
        int result = this.analyzeTranscoding(tmpConfigs, mode);
        ThunderLog.info(TAG, "getVideoEncodeTranscoding :" + playType + " mode:" + mode + "->" + result);
        return result;
    }

    private int analyzeTranscoding(VideoLiveConfig[] configs, int mode) {
        int result = mode;
        if (configs == null || configs.length == 0) {
            ThunderLog.warn(TAG, " analyzeTranscoding configs == null ");
            return result;
        }
        for (int i = 0; i < configs.length; ++i) {
            if (mode == -1 && configs[i].isDefault == 1) {
                result = configs[i].transcoding;
                break;
            }
            if (configs[i].videoLevel != mode) continue;
            result = configs[i].transcoding;
            break;
        }
        return result;
    }

    private VideoEncoderConfig analyzeVideoEncoderConfig(VideoLiveConfig[] configs, int mode) {
        VideoEncoderConfig result = new VideoEncoderConfig();
        if (configs == null || configs.length == 0) {
            ThunderLog.warn(TAG, " analyzeVideoEncoderConfig configs == null ");
            return result;
        }
        for (int i = 0; i < configs.length; ++i) {
            if (mode == -1 && configs[i].isDefault == 1) {
                result.mEncodeWidth = configs[i].videoWidth == 0 ? result.mEncodeWidth : configs[i].videoWidth;
                result.mEncodeHeight = configs[i].videoHeight == 0 ? result.mEncodeHeight : configs[i].videoHeight;
                result.mBitRate = configs[i].curRate == 0 ? result.mBitRate : configs[i].curRate;
                result.mEncodeType = configs[i].encodeId;
                result.mEncodeParameter = configs[i].encodeParam;
                result.mFrameRate = configs[i].frameRate == 0 ? result.mFrameRate : configs[i].frameRate;
                this.mCurrentConfig = configs[i];
                break;
            }
            if (configs[i].videoLevel != mode) continue;
            result.mEncodeWidth = configs[i].videoWidth == 0 ? result.mEncodeWidth : configs[i].videoWidth;
            result.mEncodeHeight = configs[i].videoHeight == 0 ? result.mEncodeHeight : configs[i].videoHeight;
            result.mBitRate = configs[i].curRate == 0 ? result.mBitRate : configs[i].curRate;
            result.mEncodeType = configs[i].encodeId;
            result.mEncodeParameter = configs[i].encodeParam;
            result.mFrameRate = configs[i].frameRate == 0 ? result.mFrameRate : configs[i].frameRate;
            this.mCurrentConfig = configs[i];
            break;
        }
        return result;
    }

    private void parseArgoResponsePlayTranscoding(int type, String response) {
        switch (type) {
            case 13: {
                this.mJsonParseImp.parseVideoPlayTranscodingMap(response);
                break;
            }
        }
    }

    private void parseArgoResponse(int type, String response) {
        switch (type) {
            case 0: {
                this.mJsonParseImp.parseVideoEncodeConfigSingle(response);
                break;
            }
            case 1: {
                this.mJsonParseImp.parseVideoEncodeConfigLianMai(response);
                break;
            }
            case 3: {
                this.mJsonParseImp.parseVideoEncodeConfigAcross(response);
                break;
            }
            case 5: {
                this.mJsonParseImp.parseVideoEncodeConfigScreenCapture(response);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                this.mJsonParseImp.parseVideoEncodeConfigSingle(response);
                break;
            }
            case 9: {
                this.mJsonParseImp.parseVideoH264DecodeConfig(response);
                break;
            }
            case 10: {
                this.mJsonParseImp.parseVideoH265DecodeConfig(response);
                break;
            }
            case 11: {
                this.mJsonParseImp.parseVideoBeautifyLevelConfig(response);
                break;
            }
            case 12: {
                this.mJsonParseImp.parseVideoBlackEncodeConfig(response);
                break;
            }
        }
    }

    @Override
    public void notifyJsonConfigResult(VideoLiveConfig[] configs) {
        int i;
        if (configs == null || configs.length == 0) {
            ThunderLog.error(TAG, "JsonParse error!");
            return;
        }
        HashMap<Integer, String> modeElement = new HashMap<Integer, String>();
        for (i = 0; i < configs.length; ++i) {
            if (configs[i].videoLevel != 0) {
                modeElement.put(configs[i].videoLevel, configs[i].description);
            }
            ThunderLog.info(TAG, " notifyJsonConfigResult playType:" + configs[i].playType + ":" + configs[i].toString());
        }
        if (configs[0].playType == 9 || configs[0].playType == 10) {
            this.mVideoPlayerImp.performVideoConfig(configs);
        }
        if (configs[0].playType == 12) {
            if (configs[0].blockEncode != null && configs[0].blockEncode.length != 0) {
                for (i = 0; i < configs[0].blockEncode.length; ++i) {
                    if (configs[0].blockEncode[i].equalsIgnoreCase(YYVideoCodec.getH264EncodeName())) {
                        this.mDisableHardEncode = true;
                        continue;
                    }
                    if (!configs[0].blockEncode[i].equalsIgnoreCase(YYVideoCodec.getH265EncodeName())) continue;
                    this.mDisableHardEncode = true;
                }
            }
            ThunderLog.info(TAG, " notifyJsonConfigResult playType:" + configs[0].playType + ": mDisableHardEncode" + this.mDisableHardEncode);
        }
        if (configs[0].playType == 11) {
            this.mBeautifyLevel = configs[0].beautifyLevel;
        }
        this.mVideoConfigsList.put(configs[0].playType, configs);
        this.mModeList.put(configs[0].playType, modeElement);
    }

    public List<ResolutionModifyConfig> getCurrentModifyConfig() {
        if (this.mCurrentConfig == null || this.mCurrentConfig.modifyConfigs == null) {
            return null;
        }
        return this.mCurrentConfig.modifyConfigs;
    }

    public VideoLiveConfig getCurrentVideoLiveConfig() {
        return this.mCurrentConfig;
    }

    public int getCurrentIntervalSecs() {
        if (this.mCurrentConfig == null) {
            return 10;
        }
        return this.mCurrentConfig.intervalSecs;
    }

    public boolean checkLowDelayByType(int playType) {
        return playType == 1 || playType == 3;
    }

    public void resetCurrentVideoLiveConfig() {
        this.mCurrentConfig = null;
    }

    public int getCurrentBeautifyLevel() {
        return this.mBeautifyLevel;
    }

    public boolean H265PlaySupport() {
        if (this.mVideoPlayerImp == null) {
            return false;
        }
        return this.mVideoPlayerImp.H265PlaySupport();
    }

    public void disableHardDecode(Boolean disable) {
        this.mDisableHardDecode = disable;
        ThunderLog.info(TAG, "disableHardDecode " + this.mDisableHardEncode);
    }

    public void disableHardEncode(Boolean disable) {
        this.mDisableHardEncode = disable;
        ThunderLog.info(TAG, "disableHardEncode " + this.mDisableHardEncode);
    }

    public int getDefaultPublishVideoMode(int playType) {
        int mode = -1;
        VideoLiveConfig[] tmpConfigs = this.getVideoLiveConfigByPlayType(playType);
        if (tmpConfigs == null || tmpConfigs.length == 0) {
            ThunderLog.warn(TAG, " getDefaultPublishVideoMode configs == null ");
            return -1;
        }
        for (int i = 0; i < tmpConfigs.length; ++i) {
            if (tmpConfigs[i].isDefault != 1) continue;
            mode = tmpConfigs[i].videoLevel;
            break;
        }
        ThunderLog.info(TAG, " getDefaultPublishVideoMode mode " + mode);
        return mode;
    }

    public int getPlayViewTypeFromStream(int streamType) {
        int decodeType = 0;
        if (this.mDisableHardDecode) {
            ThunderLog.info(TAG, " getPlayViewTypeFromStream soft decoder ");
            return decodeType;
        }
        if (streamType == 1) {
            VideoLiveConfig[] configs = this.mVideoConfigsList.get(10);
            if (configs != null && configs.length != 0) {
                ThunderLog.info(TAG, " getPlayViewTypeFromStream PLAYER_H265  " + configs[0].toString());
                if (configs[0].decodeType == 2) {
                    decodeType = 1;
                } else {
                    ThunderLog.info(TAG, " getPlayViewTypeFromStream configs[0].decodeType  " + configs[0].decodeType + " playtype:" + configs[0].playType);
                }
            } else {
                ThunderLog.info(TAG, " getPlayViewTypeFromStream  no config " + streamType);
            }
        } else if (streamType == 0) {
            VideoLiveConfig[] configs = this.mVideoConfigsList.get(9);
            if (configs != null && configs.length != 0) {
                ThunderLog.info(TAG, " getPlayViewTypeFromStream PLAYER_H264  " + configs[0].toString());
                if (configs[0].decodeType == 1) {
                    decodeType = 1;
                } else {
                    ThunderLog.info(TAG, " getPlayViewTypeFromStream configs[0].decodeType  " + configs[0].decodeType + " playtype:" + configs[0].playType);
                }
            } else {
                ThunderLog.info(TAG, " getPlayViewTypeFromStream  no config " + streamType);
            }
        }
        ThunderLog.info(TAG, " getPlayViewTypeFromStream decodeType :" + decodeType + " streamType " + streamType);
        return decodeType;
    }

    public HashMap<Integer, String> getModeListByPlayType(int playType) {
        HashMap<Integer, String> modeList = this.mModeList.get(playType);
        if (modeList == null) {
            ThunderLog.error(TAG, "HashMap<Integer, String>  modeList error");
        } else {
            String modeString = "";
            for (int key : modeList.keySet()) {
                modeString = modeString + key + ":" + modeList.get(key);
            }
            ThunderLog.info(TAG, "getModeListByPlayType " + playType + " :" + modeString);
        }
        return modeList;
    }

    public void onConfig(String key, String config) {
        if (key == null || config == null) {
            return;
        }
        ThunderLog.info("howard", " onConfig " + key + " : " + config);
        switch (key) {
            case "Android_single": {
                this.parseArgoResponse(0, config);
                break;
            }
            case "h264Support": {
                this.parseArgoResponse(9, config);
                break;
            }
            case "h265Support": {
                this.parseArgoResponse(10, config);
                break;
            }
            case "Android_beautifyLevel": {
                this.parseArgoResponse(11, config);
                break;
            }
            case "Android_lianmai": {
                this.parseArgoResponse(1, config);
                break;
            }
            case "Android_across": {
                this.parseArgoResponse(3, config);
                break;
            }
            case "Android_blackCodec": {
                this.parseArgoResponse(12, config);
                break;
            }
            case "Android_ScreenRecord": {
                this.parseArgoResponse(5, config);
                break;
            }
            case "PlayTranscodingMap": {
                this.parseArgoResponsePlayTranscoding(13, config);
            }
        }
    }

    private static class SingletonHolder {
        private static final VideoConfigManager INSTANCE = new VideoConfigManager();

        private SingletonHolder() {
        }
    }
}

