/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud.video.serviceConfig;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.video.serviceConfig.IJsonParseInterface;
import com.yy.yylivesdk4cloud.video.serviceConfig.IVideoConfigCallbackInterface;
import com.yy.yylivesdk4cloud.video.serviceConfig.VideoLiveConfig;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonParseImp
implements IJsonParseInterface {
    private static final String TAG = "cfg_JsonParseImp";
    private HandlerThread mProcessJsonParseThread;
    private Handler mProcessJsonParseHandler;
    private IVideoConfigCallbackInterface mCallback;
    private boolean mReady = false;
    private static final int MESSAGE_ENCODECONFIG_SINGLE = 0;
    private static final int MESSAGE_DECODECONFIG_H264 = 1;
    private static final int MESSAGE_DECODECONFIG_H265 = 2;
    private static final int MESSAGE_WEAKNETWORK = 3;
    private static final int MESSAGE_BEAUTIFY_LEVEL = 4;
    private static final int MESSAGE_ENCODECONFIG_LIANMAI = 5;
    private static final int MESSAGE_ENCODECONFIG_ACROSS = 7;
    private static final int MESSAGE_ENCODECONFIG_BLOCKENCODE = 8;
    private static final int MESSAGE_SCREEN_CAPTURE = 9;
    private static final int MESSAGE_PLAY_TRANSCODING = 10;
    private int interval = 10;

    public JsonParseImp(IVideoConfigCallbackInterface callback) {
        this.mCallback = callback;
        this.mProcessJsonParseThread = new HandlerThread("JsonParseThread");
        this.mProcessJsonParseThread.start();
        this.mProcessJsonParseHandler = new Handler(this.mProcessJsonParseThread.getLooper()){

            public void handleMessage(Message msg) {
                if (!JsonParseImp.this.mReady) {
                    ThunderLog.warn(JsonParseImp.TAG, " ProcessJsonParseHandler not Ready !");
                    return;
                }
                try {
                    String data = (String)msg.obj;
                    switch (msg.what) {
                        case 0: {
                            JsonParseImp.this.handlderParseVideoEncodeConfig(0, data);
                            break;
                        }
                        case 5: {
                            JsonParseImp.this.handlderParseVideoEncodeConfig(1, data);
                            break;
                        }
                        case 7: {
                            JsonParseImp.this.handlderParseVideoEncodeConfig(3, data);
                            break;
                        }
                        case 1: {
                            JsonParseImp.this.handlderParseVideoDecodeH264Config(data);
                            break;
                        }
                        case 2: {
                            JsonParseImp.this.handlderParseVideoDecodeH265Config(data);
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 4: {
                            JsonParseImp.this.handlderParseVideoBeautifyLevelConfig(data);
                            break;
                        }
                        case 8: {
                            JsonParseImp.this.handlderParseVideoBlockEncodeConfig(data);
                            break;
                        }
                        case 9: {
                            JsonParseImp.this.handlderParseVideoEncodeConfig(5, data);
                            break;
                        }
                        case 10: {
                            JsonParseImp.this.handlderParseVideoPlatTranscoding(data);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    ThunderLog.error(JsonParseImp.TAG, " mProcessJsonParseHandler deal error :" + e.toString());
                }
            }
        };
        this.mReady = true;
    }

    private void handlderParseVideoPlatTranscoding(String response) {
        if (response == null || response.isEmpty()) {
            return;
        }
        try {
            HashMap<Integer, Integer> playTranscodingMap = new HashMap<Integer, Integer>();
            JSONObject jsonObject = new JSONObject(response);
            JSONArray jsonArray = jsonObject.names();
            for (int i = 0; i < jsonArray.length(); ++i) {
                Integer key = jsonArray.getInt(i);
                playTranscodingMap.put(key, jsonObject.optInt(key.toString()));
            }
            if (jsonArray == null || jsonArray.length() == 0) {
                return;
            }
            if (this.mCallback != null) {
                this.mCallback.notifyJsonPlayModeMap(playTranscodingMap);
            } else {
                ThunderLog.error(TAG, " handlderParseVideoPlatTranscoding no callback");
            }
        }
        catch (Exception e) {
            ThunderLog.error(TAG, " handlderParseVideoPlatTranscoding error");
        }
    }

    private VideoEncoderType convertEncodeIdToType(int encodeId) {
        if (encodeId == 200) {
            return VideoEncoderType.HARD_ENCODER_H264;
        }
        if (encodeId == 201) {
            return VideoEncoderType.SOFT_ENCODER_X264;
        }
        if (encodeId == 220) {
            return VideoEncoderType.HARD_ENCODER_H265;
        }
        if (encodeId == 221) {
            return VideoEncoderType.SOFT_ENCODER_H265;
        }
        return VideoEncoderType.SOFT_ENCODER_X264;
    }

    private VideoLiveConfig[] getFieldFromJson(JSONArray jsonArray, int playType) {
        VideoLiveConfig[] configs = new VideoLiveConfig[jsonArray.length()];
        try {
            for (int i = 0; i < jsonArray.length(); ++i) {
                VideoLiveConfig config = new VideoLiveConfig();
                JSONObject item = jsonArray.getJSONObject(i);
                config.playType = playType;
                config.intervalSecs = this.interval;
                config.videoLevel = item.optInt("key");
                config.isDefault = item.optInt("isDefault");
                config.videoWidth = item.optInt("width");
                config.videoHeight = item.optInt("height");
                config.frameRate = item.optInt("frameRate");
                config.encodeId = this.convertEncodeIdToType(item.optInt("encode_id"));
                config.encodeParam = item.optString("encode_param");
                config.cameraWidth = item.optInt("previewWidth");
                config.cameraHeight = item.optInt("previewHeight");
                config.cameraFrameRate = item.optInt("previewFrameRate");
                config.codeRate_trans = item.optInt("codeRate") * 1000;
                config.maxRate = item.optInt("maxrate") * 1000;
                config.curRate = item.optInt("currate") * 1000;
                config.minRate = item.optInt("minrate") * 1000;
                config.description = item.optString("description");
                config.transcoding = item.optInt("transcoding");
                JSONArray resolutionModifies = item.optJSONArray("modifyConfig");
                if (resolutionModifies != null) {
                    ArrayList<ResolutionModifyConfig> modifyconfigs = new ArrayList<ResolutionModifyConfig>(resolutionModifies.length());
                    for (int j = 0; j < resolutionModifies.length(); ++j) {
                        item = resolutionModifies.getJSONObject(j);
                        ResolutionModifyConfig tmp = new ResolutionModifyConfig(item.optInt("width"), item.optInt("height"), item.optInt("minCodeRate") * 1000, item.optInt("maxCodeRate") * 1000, item.optInt("minFrameRate"), item.optInt("maxFrameRate"), this.convertEncodeIdToType(item.optInt("encode_id")), item.optString("encode_param"));
                        modifyconfigs.add(tmp);
                    }
                    config.modifyConfigs = modifyconfigs;
                }
                configs[i] = config;
            }
        }
        catch (Exception e) {
            ThunderLog.error(TAG, " getFieldFromJson error :" + e.toString());
            configs = null;
        }
        return configs;
    }

    private void handlderParseVideoBlockEncodeConfig(String response) {
        if (response == null || response.isEmpty()) {
            return;
        }
        try {
            VideoLiveConfig[] configs = new VideoLiveConfig[]{new VideoLiveConfig()};
            configs[0].playType = 12;
            JSONObject jsonObject = new JSONObject(response);
            String codeArray = jsonObject.optString("blackCodec");
            if (codeArray == null || codeArray.length() == 0) {
                return;
            }
            configs[0].blockEncode = codeArray.split(",");
            if (this.mCallback != null) {
                this.mCallback.notifyJsonConfigResult(configs);
            } else {
                ThunderLog.error(TAG, " handlderParseVideoBeautifyLevelConfig no callback");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handlderParseVideoBeautifyLevelConfig(String response) {
        if (response == null || response.isEmpty()) {
            return;
        }
        VideoLiveConfig[] configs = new VideoLiveConfig[]{new VideoLiveConfig()};
        int beautifyLevel = Integer.parseInt(response);
        configs[0].playType = 11;
        configs[0].beautifyLevel = beautifyLevel;
        if (this.mCallback != null) {
            this.mCallback.notifyJsonConfigResult(configs);
        } else {
            ThunderLog.error(TAG, " handlderParseVideoBeautifyLevelConfig no callback");
        }
    }

    private void handlderParseVideoEncodeConfig(int palyType, String response) {
        try {
            JSONObject jsonObject = new JSONObject(response);
            this.interval = jsonObject.optInt("resolutionModifyInterval") == 0 ? 10 : jsonObject.optInt("resolutionModifyInterval");
            JSONArray jsonArray = jsonObject.optJSONArray("resolution2");
            VideoLiveConfig[] configs = this.getFieldFromJson(jsonArray, palyType);
            if (this.mCallback != null) {
                this.mCallback.notifyJsonConfigResult(configs);
            } else {
                ThunderLog.error(TAG, " handlderParseVideoEncodeConfig no callback");
            }
        }
        catch (Exception e) {
            ThunderLog.error(TAG, " handlderParseVideoEncodeConfig :" + e.toString());
        }
    }

    private void handlderParseVideoDecodeH264Config(String response) {
        if (response == null || response.isEmpty()) {
            return;
        }
        VideoLiveConfig[] configs = new VideoLiveConfig[]{new VideoLiveConfig()};
        int decodeType = Integer.parseInt(response);
        configs[0].playType = 9;
        configs[0].decodeType = decodeType;
        if (this.mCallback != null) {
            this.mCallback.notifyJsonConfigResult(configs);
        } else {
            ThunderLog.error(TAG, " handlderParseVideoDecodeH264Config no callback");
        }
    }

    private void handlderParseVideoDecodeH265Config(String response) {
        if (response == null || response.isEmpty()) {
            return;
        }
        VideoLiveConfig[] configs = new VideoLiveConfig[]{new VideoLiveConfig()};
        int decodeType = Integer.parseInt(response);
        configs[0].playType = 10;
        configs[0].decodeType = decodeType;
        if (this.mCallback != null) {
            this.mCallback.notifyJsonConfigResult(configs);
        } else {
            ThunderLog.error(TAG, " handlderParseVideoDecodeH265Config no callback");
        }
    }

    @Override
    public void parseVideoPlayTranscodingMap(String response) {
        if (this.mReady) {
            Message msg = Message.obtain();
            msg.what = 10;
            msg.obj = response;
            this.mProcessJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseVideoBlackEncodeConfig(String response) {
        if (this.mReady) {
            Message msg = Message.obtain();
            msg.what = 8;
            msg.obj = response;
            this.mProcessJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseVideoBeautifyLevelConfig(String response) {
        if (this.mReady) {
            Message msg = Message.obtain();
            msg.what = 4;
            msg.obj = response;
            this.mProcessJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseVideoEncodeConfigLianMai(String response) {
        if (this.mReady) {
            Message msg = Message.obtain();
            msg.what = 5;
            msg.obj = response;
            this.mProcessJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseVideoEncodeConfigAcross(String response) {
        if (this.mReady) {
            Message msg = Message.obtain();
            msg.what = 7;
            msg.obj = response;
            this.mProcessJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseVideoEncodeConfigSingle(String response) {
        if (this.mReady) {
            Message msg = Message.obtain();
            msg.what = 0;
            msg.obj = response;
            this.mProcessJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseVideoEncodeConfigScreenCapture(String response) {
        if (this.mReady) {
            Message msg = Message.obtain();
            msg.what = 9;
            msg.obj = response;
            this.mProcessJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseVideoH264DecodeConfig(String response) {
        if (this.mReady) {
            Message msg = Message.obtain();
            msg.what = 1;
            msg.obj = response;
            this.mProcessJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseVideoH265DecodeConfig(String response) {
        if (this.mReady) {
            Message msg = Message.obtain();
            msg.what = 2;
            msg.obj = response;
            this.mProcessJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseWeakNetworkConfig(String response) {
        if (this.mReady) {
            Message msg = Message.obtain();
            msg.what = 3;
            msg.obj = response;
            this.mProcessJsonParseHandler.sendMessage(msg);
        }
    }
}

