/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud.video;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import com.yy.mediaframework.CameraPreviewConfig;
import com.yy.mediaframework.IPublishListener;
import com.yy.mediaframework.ITextureListener;
import com.yy.mediaframework.PublishVideoConfig;
import com.yy.mediaframework.VideoPublish;
import com.yy.mediaframework.YYVideoCodec;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.gpuimage.custom.OrangeFilterWrapper;
import com.yy.mediaframework.stat.VideoDataStat;
import com.yy.videoplayer.IVideoLibInfoExt;
import com.yy.videoplayer.VideoPlayer;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.render.VideoRenderNotify;
import com.yy.videoplayer.stat.VideoPlayerDataStat;
import com.yy.yylivesdk4cloud.ThunderConstant;
import com.yy.yylivesdk4cloud.ThunderDefaultCamera;
import com.yy.yylivesdk4cloud.ThunderPlayerView;
import com.yy.yylivesdk4cloud.ThunderPreviewConfig;
import com.yy.yylivesdk4cloud.ThunderPreviewView;
import com.yy.yylivesdk4cloud.ThunderPublisher;
import com.yy.yylivesdk4cloud.ThunderScreenCapture;
import com.yy.yylivesdk4cloud.ThunderVideoCapture;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;
import com.yy.yylivesdk4cloud.video.ThunderVideoConfig;
import com.yy.yylivesdk4cloud.video.ThunderVideoPlayListener;
import com.yy.yylivesdk4cloud.video.serviceConfig.VideoConfigManager;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public class ThunderVideoEngineImp
implements IPublishListener,
ITextureListener {
    public static final int YYPUBLISH_VIDEO_STATE_NONE = 0;
    public static final int YYPUBLISH_VIDEO_STATE_PREVIEW = 1;
    public static final int YYPUBLISH_VIDEO_STATE_ENCODE = 2;
    HashMap<String, ThunderPlayerView> mVideoViewMap;
    HashMap<String, Integer> mVideoScaleModeMap;
    private VideoPublish mPublisher = null;
    private long mCallBackPtr = 0L;
    private boolean bMixMode = false;
    private ThunderVideoCapture mCapture;
    private OrangeFilterWrapper mOrangeFilterWrapper;
    private static final int VIDEO_STAT_FPS = 0;
    private static final int VIDEO_STAT_BITRATE = 1;
    private static final int VIDEO_STATE_RESOLUTION = 2;
    private VideoConfigManager mVideoConfigManager;
    private int mVideoPublishState = 0;
    private YVideoPublishVideoConfig mCurrentVideoConfig = null;
    private Handler mUiHandler = null;
    private Map<String, WeakReference> mPlayViewAndStreamKeyMap = new HashMap<String, WeakReference>();

    public ThunderVideoEngineImp() {
        YYVideoCodec.testVideoEncoderCrash();
    }

    public void init() {
        this.mVideoViewMap = new HashMap();
        this.mVideoScaleModeMap = new HashMap();
        this.mPublisher = VideoPublish.getInstance();
        this.mVideoConfigManager = VideoConfigManager.instance();
        YYVideoLibMgr.instance().setVideoInfoListener((IVideoLibInfoExt)new ThunderVideoPlayListener(YYVideoLibMgr.instance().getAppContext(), this));
        this.mUiHandler = new Handler(Looper.getMainLooper());
        ThunderVideoConfig config = new ThunderVideoConfig();
        config.AsyncLoad();
    }

    public static String getVideoEngineVersion() {
        return "Android: 200.0.13&200.0.8";
    }

    public void updatePlayVideoStream(String streamKey, long streamId, int streamType) {
        ThunderPlayerView view = this.mVideoViewMap.get(streamKey);
        if (view == null) {
            ThunderLog.warn("yvideo-Java", "updatePlayVideoStream: cann't find video view for stream:%s", streamKey);
            return;
        }
        if (this.mVideoConfigManager.getPlayViewTypeFromStream(streamType) == 0 && view.getViewType() == 0 || this.mVideoConfigManager.getPlayViewTypeFromStream(streamType) == 1 && view.getViewType() == 1) {
            ThunderLog.info("yvideo-Java", "updatePlayVideoStream unchange stream:%s-%d - %d", streamKey, streamId, streamType);
            return;
        }
        ThunderLog.info("yvideo-Java", "updatePlayVideoStream unlink stream:%s-%d", streamKey, streamId);
        view.unLinkFromStream(streamId);
        this.setDecodeType(streamKey, streamType);
        ThunderLog.info("yvideo-Java", "updatePlayVideoStream link stream:%s, %d", streamKey, streamId);
        view.linkToStream(streamId);
    }

    public int setDecodeType(String streamKey, int streamType) {
        int scaleMode;
        final int decodeType = this.mVideoConfigManager.getPlayViewTypeFromStream(streamType);
        ThunderLog.info("ThunderVideoEngineImp", "setDecodeType streamKey " + streamKey + " type:" + streamType);
        if (this.mVideoConfigManager == null) {
            ThunderLog.error("ThunderVideoEngineImp", "setDecodeType mVideoConfigManager == null!");
            return -1;
        }
        int n = scaleMode = this.mVideoScaleModeMap.get(streamKey) == null ? -1 : this.mVideoScaleModeMap.get(streamKey);
        if (scaleMode == -1) {
            ThunderLog.error("ThunderVideoEngineImp", "setDecodeType mVideoScaleModeMap can't find scaleMode in map :" + this.mVideoScaleModeMap.size());
            return -1;
        }
        final ThunderPlayerView view = this.mVideoViewMap.get(streamKey);
        if (this.mVideoViewMap.get(streamKey) == null) {
            ThunderLog.error("ThunderVideoEngineImp", "setDecodeType mVideoScaleModeMap can't find view in map :" + this.mVideoViewMap.size());
            return -1;
        }
        final CountDownLatch barrier = new CountDownLatch(1);
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                view.prepareView(decodeType);
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            ThunderLog.error("ThunderVideoEngineImp", "setDecodeType .barrier.await" + e.toString());
        }
        view.setScaleMode(scaleMode);
        ThunderLog.info("ThunderVideoEngineImp", streamKey + " setDecodeType success : scaleMode" + scaleMode + ", decodeType: " + decodeType);
        return decodeType == 1 ? 1 : 0;
    }

    public boolean H265PlaySupport() {
        if (this.mVideoConfigManager == null) {
            return false;
        }
        ThunderLog.info("ThunderVideoEngineImp", "H265PlaySupport " + this.mVideoConfigManager.H265PlaySupport());
        return this.mVideoConfigManager.H265PlaySupport();
    }

    public boolean startVideoEngine() {
        return true;
    }

    public int getVideoDecodeTranscoding(int transcoding) {
        if (this.mVideoConfigManager == null) {
            return transcoding;
        }
        return this.mVideoConfigManager.getVideoDecodeTranscoding(transcoding);
    }

    public int getVideoEncodeTranscoding(int playType, int mode) {
        if (this.mVideoConfigManager == null) {
            return mode;
        }
        return this.mVideoConfigManager.getVideoEncodeTranscoding(playType, mode);
    }

    public boolean stopVideoEngine() {
        return true;
    }

    public void setVideoEngineCallBack(long ptr) {
        this.mCallBackPtr = ptr;
    }

    private boolean isUsingDefaultCamera() {
        return !this.bMixMode && this.mCapture instanceof ThunderDefaultCamera;
    }

    public void attachVideoCapture(Object capture) {
        if (this.mCapture != null) {
            ThunderLog.info("yvideo-Java", "detach capture: " + this.mCapture.toString());
            this.mCapture = null;
        }
        if (capture != null) {
            this.mCapture = (ThunderVideoCapture)capture;
            ThunderLog.info("yvideo-Java", "attach capture: " + this.mCapture.toString());
        }
    }

    private CameraPreviewConfig getCameraPreviewConfigByType(int playType, int previewMode) {
        CameraPreviewConfig result = this.mVideoConfigManager.getCameraPreviewConfigByType(playType, previewMode);
        ThunderLog.info("ThunderVideoEngineImp", "getCameraPreviewConfigByType:" + result.toString());
        return result;
    }

    private int getBeautyLevelInCurrentConfig() {
        int result = 0;
        if (this.mVideoConfigManager != null) {
            result = this.mVideoConfigManager.getCurrentBeautifyLevel();
        }
        ThunderLog.info("ThunderVideoEngineImp", "getBeautyLevelInCurrentConfig:" + result);
        return result;
    }

    private VideoEncoderConfig getVideoEncoderConfigByType(int playType, int mode) {
        VideoEncoderConfig result = this.mVideoConfigManager.getVideoEncodeConfigByType(playType, mode);
        ThunderLog.info("ThunderVideoEngineImp", "getVideoEncoderConfigByType:" + result.toString());
        return result;
    }

    private boolean checkLowDelayByType(int playType) {
        return this.mVideoConfigManager.checkLowDelayByType(playType);
    }

    private CameraPreviewConfig toCamerePreviewConfig(ThunderPreviewConfig config) {
        CameraPreviewConfig newConf = new CameraPreviewConfig(0);
        newConf.mCaptureResolutionWidth = config.captureResolutionWidth;
        newConf.mCaptureResolutionHeight = config.captureResolutionHeight;
        newConf.mCameraPosition = config.cameraPosition;
        newConf.mCaptureFrameRate = config.captureFrameRate;
        newConf.mCaptureOrientation = config.captureOrientation;
        return newConf;
    }

    public YVideoPublishVideoConfig setOrientation(int orientatin) {
        ThunderLog.info("ThunderVideoEngineImp", " setOrientation " + orientatin);
        if (this.mCapture instanceof ThunderScreenCapture) {
            ThunderScreenCapture yyLiveScreenCapture = (ThunderScreenCapture)this.mCapture;
            if (yyLiveScreenCapture.isLandscap() && orientatin != 1 || !yyLiveScreenCapture.isLandscap() && orientatin != 0) {
                this.stopEncodeVideo();
                yyLiveScreenCapture.setIslandScape(orientatin == 1);
                this.startEncodeVideo(this.mCurrentVideoConfig.bMirrorFrontCamera, this.mCurrentVideoConfig.bLowLatency, this.mCurrentVideoConfig.playType, this.mCurrentVideoConfig.mode);
            }
            return this.mCurrentVideoConfig;
        }
        ThunderDefaultCamera camera = (ThunderDefaultCamera)this.mCapture;
        ThunderPreviewConfig config = (ThunderPreviewConfig)camera.getCaptureConfig();
        if (orientatin != config.captureOrientation) {
            config.captureOrientation = orientatin;
            config.captureResolutionWidth += config.captureResolutionHeight;
            config.captureResolutionHeight = config.captureResolutionWidth - config.captureResolutionHeight;
            config.captureResolutionWidth -= config.captureResolutionHeight;
            camera.setCaptureConfig(config);
        }
        if (this.mVideoPublishState == 1) {
            this.mPublisher.updateCameraPreviewParam(this.toCamerePreviewConfig(config));
        } else if (this.mVideoPublishState == 2) {
            this.stopEncodeVideo();
            this.mPublisher.updateCameraPreviewParam(this.toCamerePreviewConfig(config));
            this.startEncodeVideo(this.mCurrentVideoConfig.bMirrorFrontCamera, this.mCurrentVideoConfig.bLowLatency, this.mCurrentVideoConfig.playType, this.mCurrentVideoConfig.mode);
        } else {
            ThunderLog.warn("ThunderVideoEngineImp", "setOrientation wrong!");
        }
        if (this.mCurrentVideoConfig != null) {
            this.mCurrentVideoConfig.orientation = orientatin;
            this.mCurrentVideoConfig.encodeResolutionWidth += this.mCurrentVideoConfig.encodeResolutionHeight;
            this.mCurrentVideoConfig.encodeResolutionHeight = this.mCurrentVideoConfig.encodeResolutionWidth - this.mCurrentVideoConfig.encodeResolutionHeight;
            this.mCurrentVideoConfig.encodeResolutionWidth -= this.mCurrentVideoConfig.encodeResolutionHeight;
        }
        if (this.mVideoPublishState == 2) {
            return this.mCurrentVideoConfig;
        }
        return null;
    }

    public int startPreview(Object toView, int playType, int publishMode) {
        if (this.isUsingDefaultCamera()) {
            ThunderDefaultCamera camera = (ThunderDefaultCamera)this.mCapture;
            ThunderPreviewConfig config = (ThunderPreviewConfig)camera.getCaptureConfig();
            this.mPublisher.setPhonePerformanceLevel(this.getBeautyLevelInCurrentConfig());
            CameraPreviewConfig newConfig = this.getCameraPreviewConfigByType(playType, publishMode);
            newConfig.mCameraPosition = ((ThunderPreviewConfig)camera.getCaptureConfig()).cameraPosition;
            if (config.captureOrientation == 1 && newConfig.mCaptureResolutionWidth < newConfig.mCaptureResolutionHeight) {
                int mid = newConfig.mCaptureResolutionWidth;
                newConfig.mCaptureResolutionWidth = newConfig.mCaptureResolutionHeight;
                newConfig.mCaptureResolutionHeight = mid;
            }
            this.mPublisher.startPreviewWithView(((ThunderPreviewView)((Object)toView)).getSurfaceView(), newConfig, (IPublishListener)this);
            if (camera.getCameraDataCallback() != null) {
                ThunderLog.info("yvideo-Java", "setTextureListener %s %s", camera.getCameraDataCallback().toString(), this.toString());
                this.mPublisher.setTextureListener((ITextureListener)this);
            }
            this.mOrangeFilterWrapper = this.mPublisher.getOrangeFilterWrapperObject();
            config.captureFrameRate = newConfig.mCaptureFrameRate;
            config.captureResolutionHeight = newConfig.mCaptureResolutionHeight;
            config.captureResolutionWidth = newConfig.mCaptureResolutionWidth;
            camera.setCaptureConfig(config);
            return 0;
        }
        this.mCapture.startCapture(new ThunderPublisher.IVideoPublisher(){

            @Override
            public void pushVideoData() {
            }

            @Override
            public void pushVideoData(byte[] encodedData, ThunderConstant.ThunderVideoEncodeType type, long dts, long pts) {
            }
        });
        this.mVideoPublishState = 1;
        return 0;
    }

    public int stopPreview() {
        if (this.isUsingDefaultCamera()) {
            if (this.mVideoPublishState != 1) {
                ThunderLog.info("yvideo-Java", "stopPreview videoState wrong:" + this.mVideoPublishState);
            }
            this.mVideoPublishState = 0;
            return this.mPublisher.stopPreview();
        }
        return -1;
    }

    public YVideoPublishVideoConfig startEncodeVideo(boolean bMirrorFrontCamera, boolean bLowLatency, int playType, int mode) {
        int mid;
        VideoEncoderConfig newEncoderConfig = this.getVideoEncoderConfigByType(playType, mode);
        if (this.mCapture.getClass() == ThunderScreenCapture.class && ((ThunderScreenCapture)this.mCapture).isLandscap()) {
            mid = newEncoderConfig.mEncodeWidth;
            newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
            newEncoderConfig.mEncodeHeight = mid;
        } else if (this.mCapture.getClass() == ThunderDefaultCamera.class && ((ThunderPreviewConfig)this.mCapture.getCaptureConfig()).captureOrientation == 1 && newEncoderConfig.mEncodeWidth < newEncoderConfig.mEncodeHeight) {
            mid = newEncoderConfig.mEncodeWidth;
            newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
            newEncoderConfig.mEncodeHeight = mid;
        }
        newEncoderConfig.mLowDelay = this.checkLowDelayByType(playType);
        ThunderLog.info("yvideo-Java", "startPublishVideo %dx%d %d %d %s %b %b", newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate, newEncoderConfig.mEncodeType.name(), bMirrorFrontCamera, bLowLatency);
        this.mPublisher.enableMirror(bMirrorFrontCamera);
        if (this.mCapture.getClass() == ThunderScreenCapture.class) {
            ThunderScreenCapture yyLiveScreenCapture = (ThunderScreenCapture)this.mCapture;
            this.mPublisher.initScreenLiveSession(yyLiveScreenCapture.getMediaProjection(), (IPublishListener)this, yyLiveScreenCapture.isLandscap());
        }
        this.mPublisher.setResolutionModifyConfigs(this.mVideoConfigManager.getCurrentModifyConfig(), this.mVideoConfigManager.getCurrentIntervalSecs());
        int ret = this.mPublisher.startPublishVideo("general", null, (Object)newEncoderConfig);
        if (ret == 0) {
            int videoLevel;
            int encodeType = 0;
            boolean hard = false;
            if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H264) {
                hard = true;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_X264) {
                hard = false;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_H265) {
                hard = false;
                encodeType = 1;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H265) {
                hard = true;
                encodeType = 1;
            }
            int n = videoLevel = this.mVideoConfigManager.getCurrentVideoLiveConfig() == null ? -1 : this.mVideoConfigManager.getCurrentVideoLiveConfig().videoLevel;
            if (this.mCurrentVideoConfig == null) {
                this.mCurrentVideoConfig = new YVideoPublishVideoConfig(newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate / 1000, newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, encodeType, hard, videoLevel);
            }
            this.mCurrentVideoConfig.bLowLatency = bLowLatency;
            this.mCurrentVideoConfig.bMirrorFrontCamera = bMirrorFrontCamera;
            this.mCurrentVideoConfig.playType = playType;
            this.mCurrentVideoConfig.mode = videoLevel;
            this.mCurrentVideoConfig.encodeFrameRate = newEncoderConfig.mFrameRate;
            this.mCurrentVideoConfig.encodeBitrate = newEncoderConfig.mBitRate / 1000;
            this.mCurrentVideoConfig.encodeResolutionWidth = newEncoderConfig.mEncodeWidth;
            this.mCurrentVideoConfig.encodeResolutionHeight = newEncoderConfig.mEncodeHeight;
            this.mCurrentVideoConfig.bHardwareEncoder = hard;
            this.mCurrentVideoConfig.encodeType = encodeType;
            int n2 = this.mCurrentVideoConfig.orientation = this.mCurrentVideoConfig.encodeResolutionWidth > this.mCurrentVideoConfig.encodeResolutionHeight ? 1 : 0;
        }
        if (this.mVideoPublishState != 1) {
            ThunderLog.info("yvideo-Java", "startPublishVideo videoState wrong:" + this.mVideoPublishState);
        }
        this.mVideoPublishState = 2;
        return this.mCurrentVideoConfig;
    }

    public int stopEncodeVideo() {
        this.mVideoConfigManager.resetCurrentVideoLiveConfig();
        if (this.mVideoPublishState != 2) {
            ThunderLog.info("yvideo-Java", "stopEncodeVideo videoState wrong:" + this.mVideoPublishState);
        }
        this.mVideoPublishState = 1;
        this.mPublisher.stopPublishVideo();
        if (this.mCapture.getClass() == ThunderScreenCapture.class) {
            this.mPublisher.deInitScreenLiveSession();
        }
        return 0;
    }

    public void changeScreenLiveMode(boolean pictureMode, Object bitmap) {
        this.mPublisher.changeScreenLiveMode(Boolean.valueOf(pictureMode), (Bitmap)bitmap);
    }

    public int startPlayVideoStream(String streamKey, Object toView, int scaleMode) {
        if (toView == null || streamKey == null || streamKey.isEmpty()) {
            return -1;
        }
        ThunderPlayerView view = (ThunderPlayerView)((Object)toView);
        ThunderLog.info("yvideo-Java", "startPlayVideoStream " + streamKey + " scaleMode:" + scaleMode);
        this.mVideoScaleModeMap.put(streamKey, scaleMode);
        this.mVideoViewMap.put(streamKey, view);
        return 0;
    }

    public int stopPlayVideoStream(String streamKey) {
        final ThunderPlayerView view = this.mVideoViewMap.get(streamKey);
        if (view == null) {
            return -1;
        }
        ThunderLog.debug("yvideo-Java", "stopPlayVideoStream" + streamKey);
        view.unLinkFromStream();
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                view.unPrepareView();
            }
        });
        this.mVideoViewMap.remove(streamKey);
        return 0;
    }

    public boolean updatePlayVideoView(String streamKey, Object toView, int scaleMode) {
        if (toView == null || streamKey == null || streamKey.isEmpty()) {
            return false;
        }
        ThunderPlayerView view = this.mVideoViewMap.get(streamKey);
        if (view == null) {
            return false;
        }
        if (!((Object)((Object)view)).equals(toView)) {
            ThunderLog.warn("yvideo-Java", "may toView is change!");
            return false;
        }
        ThunderLog.debug("yvideo-Java", "update play scale mode: " + scaleMode);
        return view.setScaleMode(scaleMode);
    }

    public YVideoPublishVideoConfig updatePublishVideoConfig(boolean bMirrorFrontCamera, boolean bLowLatency, int playType, int mode) {
        if (playType != this.mCurrentVideoConfig.playType || mode != this.mCurrentVideoConfig.mode) {
            int videoLevel;
            VideoEncoderConfig newEncoderConfig = this.getVideoEncoderConfigByType(playType, mode);
            PublishVideoConfig videoConfig = new PublishVideoConfig();
            videoConfig.assign(newEncoderConfig);
            videoConfig.mLowDelay = this.checkLowDelayByType(playType);
            if (videoConfig.mLowDelay != bLowLatency) {
                ThunderLog.info("yvideo-Java", "updatePublishVideoConfig %b :%d", bLowLatency, playType);
            }
            this.mPublisher.setResolutionModifyConfigs(this.mVideoConfigManager.getCurrentModifyConfig(), this.mVideoConfigManager.getCurrentIntervalSecs());
            this.mPublisher.updatePublishVideoConfig(videoConfig);
            int encodeType = 0;
            boolean hard = false;
            if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H264) {
                hard = true;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_X264) {
                hard = false;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_H265) {
                hard = false;
                encodeType = 1;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H265) {
                hard = true;
                encodeType = 1;
            }
            int n = videoLevel = this.mVideoConfigManager.getCurrentVideoLiveConfig() == null ? -1 : this.mVideoConfigManager.getCurrentVideoLiveConfig().videoLevel;
            if (this.mCurrentVideoConfig == null) {
                this.mCurrentVideoConfig = new YVideoPublishVideoConfig(newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate / 1000, newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, encodeType, hard, videoLevel);
            }
            this.mCurrentVideoConfig.playType = playType;
            this.mCurrentVideoConfig.mode = videoLevel;
            this.mCurrentVideoConfig.encodeFrameRate = newEncoderConfig.mFrameRate;
            this.mCurrentVideoConfig.encodeBitrate = newEncoderConfig.mBitRate / 1000;
            this.mCurrentVideoConfig.encodeResolutionWidth = newEncoderConfig.mEncodeWidth;
            this.mCurrentVideoConfig.encodeResolutionHeight = newEncoderConfig.mEncodeHeight;
            this.mCurrentVideoConfig.bHardwareEncoder = hard;
            this.mCurrentVideoConfig.encodeType = encodeType;
            this.mCurrentVideoConfig.orientation = ((ThunderPreviewConfig)this.mCapture.getCaptureConfig()).captureOrientation;
            this.mCurrentVideoConfig.bLowLatency = videoConfig.mLowDelay;
        }
        if (bMirrorFrontCamera != this.mCurrentVideoConfig.bMirrorFrontCamera) {
            this.mPublisher.enableMirror(bMirrorFrontCamera);
            this.mCurrentVideoConfig.bMirrorFrontCamera = bMirrorFrontCamera;
        }
        return this.mCurrentVideoConfig;
    }

    public boolean setCameraPosition(int position) {
        ((ThunderPreviewConfig)this.mCapture.getCaptureConfig()).cameraPosition = position;
        return this.mPublisher.setCameraPosition(position);
    }

    public int setPubWatermark(float x, float y, Object image) {
        return this.mPublisher.setWatermark((Bitmap)image, (int)x, (int)y);
    }

    public int setPubFaceBeautyLevel(float level) {
        if (this.mOrangeFilterWrapper != null) {
            this.mOrangeFilterWrapper.setBeautyParam(level);
        }
        return 0;
    }

    public int onVideoStreamArrive(String streamKey, long streamId) {
        ThunderPlayerView view = this.mVideoViewMap.get(streamKey);
        if (view == null) {
            ThunderLog.warn("yvideo-Java", "onVideoStreamArrive: cannot find video view for stream:%s", streamKey);
            return -1;
        }
        ThunderLog.info("yvideo-Java", "link stream:%s, %d", streamKey, streamId);
        view.linkToStream(streamId);
        return 0;
    }

    public int onVideoStreamStop(String streamKey, long streamId) {
        ThunderPlayerView view = this.mVideoViewMap.get(streamKey);
        if (view == null) {
            ThunderLog.warn("yvideo-Java", "onVideoStreamStop: cann't find video view for stream:%s", streamKey);
            return -1;
        }
        ThunderLog.info("yvideo-Java", "unlink stream:%s-%d", streamKey, streamId);
        view.unLinkFromStream(streamId);
        return 0;
    }

    public int onRequestIFrame() {
        this.mPublisher.requestEncodeIFrame();
        return 0;
    }

    public int onDynamicBitrate(long bitrate) {
        this.mPublisher.setNetworkBitrateSuggest((int)bitrate * 1000);
        return 0;
    }

    public String getAnchorHiidoStatInfo(long streamId) {
        return VideoDataStat.getInstance().getAnchorVideoData(streamId);
    }

    public String getAudienceHiidoStatInfo(long streamId) {
        return VideoPlayerDataStat.getInstance().getAudienceVideoData(streamId);
    }

    public int getPublishRuntimeInfo(int type) {
        switch (type) {
            case 0: {
                return this.mPublisher.getVideoPublishInfo(VideoPublish.VideoPublishInfoEnum.FRAME);
            }
            case 1: {
                return this.mPublisher.getVideoPublishInfo(VideoPublish.VideoPublishInfoEnum.BITRATE);
            }
            case 2: {
                return this.mPublisher.getVideoPublishInfo(VideoPublish.VideoPublishInfoEnum.RESOLUTION);
            }
        }
        return 0;
    }

    public long getPlayRuntimeInfo(long streamId, int type) {
        switch (type) {
            case 0: {
                return VideoPlayer.getInstance().getPlayerInfo(streamId, VideoPlayer.VideoPlayerInfoEnum.FRAME);
            }
            case 1: {
                break;
            }
            case 2: {
                return VideoPlayer.getInstance().getPlayerInfo(streamId, VideoPlayer.VideoPlayerInfoEnum.RESOLUTION);
            }
        }
        return 0L;
    }

    public int setPublisherPtsAdjustVal(int adjustVal) {
        if (this.mPublisher != null) {
            ThunderLog.debug("yvideo-Java", "setPublisherPtsAdjustVal " + adjustVal);
            this.mPublisher.setDeltaYYPtsMillions((long)adjustVal);
        }
        return 0;
    }

    public void onEncodeFrameData(byte[] data, int len, long pts, long dts, int frameType, VideoEncoderType encoderType) {
        int encodeType = 1;
        boolean bHardware = false;
        switch (encoderType) {
            case SOFT_ENCODER_X264: {
                bHardware = false;
                encodeType = 1;
                break;
            }
            case HARD_ENCODER_H264: {
                bHardware = true;
                encodeType = 1;
                break;
            }
            case SOFT_ENCODER_H265: {
                bHardware = false;
                encodeType = 2;
                break;
            }
            case HARD_ENCODER_H265: {
                bHardware = true;
                encodeType = 2;
                break;
            }
            case DEFAULT: 
            case ERROR: {
                ThunderLog.warn("yvideo-Java", "unknown encoder type" + encoderType.toString());
            }
        }
        if (this.mCallBackPtr != 0L) {
            this.onVideoEncodedFrame(this.mCallBackPtr, data, len, pts, dts, frameType, encodeType, bHardware);
        }
    }

    public int onTextureCallback(int textureId, int width, int height) {
        if (!this.isUsingDefaultCamera()) {
            return textureId;
        }
        ThunderDefaultCamera camera = (ThunderDefaultCamera)this.mCapture;
        if (camera.getCameraDataCallback() == null) {
            return textureId;
        }
        return camera.getCameraDataCallback().onTextureCallback(textureId, width, height);
    }

    void onVideoRenderNotify(ArrayList<VideoRenderNotify> notifications) {
        if (this.mCallBackPtr != 0L) {
            ThunderNative.onVideoRenderEvent(this.mCallBackPtr, notifications);
        }
    }

    void onHardwareDecodeErrorNotify(long userGroupId, long streamId, int errorType) {
        ThunderLog.info("yvideo-Java", "onHardwareDecodeErrorNotify %d", errorType);
        if (errorType < 3) {
            ThunderNative.enableHardwareDecoder(false, 1);
            ThunderNative.enableHardwareDecoder(false, 2);
            if (this.mVideoConfigManager != null) {
                this.mVideoConfigManager.disableHardDecode(true);
            }
        }
    }

    private native void onVideoEncodedFrame(long var1, byte[] var3, int var4, long var5, long var7, int var9, int var10, boolean var11);

    public void stopAndRecoverVideoEncode(boolean stop) {
        if (this.mPublisher != null && this.mVideoPublishState != 0) {
            this.mPublisher.stopAndRecoverStream(Boolean.valueOf(stop));
        }
    }

    private static class YVideoPublishVideoConfig {
        int encodeFrameRate;
        int encodeBitrate;
        int encodeResolutionWidth;
        int encodeResolutionHeight;
        int encodeType;
        boolean bHardwareEncoder;
        int mode;
        boolean bMirrorFrontCamera;
        boolean bLowLatency;
        int playType;
        int orientation;

        public YVideoPublishVideoConfig(int encodeFrameRate, int encodeBitrate, int encodeResolutionWidth, int encodeResolutionHeight, int encodeType, boolean bHardwareEncoder, int mode) {
            this.encodeFrameRate = encodeFrameRate;
            this.encodeBitrate = encodeBitrate;
            this.encodeResolutionWidth = encodeResolutionWidth;
            this.encodeResolutionHeight = encodeResolutionHeight;
            this.encodeType = encodeType;
            this.bHardwareEncoder = bHardwareEncoder;
            this.mode = mode;
        }

        public String toString() {
            String tmp = "" + this.encodeResolutionWidth + "x" + this.encodeResolutionHeight + "@" + this.encodeFrameRate + " " + this.encodeBitrate + " hard:" + this.bHardwareEncoder + " mode:" + this.mode;
            return tmp;
        }
    }
}

