/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud.trans;

import android.util.Log;
import com.yy.yylivesdk4cloud.ThunderAPI;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONObject;

public class TransConfigManager {
    private static final String TAG = "cfg_TransConfigManager";
    private static final String ARGO_CONFIG_KEY_COMMON_CONFIG = "TransCommonConfig";
    public static final String[] ARGO_CONFIG_KEYS = new String[]{"TransCommonConfig"};

    private TransConfigManager() {
    }

    public static TransConfigManager instance() {
        return SingletonHolder.INSTANCE;
    }

    public void onConfig(String key, String config) {
        if (key == null || config == null || config.isEmpty()) {
            return;
        }
        if (key.equals(ARGO_CONFIG_KEY_COMMON_CONFIG)) {
            this.parseCommonConfig(config);
        }
    }

    private void parseCommonConfig(String config) {
        if (config == null || config.isEmpty()) {
            return;
        }
        final HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        try {
            JSONObject configJson = new JSONObject(config);
            Iterator iterator = configJson.keys();
            while (iterator.hasNext()) {
                String keyStr = iterator.next().toString();
                int key = (int)Long.parseLong(keyStr);
                int val = (int)configJson.getLong(keyStr);
                result.put(key, val);
                Log.d((String)TAG, (String)String.format("key:%d, val:%d", key, val));
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("error" + e.toString()));
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                ThunderAPI.sharedInstance().setArgoConfig(result);
            }
        }).start();
    }

    private static class SingletonHolder {
        private static final TransConfigManager INSTANCE = new TransConfigManager();

        private SingletonHolder() {
        }
    }
}

