/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud.system;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;

public class ThunderNetStateService {
    private static final String INTERNET_PERMISSION = "android.permission.INTERNET";
    private static final String NETWORK_PERMISSION = "android.permission.ACCESS_NETWORK_STATE";
    private Context mContext;
    private BroadcastReceiver mNetReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            ThunderLog.info("ysdk-Java", "NetworkStateService onReceive pid %d", Thread.currentThread().getId());
            String action = intent.getAction();
            if (action != null && action.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                ThunderLog.info("ysdk-Java", "current network connectivity action");
                ThunderNetStateService.updateNetInfo(context);
            }
        }
    };

    public ThunderNetStateService(Context mContext) {
        this.mContext = mContext;
    }

    public void init() {
        IntentFilter mFilter = new IntentFilter();
        mFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.mContext.registerReceiver(this.mNetReceiver, mFilter);
    }

    public void fini() {
        this.mContext.unregisterReceiver(this.mNetReceiver);
    }

    private static boolean checkHasPermission(Context context, String perm) {
        int result = context.checkCallingOrSelfPermission(perm);
        return result == 0;
    }

    private static int getMobileNetworkState(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager == null) {
            ThunderLog.warn("ysdk-Java", "cannot get TelephonyManager");
            return 1;
        }
        int netType = telephonyManager.getNetworkType();
        switch (netType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: {
                return 3;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                return 4;
            }
            case 13: 
            case 18: {
                return 5;
            }
        }
        ThunderLog.warn("ysdk-Java", "unknown mobile network type:" + netType);
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateNetInfo(Context context) {
        if (context == null) {
            return;
        }
        try {
            int netState;
            if (!ThunderNetStateService.checkHasPermission(context, INTERNET_PERMISSION) || !ThunderNetStateService.checkHasPermission(context, NETWORK_PERMISSION)) {
                ThunderLog.info("ysdk-Java", "cannot get permission INTERNET or ACCESS_NETWORK_STATE!!");
                return;
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager == null) {
                ThunderLog.info("ysdk-Java", "cannot get ConnectivityManager!!");
                return;
            }
            NetworkInfo info = connectivityManager.getActiveNetworkInfo();
            if (info != null && info.isAvailable()) {
                int nType = info.getType();
                if (nType == 0) {
                    netState = ThunderNetStateService.getMobileNetworkState(context);
                    ThunderLog.info("ysdk-Java", "current network TYPE_MOBILE, netState: %d", netState);
                } else {
                    if (nType != 1) {
                        ThunderLog.warn("ysdk-Java", "current network %s is omitted", info.getTypeName());
                        return;
                    }
                    netState = 0;
                    ThunderLog.info("ysdk-Java", "current network wifi");
                }
            } else {
                ThunderLog.info("ysdk-Java", "current network No usable network!!");
                netState = 2;
            }
            ThunderNative.notifyNetState(netState);
            return;
        }
        catch (Exception exc) {
            ThunderLog.warn("ysdk-Java", "update net info error:" + exc);
        }
    }

    private static final class NetState {
        private static final int SYSNET_WIFI = 0;
        private static final int SYSNET_MOBILE = 1;
        private static final int SYSNET_DISCONNECT = 2;
        private static final int SYSNET_2G = 3;
        private static final int SYSNET_3G = 4;
        private static final int SYSNET_4G = 5;
        private static final int SYSNET_UNKNOWN = 127;

        private NetState() {
        }
    }
}

