/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud.helper;

import com.yy.yylivesdk4cloud.helper.IByteBufferPool;
import com.yy.yylivesdk4cloud.helper.IMshBuffer;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MshBuffer
implements IMshBuffer {
    public ByteBuffer mByteBuffer = null;
    public IByteBufferPool mBytePool = null;

    public MshBuffer(int size, IByteBufferPool pool) {
        this.mBytePool = pool;
        if (pool == null) {
            this.mByteBuffer = ByteBuffer.allocate(size);
            this.mByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.mByteBuffer = pool.newBuffer(size);
        }
    }

    @Override
    public void freeBuffer() {
        if (this.mBytePool != null) {
            this.mBytePool.freeBuffer(this.mByteBuffer);
            this.mByteBuffer = null;
        }
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.mByteBuffer;
    }

    @Override
    public int increase_capacity(int minIncrement) {
        int capacity = this.mByteBuffer.capacity();
        if (capacity == 0) {
            return 0;
        }
        int size = 2 * capacity;
        if (minIncrement > capacity) {
            size = capacity + minIncrement;
        }
        if (this.mBytePool == null) {
            ByteBuffer tempBuf = ByteBuffer.allocate(size);
            tempBuf.order(ByteOrder.LITTLE_ENDIAN);
            this.mByteBuffer.limit(this.mByteBuffer.position());
            this.mByteBuffer.position(0);
            tempBuf.put(this.mByteBuffer);
            this.mByteBuffer = tempBuf;
        } else {
            ByteBuffer tempBuf = this.mBytePool.newBuffer(size);
            this.mByteBuffer.limit(this.mByteBuffer.position());
            this.mByteBuffer.position(0);
            tempBuf.put(this.mByteBuffer);
            this.mBytePool.freeBuffer(this.mByteBuffer);
            this.mByteBuffer = tempBuf;
            ThunderLog.info("ysdk-Java", "===MshPoolBuffer, capactiy=" + this.mByteBuffer.capacity() + " postion=" + this.mByteBuffer.position());
        }
        return size;
    }

    @Override
    public void wrap(byte[] buffer) {
        if (this.mByteBuffer != null && this.mBytePool != null) {
            this.mBytePool.freeBuffer(this.mByteBuffer);
        }
        this.mByteBuffer = ByteBuffer.wrap(buffer);
        this.mByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.mBytePool = null;
    }
}

