/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import android.graphics.Bitmap;
import com.yy.mediaframework.gpuimage.custom.OrangeFilterWrapper;
import com.yy.mediaframework.utils.YMFLog;
import com.yy.yylivesdk4cloud.ThunderAudioCapture;
import com.yy.yylivesdk4cloud.ThunderBridgeLib;
import com.yy.yylivesdk4cloud.ThunderConstant;
import com.yy.yylivesdk4cloud.ThunderDefaultCamera;
import com.yy.yylivesdk4cloud.ThunderDefaultMic;
import com.yy.yylivesdk4cloud.ThunderPublishAudioConfig;
import com.yy.yylivesdk4cloud.ThunderPublishVideoConfig;
import com.yy.yylivesdk4cloud.ThunderScreenCapture;
import com.yy.yylivesdk4cloud.ThunderVideoCapture;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;
import com.yy.yylivesdk4cloud.video.ThunderVideoLogCallback;
import java.util.ArrayList;
import java.util.HashMap;

public class ThunderPublisher {
    private ThunderPublishAudioConfig mAudioConfig = null;
    private ThunderAudioCapture mAudioCapture = null;
    private ThunderDefaultMic mDefaultMic = new ThunderDefaultMic();
    private ThunderPublishVideoConfig mVideoConfig = null;
    private ThunderVideoCapture mVideoCapture = null;
    private ThunderDefaultCamera mDefaultCamera = new ThunderDefaultCamera();

    ThunderPublisher() {
        YMFLog.registerLogger((Object)ThunderVideoLogCallback.sharedInstance());
    }

    public int startPreviewWithView(Object view, int playType, int publishMode) {
        if (this.mVideoCapture == null) {
            this.attachVideoCapture(this.mDefaultCamera);
        }
        ThunderLog.release("ycall-Java", "startPreviewWithView view:%s", view.toString());
        return ThunderNative.startVideoPreview(view, playType, publishMode);
    }

    public int stopPreview() {
        ThunderLog.release("ycall-Java", "stopVideoPreview");
        return ThunderNative.stopVideoPreview();
    }

    public void setLivePublishRtmpParam(boolean bOpen, String url, String playPath) {
        ThunderLog.release("ycall-Java", "setLivePublishRtmpParam");
        ThunderNative.setLivePublishRtmpParam(bOpen, url, playPath);
    }

    public OrangeFilterWrapper getBeautyFilter() {
        return ThunderBridgeLib.getInstance().getBeautyFilter();
    }

    public int startPublishVideo(String streamName, ArrayList<String> groupNames, ThunderPublishVideoConfig config) {
        if (streamName == null || streamName.isEmpty()) {
            ThunderLog.error("ycall-Java", "startPublishVideo stream name must be set");
            return -1;
        }
        if (groupNames == null) {
            groupNames = new ArrayList(0);
        }
        if (config == null) {
            config = new ThunderPublishVideoConfig();
        }
        this.mVideoConfig = config;
        ThunderLog.release("ycall-Java", "startPublishVideo streamName:%s, groupNames size:%d, config:%s", streamName, groupNames.size(), config.toString());
        return ThunderNative.startPublishVideo(streamName, groupNames, config);
    }

    public int stopPublishVideo() {
        ThunderLog.release("ycall-Java", "stopPublishVideo");
        return ThunderNative.stopPublishVideo();
    }

    public HashMap<Integer, String> getSupportModeInfoWithPlayType(int playType) {
        int convertType = this.convertPlayType(playType);
        HashMap<Integer, String> map = ThunderNative.getSupportModeInfoWithPlayType(convertType);
        return map;
    }

    public void disableHardEncoder(Boolean disable) {
        ThunderNative.disableHardEncoder(disable);
    }

    public ThunderPublishVideoConfig getRemotePublishVideoConfig(int playType, int mode) {
        int convertType = this.convertPlayType(playType);
        ThunderPublishVideoConfig remotePublishVideoConfig = ThunderNative.getRemoteVideoConfig(convertType, mode);
        return remotePublishVideoConfig;
    }

    public int getDefaultPublishVideoMode(int playType) {
        int convertType = this.convertPlayType(playType);
        return ThunderNative.getDefaultPublishVideoMode(convertType);
    }

    public ThunderPublishVideoConfig getCurPublishVideoConfig() {
        return ThunderNative.getVideoConfig();
    }

    public boolean updatePublishVideoConfig(ThunderPublishVideoConfig config) {
        this.mVideoConfig = config;
        return ThunderNative.updateVideoConfig(config);
    }

    public int startPublishAudio(String streamName, ArrayList<String> groupNames, ThunderPublishAudioConfig config) {
        if (this.mAudioCapture == null) {
            ThunderNative.attachAudioCapture(this.mDefaultMic);
        }
        if (streamName == null || streamName.isEmpty()) {
            ThunderLog.error("ycall-Java", "startPublishAudio stream name must be set");
            return -1;
        }
        if (groupNames == null) {
            groupNames = new ArrayList(0);
        }
        if (config == null) {
            config = new ThunderPublishAudioConfig(4);
        }
        this.mAudioConfig = config;
        ThunderLog.release("ycall-Java", "startPublishAudio streamName:%s, groupNames size:%d, config:%s", streamName, groupNames.size(), config.toString());
        return ThunderNative.startPublishAudio(streamName, groupNames, config);
    }

    public int stopPublishAudio() {
        ThunderLog.release("ycall-Java", "stopPublishAudio");
        return ThunderNative.stopPublishAudio();
    }

    public ThunderPublishAudioConfig getCurPublishAudioConfig() {
        return this.mAudioConfig;
    }

    public boolean setCameraPosition(int position) {
        ThunderLog.release("ycall-Java", "setCameraPosition %d", position);
        return ThunderNative.setCameraPosition(position);
    }

    public int setWatermark(int posX, int posY, Bitmap image) {
        if (image == null) {
            return -1;
        }
        ThunderLog.release("ycall-Java", "setWatermark in (%d,%d)", posX, posY);
        return ThunderNative.setWatermark(posX, posY, image);
    }

    public int setFaceBeautyLevel(float level) {
        if (level >= 1.000001f) {
            level = 1.0f;
        } else if (level < 1.0E-6f) {
            level = 0.0f;
        }
        ThunderLog.release("ycall-Java", "setFaceBeautyLevel %f", Float.valueOf(level));
        return ThunderNative.setFaceBeautyLevel(level);
    }

    public boolean setMicVolume(int volume) {
        if (volume < 0) {
            volume = 0;
        }
        ThunderLog.release("ycall-Java", "setMicVolume %d", volume);
        return ThunderNative.setMicVolume(volume);
    }

    public void enableVad(boolean enable) {
        ThunderLog.release("ycall-Java", "enableVad %b", enable);
        ThunderNative.enableVad(enable);
    }

    public void EnableEqualizer(boolean enable) {
        ThunderLog.release("ycall-Java", "EnableEqualizer %b", enable);
        ThunderNative.EnableEqualizer(enable);
    }

    public void SetGqGains(int[] gains) {
        ThunderNative.SetGqGains(gains);
    }

    public void EnableCompressor(boolean enable) {
        ThunderNative.EnableCompressor(enable);
    }

    public void EnableLimiter(boolean enable) {
        ThunderNative.EnableLimiter(enable);
    }

    public void SetCompressorParam(int threshold, int makeupGain, int ratio, int knee, int releaseTime, int attackTime) {
        ThunderNative.SetCompressorParam(threshold, makeupGain, ratio, knee, releaseTime, attackTime);
    }

    public void SetLimiterParam(float fCeiling, float fThreshold, float fPreGain, float fRelease, float fAttack, float fLookahead, float fLookaheadRatio, float fRMS, float fStLink) {
        ThunderNative.setLimiterParameter(fCeiling, fThreshold, fPreGain, fRelease, fAttack, fLookahead, fLookaheadRatio, fRMS, fStLink);
    }

    public void EnableReverb(boolean enable) {
        ThunderNative.EnableReverb(enable);
    }

    public void setReverbExParameter(float RoomSize, float PreDelay, float Reverberance, float HfDamping, float ToneLow, float ToneHigh, float WetGain, float DryGain, float StereoWidth) {
        ThunderNative.setReverbExParameter(RoomSize, PreDelay, Reverberance, HfDamping, ToneLow, ToneHigh, WetGain, DryGain, StereoWidth);
    }

    public ThunderDefaultMic getDefaluteMic() {
        return this.mDefaultMic;
    }

    public void attachAudioCapture(ThunderAudioCapture capture) {
        this.mAudioCapture = capture == null ? this.mDefaultMic : capture;
        ThunderLog.release("ycall-Java", "attachAudioCapture %s", this.mAudioCapture.toString());
        ThunderNative.attachAudioCapture(this.mAudioCapture);
    }

    public void setMixAudioCapture(ArrayList<ThunderAudioCapture> mixCaptureList) {
    }

    public ThunderDefaultCamera getDefaluteCamera() {
        return this.mDefaultCamera;
    }

    public void attachVideoCapture(ThunderVideoCapture capture) {
        this.mVideoCapture = capture == null ? this.mDefaultCamera : capture;
        ThunderLog.release("ycall-Java", "attachVideoCapture %s", this.mVideoCapture.toString());
        ThunderNative.attachVideoCapture(this.mVideoCapture);
    }

    public void setMixVideoCapture(ArrayList<ThunderVideoCapture> mixCaptureList) {
    }

    public void initSreenLiveSession(ThunderScreenCapture yyLiveScreenCapture) {
        if (yyLiveScreenCapture != null) {
            this.attachVideoCapture(yyLiveScreenCapture);
        }
    }

    public void setOrientation(int orientation) {
        ThunderNative.setOrientation(orientation);
    }

    public void setAudioSourceType(int mode) {
        ThunderNative.setAudioSourceType(mode);
    }

    public boolean enableInEarMonitor(boolean enable) {
        return ThunderNative.enableInEarMonitor(enable);
    }

    public void setSoundEffect(int mode) {
        ThunderLog.release("ycall-Java", "ThunderPublisher::setSoundEffect %d", mode);
        ThunderNative.setSoundEffect(mode);
    }

    public void setVoiceChanger(int mode) {
        ThunderLog.release("ycall-Java", "ThunderPublisher::setVoiceChanger %d", mode);
        ThunderNative.setVoiceChanger(mode);
    }

    private int convertPlayType(int playType) {
        switch (playType) {
            case 0: {
                playType = 0;
                break;
            }
            case 1: {
                playType = 1;
                break;
            }
            case 2: {
                playType = 5;
                break;
            }
        }
        return playType;
    }

    public static interface IVideoPublisher {
        public void pushVideoData();

        public void pushVideoData(byte[] var1, ThunderConstant.ThunderVideoEncodeType var2, long var3, long var5);
    }

    public static interface IAudioPublisher {
        public void pushAudioData(byte[] var1, long var2);
    }
}

