/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import android.graphics.Bitmap;
import android.graphics.Rect;
import com.yy.mediaframework.gpuimage.custom.OrangeFilterWrapper;
import com.yy.yylivesdk4cloud.ThunderAudioCapture;
import com.yy.yylivesdk4cloud.ThunderBridgeLib;
import com.yy.yylivesdk4cloud.ThunderDefaultCamera;
import com.yy.yylivesdk4cloud.ThunderDefaultMic;
import com.yy.yylivesdk4cloud.ThunderLayout;
import com.yy.yylivesdk4cloud.ThunderPublishAudioConfig;
import com.yy.yylivesdk4cloud.ThunderPublishInfo;
import com.yy.yylivesdk4cloud.ThunderPublishRoom;
import com.yy.yylivesdk4cloud.ThunderPublishVideoConfig;
import com.yy.yylivesdk4cloud.ThunderRoomlLayout;
import com.yy.yylivesdk4cloud.ThunderVideoCapture;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;
import java.util.ArrayList;
import java.util.HashMap;

class ThunderPublishRoomImp
implements ThunderPublishRoom {
    private ThunderVideoCapture mVideoCapture = null;
    private ThunderAudioCapture mAudioCapture = null;
    private ThunderDefaultCamera mDefaultCamera = new ThunderDefaultCamera();
    private ThunderDefaultMic mDefaultMic = new ThunderDefaultMic();
    private String mChannelId = null;
    private String mUidString = null;
    private long mUid = 0L;
    private boolean mOwner = false;
    private boolean mPublishing = false;
    private boolean mAudioOnly = false;
    private int mPublishMode = -1;
    private int mPlayType = 0;
    private int mCamaraPosition = 0;
    private int mPubOrientation = 0;

    ThunderPublishRoomImp() {
    }

    @Override
    public int startPreview(Object view, int playType, int publishMode) {
        if (this.mVideoCapture == null) {
            this.attachVideoCapture(this.mDefaultCamera);
        }
        ThunderLog.info("ycall-Java", "startPreview view:%s", view.toString());
        int convertType = this.convertPlayType(playType);
        return ThunderNative.startVideoPreview(view, convertType, publishMode);
    }

    @Override
    public int stopPreview() {
        ThunderLog.info("ycall-Java", "stopVideoPreview");
        return ThunderNative.stopVideoPreview();
    }

    @Override
    public int startLiveInteract(ThunderLayout layout) {
        if (this.mChannelId == null) {
            ThunderLog.info("ycall-Java", "startLiveInteract channelId null");
            return -1;
        }
        if (layout == null) {
            ThunderLog.info("ycall-Java", "startLiveInteract layout error");
            return -1;
        }
        if (layout.layouts.size() == 0 || layout.speakers.size() == 0) {
            ThunderLog.info("ycall-Java", "startLiveInteract param error");
            return -1;
        }
        this.mAudioOnly = false;
        this.mPlayType = 1;
        ThunderPublishVideoConfig videoConfig = this.convertVideoConfig();
        ThunderPublishAudioConfig audioConfig = this.convertAudioConfig();
        if (layout.layouts.size() == 1) {
            ThunderRoomlLayout channelLayout = layout.layouts.get(0);
            if (this.mPublishing) {
                ThunderNative.updatePublishLive(channelLayout.channelId, true, videoConfig, audioConfig, layout);
            } else {
                this.mPublishing = true;
                if (this.mAudioCapture == null) {
                    ThunderNative.attachAudioCapture(this.mDefaultMic);
                }
                ThunderNative.startPublishLive(channelLayout.channelId, true, videoConfig, audioConfig, layout);
            }
            this.mOwner = channelLayout.owner;
        } else {
            for (ThunderRoomlLayout channelLayout : layout.layouts) {
                ThunderLayout liveLayout = this.convertLayout(layout, channelLayout);
                ThunderNative.updatePublishLive(channelLayout.channelId, false, videoConfig, audioConfig, liveLayout);
            }
            this.mOwner = true;
        }
        ThunderLog.info("ycall-Java", "startLiveInteract %s", layout.toString());
        return 0;
    }

    @Override
    public int stopLiveInteract() {
        ThunderLog.info("ycall-Java", "stopLiveInteract %b", this.mOwner);
        if (this.mOwner) {
            this.mAudioOnly = false;
            this.mPlayType = 0;
            ThunderPublishVideoConfig videoConfig = this.convertVideoConfig();
            ThunderPublishAudioConfig audioConfig = this.convertAudioConfig();
            ThunderLayout layout = this.makeLayout(null);
            return ThunderNative.updatePublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
        }
        return this.stopSinglePublish();
    }

    @Override
    public int startAudioInteract(ArrayList<String> speakers) {
        if (this.mChannelId == null) {
            ThunderLog.info("ycall-Java", "startAudioInteract channelId null");
            return -1;
        }
        if (speakers == null) {
            ThunderLog.info("ycall-Java", "startAudioInteract speakers error");
            return -1;
        }
        this.mAudioOnly = true;
        this.mPlayType = 1;
        ThunderPublishVideoConfig videoConfig = this.convertVideoConfig();
        ThunderPublishAudioConfig audioConfig = this.convertAudioConfig();
        ThunderLayout layout = this.makeLayout(speakers);
        if (this.mPublishing) {
            ThunderNative.updatePublishLive(this.mChannelId, true, videoConfig, audioConfig, layout);
        } else {
            this.mPublishing = true;
            if (this.mAudioCapture == null) {
                ThunderNative.attachAudioCapture(this.mDefaultMic);
            }
            ThunderNative.startPublishLive(this.mChannelId, true, videoConfig, audioConfig, layout);
        }
        ThunderRoomlLayout channelLayout = layout.getChannelLayout(0);
        this.mOwner = channelLayout.owner;
        return 0;
    }

    @Override
    public int stopAudioInteract() {
        ThunderLog.info("ycall-Java", "stopAudioInteract %b", this.mOwner);
        if (this.mOwner) {
            this.mAudioOnly = false;
            this.mPlayType = 0;
            ThunderPublishVideoConfig videoConfig = this.convertVideoConfig();
            ThunderPublishAudioConfig audioConfig = this.convertAudioConfig();
            ThunderLayout layout = this.makeLayout(null);
            return ThunderNative.updatePublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
        }
        return this.stopSinglePublish();
    }

    @Override
    public int startSinglePublish(int playType, int publishMode) {
        if (this.mChannelId == null) {
            ThunderLog.info("ycall-Java", "startPublish channelId null");
            return -1;
        }
        this.mPlayType = playType;
        this.mPublishMode = publishMode;
        this.mPublishing = true;
        this.mAudioOnly = false;
        if (this.mAudioCapture == null) {
            ThunderNative.attachAudioCapture(this.mDefaultMic);
        }
        ThunderPublishVideoConfig videoConfig = this.convertVideoConfig();
        ThunderPublishAudioConfig audioConfig = this.convertAudioConfig();
        ThunderLayout layout = this.makeLayout(null);
        ThunderLog.info("ycall-Java", "startPublish %s", layout.toString());
        return ThunderNative.startPublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
    }

    @Override
    public int stopSinglePublish() {
        ThunderLog.info("ycall-Java", "stopPublish %s", this.mChannelId);
        if (this.mChannelId == null) {
            return 0;
        }
        this.mPublishing = false;
        this.mOwner = false;
        this.mAudioOnly = false;
        return ThunderNative.stopPublishLive(this.mChannelId);
    }

    @Override
    public int updatePublishMode(int publishMode) {
        if (this.mPublishMode == publishMode) {
            ThunderLog.info("ycall-Java", "updatePublishMode ignore same");
            return 0;
        }
        if (!this.mPublishing) {
            this.mPublishMode = publishMode;
            ThunderLog.info("ycall-Java", "updatePublishMode not publishing");
            return 0;
        }
        boolean bSuport = false;
        int convertType = this.convertPlayType(this.mPlayType);
        HashMap<Integer, String> modeMap = ThunderNative.getSupportModeInfoWithPlayType(convertType);
        if (modeMap.size() == 0) {
            ThunderLog.info("ycall-Java", "updatePublishMode empty");
            return -1;
        }
        for (Integer key : modeMap.keySet()) {
            if (key != publishMode) continue;
            bSuport = true;
            break;
        }
        if (bSuport) {
            this.mPublishMode = publishMode;
            ThunderPublishVideoConfig videoConfig = this.convertVideoConfig();
            if (this.mPlayType == 1) {
                ThunderNative.updateVideoConfig(videoConfig);
                return 0;
            }
            ThunderPublishAudioConfig audioConfig = this.convertAudioConfig();
            ThunderLayout layout = this.makeLayout(null);
            ThunderNative.updatePublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
        }
        ThunderLog.info("ycall-Java", "updatePublishMode %d %b", publishMode, bSuport);
        return 0;
    }

    @Override
    public HashMap<Integer, String> getPublishMode(int playType) {
        int convertType = this.convertPlayType(playType);
        return ThunderNative.getSupportModeInfoWithPlayType(convertType);
    }

    @Override
    public int getDefaultPublishMode(int playType) {
        int convertType = this.convertPlayType(playType);
        return ThunderNative.getDefaultPublishVideoMode(convertType);
    }

    @Override
    public ThunderPublishInfo getCurrentPublishInfo() {
        ThunderPublishInfo publishInfo = ThunderNative.getPublishInfo();
        if (publishInfo != null) {
            publishInfo.publishOrientation = this.mPubOrientation;
            publishInfo.cameraPosition = this.mCamaraPosition;
        }
        return publishInfo;
    }

    @Override
    public boolean setCameraPosition(int position) {
        this.mCamaraPosition = position;
        ThunderLog.info("ycall-Java", "setCameraPosition %d", position);
        return ThunderNative.setCameraPosition(position);
    }

    @Override
    public void setPublishOrientation(int orientation) {
        this.mPubOrientation = orientation;
        ThunderNative.setOrientation(orientation);
    }

    @Override
    public int setWatermark(int posX, int posY, Bitmap image) {
        if (image == null) {
            return -1;
        }
        ThunderLog.info("ycall-Java", "setWatermark in (%d,%d)", posX, posY);
        return ThunderNative.setWatermark(posX, posY, image);
    }

    @Override
    public int setFaceBeautyLevel(float level) {
        if (level >= 1.000001f) {
            level = 1.0f;
        } else if (level < 1.0E-6f) {
            level = 0.0f;
        }
        ThunderLog.info("ycall-Java", "setFaceBeautyLevel %f", Float.valueOf(level));
        return ThunderNative.setFaceBeautyLevel(level);
    }

    @Override
    public boolean setMicVolume(int volume) {
        if (volume < 0) {
            volume = 0;
        } else if (volume > 100) {
            volume = 100;
        }
        ThunderLog.info("ycall-Java", "setMicVolume %d", volume);
        return ThunderNative.setMicVolume(volume);
    }

    @Override
    public OrangeFilterWrapper getBeautyFilter() {
        return ThunderBridgeLib.getInstance().getBeautyFilter();
    }

    public ThunderDefaultMic getDefaluteMic() {
        return this.mDefaultMic;
    }

    @Override
    public void attachAudioCapture(ThunderAudioCapture capture) {
        this.mAudioCapture = capture == null ? this.mDefaultMic : capture;
        ThunderLog.info("ycall-Java", "attachAudioCapture %s", this.mAudioCapture.toString());
        ThunderNative.attachAudioCapture(this.mAudioCapture);
    }

    @Override
    public void attachVideoCapture(ThunderVideoCapture capture) {
        this.mVideoCapture = capture == null ? this.mDefaultCamera : capture;
        ThunderLog.info("ycall-Java", "attachVideoCapture %s", this.mVideoCapture.toString());
        ThunderNative.attachVideoCapture(this.mVideoCapture);
    }

    @Override
    public void syncUserInfo(String channelId, String uid, boolean is32Bit, int userRole) {
        this.mChannelId = channelId;
        this.mUidString = uid;
        if (is32Bit) {
            this.mUid = uid == null ? 0L : Long.parseLong(uid);
        }
    }

    private ThunderPublishVideoConfig convertVideoConfig() {
        int convertType = this.convertPlayType(this.mPlayType);
        ThunderPublishVideoConfig config = ThunderNative.getRemoteVideoConfig(convertType, this.mPublishMode);
        if (this.mAudioOnly) {
            config.encodeResolutionWidth = 0;
            config.encodeResolutionHeight = 0;
        }
        return config;
    }

    private ThunderPublishAudioConfig convertAudioConfig() {
        ThunderPublishAudioConfig config = new ThunderPublishAudioConfig(5);
        config.bUseAudioProfile = true;
        if (this.mPlayType == 0 || this.mPlayType == 2) {
            config.roomConfig = 0;
            config.audioConfig = 2;
            config.commutMode = 2;
            config.scenarioMode = 2;
        } else if (this.mPlayType == 1) {
            config.roomConfig = 0;
            config.audioConfig = 2;
            config.commutMode = 1;
            config.scenarioMode = 1;
        }
        return config;
    }

    private ThunderLayout convertLayout(ThunderLayout liveLayout, ThunderRoomlLayout channelLayout) {
        ArrayList<ThunderRoomlLayout> layouts = new ArrayList<ThunderRoomlLayout>();
        layouts.add(channelLayout);
        ThunderLayout layout = new ThunderLayout();
        layout.width = liveLayout.width;
        layout.height = liveLayout.height;
        layout.layouts = layouts;
        layout.speakers = liveLayout.speakers;
        return layout;
    }

    private ThunderLayout makeLayout(ArrayList<String> speakers) {
        int convertType = this.convertPlayType(this.mPlayType);
        ThunderPublishVideoConfig config = ThunderNative.getRemoteVideoConfig(convertType, this.mPublishMode);
        Rect rect = new Rect(0, 0, config.encodeResolutionWidth, config.encodeResolutionHeight);
        ThunderRoomlLayout channelLayout = new ThunderRoomlLayout();
        channelLayout.channelId = this.mChannelId;
        channelLayout.layoutNo = 0;
        channelLayout.layout = rect;
        ArrayList<ThunderRoomlLayout> layouts = new ArrayList<ThunderRoomlLayout>();
        layouts.add(channelLayout);
        ThunderLayout layout = new ThunderLayout();
        layout.width = rect.width();
        layout.height = rect.height();
        layout.layouts = layouts;
        if (speakers == null || speakers.isEmpty()) {
            channelLayout.owner = this.mPublishing;
            ArrayList<String> spk = new ArrayList<String>();
            spk.add(this.mUidString);
            layout.speakers = spk;
        } else {
            channelLayout.owner = true;
            layout.speakers = speakers;
        }
        return layout;
    }

    private int convertPlayType(int playType) {
        if (this.mAudioOnly) {
            return 0;
        }
        switch (playType) {
            case 0: {
                playType = 0;
                break;
            }
            case 1: {
                playType = 1;
                break;
            }
            case 2: {
                playType = 5;
                break;
            }
        }
        return playType;
    }
}

