/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import com.yy.yylivesdk4cloud.ThunderGroup;
import com.yy.yylivesdk4cloud.ThunderStream;
import com.yy.yylivesdk4cloud.ThunderStreamLevelInfo;
import java.util.ArrayList;
import java.util.Map;

public class ThunderNotification {
    public static final int kYYLiveAPINotification_PublishStatus = 0;
    public static final int kYYLiveAPINotification_PublishRunTimeInfo = 1;
    public static final int kYYLiveAPINotification_PlayStatus = 2;
    public static final int kYYLiveAPINotification_PlayRunTimeInfo = 3;
    public static final int kYYLiveAPINotification_AudioCaptureVolume = 4;
    public static final int kYYLiveAPINotification_AudioPlayVolume = 5;
    public static final int kYYLiveAPINotification_BizAuthRes = 6;
    public static final int kYYLiveAPINotification_SdkAuthRes = 7;
    public static final int kYYLiveAPINotification_UninstallSdk = 8;
    public static final int kYYLiveAPINotifioation_StringUid = 9;
    public static final int kYYLiveAPINotification_JoinChannelStatus = 10;
    public static final int kYYLiveAPINotification_StreamInfoStatus = 11;
    public static final int kYYLiveAPINotification_RtmpPublishStatus = 12;
    public static final int kYYLiveAPINotification_ResolutionChangeInfo = 13;
    public static final int kYYLiveAPINotification_AudioPlayData = 14;
    public static final int kYYLiveAPINotification_AudioPlaySpectrumData = 15;
    public static final int kYYLiveAPINotification_AudioCapturePcmData = 16;
    public static final int kYYLiveAPINotification_UserAppMsgData = 17;
    public static final int kYYLiveAPINotification_AppMsgDataFailedStatus = 18;
    public static final int kYYLiveAPINotification_AudioRenderPcmData = 19;
    public static final int kYYLiveAPINotification_PublishLossResult = 20;
    public static final int kYYLiveAPINotification_PublishChannelStatus = 21;
    public static final int kYYLiveAPINotification_PublishChannelStreamInfo = 22;
    public static final int kYYLiveAPINotification_InitiateHttpsRequest = 23;
    public static final int kYYLiveAPINotification_UserMuteAudio = 24;
    public static final int kYYLiveAPINotification_UserJoined = 25;
    public static final int kYYLiveAPINotification_UserOffline = 26;
    public static final int kYYLiveAPINotification_NetworkQuality = 27;

    public static class NetworkQuality {
        private long mUid;
        private int mTxQuality;
        private int mRxQuality;

        public NetworkQuality(long uid, int txQuality, int rxQuality) {
            this.mUid = uid;
            this.mTxQuality = txQuality;
            this.mRxQuality = rxQuality;
        }

        public long getUid() {
            return this.mUid;
        }

        public int getTxQuality() {
            return this.mTxQuality;
        }

        public int getRxQuality() {
            return this.mRxQuality;
        }
    }

    public static class UserOffline {
        private long mUid;
        private int mReason;

        public UserOffline(long uid, int reason) {
            this.mUid = uid;
            this.mReason = reason;
        }

        public long getUid() {
            return this.mUid;
        }

        public int getReason() {
            return this.mReason;
        }
    }

    public static class UserJoined {
        private long mUid;

        public UserJoined(long uid) {
            this.mUid = uid;
        }

        public long getUid() {
            return this.mUid;
        }
    }

    public static class UserMuteAudio {
        private long mUid;
        private boolean mIsMuted;

        public UserMuteAudio(long uid, int muted) {
            this.mUid = uid;
            this.mIsMuted = muted == 1;
        }

        public long getUid() {
            return this.mUid;
        }

        public boolean isMuted() {
            return this.mIsMuted;
        }
    }

    public static class InitiateHttpsRequest {
        private String mReqUrl;
        private int mTarget;

        public InitiateHttpsRequest(String reqUrl, int target) {
            this.mReqUrl = reqUrl;
            this.mTarget = target;
        }

        public String getReqUrl() {
            return this.mReqUrl;
        }

        public int getTarget() {
            return this.mTarget;
        }
    }

    public static class PublishChannelStreamInfo {
        private String mChannelId;
        private ArrayList<ThunderStream> mStreams;

        public PublishChannelStreamInfo(String channelId, ArrayList<ThunderStream> streams) {
            this.mChannelId = channelId;
            this.mStreams = streams;
        }

        public String getChannelId() {
            return this.mChannelId;
        }

        public ArrayList<ThunderStream> getStreams() {
            return this.mStreams;
        }
    }

    public static class PublishChannelStatus {
        public static final int YYLIVE_PUBLISHSTATUS_SUCCESS = 0;
        public static final int YYLIVE_PUBLISHSTATUS_PARAM_ERROR = 1;
        public static final int YYLIVE_PUBLISHSTATUS_FAILED = 2;
        public static final int YYLIVE_PUBLISHSTATUS_AUTH_FAILED = 3;
        public static final int YYLIVE_PUBLISHSTATUS_USER_NOT_ANCHOR = 4;
        private int mStatus;
        private String mChannelId;

        public PublishChannelStatus(String channelId, int status) {
            this.mChannelId = channelId;
            this.mStatus = status;
        }

        public int getStatus() {
            return this.mStatus;
        }

        public String getChannelId() {
            return this.mChannelId;
        }
    }

    public static class AppMsgDataFailedStatus {
        public static final int YYLIVE_HIGHT_FREQUENCY = 1;
        public static final int YYLIVE_LARGE_MSG_DATA = 2;
        private int failedStatus;

        public AppMsgDataFailedStatus(int status) {
            this.failedStatus = status;
        }

        public int getFailedStatus() {
            return this.failedStatus;
        }
    }

    public static class UserAppMsgData {
        private byte[] mData;
        private long mUid;

        public UserAppMsgData(byte[] data, long uid) {
            this.mData = data;
            this.mUid = uid;
        }

        public byte[] getData() {
            return this.mData;
        }

        public long getUid() {
            return this.mUid;
        }
    }

    public static class AudioRenderPcmData {
        private byte[] mData;
        private int mDataSize;
        private int mDuration;
        private int mSampleRate;
        private int mChannel;

        public AudioRenderPcmData(byte[] data, int dataSize, int duration, int sampleRate, int channel) {
            this.mData = data;
            this.mDataSize = dataSize;
            this.mDuration = duration;
            this.mSampleRate = sampleRate;
            this.mChannel = channel;
        }

        public byte[] getData() {
            return this.mData;
        }

        public int getDataSize() {
            return this.mDataSize;
        }

        public int getDuration() {
            return this.mDuration;
        }

        public int getSampleRate() {
            return this.mSampleRate;
        }

        public int getChannel() {
            return this.mChannel;
        }
    }

    public static class AudioCapturePcmData {
        private byte[] mData;
        private int mDataSize;
        private int mSampleRate;
        private int mChannel;

        public AudioCapturePcmData(byte[] data, int dataSize, int sampleRate, int channel) {
            this.mData = data;
            this.mDataSize = dataSize;
            this.mSampleRate = sampleRate;
            this.mChannel = channel;
        }

        public byte[] getData() {
            return this.mData;
        }

        public int getDataSize() {
            return this.mDataSize;
        }

        public int getSampleRate() {
            return this.mSampleRate;
        }

        public int getChannel() {
            return this.mChannel;
        }
    }

    public static class AudioPlaySpectrumData {
        private byte[] mData;

        public AudioPlaySpectrumData(byte[] data) {
            this.mData = data;
        }

        public byte[] getData() {
            return this.mData;
        }
    }

    public static class AudioDataInfo {
        private long mUid;
        private int mDuration;
        private int mCpt;
        private int mPts;
        private byte[] mData;

        public AudioDataInfo(long uid, int duration, int cpt, int pts, byte[] data) {
            this.mUid = uid;
            this.mDuration = duration;
            this.mCpt = cpt;
            this.mPts = pts;
            this.mData = data;
        }

        public long getUid() {
            return this.mUid;
        }

        public int getDuration() {
            return this.mDuration;
        }

        public int getCpt() {
            return this.mCpt;
        }

        public int getPts() {
            return this.mPts;
        }

        public byte[] getData() {
            return this.mData;
        }
    }

    public static class PublishLossResult {
        public static final int YYLIVE_PUBLISH_NET_NORMAL = 0;
        public static final int YYLIVE_PUBLISH_NET_WEAK = 1;
        private int mAppid;
        private int mResult;

        public PublishLossResult(int appid, int result) {
            this.mAppid = appid;
            this.mResult = result;
        }

        public int getAppid() {
            return this.mAppid;
        }

        public int getResult() {
            return this.mResult;
        }
    }

    public static class RtmpPublishStatus {
        public static final int YYLIVE_RTMP_PUBLISH_SUCCESS = 1;
        public static final int YYLIVE_RTMP_PUBLISH_STREAM_SUCCESS = 2;
        public static final int YYLIVE_RTMP_PUBLISH_FETCH_RTMP_FAILED = 3;
        public static final int YYLIVE_RTMP_PUBLISH_PARSE_URL_FAILED = 4;
        public static final int YYLIVE_RTMP_PUBLISH_TCP_FAILED = 5;
        public static final int YYLIVE_RTMP_PUBLISH_AUTH_FAILED = 6;
        public static final int YYLIVE_RTMP_PUBLISH_STREAM_FAILED = 7;
        public static final int YYLIVE_RTMP_PUBLISH_CLOSED = 8;
        public static final int YYLIVE_RTMP_PUBLISH_NO_RESOURCE = 9;
        public static final int YYLIVE_RTMP_PUBLISH_SEND_FIRST_FRAME = 10;
        public static final int YYLIVE_RTMP_PUBLISH_SERVER_DELETE_STREAM = 11;
        public static final int YYLIVE_RTMP_PUBLISH_READ_PACKET_FAILED = 12;
        private int mAppid;
        private int mStatus;

        public RtmpPublishStatus(int appid, int status) {
            this.mAppid = appid;
            this.mStatus = status;
        }

        public int getAppid() {
            return this.mAppid;
        }

        public int getStatus() {
            return this.mStatus;
        }
    }

    public static class StreamStatusInfo {
        public static final int YYLIVE_STREAM_NO_STREAM = 0;
        public static final int YYLIVE_STREAM_LEVEL_CHG = 1;
        public static final int YYLIVE_STREAM_LINE_CHG = 2;
        public static final int YYLIVE_STREAM_NAME_CHG = 4;
        public static final int YYLIVE_STREAM_CONFIG_CHG = 16;
        public static final int YYLIVE_STREAM_STOP = 32;
        public static final int YYLIVE_STREAM_ARRIVE = 64;
        private int mCurLine;
        private String mChannelId;
        private int mStatus;
        private Map<Integer, ThunderStreamLevelInfo> mStreamLevel;

        public StreamStatusInfo(int curLine, String channelId, int status, Map<Integer, ThunderStreamLevelInfo> streamLevel) {
            this.mCurLine = curLine;
            this.mChannelId = channelId;
            this.mStatus = status;
            this.mStreamLevel = streamLevel;
        }

        public int getCurLine() {
            return this.mCurLine;
        }

        public String getChannelId() {
            return this.mChannelId;
        }

        public int getStatus() {
            return this.mStatus;
        }

        public Map<Integer, ThunderStreamLevelInfo> getStreamLevel() {
            return this.mStreamLevel;
        }
    }

    public static class JoinChannelStatus {
        public static final int YYLIVE_JOINCHANNEL_STATUS_SUCCESS = 0;
        public static final int YYLIVE_JOINCHANNEL_STATUS_TIMEOUT = 1;
        private String mChannelId;
        private int mStatus;

        public JoinChannelStatus(String channelId, int status) {
            this.mChannelId = channelId;
            this.mStatus = status;
        }

        public String getChannelId() {
            return this.mChannelId;
        }

        public int getStatus() {
            return this.mStatus;
        }
    }

    public static class ResolutionChangeInfo {
        private ThunderStream mStream;
        private int mWidth;
        private int mHeight;

        public ResolutionChangeInfo(ThunderStream stream, int width, int height) {
            this.mStream = stream;
            this.mWidth = width;
            this.mHeight = height;
        }

        public ThunderStream getStream() {
            return this.mStream;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }
    }

    public static class UidInt2String {
        private int mUid;
        private String mStrUid;

        public UidInt2String(int iUid, String strUid) {
            this.mUid = iUid;
            this.mStrUid = this.removeNonNumericChar(strUid);
        }

        private String removeNonNumericChar(String strUid) {
            StringBuffer buffer = new StringBuffer();
            int length = strUid.length();
            for (int i = 0; i < length; ++i) {
                int codePoint = Character.codePointAt(strUid, i);
                if (codePoint < 48 || codePoint > 57) continue;
                buffer.append(strUid.charAt(i));
            }
            return buffer.toString();
        }

        public int getUidInt() {
            return this.mUid;
        }

        public String getUidString() {
            return this.mStrUid;
        }
    }

    public static class UninstallSdk {
    }

    public static class SdkAuthResult {
        public static final int YYLIVE_SDK_AUTHRES_SUCCUSS = 0;
        public static final int YYLIVE_SDK_AUTHRES_ERR_SERVER_INTERNAL = 10000;
        public static final int YYLIVE_SDK_AUTHRES_ERR_NO_TOKEN = 10001;
        public static final int YYLIVE_SDK_AUTHRES_ERR_TOKEN_ERR = 10002;
        public static final int YYLIVE_SDK_AUTHRES_ERR_APPID = 10003;
        public static final int YYLIVE_SDK_AUTHRES_ERR_UID = 10004;
        public static final int YYLIVE_SDK_AUTHRES_ERR_TOKEN_EXPIRE = 10005;
        public static final int YYLIVE_SDK_AUTHRES_ERR_NO_APP = 10006;
        private int mAppId;
        private int mUid;
        private int mSdkAuthResult;

        public SdkAuthResult(int appId, int uid, int sdkAuthResult) {
            this.mAppId = appId;
            this.mUid = uid;
            this.mSdkAuthResult = sdkAuthResult;
        }

        public int getAppId() {
            return this.mAppId;
        }

        public int getUid() {
            return this.mUid;
        }

        public int getSdkAuthResult() {
            return this.mSdkAuthResult;
        }
    }

    public static class BizAuthResult {
        private ThunderStream mStream;
        private ThunderGroup mGroup;
        private boolean mBPublish;
        private int mBizAuthResult;

        public BizAuthResult(ThunderStream stream, ThunderGroup group, boolean bPublish, int bizAuthResult) {
            this.mStream = stream;
            this.mGroup = group;
            this.mBPublish = bPublish;
            this.mBizAuthResult = bizAuthResult;
        }

        public ThunderStream getAuthStream() {
            return this.mStream;
        }

        public ThunderGroup getAuthGroup() {
            return this.mGroup;
        }

        public boolean isPublishAuth() {
            return this.mBPublish;
        }

        public int getBizAuthResult() {
            return this.mBizAuthResult;
        }
    }

    public static class YYAudioCaptureVolume {
        public int mVolume;
        public long mCpt;
        public int mMicVolume;

        public YYAudioCaptureVolume(int volulme, long cpt, int micVolume) {
            this.mVolume = volulme;
            this.mCpt = cpt;
            this.mMicVolume = micVolume;
        }
    }

    public static class AudioVolumeInfo {
        private Map<Long, YYVolumeInfo> mVolumeInfos;

        public AudioVolumeInfo(Map<Long, YYVolumeInfo> volumeInfos) {
            this.mVolumeInfos = volumeInfos;
        }

        public Map<Long, YYVolumeInfo> getVolumeInfos() {
            return this.mVolumeInfos;
        }
    }

    public static class YYVolumeInfo {
        public int mVolume;
        public long mPts;
        public ArrayList<Long> mActualSpeakerUidList;

        public YYVolumeInfo(int volume, long pts, ArrayList<Long> actualSpeakerUidList) {
            this.mVolume = volume;
            this.mPts = pts;
            this.mActualSpeakerUidList = actualSpeakerUidList;
        }
    }

    public static class PlayRunTimeInfo {
        private ThunderStream mStream;
        private YYLiveRunTimeInfo mInfo;

        public PlayRunTimeInfo(ThunderStream stream, YYLiveRunTimeInfo info) {
            this.mStream = stream;
            this.mInfo = info;
        }

        public ThunderStream getStream() {
            return this.mStream;
        }

        public YYLiveRunTimeInfo getInfo() {
            return this.mInfo;
        }
    }

    public static class PlayStatusInfo {
        public static final int YYLIVE_PLAYSTATUS_PARAM_ERROR = -1;
        public static final int YYLIVE_PLAYSTATUS_SUBSCRIBE_SUCCUSS = 0;
        public static final int YYLIVE_PLAYSTATUS_SUBSCRIBE_FAILED = 1;
        public static final int YYLIVE_PLAYSTATUS_SUBSCRIBE_CANCEL = 2;
        public static final int YYLIVE_PLAYSTATUS_STREAM_ARRIVE = 3;
        public static final int YYLIVE_PLAYSTATUS_STREAM_RENDERED = 4;
        public static final int YYLIVE_PLAYSTATUS_STREAM_STOP = 5;
        private int mStatus;
        private ThunderStream mStream;

        public PlayStatusInfo(ThunderStream stream, int status) {
            this.mStream = stream;
            this.mStatus = status;
        }

        public ThunderStream getStream() {
            return this.mStream;
        }

        public int getStatus() {
            return this.mStatus;
        }
    }

    public static class PublishRunTimeInfo {
        private String mStreamName;
        private YYLiveRunTimeInfo mInfo;

        public PublishRunTimeInfo(String streamName, YYLiveRunTimeInfo info) {
            this.mStreamName = streamName;
            this.mInfo = info;
        }

        public String getStreamName() {
            return this.mStreamName;
        }

        public YYLiveRunTimeInfo getInfo() {
            return this.mInfo;
        }
    }

    public static class YYLiveRunTimeInfo {
        public static final int YYLIVE_QUALITY_UNKNOWN = 0;
        public static final int YYLIVE_QUALITY_VERYGOOD = 1;
        public static final int YYLIVE_QUALITY_GOOD = 2;
        public static final int YYLIVE_QUALITY_NORMAL = 3;
        public static final int YYLIVE_QUALITY_BAD = 4;
        public static final int YYLIVE_QUALITY_VERYBAD = 5;
        public static final int YYLIVE_LINKSTATUS_CONNECTING = 0;
        public static final int YYLIVE_LINKSTATUS_CONNECTED = 1;
        public static final int YYLIVE_LINKSTATUS_DISCONNECT = 2;
        public static final int YYLIVE_LINKSTATUS_SERVERREJECT = 3;
        private int mFps;
        private int mBitrate;
        private int mWidth;
        private int mHeight;
        private int mAudioBitrate;
        private int mQuality;
        private int mRtt;
        private int mLossRate;
        private int mLinkStatus;
        private int mRealBitrate;

        public YYLiveRunTimeInfo(int fps, int bitrate, int width, int height, int audioBitrate, int quality, int rtt, int lossRate, int linkStatus, int realBitrate) {
            this.mFps = fps;
            this.mBitrate = bitrate;
            this.mWidth = width;
            this.mHeight = height;
            this.mAudioBitrate = audioBitrate;
            this.mQuality = quality;
            this.mRtt = rtt;
            this.mLossRate = lossRate;
            this.mLinkStatus = linkStatus;
            this.mRealBitrate = realBitrate;
        }

        public int getFps() {
            return this.mFps;
        }

        public int getBitrate() {
            return this.mBitrate;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public int getAudioBitrate() {
            return this.mAudioBitrate;
        }

        public int getQuality() {
            return this.mQuality;
        }

        public int getRtt() {
            return this.mRtt;
        }

        public int getLossRate() {
            return this.mLossRate;
        }

        public int getLinkStatus() {
            return this.mLinkStatus;
        }

        public int getPublishRealBitrate() {
            return this.mRealBitrate;
        }
    }

    public static class PublishStatusInfo {
        public static final int YYLIVE_PUBLISHSTATUS_PARAM_ERROR = -1;
        public static final int YYLIVE_PUBLISHSTATUS_PUBLISH_SUCCESS = 0;
        public static final int YYLIVE_PUBLISHSTATUS_PUBLISH_FAILED = 1;
        public static final int YYLIVE_PUBLISHSTATUS_PUBLISH_AUTH_FAILED = 2;
        public static final int YYLIVE_PUBLISHSTATUS_USER_NOT_ANCHOR = 3;
        private String mStreamName;
        private int mStatus;

        public PublishStatusInfo(String streamName, int status) {
            this.mStreamName = streamName;
            this.mStatus = status;
        }

        public String getStreamName() {
            return this.mStreamName;
        }

        public int getStatus() {
            return this.mStatus;
        }
    }
}

