/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.yy.yylivesdk4cloud.IThunderLogCallback;
import com.yy.yylivesdk4cloud.ThunderAPI;
import com.yy.yylivesdk4cloud.ThunderAudioFilePlayer;
import com.yy.yylivesdk4cloud.ThunderEventHandler;
import com.yy.yylivesdk4cloud.ThunderGroup;
import com.yy.yylivesdk4cloud.ThunderNotification;
import com.yy.yylivesdk4cloud.ThunderPublishAudioConfig;
import com.yy.yylivesdk4cloud.ThunderStream;
import com.yy.yylivesdk4cloud.audio.IAudioFrameObserver;
import com.yy.yylivesdk4cloud.helper.ThunderHttpsRequestHandler;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ThunderEngine {
    private static final String TAG = "RtcEngine";
    private static boolean mIsInited = false;
    private static long mJoinRoomTimestamp;
    private static int sMyAppId;
    private static long sMySceneId;
    private static ThunderEventHandler mRtcEventHandler;
    private static ThunderHttpsRequestHandler mHttpsRequestHandler;
    private long mMyUid = 0L;
    private Map<Integer, String> mUidToStringMap = new HashMap<Integer, String>();
    private boolean mIs32bitUid = true;
    private String mMyStrUid = "";
    private boolean mIsUserBanned = false;
    private byte[] mToken;
    private static String mLogPath;
    private static int mLogLevel;
    private static IThunderLogCallback mYyLogCallback;
    private boolean mBGroupSubscribe = false;
    private boolean mBAudioPublish = false;
    private String mStringName = "";
    private int mRoomAppId = 0;
    private String mRoomName = "";
    private int mRoomConfig = 0;
    private int mAudioConfig = 0;
    private int mCommutMode = 0;
    private int mScenarioMode = 0;
    private boolean mBEnablePlayDataIndication = false;
    private static int s_playVolumeNotifyCount;
    private static int s_playDataNotifyCount;
    private static NotificationHandler mHandler;
    private int[] mEqGains = new int[11];
    private boolean mBEnableEqualizer = false;
    private boolean mBEnableCompressor = false;
    private boolean mBEnableLimiter = false;
    private boolean mBEnableReverbEx = false;
    private ReverbExParameter mReverbExGains = new ReverbExParameter();
    private CompressorParam mCompressorGains = new CompressorParam();
    private LimterParam mLimiterGins = new LimterParam();
    private Set<ThunderAudioFilePlayer> mAudioFilePlayerSet = new TreeSet<ThunderAudioFilePlayer>();

    public String getRoomName() {
        return this.mRoomName;
    }

    public String getMyUid() {
        return this.mMyStrUid;
    }

    private ThunderEngine() {
    }

    private static synchronized ThunderEngine createRtcEngine(Context context, String appId, long sceneId, ThunderEventHandler handler) {
        if (!mIsInited) {
            mRtcEventHandler = handler;
            mHttpsRequestHandler = new ThunderHttpsRequestHandler();
            sMyAppId = Integer.parseInt(appId);
            sMySceneId = sceneId;
            ThunderAPI.sharedInstance().initWithAppId(sMyAppId, sMySceneId, context);
            mIsInited = true;
        }
        return SingleonHolder.INSTANCE;
    }

    public static synchronized ThunderEngine createEngine(Context context, String appId, long sceneId, ThunderEventHandler handler) {
        ThunderEngine rtcEngine = null;
        try {
            rtcEngine = ThunderEngine.createRtcEngine(context, appId, sceneId, handler);
            if (rtcEngine != null && mHandler == null) {
                mHandler = new NotificationHandler(rtcEngine);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rtcEngine;
    }

    public static synchronized ThunderEngine createWithLoop(Context context, String appId, long sceneId, ThunderEventHandler handler, Looper loop) {
        ThunderEngine rtcEngine = ThunderEngine.createRtcEngine(context, appId, sceneId, handler);
        if (mHandler == null) {
            mHandler = new NotificationHandler(rtcEngine, loop);
        }
        return rtcEngine;
    }

    public static synchronized void destroyEngine() {
        try {
            if (mIsInited) {
                ThunderAPI.sharedInstance().deInit();
                mIsInited = false;
                SingleonHolder.INSTANCE.resetRtcEngine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getVersion() {
        return ThunderAPI.sharedInstance().getVersion();
    }

    public static int setLogFilePath(String filePath) {
        mLogPath = filePath;
        if (filePath == null || filePath.isEmpty()) {
            ThunderAPI.enableLog(false, mLogLevel, mLogPath, null);
        } else {
            ThunderAPI.enableLog(true, mLogLevel, mLogPath, null);
        }
        return 0;
    }

    public static int setLogCallback(IThunderLogCallback callback) {
        mYyLogCallback = callback;
        if (mYyLogCallback != null) {
            ThunderAPI.enableLog(true, mLogLevel, "", mYyLogCallback);
        } else {
            ThunderAPI.enableLog(false, mLogLevel, "", mYyLogCallback);
        }
        return 0;
    }

    public static int setLogLevel(int level) {
        mLogLevel = level;
        return 0;
    }

    public void setSceneId(long sceneId) {
        sMySceneId = sceneId;
        ThunderAPI.sharedInstance().setSceneId(sceneId);
    }

    public int setRoomConfig(int config) {
        ThunderLog.release("yrtc", "setRoomConfig: profile=%d", config);
        this.mRoomConfig = config;
        boolean bLowLatency = false;
        switch (this.mRoomConfig) {
            case 0: {
                bLowLatency = false;
                break;
            }
            case 1: 
            case 3: {
                bLowLatency = true;
                break;
            }
            case 4: {
                bLowLatency = true;
            }
        }
        ThunderAPI.sharedInstance().setRoomConfig(config);
        ThunderAPI.sharedInstance().enableLowLatency(bLowLatency);
        return 0;
    }

    public int setArea(int area) {
        ThunderLog.release("yrtc", "setArea: area=%d", area);
        int iResult = 0;
        int transSdkArea = 0;
        switch (area) {
            case 0: {
                transSdkArea = 0;
                break;
            }
            case 1: {
                transSdkArea = 100;
                break;
            }
            case 2: {
                transSdkArea = 101;
                break;
            }
            default: {
                iResult = -1;
            }
        }
        ThunderAPI.sharedInstance().setAreaType(transSdkArea);
        return iResult;
    }

    public int setUse64bitUid(boolean is64bitUid) {
        this.mIs32bitUid = !is64bitUid;
        return 0;
    }

    public int joinRoom(byte[] token, String joinRoom, String uid) {
        ThunderLog.release("yrtc", "joinRoom: joinRoom=%s, uid=%s, token=%s", this.getPrintString(joinRoom), this.getPrintString(uid), this.getPrintString(token));
        if (this.mBGroupSubscribe) {
            return -1;
        }
        if (!this.isValidRoomStream(joinRoom)) {
            return -2;
        }
        if (uid == null || uid.isEmpty()) {
            return -3;
        }
        this.mMyStrUid = uid;
        if (this.mIs32bitUid) {
            try {
                this.mMyUid = Long.parseLong(uid);
            }
            catch (NumberFormatException exception) {
                return -4;
            }
        }
        ThunderNative.setVoiceOnlySdk(true);
        ThunderNative.setChannelName(joinRoom);
        ThunderAPI.sharedInstance().registerNotificationHandler(mHandler);
        this.mToken = token;
        ThunderAPI.sharedInstance().updateToken(token);
        if (this.mIs32bitUid) {
            ThunderAPI.sharedInstance().joinMedia(this.mMyUid);
        } else {
            ThunderAPI.sharedInstance().joinMedia(this.mMyStrUid, 0L, 0L);
        }
        ThunderAPI.sharedInstance().setUserRole(1);
        ArrayList<ThunderGroup> audioGroup = new ArrayList<ThunderGroup>(0);
        ThunderGroup oneGroup = new ThunderGroup();
        this.mRoomName = joinRoom;
        this.mRoomAppId = sMyAppId;
        oneGroup.appId = this.mRoomAppId;
        oneGroup.groupName = "g_" + this.mRoomName;
        audioGroup.add(oneGroup);
        ThunderAPI.sharedInstance().getPlayer().startPlayStreams(null, audioGroup);
        this.mBGroupSubscribe = true;
        return 0;
    }

    private boolean isValidRoomStream(String roomName) {
        if (roomName == null || roomName.isEmpty()) {
            return false;
        }
        int length = roomName.length();
        if (length > 64) {
            return false;
        }
        int validCharCount = 0;
        for (int i = 0; i < length; ++i) {
            int codePoint = Character.codePointAt(roomName, i);
            if (!(codePoint == 45 || codePoint == 95 || codePoint >= 48 && codePoint <= 57 || codePoint >= 65 && codePoint <= 90) && (codePoint < 97 || codePoint > 122)) continue;
            ++validCharCount;
        }
        if (validCharCount == length) {
            return true;
        }
        ThunderLog.error("yrtc", "found invalid char in roomname!");
        return false;
    }

    public int leaveRoom() {
        ThunderLog.release("yrtc", "leaveRoom");
        this.tryStopPublish();
        this.tryStopSubscribe();
        this.removeAllUid2String();
        ThunderAPI.sharedInstance().leaveMedia();
        return 0;
    }

    public int updateToken(byte[] token) {
        ThunderLog.release("yrtc", "updateToken: %s ", this.getPrintString(token));
        this.mToken = token;
        ThunderAPI.sharedInstance().updateToken(token);
        return 0;
    }

    public int enableAudioEngine() {
        ThunderLog.release("yrtc", "enableAudioEngine ");
        if (!this.mBGroupSubscribe) {
            return -1;
        }
        if (this.mBAudioPublish) {
            return -2;
        }
        this.mStringName = "a_" + this.mMyUid + "_" + this.mRoomName;
        String groupName = "g_" + this.mRoomName;
        ArrayList<String> groupList = new ArrayList<String>();
        groupList.add(groupName);
        ThunderPublishAudioConfig config = new ThunderPublishAudioConfig(2);
        config.bUseAudioProfile = true;
        config.roomConfig = this.mRoomConfig;
        config.audioConfig = this.mAudioConfig;
        config.commutMode = this.mCommutMode;
        config.scenarioMode = this.mScenarioMode;
        this.mBAudioPublish = true;
        ThunderAPI.sharedInstance().getPublisher().startPublishAudio(this.mStringName, groupList, config);
        return 0;
    }

    public int disableAudioEngine() {
        ThunderLog.release("yrtc", "disableAudioEngine ");
        this.tryStopPublish();
        return 0;
    }

    public int setAudioConfig(int config, int commutMode, int scenarioMode) {
        ThunderLog.release("yrtc", "setAudioConfig: config=%d, commutMode=%d, scenarioMode=%d", config, commutMode, scenarioMode);
        this.mAudioConfig = config;
        this.mCommutMode = commutMode;
        this.mScenarioMode = scenarioMode;
        return 0;
    }

    public int enableLoudspeaker(boolean enabled) {
        ThunderLog.release("yrtc", "enableLoudspeaker: %b", enabled);
        ThunderAPI.sharedInstance().getPlayer().enableLoudSpeaker(enabled);
        return 0;
    }

    public boolean isLoudspeakerEnabled() {
        return ThunderAPI.sharedInstance().getPlayer().getLoudSpeakerEnabled();
    }

    public int setAudioVolumeIndication(int interval, int moreThanThd, int lessThanThd, int smooth) {
        ThunderLog.release("yrtc", "setAudioVolumeIndication: interval=%d,moreThanThd=%d, lessThanThd=%d, smooth=%d", interval, moreThanThd, lessThanThd, smooth);
        ThunderAPI.sharedInstance().setPlayVolumeInterval(interval, moreThanThd, lessThanThd);
        return 0;
    }

    public int enableCaptureVolumeIndication(int interval, int moreThanThd, int lessThanThd, int smooth) {
        ThunderLog.release("yrtc", "enableCaptureVolumeIndication: interval=%d,moreThanThd=%d, lessThanThd=%d, smooth=%d", interval, moreThanThd, lessThanThd, smooth);
        ThunderAPI.sharedInstance().setCaptureVolumeInterval(interval, moreThanThd, lessThanThd);
        return 0;
    }

    public boolean startAudioSaver(String fileName, int saverMode, int fileMode) {
        ThunderLog.release("yrtc", "startAudioSaver: fileName=%s,saverMode=%d, fileMode=%d", this.getPrintString(fileName), saverMode, fileMode);
        if (fileName.isEmpty()) {
            return false;
        }
        return ThunderAPI.sharedInstance().startAudioSaver(fileName, saverMode, fileMode);
    }

    public boolean stopAudioSaver() {
        ThunderLog.release("yrtc", "stopAudioSaver");
        return ThunderAPI.sharedInstance().stopAudioSaver();
    }

    public void setSoundEffect(int mode) {
        ThunderLog.release("yrtc", "ThunderEngine::setSoundEffect %d", mode);
        ThunderAPI.sharedInstance().getPublisher().setSoundEffect(mode);
    }

    public void setVoiceChanger(int mode) {
        ThunderLog.release("yrtc", "ThunderEngine::setVoiceChanger %d", mode);
        ThunderAPI.sharedInstance().getPublisher().setVoiceChanger(mode);
    }

    public int stopLocalAudioStream(boolean stop) {
        ThunderLog.release("yrtc", "stopLocalAudioStream: %b", stop);
        int volume = 80;
        if (stop) {
            volume = 0;
        }
        ThunderAPI.sharedInstance().getPublisher().setMicVolume(volume);
        return 0;
    }

    public int stopAllRemoteAudioStreams(boolean stop) {
        ThunderLog.release("yrtc", "stopAllRemoteAudioStreams: %b", stop);
        ThunderAPI.sharedInstance().getPlayer().enableAllMute(stop);
        return 0;
    }

    public int stopRemoteAudioStream(String uid, boolean stop) {
        ThunderLog.release("yrtc", "stopRemoteAudioStream: uid=%s, %b", this.getPrintString(uid), stop);
        ThunderStream stream = new ThunderStream();
        if (this.mIs32bitUid) {
            try {
                stream.speakerUid = Long.parseLong(uid);
            }
            catch (NumberFormatException exception) {
                return -1;
            }
        } else {
            if (uid == null) {
                return -2;
            }
            ThunderAPI.sharedInstance().getPlayer().enableMute(stop, uid);
            stream.speakerUid = this.getIntUid(uid);
            if (stream.speakerUid == 0L) {
                return 0;
            }
        }
        ThunderAPI.sharedInstance().getPlayer().enableMute(stop, stream);
        return 0;
    }

    public int setLoudSpeakerVolume(int volume) {
        ThunderLog.release("yrtc", "setLoudSpeakerVolume: %d", volume);
        boolean bResult = ThunderAPI.sharedInstance().getPlayer().setSpeakerVolume(volume);
        if (bResult) {
            return 0;
        }
        return -1;
    }

    public int setMicVolume(int volume) {
        ThunderLog.release("yrtc", "setMicVolume: %d", volume);
        boolean bResult = ThunderAPI.sharedInstance().getPublisher().setMicVolume(volume);
        if (bResult) {
            return 0;
        }
        return -1;
    }

    public int setRemoteAudioStreamsVolume(String uid, int volume) {
        ThunderLog.release("yrtc", "setRemoteAudioStreamsVolume: uid=%s, volume=%d", this.getPrintString(uid), volume);
        if (!this.mBGroupSubscribe) {
            return -1;
        }
        ThunderStream stream = new ThunderStream();
        if (this.mIs32bitUid) {
            try {
                stream.speakerUid = Long.parseLong(uid);
            }
            catch (NumberFormatException exception) {
                return -1;
            }
        } else {
            stream.speakerUid = this.getIntUid(uid);
            if (stream.speakerUid == 0L) {
                if (this.isNumeric(uid)) {
                    try {
                        stream.speakerUid = Long.parseLong(uid);
                    }
                    catch (NumberFormatException exception) {
                        return -2;
                    }
                } else {
                    return -3;
                }
            }
        }
        if (ThunderAPI.sharedInstance().getPlayer().setPlayVolume(volume, stream)) {
            return 0;
        }
        return -4;
    }

    public ThunderAudioFilePlayer createAudioFilePlayer() {
        ThunderLog.release("yrtc", "createAudioFilePlayer");
        ThunderAudioFilePlayer audioFilePlayer = new ThunderAudioFilePlayer();
        this.mAudioFilePlayerSet.add(audioFilePlayer);
        return audioFilePlayer;
    }

    public void destroyAudioFilePlayer(ThunderAudioFilePlayer audioFilePlayer) {
        ThunderLog.release("yrtc", "destroyAudioFilePlayer: %s", this.getPrintString(audioFilePlayer));
        if (audioFilePlayer == null) {
            return;
        }
        audioFilePlayer.destroyAudioFilePlayer();
        this.mAudioFilePlayerSet.remove(audioFilePlayer);
    }

    public int setEnableEqualizer(boolean enabled) {
        this.mBEnableEqualizer = enabled;
        ThunderAPI.sharedInstance().getPublisher().EnableEqualizer(enabled);
        return 0;
    }

    public int setEqGains(int[] gains) {
        if (gains == null) {
            return -1;
        }
        if (gains.length < 11) {
            return -2;
        }
        for (int i = 0; i <= 10; ++i) {
            if (gains[i] >= -12 && gains[i] <= 12) continue;
            return -3;
        }
        this.mEqGains = gains;
        ThunderAPI.sharedInstance().getPublisher().SetGqGains(gains);
        return 0;
    }

    public int setEnableReverb(boolean enabled) {
        this.mBEnableReverbEx = enabled;
        ThunderAPI.sharedInstance().getPublisher().EnableReverb(enabled);
        return 0;
    }

    public int setReverbExParameter(ReverbExParameter param) {
        if (param == null) {
            return -1;
        }
        if ((double)param.mRoomSize < 0.0 || (double)param.mRoomSize > 100.0 || (double)param.mPreDelay < 0.0 || (double)param.mPreDelay > 200.0 || (double)param.mReverberance < 0.0 || (double)param.mReverberance > 100.0 || (double)param.mHfDamping < 0.0 || (double)param.mHfDamping > 100.0 || (double)param.mToneLow < 0.0 || (double)param.mToneLow > 100.0 || (double)param.mToneHigh < 0.0 || (double)param.mToneHigh > 100.0 || (double)param.mWetGain < -20.0 || (double)param.mWetGain > 10.0 || (double)param.mDryGain < -20.0 || (double)param.mDryGain > 10.0 || (double)param.mStereoWidth < 0.0 || (double)param.mStereoWidth > 100.0) {
            return -2;
        }
        this.mReverbExGains = param;
        ThunderAPI.sharedInstance().getPublisher().setReverbExParameter(param.mRoomSize, param.mPreDelay, param.mReverberance, param.mHfDamping, param.mToneLow, param.mToneHigh, param.mWetGain, param.mDryGain, param.mStereoWidth);
        return 0;
    }

    public int setEnableCompressor(boolean enabled) {
        this.mBEnableCompressor = enabled;
        ThunderAPI.sharedInstance().getPublisher().EnableCompressor(enabled);
        return 0;
    }

    public int setCompressorParam(CompressorParam param) {
        if (param == null) {
            return -1;
        }
        if (param.mThreshold < -10 || param.mThreshold > 0 || param.mReleaseTime <= 0 || param.mAttackTime <= 0) {
            return -2;
        }
        this.mCompressorGains = param;
        ThunderAPI.sharedInstance().getPublisher().SetCompressorParam(param.mThreshold, param.mMakeupGain, param.mRatio, param.mKnee, param.mReleaseTime, param.mAttackTime);
        return 0;
    }

    public int setEnableLimiter(boolean enabled) {
        this.mBEnableLimiter = enabled;
        ThunderAPI.sharedInstance().getPublisher().EnableLimiter(enabled);
        return 0;
    }

    public int setLimiterParam(LimterParam param) {
        if (param == null) {
            return -1;
        }
        this.mLimiterGins = param;
        ThunderAPI.sharedInstance().getPublisher().SetLimiterParam(param.fCeiling, param.fThreshold, param.fPreGain, param.fRelease, param.fAttack, param.fLookahead, param.fLookaheadRatio, param.fRMS, param.fStLink);
        return 0;
    }

    public void setExternalAudioProcessor(long eap) {
        ThunderAPI.sharedInstance().setExternalAudioProcessor(eap);
    }

    public void enableAudioPlaySpectrum(boolean enable) {
        ThunderAPI.sharedInstance().enableAudioPlaySpectrum(enable);
    }

    public void setAudioPlaySpectrumInfo(int spectrumLen, int notifyIntervalMS) {
        ThunderAPI.sharedInstance().setAudioPlaySpectrumInfo(spectrumLen, notifyIntervalMS);
    }

    public int sendUserAppMsgData(byte[] msgData) {
        ThunderAPI.sharedInstance().sendUserAppMsgData(msgData);
        return 0;
    }

    public void enableAudioDataIndication(boolean enablePlay) {
        this.mBEnablePlayDataIndication = enablePlay;
        ThunderAPI.sharedInstance().enableAudioDataIndication(enablePlay);
    }

    public void enableCapturePcmDataCallBack(boolean enable, int sampleRate, int room) {
        ThunderAPI.sharedInstance().enableCapturePcmDataCallBack(enable, sampleRate, room);
    }

    public boolean enableRenderPcmDataCallBack(boolean enable, int sampleRate, int room) {
        ThunderLog.release("yrtc", "enableRenderPcmDataCallBack enable = %b sampleRate: %d, room = %d ", enable, sampleRate, room);
        return ThunderAPI.sharedInstance().enableRenderPcmDataCallBack(enable, sampleRate, room);
    }

    public void setAudioSourceType(int sourceType) {
        ThunderLog.release("ycall-Java", "setAudioSourceType: sourceType=%d", sourceType);
        ThunderAPI.sharedInstance().getPublisher().setAudioSourceType(sourceType);
    }

    public int setEnableInEarMonitor(boolean enable) {
        ThunderLog.release("ycall-Java", "setEnableInEarMonitor: %b", enable);
        if (ThunderAPI.sharedInstance().getPublisher().enableInEarMonitor(enable)) {
            return 0;
        }
        return -1;
    }

    public int registerAudioFrameObserver(IAudioFrameObserver observer) {
        return ThunderAPI.sharedInstance().registerAudioFrameObserver(observer);
    }

    public int setRecordingAudioFrameParameters(int sampleRate, int room, int mode, int samplesPerCall) {
        return ThunderAPI.sharedInstance().setRecordingAudioFrameParameters(sampleRate, room, mode, samplesPerCall);
    }

    public int setPlaybackAudioFrameParameters(int sampleRate, int room, int mode, int samplesPerCall) {
        return ThunderAPI.sharedInstance().setPlaybackAudioFrameParameters(sampleRate, room, mode, samplesPerCall);
    }

    private void tryStopPublish() {
        if (this.mBAudioPublish) {
            ThunderAPI.sharedInstance().getPublisher().stopPublishAudio();
            this.mBAudioPublish = false;
            this.mStringName = "";
        }
    }

    private boolean isNumeric(String strNum) {
        String bigStr;
        Pattern pattern = Pattern.compile("^\\d+$");
        try {
            bigStr = new BigDecimal(strNum).toString();
        }
        catch (Exception e) {
            return false;
        }
        Matcher isNum = pattern.matcher(bigStr);
        return isNum.matches();
    }

    private void tryStopSubscribe() {
        if (this.mBGroupSubscribe) {
            ArrayList<ThunderGroup> audioGroup = new ArrayList<ThunderGroup>(0);
            ThunderGroup oneGroup = new ThunderGroup();
            oneGroup.appId = this.mRoomAppId;
            oneGroup.groupName = "g_" + this.mRoomName;
            audioGroup.add(oneGroup);
            ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(null, audioGroup);
            this.mBGroupSubscribe = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUid2String(int iUid, String strUid) {
        this.removeUid2String(strUid);
        ThunderEngine thunderEngine = this;
        synchronized (thunderEngine) {
            this.mUidToStringMap.put(iUid, strUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringUid(int iUid) {
        ThunderEngine thunderEngine = this;
        synchronized (thunderEngine) {
            return this.mUidToStringMap.get(iUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIntUid(String strUid) {
        int iUid = 0;
        ThunderEngine thunderEngine = this;
        synchronized (thunderEngine) {
            if (strUid != null && strUid.length() != 0) {
                for (Integer key : this.mUidToStringMap.keySet()) {
                    if (!strUid.equals(this.mUidToStringMap.get(key))) continue;
                    iUid = key;
                    break;
                }
            }
        }
        return iUid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUid2String(int iUid) {
        ThunderEngine thunderEngine = this;
        synchronized (thunderEngine) {
            this.mUidToStringMap.remove(iUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUid2String(String strUid) {
        ThunderEngine thunderEngine = this;
        synchronized (thunderEngine) {
            if (strUid != null && strUid.length() != 0) {
                for (Integer key : this.mUidToStringMap.keySet()) {
                    if (!strUid.equals(this.mUidToStringMap.get(key))) continue;
                    this.mUidToStringMap.remove(key);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllUid2String() {
        ThunderEngine thunderEngine = this;
        synchronized (thunderEngine) {
            this.mUidToStringMap.clear();
        }
    }

    private void resetRtcEngine() {
        mHandler = null;
        sMyAppId = 0;
        sMySceneId = 0L;
        mRtcEventHandler = null;
        mHttpsRequestHandler = null;
        this.mMyUid = 0L;
        this.mIs32bitUid = false;
        this.mMyStrUid = "";
        this.mUidToStringMap = new HashMap<Integer, String>();
        mLogLevel = 0;
        mLogPath = "";
        mYyLogCallback = null;
        this.mBGroupSubscribe = false;
        this.mBAudioPublish = false;
        this.mRoomAppId = 0;
        this.mRoomName = "";
        this.mRoomConfig = 0;
        this.mAudioConfig = 0;
        this.mCommutMode = 0;
        this.mScenarioMode = 0;
        s_playVolumeNotifyCount = 0;
        s_playDataNotifyCount = 0;
        this.mBEnablePlayDataIndication = false;
        this.mEqGains = new int[11];
        this.mBEnableEqualizer = false;
        this.mBEnableCompressor = false;
        this.mBEnableLimiter = false;
        this.mBEnableReverbEx = false;
        this.mReverbExGains = new ReverbExParameter();
        this.mCompressorGains = new CompressorParam();
        this.mLimiterGins = new LimterParam();
        for (ThunderAudioFilePlayer audioFilePlayer : this.mAudioFilePlayerSet) {
            audioFilePlayer.destroyAudioFilePlayer();
        }
        this.mAudioFilePlayerSet.clear();
    }

    private String getPrintString(String str) {
        String result = "";
        if (str != null) {
            result = str;
        }
        return result;
    }

    private String getPrintString(byte[] data) {
        String result = "";
        if (data != null) {
            result = data.toString();
        }
        return result;
    }

    private String getPrintString(Object obj) {
        String result = "";
        if (obj != null) {
            result = obj.toString();
        }
        return result;
    }

    static {
        sMyAppId = 0;
        sMySceneId = 0L;
        mLogPath = "";
        mLogLevel = 0;
        mYyLogCallback = null;
        s_playVolumeNotifyCount = 0;
        s_playDataNotifyCount = 0;
        mHandler = null;
    }

    private static class SingleonHolder {
        private static final ThunderEngine INSTANCE = new ThunderEngine();

        private SingleonHolder() {
        }
    }

    public static final class LimterParam {
        public float fCeiling = 0.0f;
        public float fThreshold = 0.0f;
        public float fPreGain = 0.0f;
        public float fRelease = 0.0f;
        public float fAttack = 0.0f;
        public float fLookahead = 0.0f;
        public float fLookaheadRatio = 0.0f;
        public float fRMS = 0.0f;
        public float fStLink = 0.0f;
    }

    public static final class CompressorParam {
        public int mThreshold = 0;
        public int mMakeupGain = 0;
        public int mRatio = 0;
        public int mKnee = 0;
        public int mReleaseTime = 0;
        public int mAttackTime = 0;
    }

    public static final class ReverbExParameter {
        public float mRoomSize = 0.0f;
        public float mPreDelay = 0.0f;
        public float mReverberance = 0.0f;
        public float mHfDamping = 0.0f;
        public float mToneLow = 0.0f;
        public float mToneHigh = 0.0f;
        public float mWetGain = 0.0f;
        public float mDryGain = 0.0f;
        public float mStereoWidth = 0.0f;
    }

    private static class NotificationHandler
    extends Handler {
        private final WeakReference<ThunderEngine> mRtcEngine;

        public NotificationHandler(ThunderEngine rtc) {
            this.mRtcEngine = new WeakReference<ThunderEngine>(rtc);
        }

        public NotificationHandler(ThunderEngine rtc, Looper loop) {
            super(loop);
            this.mRtcEngine = new WeakReference<ThunderEngine>(rtc);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    ThunderNotification.PublishStatusInfo info = (ThunderNotification.PublishStatusInfo)msg.obj;
                    ThunderLog.release(ThunderEngine.TAG, String.format("ThunderNotification.PublishStatusInfo stream=%s status=%d", info.getStreamName(), info.getStatus()));
                    break;
                }
                case 1: {
                    ThunderNotification.PublishRunTimeInfo info = (ThunderNotification.PublishRunTimeInfo)msg.obj;
                    break;
                }
                case 2: {
                    ThunderNotification.PlayStatusInfo info = (ThunderNotification.PlayStatusInfo)msg.obj;
                    ThunderLog.release(ThunderEngine.TAG, String.format("ThunderNotification.PlayStatusInfo stream=%s status=%d", info.getStream().streamName, info.getStatus()));
                    switch (info.getStatus()) {
                        case -1: {
                            break;
                        }
                        case 0: {
                            mJoinRoomTimestamp = System.currentTimeMillis();
                            if (mRtcEventHandler == null) break;
                            mRtcEventHandler.onJoinRoomSuccess(((ThunderEngine)this.mRtcEngine.get()).getRoomName(), ((ThunderEngine)this.mRtcEngine.get()).getMyUid(), 0);
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            if (mRtcEventHandler == null) break;
                            ThunderEventHandler.RoomStats status = new ThunderEventHandler.RoomStats();
                            mRtcEventHandler.onLeaveRoom(status);
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 4: {
                            break;
                        }
                    }
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    ThunderNotification.YYAudioCaptureVolume info = (ThunderNotification.YYAudioCaptureVolume)msg.obj;
                    if (mRtcEventHandler == null) break;
                    mRtcEventHandler.onCaptureVolumeIndication(info.mVolume, (int)info.mCpt, info.mMicVolume);
                    break;
                }
                case 5: {
                    ThunderNotification.AudioVolumeInfo info = (ThunderNotification.AudioVolumeInfo)msg.obj;
                    if (info.getVolumeInfos() == null) break;
                    int maxVol = 0;
                    int index = 0;
                    ArrayList<ThunderEventHandler.AudioVolumeInfo> volInfos = new ArrayList<ThunderEventHandler.AudioVolumeInfo>();
                    for (Map.Entry<Long, ThunderNotification.YYVolumeInfo> entry : info.getVolumeInfos().entrySet()) {
                        if (entry.getValue().mActualSpeakerUidList == null || entry.getValue().mActualSpeakerUidList.isEmpty()) continue;
                        for (long uid : entry.getValue().mActualSpeakerUidList) {
                            ThunderEventHandler.AudioVolumeInfo volInfo = new ThunderEventHandler.AudioVolumeInfo();
                            if (((ThunderEngine)this.mRtcEngine.get()).mIs32bitUid) {
                                volInfo.uid = Long.toString(uid);
                            } else {
                                volInfo.uid = ((ThunderEngine)this.mRtcEngine.get()).getStringUid((int)uid);
                                if (volInfo.uid == null || volInfo.uid.isEmpty()) continue;
                            }
                            volInfo.volume = entry.getValue().mVolume;
                            volInfo.pts = (int)entry.getValue().mPts;
                            if (maxVol < volInfo.volume) {
                                maxVol = volInfo.volume;
                            }
                            ++index;
                            volInfos.add(volInfo);
                            if (s_playVolumeNotifyCount % 200 != 0) continue;
                            ThunderLog.release(ThunderEngine.TAG, String.format("ThunderNotification.AudioPlayVolume, [%d] uid %s, volume %d", index, volInfo.uid.toString(), volInfo.volume));
                        }
                    }
                    int volSize = volInfos.size();
                    if (volSize <= 0) break;
                    ThunderEventHandler.AudioVolumeInfo[] volList = new ThunderEventHandler.AudioVolumeInfo[volSize];
                    for (int i = 0; i < volSize; ++i) {
                        volList[i] = (ThunderEventHandler.AudioVolumeInfo)volInfos.get(i);
                    }
                    if (mRtcEventHandler == null) break;
                    mRtcEventHandler.onPlayVolumeIndication(volList, maxVol);
                    ++s_playVolumeNotifyCount;
                    break;
                }
                case 6: {
                    ThunderNotification.BizAuthResult result = (ThunderNotification.BizAuthResult)msg.obj;
                    ThunderLog.release(ThunderEngine.TAG, String.format("ThunderNotification.BizAuthResult stream=%s group=%s result=%d", result.getAuthStream() != null ? result.getAuthStream().streamName : "null", result.getAuthGroup() != null ? result.getAuthGroup().groupName : "null", result.getBizAuthResult()));
                    if (mRtcEventHandler == null) break;
                    mRtcEventHandler.onBizAuthResult(result.isPublishAuth(), result.getBizAuthResult());
                    break;
                }
                case 7: {
                    ThunderNotification.SdkAuthResult result = (ThunderNotification.SdkAuthResult)msg.obj;
                    ThunderLog.release(ThunderEngine.TAG, String.format("ThunderNotification.SdkAuthResult appId=%d uid=%d result=%d", result.getAppId(), result.getUid(), result.getSdkAuthResult()));
                    if (mRtcEventHandler == null) break;
                    int authResult = result.getSdkAuthResult();
                    switch (authResult) {
                        case 0: {
                            if (!((ThunderEngine)this.mRtcEngine.get()).mIsUserBanned) break;
                            ((ThunderEngine)this.mRtcEngine.get()).mIsUserBanned = false;
                            mRtcEventHandler.onUserBanned(false);
                            break;
                        }
                        case 10005: {
                            mRtcEventHandler.onTokenRequest();
                            break;
                        }
                        case 10007: {
                            mRtcEventHandler.onTokenWillExpire(((ThunderEngine)this.mRtcEngine.get()).mToken);
                            break;
                        }
                        case 10008: {
                            ((ThunderEngine)this.mRtcEngine.get()).mIsUserBanned = true;
                            mRtcEventHandler.onUserBanned(true);
                        }
                    }
                    mRtcEventHandler.onSdkAuthResult(authResult);
                    break;
                }
                case 9: {
                    ThunderNotification.UidInt2String result = (ThunderNotification.UidInt2String)msg.obj;
                    ((ThunderEngine)this.mRtcEngine.get()).addUid2String(result.getUidInt(), result.getUidString());
                    ThunderLog.release(ThunderEngine.TAG, String.format("ThunderNotification.UidInt2String uid=%d str=%s", result.getUidInt(), result.getUidString()));
                    break;
                }
                case 14: {
                    ThunderNotification.AudioDataInfo result = (ThunderNotification.AudioDataInfo)msg.obj;
                    long uid = result.getUid();
                    String strUid = "";
                    if (((ThunderEngine)this.mRtcEngine.get()).mIs32bitUid) {
                        strUid = Long.toString(uid);
                    } else {
                        strUid = ((ThunderEngine)this.mRtcEngine.get()).getStringUid((int)uid);
                        if ((strUid == null || strUid.isEmpty()) && ((strUid = Long.toString(uid)) == null || strUid.isEmpty())) {
                            return;
                        }
                    }
                    int duration = result.getDuration();
                    int cpt = result.getCpt();
                    int pts = result.getPts();
                    byte[] data = result.getData();
                    int len = 0;
                    if (null != data) {
                        len = data.length;
                    }
                    if (s_playDataNotifyCount % 500 == 0) {
                        ThunderLog.release(ThunderEngine.TAG, String.format("ThunderNotification.AudioPlayData,cpt:%d,pts:%d, len:%d", cpt, pts, len));
                    }
                    ++s_playDataNotifyCount;
                    if (mRtcEventHandler == null) break;
                    mRtcEventHandler.onAudioPlayData(data, cpt, pts, strUid, duration);
                    break;
                }
                case 15: {
                    ThunderNotification.AudioPlaySpectrumData result = (ThunderNotification.AudioPlaySpectrumData)msg.obj;
                    if (mRtcEventHandler == null) break;
                    mRtcEventHandler.onAudioPlaySpectrumData(result.getData());
                    break;
                }
                case 16: {
                    ThunderNotification.AudioCapturePcmData result = (ThunderNotification.AudioCapturePcmData)msg.obj;
                    if (mRtcEventHandler == null) break;
                    mRtcEventHandler.onAudioCapturePcmData(result.getData(), result.getDataSize(), result.getSampleRate(), result.getChannel());
                    break;
                }
                case 19: {
                    ThunderNotification.AudioRenderPcmData result = (ThunderNotification.AudioRenderPcmData)msg.obj;
                    if (mRtcEventHandler == null) break;
                    mRtcEventHandler.onAudioRenderPcmData(result.getData(), result.getDataSize(), result.getDuration(), result.getSampleRate(), result.getChannel());
                    break;
                }
                case 17: {
                    ThunderNotification.UserAppMsgData result = (ThunderNotification.UserAppMsgData)msg.obj;
                    long uid = result.getUid();
                    String strUid = "";
                    strUid = Long.toString(uid);
                    if (mRtcEventHandler == null) break;
                    mRtcEventHandler.onRecvUserAppMsgData(result.getData(), strUid);
                    break;
                }
                case 18: {
                    ThunderNotification.AppMsgDataFailedStatus result = (ThunderNotification.AppMsgDataFailedStatus)msg.obj;
                    ThunderLog.info(ThunderEngine.TAG, String.format("ThunderNotification.AppMsgDataFailedStatus status=%d", result.getFailedStatus()));
                    if (mRtcEventHandler == null) break;
                    mRtcEventHandler.onSendAppMsgDataFailedStatus(result.getFailedStatus());
                    break;
                }
                case 23: {
                    ThunderNotification.InitiateHttpsRequest result = (ThunderNotification.InitiateHttpsRequest)msg.obj;
                    String reqUrl = result.getReqUrl();
                    int target = result.getTarget();
                    ThunderLog.info(ThunderEngine.TAG, String.format("ThunderNotification.InitiateHttpsRequest reqUrl=%s target=%d", reqUrl, target));
                    if (mHttpsRequestHandler == null) break;
                    mHttpsRequestHandler.send(reqUrl, target);
                    break;
                }
                case 24: {
                    ThunderNotification.UserMuteAudio result = (ThunderNotification.UserMuteAudio)msg.obj;
                    if (mRtcEventHandler == null) break;
                    mRtcEventHandler.onRemoteAudioStopped(Long.toString(result.getUid()), result.isMuted());
                    break;
                }
                case 25: {
                    ThunderNotification.UserJoined result = (ThunderNotification.UserJoined)msg.obj;
                    if (mRtcEventHandler == null) break;
                    int elapsed = (int)(System.currentTimeMillis() - mJoinRoomTimestamp);
                    mRtcEventHandler.onUserJoined(Long.toString(result.getUid()), elapsed);
                    break;
                }
                case 26: {
                    ThunderNotification.UserOffline result = (ThunderNotification.UserOffline)msg.obj;
                    if (mRtcEventHandler == null) break;
                    mRtcEventHandler.onUserOffline(Long.toString(result.getUid()), result.getReason());
                    break;
                }
                case 27: {
                    ThunderNotification.NetworkQuality result = (ThunderNotification.NetworkQuality)msg.obj;
                    if (mRtcEventHandler == null) break;
                    mRtcEventHandler.onNetworkQuality(Long.toString(result.getUid()), result.getTxQuality(), result.getRxQuality());
                    break;
                }
            }
        }
    }
}

