/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import com.yy.mediaframework.VideoLibAPI;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.yylivesdk4cloud.IThunderLogCallback;
import com.yy.yylivesdk4cloud.ThunderDeviceInfo;
import com.yy.yylivesdk4cloud.ThunderPlayer;
import com.yy.yylivesdk4cloud.ThunderPublishRoom;
import com.yy.yylivesdk4cloud.ThunderPublishRoomImp;
import com.yy.yylivesdk4cloud.ThunderPublisher;
import com.yy.yylivesdk4cloud.audio.IAudioFrameObserver;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;
import com.yy.yylivesdk4cloud.system.ThunderForeBackgroundListener;
import com.yy.yylivesdk4cloud.system.ThunderNetStateService;
import com.yy.yylivesdk4cloud.video.serviceConfig.ArgoServiceImp;
import java.util.HashMap;
import java.util.HashSet;

public class ThunderAPI {
    private ThunderPlayer mPlayer = null;
    private ThunderPublisher mPublisher = null;
    private ThunderPublishRoom mPubChannel = null;
    private ThunderNetStateService mNetStateService = null;
    private ThunderForeBackgroundListener mForeBackgroundListener = null;
    private String mVersion = null;
    private int mVersionInt = 0;
    private ThunderNative.NotificationDispatcher mNotificationDispatcher = null;
    private ArgoServiceImp mArgoService = null;
    private boolean mIsInited = false;
    private boolean m32BitUid = true;

    private ThunderAPI() {
        try {
            System.loadLibrary("yyvideoplayer");
        }
        catch (Throwable e) {
            e.printStackTrace();
            ThunderLog.error("ycall-Java", "load yyvideoplayer failed!");
        }
        try {
            System.loadLibrary("yylivesdk4cloud");
        }
        catch (Throwable e) {
            e.printStackTrace();
            ThunderLog.error("ycall-Java", "load yylivesdk4cloud failed!");
            return;
        }
        this.mPlayer = new ThunderPlayer();
        this.mPublisher = new ThunderPublisher();
        this.mPubChannel = new ThunderPublishRoomImp();
    }

    public static ThunderAPI sharedInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static void enableLog(boolean enable, int level, String logPath, IThunderLogCallback callback) {
        ThunderAPI.sharedInstance();
        ThunderNative.enableLog(enable, callback, level, logPath);
        ThunderLog.release("ycall-Java", "enableLog enable:%b level:%d, path:%s", enable, level, logPath);
    }

    public void fetchedLogConfig() {
        ThunderNative.fetchedLogConfig();
    }

    public String getVersion() {
        return this.mVersion;
    }

    public int getVersionInt() {
        return this.mVersionInt;
    }

    public boolean initWithAppId(long appId, long sceneId, Context appContext) {
        if (this.mIsInited) {
            return false;
        }
        ThunderLog.release("ycall-Java", "init appId:%d sceneId:%d appContext:%s", appId, sceneId, appContext.toString());
        if (this.mNetStateService != null) {
            this.mNetStateService.fini();
        }
        if (this.mForeBackgroundListener != null) {
            this.mForeBackgroundListener.fini();
        }
        this.mNotificationDispatcher = new ThunderNative.NotificationDispatcher(){
            private final HashSet<Handler> mNotificationHandlers = new HashSet();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerNotificationHandler(Handler handler) {
                HashSet<Handler> hashSet = this.mNotificationHandlers;
                synchronized (hashSet) {
                    this.mNotificationHandlers.add(handler);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterNotificationHandler(Handler handler) {
                HashSet<Handler> hashSet = this.mNotificationHandlers;
                synchronized (hashSet) {
                    this.mNotificationHandlers.remove(handler);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object[] collectNotificationHandlers() {
                Object[] handlers = null;
                HashSet<Handler> hashSet = this.mNotificationHandlers;
                synchronized (hashSet) {
                    if (this.mNotificationHandlers.size() > 0) {
                        handlers = this.mNotificationHandlers.toArray();
                    }
                }
                return handlers;
            }
        };
        ThunderDeviceInfo info = new ThunderDeviceInfo(appContext);
        int ret = ThunderNative.init(appId, sceneId, appContext, info, this.mNotificationDispatcher);
        if (ret < 0) {
            ThunderLog.error("ycall-Java", "init failed!");
            return false;
        }
        this.mNetStateService = new ThunderNetStateService(appContext);
        this.mForeBackgroundListener = new ThunderForeBackgroundListener(appContext);
        this.mNetStateService.init();
        this.mForeBackgroundListener.init();
        VideoLibAPI.instance().initVideoLib(appId, sceneId, appContext);
        YYVideoLibMgr.instance().init(appContext, "1.0", "YYLiveDemo", Build.VERSION.RELEASE, Build.MODEL, null);
        this.mVersion = ThunderNative.getVersion();
        this.mVersionInt = ThunderNative.getVersionInt();
        this.mArgoService = new ArgoServiceImp(appContext, info, appId, sceneId);
        this.mIsInited = true;
        ThunderLog.release("ycall-Java", "init succeeded, version %s", this.mVersion, " versionInt %u", this.mVersionInt);
        return true;
    }

    public void deInit() {
        if (!this.mIsInited) {
            return;
        }
        if (this.mNetStateService != null) {
            this.mNetStateService.fini();
        }
        if (this.mForeBackgroundListener != null) {
            this.mForeBackgroundListener.fini();
        }
        if (this.mArgoService != null) {
            this.mArgoService.fini();
        }
        ThunderNative.fini();
        this.mNetStateService = null;
        this.mForeBackgroundListener = null;
        this.mArgoService = null;
        this.mVersion = null;
        this.mVersionInt = 0;
        this.mIsInited = false;
        ThunderLog.release("ycall-Java", "[call] ThunderAPI.deInit success");
    }

    public void registerNotificationHandler(Handler handler) {
        ThunderLog.release("ycall-Java", "registerNotificationHandler %s", handler.toString());
        this.mNotificationDispatcher.registerNotificationHandler(handler);
    }

    public void unregisterNotificationHandler(Handler handler) {
        ThunderLog.release("ycall-Java", "unregisterNotificationHandler %s", handler.toString());
        this.mNotificationDispatcher.unregisterNotificationHandler(handler);
    }

    public void setAreaType(int areaType) {
        ThunderLog.release("ycall-Java", "setAreaType %d", areaType);
        ThunderNative.setAreaType(areaType);
    }

    public void enableVad(boolean enable) {
        ThunderLog.release("ycall-Java", "enableVad %b", enable);
        ThunderNative.enableVad(enable);
    }

    public void setSceneId(long sceneId) {
        if (this.mArgoService != null) {
            this.mArgoService.setProfileParam("scene_id", String.valueOf(sceneId));
            this.mArgoService.queryConfigs();
        }
        ThunderLog.release("ycall-Java", "setSceneId %d", sceneId);
        ThunderNative.setSceneId(sceneId);
    }

    public void updateToken(byte[] token) {
        if (token == null) {
            return;
        }
        ThunderLog.release("ycall-Java", "updateToken sToken %d", token.length);
        ThunderNative.updateToken(token, null);
    }

    public void joinMedia(long uid) {
        ThunderLog.release("ycall-Java", "joinMedia %d", uid);
        this.fetchConfigsWith(Long.toString(uid));
        ThunderNative.joinMedia(uid, 0L, 0L);
    }

    public void joinMedia(long uid, long sid, long subSid) {
        ThunderLog.release("ycall-Java", "joinMedia %d %d %d", uid, sid, subSid);
        this.fetchConfigsWith(Long.toString(uid));
        ThunderNative.joinMedia(uid, sid, subSid);
    }

    public void joinMedia(String uid, long sid, long subSid) {
        String _uid = uid != null ? uid : new String();
        ThunderLog.release("ycall-Java", "joinMedia %s %d %d", _uid, sid, subSid);
        this.fetchConfigsWith(_uid);
        ThunderNative.joinMedia(_uid, sid, subSid);
    }

    private void fetchConfigsWith(String uid) {
        if (this.mArgoService != null) {
            ThunderLog.release("ycall-Java", "fetchConfigsWith %s", uid);
            this.mArgoService.setProfileParam("uid", uid);
            this.mArgoService.queryConfigs();
        }
    }

    public void leaveMedia() {
        ThunderLog.release("ycall-Java", "leaveMedia");
        ThunderNative.leaveMedia();
    }

    public boolean joinChannel(String channelId, String uid, int userRole) {
        if (channelId == null || uid == null) {
            ThunderLog.info("ycall-Java", "joinRoom param error");
            return false;
        }
        if (this.mArgoService != null) {
            this.mArgoService.setProfileParam("uid", uid);
            this.mArgoService.setProfileParam("channel_id", channelId);
            this.mArgoService.queryConfigs();
        }
        ThunderLog.info("ycall-Java", "joinRoom %s %s %d", channelId, uid, userRole);
        ThunderNative.joinChannel(channelId, uid, this.m32BitUid, userRole);
        return true;
    }

    public void leaveChannel() {
        ThunderLog.info("ycall-Java", "leaveRoom");
        ThunderNative.leaveChannel();
    }

    private void set32BitUid(boolean is32Bit) {
        ThunderLog.release("ycall-Java", "set32BitUid %b", is32Bit);
        this.m32BitUid = is32Bit;
    }

    public void setUserRole(int role) {
        ThunderLog.release("ycall-Java", "setUserRole %d", role);
        ThunderNative.setUserRole(role);
    }

    public void enableLowLatency(boolean enable) {
        ThunderLog.release("ycall-Java", "enableLowLatency %b", enable);
        ThunderNative.enableLowLatency(enable);
    }

    public void setRoomConfig(int profile) {
        ThunderLog.release("ycall-Java", "setRoomConfig %d", profile);
        ThunderNative.setChannelProfile(profile);
    }

    public void setPlayVolumeInterval(int interval, int moreThanThd, int lessThanThd) {
        ThunderNative.setPlayVolumeInterval(interval, moreThanThd, lessThanThd);
    }

    public void setCaptureVolumeInterval(int interval, int moreThanThd, int lessThanThd) {
        ThunderNative.setCaptureVolumeInterval(interval, moreThanThd, lessThanThd);
    }

    public boolean startAudioSaver(String fileName, int saverMode, int fileMode) {
        return ThunderNative.startAudioSaver(fileName, saverMode, fileMode);
    }

    public boolean stopAudioSaver() {
        return ThunderNative.stopAudioSaver();
    }

    public ThunderPublisher getPublisher() {
        return this.mPublisher;
    }

    public ThunderPublishRoom getPublishChannel() {
        return this.mPubChannel;
    }

    public ThunderPlayer getPlayer() {
        return this.mPlayer;
    }

    public void setExternalAudioProcessor(long eap) {
        ThunderLog.release("ycall-Java", "setExternalAudioProcessor %d", eap);
        ThunderNative.setExternalAudioProcessor(eap);
    }

    public void enableAudioPlaySpectrum(boolean enable) {
        ThunderNative.enableAudioPlaySepctrum(enable);
    }

    public void setAudioPlaySpectrumInfo(int spectrumLen, int notifyIntervalMS) {
        ThunderNative.setAudioPlaySepctrumInfo(spectrumLen, notifyIntervalMS);
    }

    public void enableAudioDataIndication(boolean enable) {
        ThunderNative.enableAudioDataIndication(enable);
    }

    public void enableCapturePcmDataCallBack(boolean enable, int sampleRate, int channel) {
        ThunderNative.enableCapturePcmDataCallBack(enable, sampleRate, channel);
    }

    public boolean enableRenderPcmDataCallBack(boolean enable, int sampleRate, int channel) {
        if (!(sampleRate != -1 && sampleRate != 8000 && sampleRate != 16000 && sampleRate != 441000 && sampleRate != 480000 || channel != -1 && channel != 1 && channel != 2)) {
            ThunderNative.enableRenderPcmDataCallBack(enable, sampleRate, channel);
            return true;
        }
        return false;
    }

    public void sendUserAppMsgData(byte[] msgData) {
        if (msgData == null) {
            return;
        }
        ThunderNative.sendUserAppMsgData(msgData);
    }

    public void setArgoConfig(HashMap<Integer, Integer> cfg) {
        if (this.mIsInited) {
            ThunderNative.setArgoConfig(cfg);
        }
    }

    public void setHttpsBinaryResponse(String reqUrl, byte[] response, int statusCode, int errCode, int target) {
        ThunderNative.setHttpsBinaryResponse(reqUrl, response, statusCode, errCode, target);
    }

    public void setHttpsTextResponse(String reqUrl, String response, int statusCode, int errCode, int target) {
        ThunderNative.setHttpsTextResponse(reqUrl, response, statusCode, errCode, target);
    }

    public int registerAudioFrameObserver(IAudioFrameObserver observer) {
        ThunderNative.registerAudioFrameObserver(observer);
        return 0;
    }

    public int setRecordingAudioFrameParameters(int sampleRate, int channel, int mode, int samplesPerCall) {
        ThunderNative.setRecordingAudioFrameParameters(sampleRate, channel, mode, samplesPerCall);
        return 0;
    }

    public int setPlaybackAudioFrameParameters(int sampleRate, int channel, int mode, int samplesPerCall) {
        ThunderNative.setPlaybackAudioFrameParameters(sampleRate, channel, mode, samplesPerCall);
        return 0;
    }

    private static class SingletonHolder {
        private static final ThunderAPI INSTANCE = new ThunderAPI();

        private SingletonHolder() {
        }
    }
}

