package com.yy.yylivesdk4cloud.video.serviceConfig;

import com.yy.yylivesdk4cloud.ThunderConstant;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;


/**
 * Created by Administrator on 2018/8/15.
 */

public class VideoPlayerImp implements IVideoPlayerInterface {
    private final static String TAG = "cfg_VideoPlayerImp";

    private boolean mH265Support = false;
    @Override
    public void performVideoConfig(VideoLiveConfig[] configs) {
        if(configs == null || configs.length == 0){
            ThunderLog.warn(TAG, "VideoConfig is null!");
            return;
        }
        if(configs[0].playType == VideoLiveConfig.Type.PLAYER_H264){
            if(configs[0].decodeType == VideoLiveConfig.DecodeType.CODEC_DECODEC_H264_HW){
                ThunderLog.info(TAG, "player enable hardware h264");
                ThunderNative.enableHardwareDecoder(true, ThunderConstant.ThunderVideoEncodeType.THUNDER_ENCODE_TYPE_H264);
            }else {
                ThunderLog.info(TAG, "player disable hardware h264");
                ThunderNative.enableHardwareDecoder(false, ThunderConstant.ThunderVideoEncodeType.THUNDER_ENCODE_TYPE_H264);
            }
        }


        if(configs[0].playType == VideoLiveConfig.Type.PLAYER_H265){
            if(configs[0].decodeType == VideoLiveConfig.DecodeType.CODEC_DECODEC_H265_HW){
                ThunderLog.info(TAG, "player enable hardware h265");
                ThunderNative.enableHardwareDecoder(true, ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H265);
                mH265Support = true;
            }else if(configs[0].decodeType == VideoLiveConfig.DecodeType.CODEC_DECODEC_H265_SOFT){
                ThunderLog.info(TAG, "player enable soft h265");
                ThunderNative.enableHardwareDecoder(false, ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H265);
                mH265Support = true;
            }else {
                //不支持H265
                ThunderLog.info(TAG, "player no support 265 dec  ");
            }
        }
    }

    @Override
    public boolean H265PlaySupport() {
        return mH265Support;
    }
}
