package com.yy.yylivesdk4cloud.video.serviceConfig;

import com.yy.mediaframework.CameraPreviewConfig;
import com.yy.mediaframework.YYVideoCodec;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.yylivesdk4cloud.helper.ThunderLog;

import java.util.HashMap;
import java.util.List;


/**
 * Created by Administrator on 2018/8/13.
 */

public class VideoConfigManager implements IVideoConfigCallbackInterface{
    private final static String TAG = "cfg_VideoConfigManage";

    private final static String ARGO_CONFIG_KEY_SINGLE = "Android_single";
    private final static String ARGO_CONFIG_KEY_PLAYER_H265 = "h265Support";
    private final static String ARGO_CONFIG_KEY_PLAYER_H264 = "h264Support";
    //    private final static String ARGO_CONFIG_KEY_LIANMAI_1ST = "Android_lianmai_1st";
//    private final static String ARGO_CONFIG_KEY_LIANMAI_2ST = "Android_lianmai_2st";
    private final static String ARGO_CONFIG_KEY_LIANMAI = "Android_lianmai";
    private final static String ARGO_CONFIG_KEY_LIANMAI_ACROSS = "Android_across";
    private final static String ARGO_CONFIG_KEY_BEAUTIFYLEVEL = "Android_beautifyLevel";
    private final static String ARGO_CONFIG_KEY_BLACKCODEC = "Android_blackCodec";
    private final static String ARGO_CONFIG_KEY_HAMO_SCREENRECORD = "Android_ScreenRecord";
    private final static String ARGO_CONFIG_KEY_HAMO_PLAYTRANSCODING_MAP = "PlayTranscodingMap";

    public final static String[] ARGO_CONFIG_KEYS = {
            ARGO_CONFIG_KEY_SINGLE,
            ARGO_CONFIG_KEY_PLAYER_H265,
            ARGO_CONFIG_KEY_PLAYER_H264,
            ARGO_CONFIG_KEY_LIANMAI,
//            ARGO_CONFIG_KEY_LIANMAI_1ST,
//            ARGO_CONFIG_KEY_LIANMAI_2ST ,
            ARGO_CONFIG_KEY_LIANMAI_ACROSS,
            ARGO_CONFIG_KEY_BEAUTIFYLEVEL,
            ARGO_CONFIG_KEY_BLACKCODEC,
            ARGO_CONFIG_KEY_HAMO_SCREENRECORD,
            ARGO_CONFIG_KEY_HAMO_PLAYTRANSCODING_MAP};

    private IJsonParseInterface mJsonParseImp;
    private IVideoPlayerInterface mVideoPlayerImp;
    //当前的mode
    private VideoLiveConfig mCurrentConfig = null;

    private int mBeautifyLevel = 0;
    private boolean mDisableHardEncode = false;
    private boolean mDisableHardDecode = false;

    //配置中心拉取配置中包含的mode
    private HashMap<Integer, HashMap<Integer, String>> mModeList = new HashMap<>();
    private HashMap<Integer, VideoLiveConfig[]> mVideoConfigsList =  new HashMap<>();

    private HashMap<Integer, Integer> mDecodeVideoTranscodingMap = null;

    private static class SingletonHolder {
        private static final VideoConfigManager INSTANCE = new VideoConfigManager();
    }


    public static VideoConfigManager instance() {
        return SingletonHolder.INSTANCE;
    }

    private VideoConfigManager() {
        mJsonParseImp = new JsonParseImp(this);
        mVideoPlayerImp = new VideoPlayerImp();
    }


    private VideoLiveConfig[] getVideoLiveConfigByPlayType(int playType){
        VideoLiveConfig[] tmpConfigs = mVideoConfigsList.get(playType);
        return tmpConfigs;
    }

    /**
     *  从配置中心的解析列表获取预览配置
     *  当playType和mode完全匹配时，采用匹配项的值
     *  当mode不匹配时，会默认用配置中心中标明isDefault = 1的匹配项的值
     *  当mode不匹配且isDefault没指定，则用默认的参数544*960 1200 硬编
     * @param playType  玩法
     * @param mode  开播模式
     * @return 编码配置参数
     */
    public CameraPreviewConfig getCameraPreviewConfigByType(int playType , int mode){

        VideoLiveConfig[] tmpConfigs = getVideoLiveConfigByPlayType(playType);
        CameraPreviewConfig result = analyzeCameraPreviewConfig(tmpConfigs, mode);

        ThunderLog.info(TAG, "getCameraPreviewConfigByType playtype:" + playType +" mode:" + mode +"->" + result.toString());
        return result;
    }

    private CameraPreviewConfig analyzeCameraPreviewConfig(VideoLiveConfig[] configs, int mode){
        CameraPreviewConfig result = new CameraPreviewConfig();
        if(configs == null || configs.length == 0){
            ThunderLog.error(TAG, " analyzeCameraPreviewConfig failed because no VideoConfig, return default!");
            return  result;
        }

        for(int i = 0; i < configs.length; i++){
            if(mode == -1 && configs[i].isDefault == 1){
                result.mCaptureFrameRate = configs[i].cameraFrameRate==0 ? result.mCaptureFrameRate:configs[i].cameraFrameRate;
                result.mCaptureResolutionWidth = configs[i].cameraWidth==0 ? result.mCaptureResolutionWidth:configs[i].cameraWidth;
                result.mCaptureResolutionHeight = configs[i].cameraHeight==0 ? result.mCaptureResolutionHeight:configs[i].cameraHeight;
                mCurrentConfig = configs[i];
                break;
            }else if(configs[i].videoLevel == mode){
                result.mCaptureFrameRate = configs[i].cameraFrameRate==0 ? result.mCaptureFrameRate:configs[i].cameraFrameRate;
                result.mCaptureResolutionWidth = configs[i].cameraWidth==0 ? result.mCaptureResolutionWidth:configs[i].cameraWidth;
                result.mCaptureResolutionHeight = configs[i].cameraHeight==0 ? result.mCaptureResolutionHeight:configs[i].cameraHeight;
                mCurrentConfig = configs[i];
                break;
            }
        }

        return result;
    }

    /**
     *  从配置中心的解析列表获取编码配置
     *  当playType和mode完全匹配时，采用匹配项的值
     *  当mode不匹配时，会默认用配置中心中标明isDefault = 1的匹配项的值
     *  当mode不匹配且isDefault没指定，则用默认的参数544*960 1200 硬编
     * @param playType  玩法
     * @param mode  开播模式
     * @return 编码配置参数
     */
    public VideoEncoderConfig getVideoEncodeConfigByType(int playType , int mode){
        VideoLiveConfig[] tmpConfigs = getVideoLiveConfigByPlayType(playType);

        VideoEncoderConfig result = analyzeVideoEncoderConfig(tmpConfigs, mode);
        if(mDisableHardEncode){
            if(result.mEncodeType == VideoEncoderType.HARD_ENCODER_H264){
                result.mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
            }else if(result.mEncodeType == VideoEncoderType.HARD_ENCODER_H265 ){
                result.mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
            }
        }
        ThunderLog.info(TAG, "getVideoEncodeConfigByType :" + playType +" mode:" + mode +"->"  + result.toString());
        return result;
    }

    @Override
    public void notifyJsonPlayModeMap(HashMap<Integer, Integer> map) {
        mDecodeVideoTranscodingMap = map;
        ThunderLog.info(TAG, "notifyJsonPlayModeMap :" + mDecodeVideoTranscodingMap.toString());
    }

    public int getVideoDecodeTranscoding(int transcoding){
        if(mDecodeVideoTranscodingMap == null){
            ThunderLog.info(TAG, "getVideoDecodeTranscoding mDecodeVideoTranscodingMap:null" );
            return transcoding;
        }

        int result =  mDecodeVideoTranscodingMap.get(transcoding) == null ? transcoding : mDecodeVideoTranscodingMap.get(transcoding);
        ThunderLog.info(TAG, "getVideoDecodeTranscoding  " + transcoding + ":" + result);

        return result;
    }

    public int getVideoEncodeTranscoding(int playType , int mode){
        VideoLiveConfig[] tmpConfigs = getVideoLiveConfigByPlayType(playType);

        int result = analyzeTranscoding(tmpConfigs, mode);
        ThunderLog.info(TAG, "getVideoEncodeTranscoding :" + playType +" mode:" + mode +"->"  + result);
        return result;
    }


    private int analyzeTranscoding(VideoLiveConfig[] configs, int mode){
        int result = mode;
        if(configs == null || configs.length == 0){
            ThunderLog.warn(TAG, " analyzeTranscoding configs == null ");
            return result;
        }
        for(int i = 0; i < configs.length; i ++){
            if(mode == -1 && configs[i].isDefault == 1){
                //当未指定mode时才有配置中心的default来指定默认开播参数
                result = configs[i].transcoding;
                break;
            }else if(configs[i].videoLevel == mode){
                result = configs[i].transcoding;
                break;
            }
        }
        return result;
    }


    private VideoEncoderConfig analyzeVideoEncoderConfig(VideoLiveConfig[] configs, int mode){
        VideoEncoderConfig result = new VideoEncoderConfig();
        if(configs == null || configs.length == 0){
            ThunderLog.warn(TAG, " analyzeVideoEncoderConfig configs == null ");
            return result;
        }
        for(int i = 0; i < configs.length; i ++){
            if(mode == -1 && configs[i].isDefault == 1){
                //当未指定mode时才有配置中心的default来指定默认开播参数
                result.mEncodeWidth = configs[i].videoWidth==0 ? result.mEncodeWidth : configs[i].videoWidth;
                result.mEncodeHeight = configs[i].videoHeight==0 ? result.mEncodeHeight : configs[i].videoHeight;
                result.mBitRate = configs[i].curRate==0 ? result.mBitRate : configs[i].curRate;
                result.mEncodeType = configs[i].encodeId;
                result.mEncodeParameter = configs[i].encodeParam;
                result.mFrameRate = configs[i].frameRate== 0 ? result.mFrameRate : configs[i].frameRate;
                mCurrentConfig = configs[i];
                break;
            }else if(configs[i].videoLevel == mode){
                //服务器配置中心没设置默认值时，采用mode匹配
                result.mEncodeWidth = configs[i].videoWidth==0 ? result.mEncodeWidth : configs[i].videoWidth;
                result.mEncodeHeight = configs[i].videoHeight==0 ? result.mEncodeHeight : configs[i].videoHeight;
                result.mBitRate = configs[i].curRate==0 ? result.mBitRate : configs[i].curRate;
                result.mEncodeType = configs[i].encodeId;
                result.mEncodeParameter = configs[i].encodeParam;
                result.mFrameRate = configs[i].frameRate== 0 ? result.mFrameRate : configs[i].frameRate;
                mCurrentConfig = configs[i];
                break;
            }
        }
        return result;
    }

    private void parseArgoResponsePlayTranscoding(int type, String response ){
        switch (type){
            case VideoLiveConfig.Type.PLAYTRANSCODING:
                mJsonParseImp.parseVideoPlayTranscodingMap(response);
                break;
            default:
                break;
        }
    }

    private void parseArgoResponse(int type, String response){
        switch (type){
            case VideoLiveConfig.Type.SINGLE:
                mJsonParseImp.parseVideoEncodeConfigSingle(response);
                break;
            case VideoLiveConfig.Type.LIANMAI:
                mJsonParseImp.parseVideoEncodeConfigLianMai(response);
                break;
//            case VideoLiveConfig.Type.LIANMAI_2st:
//                mJsonParseImp.parseVideoEncodeConfigLianMai2st(response);
//                break;
            case VideoLiveConfig.Type.ACROSS:
                mJsonParseImp.parseVideoEncodeConfigAcross(response);
                break;
            case VideoLiveConfig.Type.SCREEN_CAPTURE:
                mJsonParseImp.parseVideoEncodeConfigScreenCapture(response);
                break;
            case VideoLiveConfig.Type.ARENA_CROSS:
            case VideoLiveConfig.Type.MULIT_LIVE:
            case VideoLiveConfig.Type.MULIT_LIVE_LIANMAI:
                break;
            case VideoLiveConfig.Type.ONE_TO_ONE:
                mJsonParseImp.parseVideoEncodeConfigSingle(response);
                break;
            case VideoLiveConfig.Type.PLAYER_H264:
                mJsonParseImp.parseVideoH264DecodeConfig(response);
                break;
            case VideoLiveConfig.Type.PLAYER_H265:
                mJsonParseImp.parseVideoH265DecodeConfig(response);
                break;
            case VideoLiveConfig.Type.BEAUTIFYLEVEL:
                mJsonParseImp.parseVideoBeautifyLevelConfig(response);
                break;
            case VideoLiveConfig.Type.BLACKENCODEC:
                mJsonParseImp.parseVideoBlackEncodeConfig(response);
                break;
            default:
                break;
        }

    }

    @Override
    public void notifyJsonConfigResult(VideoLiveConfig[] configs) {

        if(configs == null || configs.length == 0){
            ThunderLog.error(TAG, "JsonParse error!");
            return;
        }
        HashMap<Integer, String> modeElement = new HashMap<>();
        for (int i = 0; i < configs.length; i++) {
            if(configs[i].videoLevel != 0) {
                modeElement.put(configs[i].videoLevel, configs[i].description);
            }
            ThunderLog.info(TAG, " notifyJsonConfigResult playType:"+ configs[i].playType + ":" + configs[i].toString());
        }
        if(configs[0].playType == VideoLiveConfig.Type.PLAYER_H264 ||
                configs[0].playType == VideoLiveConfig.Type.PLAYER_H265){
            mVideoPlayerImp.performVideoConfig(configs);
        }

        if(configs[0].playType == VideoLiveConfig.Type.BLACKENCODEC ){
            if(configs[0].blockEncode != null && configs[0].blockEncode.length != 0){
                for(int i = 0; i < configs[0].blockEncode.length ;i++){
                    if(configs[0].blockEncode[i].equalsIgnoreCase(YYVideoCodec.getH264EncodeName())){
                        mDisableHardEncode = true;
                    }else if(configs[0].blockEncode[i].equalsIgnoreCase(YYVideoCodec.getH265EncodeName())){
                        mDisableHardEncode = true;
                    }
                }
            }
            ThunderLog.info(TAG, " notifyJsonConfigResult playType:"+ configs[0].playType + ": mDisableHardEncode" + mDisableHardEncode);
        }

        if(configs[0].playType == VideoLiveConfig.Type.BEAUTIFYLEVEL){
            mBeautifyLevel = configs[0].beautifyLevel;
        }
        mVideoConfigsList.put(configs[0].playType, configs);
        mModeList.put(configs[0].playType, modeElement);
    }

    public List<ResolutionModifyConfig> getCurrentModifyConfig(){
        if(mCurrentConfig == null || mCurrentConfig.modifyConfigs == null){
            return null;
        }
        return mCurrentConfig.modifyConfigs;
    }

    public VideoLiveConfig getCurrentVideoLiveConfig(){
        return mCurrentConfig;
    }
    public int getCurrentIntervalSecs(){
        if(mCurrentConfig == null){
            return 10;
        }
        return mCurrentConfig.intervalSecs;
    }

    public boolean checkLowDelayByType(int playType){
        if(playType == VideoLiveConfig.Type.LIANMAI || //playType == VideoLiveConfig.Type.LIANMAI_2st ||
                playType == VideoLiveConfig.Type.ACROSS){
            return true;
        }
        return false;
    }

    public void resetCurrentVideoLiveConfig(){
        mCurrentConfig = null;
    }

    public int getCurrentBeautifyLevel(){
        return  mBeautifyLevel;
    }

    public boolean H265PlaySupport(){
        if(mVideoPlayerImp == null){
            return  false;
        }
        return mVideoPlayerImp.H265PlaySupport();
    }

    public void disableHardDecode(Boolean disable){
        mDisableHardDecode = disable;
        ThunderLog.info(TAG, "disableHardDecode " + mDisableHardEncode);
    }
    public void disableHardEncode(Boolean disable){
        mDisableHardEncode = disable;
        ThunderLog.info(TAG, "disableHardEncode " + mDisableHardEncode);
    }

    public int getDefaultPublishVideoMode(int playType){
        int mode = -1;
        VideoLiveConfig[] tmpConfigs = getVideoLiveConfigByPlayType(playType);
        if(tmpConfigs == null || tmpConfigs.length == 0){
            ThunderLog.warn(TAG, " getDefaultPublishVideoMode configs == null ");
            return -1;
        }
        for(int i = 0; i < tmpConfigs.length; i ++) {
            if(tmpConfigs[i].isDefault == 1){
                mode = tmpConfigs[i].videoLevel;
                break;
            }
        }
        ThunderLog.info(TAG, " getDefaultPublishVideoMode mode " + mode);
        return mode;
    }

    public int getPlayViewTypeFromStream(int streamType){

        int decodeType =  VideoConstant.DecoderType.SOFT_DEOCDER;
        if(mDisableHardDecode){
            ThunderLog.info(TAG, " getPlayViewTypeFromStream soft decoder ");
            return decodeType;
        }
        if(streamType == VideoLiveConfig.StreamType.STREAM_TYPE_H265){
            //判断当前机器是支持软解还是硬解
            VideoLiveConfig[] configs = mVideoConfigsList.get(VideoLiveConfig.Type.PLAYER_H265);
            if(configs != null && configs.length != 0){
                ThunderLog.info(TAG, " getPlayViewTypeFromStream PLAYER_H265  "+ configs[0].toString());
                if(configs[0].decodeType == VideoLiveConfig.DecodeType.CODEC_DECODEC_H265_HW){
                    decodeType = VideoConstant.DecoderType.ANDROID_HARD_DECODER1;
                }else {
                    ThunderLog.info(TAG, " getPlayViewTypeFromStream configs[0].decodeType  "+ configs[0].decodeType + " playtype:" + configs[0].playType );
                }
            }else {
                ThunderLog.info(TAG, " getPlayViewTypeFromStream  no config "+ streamType );
            }
        }else if(streamType == VideoLiveConfig.StreamType.STREAM_TYPE_H264){
            VideoLiveConfig[] configs = mVideoConfigsList.get(VideoLiveConfig.Type.PLAYER_H264);
            if(configs != null && configs.length != 0){
                ThunderLog.info(TAG, " getPlayViewTypeFromStream PLAYER_H264  "+ configs[0].toString());
                if(configs[0].decodeType == VideoLiveConfig.DecodeType.CODEC_DECODEC_H264_HW){
                    decodeType = VideoConstant.DecoderType.ANDROID_HARD_DECODER1;
                }else {
                    ThunderLog.info(TAG, " getPlayViewTypeFromStream configs[0].decodeType  "+ configs[0].decodeType + " playtype:" + configs[0].playType );
                }
            }else {
                ThunderLog.info(TAG, " getPlayViewTypeFromStream  no config "+ streamType );
            }
        }
        ThunderLog.info(TAG, " getPlayViewTypeFromStream decodeType :"+ decodeType + " streamType " + streamType );
        return  decodeType;
    }

    public HashMap<Integer, String> getModeListByPlayType(int playType){
        HashMap<Integer, String>  modeList = mModeList.get(playType);
        if(modeList == null){
            ThunderLog.error(TAG, "HashMap<Integer, String>  modeList error");
        }else {
            String modeString = "";
            for( int key : modeList.keySet()){
                modeString += key + ":" + modeList.get(key);
            }
            ThunderLog.info(TAG, "getModeListByPlayType " + playType +" :" + modeString);
        }
        return modeList;
    }

    public void onConfig(String key, String config) {
        if (key == null || config == null) {
            return;
        }
        ThunderLog.info("howard", " onConfig " + key + " : " + config);
        switch (key) {
            case ARGO_CONFIG_KEY_SINGLE:
                parseArgoResponse(VideoLiveConfig.Type.SINGLE, config);
                break;
            case ARGO_CONFIG_KEY_PLAYER_H264:
                parseArgoResponse(VideoLiveConfig.Type.PLAYER_H264, config);
                break;
            case ARGO_CONFIG_KEY_PLAYER_H265:
                parseArgoResponse(VideoLiveConfig.Type.PLAYER_H265, config);
                break;
            case ARGO_CONFIG_KEY_BEAUTIFYLEVEL:
                parseArgoResponse(VideoLiveConfig.Type.BEAUTIFYLEVEL, config);
                break;
            case ARGO_CONFIG_KEY_LIANMAI:
                parseArgoResponse(VideoLiveConfig.Type.LIANMAI, config);
                break;
//            case ARGO_CONFIG_KEY_LIANMAI_2ST:
//                parseArgoResponse(VideoLiveConfig.Type.LIANMAI_2st, config);
//                break;
            case ARGO_CONFIG_KEY_LIANMAI_ACROSS:
                parseArgoResponse(VideoLiveConfig.Type.ACROSS, config);
                break;
            case ARGO_CONFIG_KEY_BLACKCODEC:
                parseArgoResponse(VideoLiveConfig.Type.BLACKENCODEC, config);
                break;
            case ARGO_CONFIG_KEY_HAMO_SCREENRECORD:
                parseArgoResponse(VideoLiveConfig.Type.SCREEN_CAPTURE, config);
                break;
            case ARGO_CONFIG_KEY_HAMO_PLAYTRANSCODING_MAP:
                parseArgoResponsePlayTranscoding(VideoLiveConfig.Type.PLAYTRANSCODING, config);
            default:
                break;
        }
    }
}
