package com.yy.yylivesdk4cloud.video.serviceConfig;

import android.content.Context;

import com.yy.yylivesdk4cloud.helper.ThunderLog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

/**
 * 所有的函数调用均在{@link VideoConfigManager }的hanler中
 * Created by Administrator on 2018/8/16.
 */

public class LocalCachedConfigs {
    private static final String TAG = "cfg_LocalCachedConfigs";
    private final static String VIDEOCONFIG_NAME_SINGLE = "videoConfig_single";
    private final static String VIDEOCONFIG_NAME_LIANMAI_1st = "videoConfig_lianmai_1st";
    private final static String VIDEOCONFIG_NAME_LIANMAI_2st = "videoConfig_lianmai_2st";
    private final static String VIDEOCONFIG_NAME_ACROSS = "videoConfig_across";
    private final static String VIDEOCONFIG_NAME_ARENA_CROSS = "videoConfig_arena_across";
    private final static String VIDEOCONFIG_NAME_SCREEN_CAPTURE = "videoConfig_screen_capture";
    private final static String VIDEOCONFIG_NAME_MULIT_LIVE = "videoConfig_mulitlive";
    private final static String VIDEOCONFIG_NAME_MULIT_LIVE_LIANMAI = "videoConfig_mulitlive_lianmai";
    private final static String VIDEOCONFIG_NAME_ONE_TO_ONE = "videoConfig_one_to_one";
    private final static String VIDEOCONFIG_NAME_PLAYER_H265 = "videoConfig_dec_h265";
    private final static String VIDEOCONFIG_NAME_PLAYER_H264 = "videoConfig_dec_h264";
    private final static String VIDEOCONFIG_NAME_PLAYER_BEAUTIFYLEVEL = "videoConfig_beautifylevel";

    private static volatile File sSharedPrefDir = null;

    public LocalCachedConfigs(Context context) {
        File dir = new File(context.getApplicationContext().getApplicationInfo().dataDir);
        ThunderLog.info("SharedPreferencesUtils", dir.toString());
        File sharedPrefDir = new File(dir, "/shared_prefs");
        if (!sharedPrefDir.exists()) {
            if (sharedPrefDir.mkdir()) {
                sSharedPrefDir = sharedPrefDir;
            }
        } else {
            sSharedPrefDir = sharedPrefDir;
        }
    }

    public String getConfigString(String key){
        File file = getSharedPrefsFile(key);
        if(file == null){
            ThunderLog.error(TAG, "getConfigString file get failed!");
            return null;
        }

        FileInputStream inputStream;
        byte[] buff = new byte[16*1024];
        String result = null;
        try{
            inputStream = new FileInputStream(file);
            int len = inputStream.read(buff);
            if(len > 0){
                result =  new String(buff, 0, len, "UTF-8");
            }
            inputStream.close();
        }catch (Exception e){
            ThunderLog.error(TAG, "file read error:" + e.toString());
            return null;
        }

        ThunderLog.info(TAG, "getConfigString : " + key + " success!");
        return result;
    }

    public void setConfigString(String key, String value){
        File file = getSharedPrefsFile(key);
        if(file == null){
            ThunderLog.error(TAG, " setConfigString file get failed!");
            return ;
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            outputStream.write(value.getBytes());
            outputStream.close();
        }catch (Exception e){
            ThunderLog.error(TAG, "file write error:" + e.toString());
            return;
        }
        ThunderLog.info(TAG, " setConfigString  success, key:" + key);
    }

    private static File getSharedPrefsFile(String name) {
        if (sSharedPrefDir != null) {
            return new File(sSharedPrefDir, name + ".xml");
        }
        return null;
    }
}
