package com.yy.yylivesdk4cloud.video.serviceConfig;


import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;

import com.yy.argo.Argo;
import com.yy.yylivesdk4cloud.BuildConfig;
import com.yy.yylivesdk4cloud.ThunderAPI;
import com.yy.yylivesdk4cloud.ThunderDeviceInfo;
import com.yy.yylivesdk4cloud.audio.AudioConfigManager;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.log.LogConfigManager;
import com.yy.yylivesdk4cloud.trans.TransConfigManager;

import java.util.HashMap;
import java.util.Map;



/**
 * Created by Administrator on 2018/8/13.
 */
public class ArgoServiceImp implements IArgoServiceInterface {
    private final static String TAG = "cfg_ArgoServiceImp";
    private HandlerThread mProcessThread;
    private Handler mProcessHandler;
    private LocalCachedConfigs mLocalConfigs;
    private Argo mArgo;
    private String mAppId;
    private String mSceneId;
    private String mUid;
    private String mChannelID;
    private String mAppVersion;
    Map<String, String> mProfiles = new HashMap<>();
    private final static int MESSAGE_CONFIG_SAVE = 0;
    private final static int MESSAGE_CONFIG_REQUEST = 1;
    private final static int MESSAGE_CONFIG_RESPONSE = 2;
    private final static int MESSAGE_CONFIG_LOCAL = 3;
    private final static int MESSAGE_CONFIG_SET_PROFILR = 4;

    public ArgoServiceImp(Context context, ThunderDeviceInfo deviceInfo, long appId, long sceneId) {
        mAppId = Long.toString(appId);
        mSceneId = Long.toString(sceneId);
        mArgo = Argo.create("sdk", context);
        mAppVersion = deviceInfo.appInfo.split("-")[1];
        mProcessThread = new HandlerThread("ArgoServiceThread");
        mProcessThread.start();
        mProcessHandler = new Handler(mProcessThread.getLooper()){
            @Override
            public void handleMessage(Message msg) {
                switch (msg.what){
                    case MESSAGE_CONFIG_REQUEST:
                        handleConfigRequest();
                        break;
                    case MESSAGE_CONFIG_RESPONSE:
                        handleConfigResponse((Map<String, String>)msg.obj);
                        break;
                    case MESSAGE_CONFIG_SAVE:
                        break;
                    case MESSAGE_CONFIG_LOCAL:
                        handleQueryLocalCachedConfigs((Context) msg.obj);
                        break;
                    case MESSAGE_CONFIG_SET_PROFILR:
                        handleArgoSetProfile();
                        break;
                    default:
                        break;
                }
            }
        };

        mProcessHandler.sendMessage(Message.obtain(mProcessHandler, MESSAGE_CONFIG_SET_PROFILR));
        mProcessHandler.sendMessage(Message.obtain(mProcessHandler,MESSAGE_CONFIG_LOCAL, context));
        mProcessHandler.sendMessage(Message.obtain(mProcessHandler, MESSAGE_CONFIG_REQUEST));
    }

    public void fini() {
    	if (mProcessThread != null) {
    		// 调用quit接口后将无法继续使用当前的HandlerThread，除非再创建新的
    		mProcessThread.quit();
		}
		mProcessThread = null;
    	mProcessHandler = null;
	}

    private void handleArgoSetProfile(){
        synchronized (this) {
            mProfiles.put(ArgoProfileKey.ARGO_PROFILE_KEY_SDK_VER, Integer.toString(ThunderAPI.sharedInstance().getVersionInt()));
            if(mUid != null && !mUid.isEmpty()) {
                mProfiles.put(ArgoProfileKey.ARGO_PROFILE_KEY_UID, mUid);
            }
            mProfiles.put(ArgoProfileKey.ARGO_PROFILE_KEY_APP_VER, mAppVersion);
            mProfiles.put(ArgoProfileKey.ARGO_PROFILE_KEY_APPID, mAppId);
            mProfiles.put(ArgoProfileKey.ARGO_PROFILE_KEY_OS, "Android");
            mProfiles.put(ArgoProfileKey.ARGO_PROFILE_KEY_MODEL,  Build.MODEL);
            mProfiles.put(ArgoProfileKey.ARGO_PROFILE_KEY_OS_VERSION, android.os.Build.VERSION.RELEASE);
            if(mChannelID != null && !mChannelID.isEmpty()) {
                mProfiles.put(ArgoProfileKey.ARGO_PROFILE_KEY_CHANNEL_ID, mChannelID);
            }
            mProfiles.put(ArgoProfileKey.ARGO_PROFILE_KEY_SCENE_ID, mSceneId);
            if(ThunderAPI.sharedInstance().getVersion() != null){
                mProfiles.put("app_ver", ThunderAPI.sharedInstance().getVersion());
            }
            mArgo.setProfiles(mProfiles);
        }
    }

    private void handleQueryLocalCachedConfigs(Context context){
        mLocalConfigs = new LocalCachedConfigs(context);
        //Video config
        if(BuildConfig.__YY_VIDEO_SUPPORT__) {
            for (String key : VideoConfigManager.ARGO_CONFIG_KEYS) {
                String xml = mLocalConfigs.getConfigString(key);
                VideoConfigManager.instance().onConfig(key, xml);
            }
        }
        //Audio config
        for (String key :AudioConfigManager.ARGO_CONFIG_KEYS) {
            String xml = mLocalConfigs.getConfigString(key);
            AudioConfigManager.instance().onConfig(key, xml);
        }
        // log config
		for (String key :LogConfigManager.ARGO_CONFIG_KEYS) {
			String xml = mLocalConfigs.getConfigString(key);
			LogConfigManager.instance().onConfig(key, xml);
		}
		// trans config
        for (String key : TransConfigManager.ARGO_CONFIG_KEYS) {
            String xml = mLocalConfigs.getConfigString(key);
            TransConfigManager.instance().onConfig(key, xml);
        }
    }

    private void handleConfigRequest(){
		synchronized (this) {
			mArgo.setProfiles(mProfiles);
		}
		mArgo.queryConfigs(new Argo.ConfigsHandler() {
            @Override
            public void onConfigs(Map<String, String> configs) {
                if (mProcessHandler == null || configs.isEmpty()) {
                    return;
                }
                ThunderLog.info(TAG, "receive argo config " + configs.toString());
                Message msg = Message.obtain();
                msg.what = MESSAGE_CONFIG_RESPONSE;
                msg.obj = configs;
                mProcessHandler.sendMessage(msg);
            }

            @Override
            public void onFailure(int code, String message) {
                ThunderLog.warn(TAG, "Argo query failed: " + message);

                // Warn: implements custom data recovery here
            }

            @Override
            public void onCompletion(@Argo.QueryResult int result) {
                ThunderLog.info(TAG, "Did end querying");

                // TODO: do something if finalizing is needed
            }
        });
        ThunderLog.info(TAG, "begin queryConfigs");
    }

    private void handleConfigResponse(Map<String, String> configs){
        for (String key:configs.keySet()) {
            String value = configs.get(key);
            if(BuildConfig.__YY_VIDEO_SUPPORT__) {
                VideoConfigManager.instance().onConfig(key, value);
            }
            AudioConfigManager.instance().onConfig(key, value);
			LogConfigManager.instance().onConfig(key, value);
            TransConfigManager.instance().onConfig(key, value);
            //更新本地配置
            mLocalConfigs.setConfigString(key, value);
        }
    }

    static {
        final String argoTag = "ArgoSDK";

        Argo.init(Argo.Environment.Product, new Argo.Logger() {
            @Override
            public void log(@Argo.Level int lv, String msg) {
                switch (lv) {
                    case Argo.Level.Debug: ThunderLog.debug(argoTag, msg);  break;
                    case Argo.Level.Info:  ThunderLog.info(argoTag, msg);   break;
                    case Argo.Level.Warn:  ThunderLog.warn(argoTag, msg);   break;
                    case Argo.Level.Error: ThunderLog.error(argoTag, msg);  break;
                    default:
                        ThunderLog.debug(argoTag, msg);
                        break;
                }
            }
        });
    }

    //请求配置
    public void queryConfigs() {
        //todo
        ThunderLog.info(TAG, " queryConfigs begin");
        mProcessHandler.sendMessage(Message.obtain(mProcessHandler, MESSAGE_CONFIG_REQUEST));
    }

    //更新配置
    public void setProfileParam(String key, String value) {
        if(value == null || key == null || key.isEmpty() || value.isEmpty()){
            return;
        }

        if(key.equalsIgnoreCase(ArgoProfileKey.ARGO_PROFILE_KEY_UID)){
            mUid = value;
        }
        if(key.equalsIgnoreCase(ArgoProfileKey.ARGO_PROFILE_KEY_CHANNEL_ID)){
            mChannelID = value;
        }
		synchronized (this) {
			mProfiles.put(key, value);
			ThunderLog.info(TAG, "setProfileParam " + mProfiles);
		}
    }


    public static class ArgoProfileKey {
        public static final String ARGO_PROFILE_KEY_SDK_VER = "sdk_version";    //sdk版本
        public static final String ARGO_PROFILE_KEY_UID = "uid";                //用户uid
        public static final String ARGO_PROFILE_KEY_APP_VER = "app_ver";        //应用版本号
        public static final String ARGO_PROFILE_KEY_APPID = "appid";            //应用id(测试验证器,勿删)
        public static final String ARGO_PROFILE_KEY_OS = "os";                  //操作系统
        public static final String ARGO_PROFILE_KEY_MODEL = "model";            //机型
        public static final String ARGO_PROFILE_KEY_OS_VERSION = "osversion";   //系统版本
        public static final String ARGO_PROFILE_KEY_CHANNEL_ID = "channel_id";   //频道ID
        public static final String ARGO_PROFILE_KEY_SCENE_ID = "scene_id";       //场景ID
    }
}
