package com.yy.yylivesdk4cloud.video;


import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;

import com.yy.mediaframework.CameraPreviewConfig;
import com.yy.mediaframework.IPublishListener;
import com.yy.mediaframework.ITextureListener;
import com.yy.mediaframework.PublishVideoConfig;
import com.yy.mediaframework.VideoPublish;
import com.yy.mediaframework.YYVideoCodec;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.gpuimage.custom.OrangeFilterWrapper;
import com.yy.mediaframework.stat.VideoDataStat;
import com.yy.videoplayer.VideoPlayer;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.render.VideoRenderNotify;
import com.yy.videoplayer.stat.VideoPlayerDataStat;
import com.yy.yylivesdk4cloud.BuildConfig;
import com.yy.yylivesdk4cloud.ThunderConstant;
import com.yy.yylivesdk4cloud.ThunderDefaultCamera;
import com.yy.yylivesdk4cloud.ThunderPreviewConfig;
import com.yy.yylivesdk4cloud.ThunderScreenCapture;
import com.yy.yylivesdk4cloud.ThunderPlayerView;
import com.yy.yylivesdk4cloud.ThunderPreviewView;
import com.yy.yylivesdk4cloud.ThunderPublisher;
import com.yy.yylivesdk4cloud.ThunderVideoCapture;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;
import com.yy.yylivesdk4cloud.video.serviceConfig.VideoConfigManager;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

/**
 * Created by xiaojun on 2018/1/4.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */

/* 对应 C++ 代码的 ThunderVideoEngineImp 类 */
public class ThunderVideoEngineImp implements IPublishListener, ITextureListener {

	public static final int YYPUBLISH_VIDEO_STATE_NONE = 0;
	public static final int YYPUBLISH_VIDEO_STATE_PREVIEW = 1;
	public static final int YYPUBLISH_VIDEO_STATE_ENCODE = 2;

	HashMap<String, ThunderPlayerView> mVideoViewMap;
	HashMap<String, Integer> mVideoScaleModeMap;
	private VideoPublish mPublisher = null;
	private long mCallBackPtr = 0;
	private boolean bMixMode = false;
	private ThunderVideoCapture mCapture;
	private OrangeFilterWrapper mOrangeFilterWrapper;

	private final static int VIDEO_STAT_FPS = 0;
	private final static int VIDEO_STAT_BITRATE = 1;
	private final static int VIDEO_STATE_RESOLUTION = 2;
	private VideoConfigManager mVideoConfigManager;
	private int mVideoPublishState = YYPUBLISH_VIDEO_STATE_NONE;
	private YVideoPublishVideoConfig mCurrentVideoConfig = null;
	private Handler mUiHandler = null;
	private Map<String, WeakReference> mPlayViewAndStreamKeyMap = new HashMap<>();

	public ThunderVideoEngineImp() {
		//比拉取配置要早,异步检查硬编兼容性
		YYVideoCodec.testVideoEncoderCrash();
	}

	public void init(){
		mVideoViewMap = new HashMap<String, ThunderPlayerView>();
		mVideoScaleModeMap = new HashMap<String, Integer>();
		mPublisher = VideoPublish.getInstance();
		mVideoConfigManager = VideoConfigManager.instance();
		YYVideoLibMgr.instance().setVideoInfoListener(
				new ThunderVideoPlayListener(YYVideoLibMgr.instance().getAppContext(), this));
		mUiHandler = new android.os.Handler(Looper.getMainLooper());
		ThunderVideoConfig config = new ThunderVideoConfig();
		config.AsyncLoad();
	}

	public static String getVideoEngineVersion() {
		return "Android: " + BuildConfig.YY_VIDEOLIB_VERSION
				+ "&"+ BuildConfig.YY_VIDEOPLAYER_VERSION;
	}

	public void updatePlayVideoStream(String streamKey, long streamId, final int streamType){
		//先拆掉前面的流程,releaseDecoder是传输拆掉，view是在setDecodeType里面拆掉重建
		ThunderPlayerView view = mVideoViewMap.get(streamKey);
		if (view == null) {
			ThunderLog.warn(ThunderLog.kLogTagVideo,
					"updatePlayVideoStream: cann't find video view for stream:%s",
					streamKey);
			return ;
		}

		if((mVideoConfigManager.getPlayViewTypeFromStream(streamType) == VideoConstant.DecoderType.SOFT_DEOCDER && view.getViewType() == 0)||
				mVideoConfigManager.getPlayViewTypeFromStream(streamType) == VideoConstant.DecoderType.ANDROID_HARD_DECODER1 && view.getViewType() == 1){
			ThunderLog.info(ThunderLog.kLogTagVideo, "updatePlayVideoStream unchange stream:%s-%d - %d", streamKey, streamId, streamType);
			return;
		}

		ThunderLog.info(ThunderLog.kLogTagVideo, "updatePlayVideoStream unlink stream:%s-%d", streamKey, streamId);
		view.unLinkFromStream(streamId);

		//新建流程
		setDecodeType(streamKey, streamType);

		ThunderLog.info(ThunderLog.kLogTagVideo, "updatePlayVideoStream link stream:%s, %d", streamKey, streamId);
		view.linkToStream(streamId);
	}

	public int setDecodeType(String streamKey, final int streamType){
		final int decodeType = mVideoConfigManager.getPlayViewTypeFromStream(streamType);
		ThunderLog.info("ThunderVideoEngineImp", "setDecodeType streamKey " + streamKey + " type:" + streamType);
		if(mVideoConfigManager == null) {
			ThunderLog.error("ThunderVideoEngineImp", "setDecodeType mVideoConfigManager == null!");
			return -1;
		}
		int scaleMode = mVideoScaleModeMap.get(streamKey) == null ? -1 : mVideoScaleModeMap.get(streamKey);
		if(scaleMode == -1){
			ThunderLog.error("ThunderVideoEngineImp", "setDecodeType mVideoScaleModeMap can't find scaleMode in map :" + mVideoScaleModeMap.size());
			return -1;
		}

		final ThunderPlayerView view = mVideoViewMap.get(streamKey);
		if(mVideoViewMap.get(streamKey) == null){
			ThunderLog.error("ThunderVideoEngineImp", "setDecodeType mVideoScaleModeMap can't find view in map :" + mVideoViewMap.size());
			return -1;
		}

		final CountDownLatch barrier = new CountDownLatch(1);
		mUiHandler.post(new Runnable() {
			@Override
			public void run() {
				view.prepareView(decodeType);
				barrier.countDown();
			}
		});
		try {
			barrier.await();
		} catch (InterruptedException e) {
			ThunderLog.error("ThunderVideoEngineImp","setDecodeType .barrier.await" + e.toString());
		}


//		if (!bSuccess) {
//			ThunderLog.error(ThunderLog.kLogTagVideo,
//					"setDecodeType: prepareView failed for " + streamType + " streamkey:" + streamKey);
//			return ;
//		}
		view.setScaleMode(scaleMode);
		ThunderLog.info("ThunderVideoEngineImp", streamKey+" setDecodeType success : scaleMode" + scaleMode +", decodeType: " + decodeType);

		return (decodeType == VideoConstant.DecoderType.ANDROID_HARD_DECODER1 ?  1: 0);
	}

	public boolean H265PlaySupport(){
		if(mVideoConfigManager == null){
			return  false;
		}
		ThunderLog.info("ThunderVideoEngineImp", "H265PlaySupport " + mVideoConfigManager.H265PlaySupport());
		return mVideoConfigManager.H265PlaySupport();
	}

	public boolean startVideoEngine() {
		return true;
	}

	public int getVideoDecodeTranscoding(int transcoding){
		if(mVideoConfigManager == null){
			return transcoding;
		}
		return mVideoConfigManager.getVideoDecodeTranscoding(transcoding);
	}


	public int getVideoEncodeTranscoding(int playType, int mode){
		if(mVideoConfigManager == null){
			return mode;
		}
		return mVideoConfigManager.getVideoEncodeTranscoding(playType, mode);
	}

	public boolean stopVideoEngine() {
		return true;
	}

	public void setVideoEngineCallBack(long ptr) {
		mCallBackPtr = ptr;
	}

	private boolean isUsingDefaultCamera() {
		return !bMixMode && (mCapture instanceof ThunderDefaultCamera);
	}

	public void attachVideoCapture(Object capture) {
		if (mCapture != null) {
			ThunderLog.info(ThunderLog.kLogTagVideo, "detach capture: " + mCapture.toString());
			mCapture = null;
		}
		if (capture != null) {
			mCapture = (ThunderVideoCapture) capture;
			ThunderLog.info(ThunderLog.kLogTagVideo, "attach capture: " + mCapture.toString());
		}
	}

	private CameraPreviewConfig getCameraPreviewConfigByType(int playType, int previewMode){
		CameraPreviewConfig result = mVideoConfigManager.getCameraPreviewConfigByType(playType, previewMode);
		ThunderLog.info("ThunderVideoEngineImp", "getCameraPreviewConfigByType:" + result.toString());
		return result;
	}

	private int getBeautyLevelInCurrentConfig(){
		int result = 0;
		if(mVideoConfigManager != null) {
			result = mVideoConfigManager.getCurrentBeautifyLevel();
		}

		ThunderLog.info("ThunderVideoEngineImp", "getBeautyLevelInCurrentConfig:" + result);
		return result;
	}

	private VideoEncoderConfig getVideoEncoderConfigByType(int playType, int mode){
		VideoEncoderConfig result = mVideoConfigManager.getVideoEncodeConfigByType(playType, mode);
		ThunderLog.info("ThunderVideoEngineImp", "getVideoEncoderConfigByType:" + result.toString());
		return result;
	}

	private boolean checkLowDelayByType(int playType){
		return mVideoConfigManager.checkLowDelayByType(playType);
	}

	private CameraPreviewConfig toCamerePreviewConfig(ThunderPreviewConfig config) {
		CameraPreviewConfig newConf = new CameraPreviewConfig(CameraPreviewConfig.PREVIEW_MODE_NORMAL);
		newConf.mCaptureResolutionWidth = config.captureResolutionWidth;
		newConf.mCaptureResolutionHeight = config.captureResolutionHeight;
		newConf.mCameraPosition = config.cameraPosition;
		newConf.mCaptureFrameRate = config.captureFrameRate;
		newConf.mCaptureOrientation = config.captureOrientation;
		return newConf;
	}

	public YVideoPublishVideoConfig setOrientation(int orientatin){
		ThunderLog.info("ThunderVideoEngineImp", " setOrientation " + orientatin);
		if(mCapture instanceof ThunderScreenCapture) {
			ThunderScreenCapture yyLiveScreenCapture = (ThunderScreenCapture) mCapture;
			if((yyLiveScreenCapture.isLandscap() && orientatin != ThunderConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_LANDSCAPE) ||
					(!yyLiveScreenCapture.isLandscap()) && (orientatin != ThunderConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_PORTRAIT)){
				stopEncodeVideo();
				yyLiveScreenCapture.setIslandScape(orientatin == ThunderConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_LANDSCAPE);
				startEncodeVideo(mCurrentVideoConfig.bMirrorFrontCamera, mCurrentVideoConfig.bLowLatency, mCurrentVideoConfig.playType, mCurrentVideoConfig.mode);
			}

			return mCurrentVideoConfig;
		}else {

			ThunderDefaultCamera camera = (ThunderDefaultCamera) mCapture;
			ThunderPreviewConfig config = (ThunderPreviewConfig)camera.getCaptureConfig();
			if(orientatin != config.captureOrientation){
				//横竖屏变换
				config.captureOrientation = orientatin;
				config.captureResolutionWidth = config.captureResolutionWidth + config.captureResolutionHeight;
				config.captureResolutionHeight = config.captureResolutionWidth - config.captureResolutionHeight;
				config.captureResolutionWidth = config.captureResolutionWidth - config.captureResolutionHeight;
				camera.setCaptureConfig(config);
			}

			if(mVideoPublishState == YYPUBLISH_VIDEO_STATE_PREVIEW){
				mPublisher.updateCameraPreviewParam(toCamerePreviewConfig(config));
			}else if(mVideoPublishState == YYPUBLISH_VIDEO_STATE_ENCODE){
				stopEncodeVideo();
				mPublisher.updateCameraPreviewParam(toCamerePreviewConfig(config));
				startEncodeVideo(mCurrentVideoConfig.bMirrorFrontCamera, mCurrentVideoConfig.bLowLatency, mCurrentVideoConfig.playType, mCurrentVideoConfig.mode);
			}else{
				ThunderLog.warn("ThunderVideoEngineImp", "setOrientation wrong!");
			}

			if(mCurrentVideoConfig != null){
				mCurrentVideoConfig.orientation = orientatin;
				mCurrentVideoConfig.encodeResolutionWidth = mCurrentVideoConfig.encodeResolutionWidth + mCurrentVideoConfig.encodeResolutionHeight;
				mCurrentVideoConfig.encodeResolutionHeight = mCurrentVideoConfig.encodeResolutionWidth - mCurrentVideoConfig.encodeResolutionHeight;
				mCurrentVideoConfig.encodeResolutionWidth = mCurrentVideoConfig.encodeResolutionWidth - mCurrentVideoConfig.encodeResolutionHeight;
			}

			if(mVideoPublishState == YYPUBLISH_VIDEO_STATE_ENCODE){
				return mCurrentVideoConfig;
			}else {
				return null;
			}
		}
	}

	public int startPreview(Object toView, int playType, int publishMode) {

		if (isUsingDefaultCamera()) {
			ThunderDefaultCamera camera = (ThunderDefaultCamera) mCapture;
			ThunderPreviewConfig config = (ThunderPreviewConfig)camera.getCaptureConfig();

			mPublisher.setPhonePerformanceLevel(getBeautyLevelInCurrentConfig());

			CameraPreviewConfig newConfig = getCameraPreviewConfigByType(playType, publishMode);
			newConfig.mCameraPosition = ((ThunderPreviewConfig)camera.getCaptureConfig()).cameraPosition;
			if(config.captureOrientation == ThunderConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_LANDSCAPE){
				//横屏模式
				if(newConfig.mCaptureResolutionWidth < newConfig.mCaptureResolutionHeight) {
					int mid = newConfig.mCaptureResolutionWidth;
					newConfig.mCaptureResolutionWidth = newConfig.mCaptureResolutionHeight;
					newConfig.mCaptureResolutionHeight = mid;
				}
			}
			mPublisher.startPreviewWithView(((ThunderPreviewView)toView).getSurfaceView(),
					newConfig, this);

			if (camera.getCameraDataCallback() != null) {
				ThunderLog.info(ThunderLog.kLogTagVideo, "setTextureListener %s %s",
						camera.getCameraDataCallback().toString(), this.toString());
				mPublisher.setTextureListener(this);
			}
			mOrangeFilterWrapper = mPublisher.getOrangeFilterWrapperObject();

			//同步当前camera的config
			config.captureFrameRate = newConfig.mCaptureFrameRate;
			config.captureResolutionHeight = newConfig.mCaptureResolutionHeight;
			config.captureResolutionWidth = newConfig.mCaptureResolutionWidth;
			camera.setCaptureConfig(config);
			return 0;
		} else {
			mCapture.startCapture(new ThunderPublisher.IVideoPublisher() {
				@Override
				public void pushVideoData() {

				}

				@Override
				public void pushVideoData(byte[] encodedData,
										  ThunderConstant.ThunderVideoEncodeType type,
										  long dts,
										  long pts) {

				}
			});
		}

		mVideoPublishState = YYPUBLISH_VIDEO_STATE_PREVIEW;
		return 0;
	}

	public int stopPreview() {
		if (isUsingDefaultCamera()) {
			if(mVideoPublishState != YYPUBLISH_VIDEO_STATE_PREVIEW){
				ThunderLog.info(ThunderLog.kLogTagVideo, "stopPreview videoState wrong:" + mVideoPublishState);
			}
			mVideoPublishState = YYPUBLISH_VIDEO_STATE_NONE;
			return mPublisher.stopPreview();
		}
		return -1;
	}

	/**
	 * 从配置中心提取配置开播
	 * @param bMirrorFrontCamera	镜像
	 * @param bLowLatency			低延时
	 * @param playType				玩法
	 * @param mode					模式
	 * @return 			实际使用的编码参数
	 */
	public YVideoPublishVideoConfig startEncodeVideo(
			boolean bMirrorFrontCamera,
			boolean bLowLatency,
			int playType,
			int mode) {



		VideoEncoderConfig newEncoderConfig = getVideoEncoderConfigByType(playType, mode);
		if( mCapture.getClass() == ThunderScreenCapture.class && ((ThunderScreenCapture) mCapture).isLandscap()){
			int mid = newEncoderConfig.mEncodeWidth;
			newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
			newEncoderConfig.mEncodeHeight = mid;
		}else if( mCapture.getClass() == ThunderDefaultCamera.class &&((ThunderPreviewConfig)mCapture.getCaptureConfig()).captureOrientation == ThunderConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_LANDSCAPE){
			//横屏模式
			if(newEncoderConfig.mEncodeWidth < newEncoderConfig.mEncodeHeight) {
				int mid = newEncoderConfig.mEncodeWidth;
				newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
				newEncoderConfig.mEncodeHeight = mid;
			}
		}

		newEncoderConfig.mLowDelay = checkLowDelayByType(playType);

		ThunderLog.info(ThunderLog.kLogTagVideo, "startPublishVideo %dx%d %d %d %s %b %b",
				newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate,
				newEncoderConfig.mEncodeType.name(), bMirrorFrontCamera, bLowLatency);

		mPublisher.enableMirror(bMirrorFrontCamera);
		if (mCapture.getClass() == ThunderScreenCapture.class)
		{
			// 录屏
			ThunderScreenCapture yyLiveScreenCapture = (ThunderScreenCapture) mCapture;
			mPublisher.initScreenLiveSession(yyLiveScreenCapture.getMediaProjection(), this, yyLiveScreenCapture.isLandscap());
		}

		//设置动态分辨率
		mPublisher.setResolutionModifyConfigs(mVideoConfigManager.getCurrentModifyConfig() , mVideoConfigManager.getCurrentIntervalSecs());

		int ret = mPublisher.startPublishVideo("general", null, newEncoderConfig);

		if(ret == 0){
			int encodeType = 0;
			boolean hard = false;
			if(newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H264 ){
				hard = true;
				encodeType = 0;
			}else if(newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_X264){
				hard = false;
				encodeType = 0;
			}else if(newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_H265){
				hard = false;
				encodeType = 1;
			}else if(newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H265){
				hard = true;
				encodeType = 1;
			}

			int videoLevel = mVideoConfigManager.getCurrentVideoLiveConfig() == null ? -1 : mVideoConfigManager.getCurrentVideoLiveConfig().videoLevel;

			if(mCurrentVideoConfig == null) {
				mCurrentVideoConfig = new YVideoPublishVideoConfig(newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate / 1000, newEncoderConfig.mEncodeWidth,
						newEncoderConfig.mEncodeHeight, encodeType, hard, videoLevel);
			}

			mCurrentVideoConfig.bLowLatency = bLowLatency;
			mCurrentVideoConfig.bMirrorFrontCamera = bMirrorFrontCamera;
			mCurrentVideoConfig.playType = playType;
			mCurrentVideoConfig.mode = videoLevel;
			mCurrentVideoConfig.encodeFrameRate = newEncoderConfig.mFrameRate;
			mCurrentVideoConfig.encodeBitrate = newEncoderConfig.mBitRate / 1000;
			mCurrentVideoConfig.encodeResolutionWidth = newEncoderConfig.mEncodeWidth;
			mCurrentVideoConfig.encodeResolutionHeight = newEncoderConfig.mEncodeHeight;
			mCurrentVideoConfig.bHardwareEncoder = hard;
			mCurrentVideoConfig.encodeType = encodeType;

			mCurrentVideoConfig.orientation = mCurrentVideoConfig.encodeResolutionWidth > mCurrentVideoConfig.encodeResolutionHeight ?
					ThunderConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_LANDSCAPE : ThunderConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_PORTRAIT;
		}

		if(mVideoPublishState != YYPUBLISH_VIDEO_STATE_PREVIEW) {
			ThunderLog.info(ThunderLog.kLogTagVideo, "startPublishVideo videoState wrong:" + mVideoPublishState);
		}
		mVideoPublishState = YYPUBLISH_VIDEO_STATE_ENCODE;
		return mCurrentVideoConfig;
	}

	public int stopEncodeVideo() {
		mVideoConfigManager.resetCurrentVideoLiveConfig();
		if(mVideoPublishState != YYPUBLISH_VIDEO_STATE_ENCODE) {
			ThunderLog.info(ThunderLog.kLogTagVideo, "stopEncodeVideo videoState wrong:" + mVideoPublishState);
		}
		mVideoPublishState = YYPUBLISH_VIDEO_STATE_PREVIEW;
		mPublisher.stopPublishVideo();

		if (mCapture.getClass() == ThunderScreenCapture.class) {
			mPublisher.deInitScreenLiveSession();
		}
		return 0;
	}


	public void changeScreenLiveMode(boolean pictureMode, Object bitmap){
		mPublisher.changeScreenLiveMode(pictureMode, (Bitmap)bitmap);
	}

	public int startPlayVideoStream(String streamKey,
									Object toView,
									int scaleMode) {
		if (toView == null || streamKey == null || streamKey.isEmpty()) {
			return -1;
		}
		ThunderPlayerView view = (ThunderPlayerView) toView;
		ThunderLog.info(ThunderLog.kLogTagVideo, "startPlayVideoStream " + streamKey + " scaleMode:" + scaleMode);

		mVideoScaleModeMap.put(streamKey, scaleMode);
		mVideoViewMap.put(streamKey, view);
		return 0;
	}

	public int stopPlayVideoStream(String streamKey) {
		final ThunderPlayerView view = mVideoViewMap.get(streamKey);
		if (view == null) {
			return -1;
		}
		ThunderLog.debug(ThunderLog.kLogTagVideo, "stopPlayVideoStream" + streamKey);
		view.unLinkFromStream();
		mUiHandler.post(new Runnable() {
			@Override
			public void run() {
				view.unPrepareView();
			}
		});
		mVideoViewMap.remove(streamKey);
		return 0;
	}

	public boolean updatePlayVideoView(String streamKey, Object toView, int scaleMode) {
		if (toView == null || streamKey == null || streamKey.isEmpty()) {
			return false;
		}

		ThunderPlayerView view = mVideoViewMap.get(streamKey);
		if (view == null) {
			return false;
		}

		if (!view.equals(toView)) {
			ThunderLog.warn(ThunderLog.kLogTagVideo, "may toView is change!");
			return false;
		}
		ThunderLog.debug(ThunderLog.kLogTagVideo, "update play scale mode: " + scaleMode);
		return view.setScaleMode(scaleMode);
	}


	/**
	 *  *  更新预览和开播参数,从配置中心中依据playType 和 mode 匹配详细的参数值
	 * @param bMirrorFrontCamera 	镜像开启
	 * @param bLowLatency			低延时
	 * @param playType				玩法{@link com.yy.yylivesdk4cloud.video.serviceConfig.VideoLiveConfig.Type}
	 * @param mode					模式{@link com.yy.yylivesdk4cloud.video.serviceConfig.VideoLiveConfig.Level}
	 * @return  实际使用的编码参数 {@link YVideoPublishVideoConfig}
	 */
	public YVideoPublishVideoConfig updatePublishVideoConfig(
			boolean bMirrorFrontCamera,
			boolean bLowLatency,
			int playType,
			int mode) {
		if(playType != mCurrentVideoConfig.playType || mode != mCurrentVideoConfig.mode){
			VideoEncoderConfig newEncoderConfig = getVideoEncoderConfigByType(playType, mode);
			PublishVideoConfig videoConfig = new PublishVideoConfig();
			videoConfig.assign(newEncoderConfig);

			videoConfig.mLowDelay = checkLowDelayByType(playType);

			if(videoConfig.mLowDelay != bLowLatency){
				ThunderLog.info(ThunderLog.kLogTagVideo, "updatePublishVideoConfig %b :%d", bLowLatency, playType);
			}

			//设置动态分辨率
			mPublisher.setResolutionModifyConfigs(mVideoConfigManager.getCurrentModifyConfig() , mVideoConfigManager.getCurrentIntervalSecs());

			mPublisher.updatePublishVideoConfig(videoConfig);

			int encodeType = 0;
			boolean hard = false;
			if(newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H264 ){
				hard = true;
				encodeType = 0;
			}else if(newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_X264){
				hard = false;
				encodeType = 0;
			}else if(newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_H265){
				hard = false;
				encodeType = 1;
			}else if(newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H265){
				hard = true;
				encodeType = 1;
			}

			int videoLevel = mVideoConfigManager.getCurrentVideoLiveConfig() == null ? -1 : mVideoConfigManager.getCurrentVideoLiveConfig().videoLevel;

			if(mCurrentVideoConfig == null) {
				mCurrentVideoConfig = new YVideoPublishVideoConfig(newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate / 1000, newEncoderConfig.mEncodeWidth,
						newEncoderConfig.mEncodeHeight, encodeType, hard, videoLevel);
			}

			mCurrentVideoConfig.playType = playType;
			mCurrentVideoConfig.mode = videoLevel;
			mCurrentVideoConfig.encodeFrameRate = newEncoderConfig.mFrameRate;
			mCurrentVideoConfig.encodeBitrate = newEncoderConfig.mBitRate / 1000;
			mCurrentVideoConfig.encodeResolutionWidth = newEncoderConfig.mEncodeWidth;
			mCurrentVideoConfig.encodeResolutionHeight = newEncoderConfig.mEncodeHeight;
			mCurrentVideoConfig.bHardwareEncoder = hard;
			mCurrentVideoConfig.encodeType = encodeType;
			mCurrentVideoConfig.orientation = ((ThunderPreviewConfig)mCapture.getCaptureConfig()).captureOrientation;

			mCurrentVideoConfig.bLowLatency = videoConfig.mLowDelay;
		}

//		if(bLowLatency != mCurrentVideoConfig.bLowLatency){
//			mPublisher.setLowDelayMode(bLowLatency);
//			mCurrentVideoConfig.bLowLatency = bLowLatency;
//		}

		if(bMirrorFrontCamera != mCurrentVideoConfig.bMirrorFrontCamera){
			mPublisher.enableMirror(bMirrorFrontCamera);
			mCurrentVideoConfig.bMirrorFrontCamera = bMirrorFrontCamera;
		}

		return mCurrentVideoConfig;
	}

	public boolean setCameraPosition(int position) {
		((ThunderPreviewConfig)mCapture.getCaptureConfig()).cameraPosition = position;
		return mPublisher.setCameraPosition(position);
	}

	public int setPubWatermark(float x, float y, Object image) {
		return mPublisher.setWatermark((Bitmap) image, (int)x, (int)y);
	}

	public int setPubFaceBeautyLevel(float level) {
//		mPublisher.setBeautyParam(level);
		if (mOrangeFilterWrapper != null)
		{
			mOrangeFilterWrapper.setBeautyParam(level);
		}
		return 0;
	}

	public int onVideoStreamArrive(String streamKey, long streamId) {
		ThunderPlayerView view = mVideoViewMap.get(streamKey);
		if (view == null) {
			ThunderLog.warn(ThunderLog.kLogTagVideo,
					"onVideoStreamArrive: cannot find video view for stream:%s",
					streamKey);
			return -1;
		}
		ThunderLog.info(ThunderLog.kLogTagVideo, "link stream:%s, %d", streamKey, streamId);
		view.linkToStream(streamId);
		return 0;
	}

	public int onVideoStreamStop(String streamKey, long streamId) {
		ThunderPlayerView view = mVideoViewMap.get(streamKey);
		if (view == null) {
			ThunderLog.warn(ThunderLog.kLogTagVideo,
					"onVideoStreamStop: cann't find video view for stream:%s",
					streamKey);
			return -1;
		}
		ThunderLog.info(ThunderLog.kLogTagVideo, "unlink stream:%s-%d", streamKey, streamId);
		view.unLinkFromStream(streamId);
		return 0;
	}

	public int onRequestIFrame() {
		mPublisher.requestEncodeIFrame();
		return 0;
	}

	//弱网
	public int onDynamicBitrate(long bitrate) {
		// 传输回调回来的比特率数值单位是 kbps
		mPublisher.setNetworkBitrateSuggest((int)bitrate * 1000);
		return 0;
	}

	/**
	 * 获取海度统计数据
	 */
	public String getAnchorHiidoStatInfo(long streamId) {
		return VideoDataStat.getInstance().getAnchorVideoData(streamId);
	}

	public String getAudienceHiidoStatInfo(long streamId) {
		return VideoPlayerDataStat.getInstance().getAudienceVideoData(streamId);
	}

	/**
	 * 获取视频实时统计数据
	 */
	public int getPublishRuntimeInfo(int type) {
		switch (type) {
			case VIDEO_STAT_FPS:
				return mPublisher.getVideoPublishInfo(VideoPublish.VideoPublishInfoEnum.FRAME);
			case VIDEO_STAT_BITRATE:
				return mPublisher.getVideoPublishInfo(VideoPublish.VideoPublishInfoEnum.BITRATE);
			case VIDEO_STATE_RESOLUTION:
				return mPublisher.getVideoPublishInfo(VideoPublish.VideoPublishInfoEnum.RESOLUTION);
		}
		return 0;
	}

	public long getPlayRuntimeInfo(long streamId, int type) {
		switch (type) {
			case VIDEO_STAT_FPS:
				return VideoPlayer.getInstance().getPlayerInfo(streamId, VideoPlayer.VideoPlayerInfoEnum.FRAME);
			case VIDEO_STAT_BITRATE:
				break; // 播放不统计码率
			case VIDEO_STATE_RESOLUTION:
				return VideoPlayer.getInstance().getPlayerInfo(streamId, VideoPlayer.VideoPlayerInfoEnum.RESOLUTION);
		}
		return 0;
	}

	/**
	 * 后台配置下发的主播端采集时间戳校正值
	 * @param adjustVal
	 * @return
	 */
	public int setPublisherPtsAdjustVal(int adjustVal) {
		if (mPublisher != null) {
			ThunderLog.debug(ThunderLog.kLogTagVideo, "setPublisherPtsAdjustVal " + adjustVal);
			mPublisher.setDeltaYYPtsMillions(adjustVal);
		}
		return 0;
	}

	/**
	 * 视频数据回调函数，传回的是编码后的数据
	 */
	@Override
	public void onEncodeFrameData(byte[] data,
								  int len,
								  long pts,
								  long dts,
								  int frameType,
								  VideoEncoderType encoderType) {
		int encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDER_ENCODE_TYPE_H264;
		boolean bHardware = false;

		switch (encoderType) {
			case SOFT_ENCODER_X264:
				bHardware = false;
				encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDER_ENCODE_TYPE_H264;
				break;
			case HARD_ENCODER_H264:
				bHardware = true;
				encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDER_ENCODE_TYPE_H264;
				break;
			case SOFT_ENCODER_H265:
				bHardware = false;
				encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H265;
				break;
			case HARD_ENCODER_H265:
				bHardware = true;
				encodeType = ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H265;
				break;
			case DEFAULT:
			case ERROR:
				ThunderLog.warn(ThunderLog.kLogTagVideo, "unknown encoder type" + encoderType.toString());
		}

		if (mCallBackPtr != 0) {
			onVideoEncodedFrame(mCallBackPtr, data, len, pts, dts, frameType, encodeType, bHardware);
		}
	}

	/**
	 * 采集回调
	 */
	@Override
	public int onTextureCallback(int textureId, int width, int height) {
//		ThunderLog.info(ThunderLog.kLogTagVideo, "onTextureCallback %d %dx%d",
//				textureId, width, height);
		if (!isUsingDefaultCamera()) {
			return textureId;
		}
		ThunderDefaultCamera camera = (ThunderDefaultCamera) mCapture;
		if (camera.getCameraDataCallback() == null) {
			return textureId;
		}
		return camera.getCameraDataCallback().onTextureCallback(textureId, width, height);
	}

	void onVideoRenderNotify(final ArrayList<VideoRenderNotify> notifications) {
		if (mCallBackPtr != 0) {
			ThunderNative.onVideoRenderEvent(mCallBackPtr, notifications);
		}
	}

	void onHardwareDecodeErrorNotify(long userGroupId, long streamId, int errorType) {
		ThunderLog.info(ThunderLog.kLogTagVideo, "onHardwareDecodeErrorNotify %d",
				errorType);
		if (errorType < 3) { //0 reset_error 1 init_error 2 decoding_error 3 stop_block_error
			ThunderNative.enableHardwareDecoder(false, ThunderConstant.ThunderVideoEncodeType.THUNDER_ENCODE_TYPE_H264);
			ThunderNative.enableHardwareDecoder(false, ThunderConstant.ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H265);
			if(mVideoConfigManager != null){
				mVideoConfigManager.disableHardDecode(true);
			}
		}
	}

	private native void onVideoEncodedFrame(long callback,
											byte[] data,
											int len,
											long pts,
											long dts,
											int frameType,
											int encodeType,
											boolean bHardware);

	/**
	 * 返回给Jni层当前实际使用的配置
	 */
	private static class YVideoPublishVideoConfig{
		int encodeFrameRate;
		int encodeBitrate;
		int encodeResolutionWidth;
		int encodeResolutionHeight;
		int encodeType;
		boolean bHardwareEncoder;
		int mode;
		boolean bMirrorFrontCamera;
		boolean bLowLatency;
		int playType;
		int orientation;

		public YVideoPublishVideoConfig(int encodeFrameRate, int encodeBitrate, int encodeResolutionWidth, int encodeResolutionHeight, int encodeType, boolean bHardwareEncoder, int mode) {
			this.encodeFrameRate = encodeFrameRate;
			this.encodeBitrate = encodeBitrate;
			this.encodeResolutionWidth = encodeResolutionWidth;
			this.encodeResolutionHeight = encodeResolutionHeight;
			this.encodeType = encodeType;
			this.bHardwareEncoder = bHardwareEncoder;
			this.mode = mode;
		}

		@Override
		public String toString() {
			String tmp = "" + this.encodeResolutionWidth +
					"x" + this.encodeResolutionHeight +
					"@" + this.encodeFrameRate +
					" " + this.encodeBitrate +
					" hard:" + this.bHardwareEncoder +
					" mode:" + this.mode;
			return tmp;
		}
	}


	public void stopAndRecoverVideoEncode(boolean stop){
		if(mPublisher!= null && mVideoPublishState != YYPUBLISH_VIDEO_STATE_NONE) {
			mPublisher.stopAndRecoverStream(stop);
		}
	}
}
