package com.yy.yylivesdk4cloud.trans;

import android.util.Log;
import java.util.HashMap;
import java.util.Iterator;

import com.yy.yylivesdk4cloud.ThunderAPI;

import org.json.JSONObject;

/**
 * 管理transsdk config
 */
public class TransConfigManager {
	private final static String TAG = "cfg_TransConfigManager";
	private final static String ARGO_CONFIG_KEY_COMMON_CONFIG = "TransCommonConfig";
	public final static String[] ARGO_CONFIG_KEYS = {
			ARGO_CONFIG_KEY_COMMON_CONFIG,
	};

	private TransConfigManager() {
	}

	private static class SingletonHolder {
		private static final TransConfigManager INSTANCE = new TransConfigManager();
	}

	public static TransConfigManager instance() {
		return SingletonHolder.INSTANCE;
	}

	public void onConfig(String key, String config) {
		if (key == null || config == null || config.isEmpty()) {
			return;
		}
		if (key.equals(ARGO_CONFIG_KEY_COMMON_CONFIG)) {
			parseCommonConfig(config);
		}
	}

	private void parseCommonConfig(final String config) {
		if (config == null || config.isEmpty()) {
			return;
		}
		final HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
		try {
			JSONObject configJson = new JSONObject(config);
			Iterator iterator = configJson.keys();
			while (iterator.hasNext()) {
				String keyStr = iterator.next().toString();
				int key = (int) Long.parseLong(keyStr);
				int val = (int) configJson.getLong(keyStr);
				result.put(key, val);
				Log.d(TAG, String.format("key:%d, val:%d", key, val));
			}
		} catch (Exception e) {
			Log.d(TAG, "error" + e.toString());
			return;
		}

		new Thread(new Runnable() {
			@Override
			public void run() {
				ThunderAPI.sharedInstance().setArgoConfig(result);
			}
		}).start();

	}
}

