package com.yy.yylivesdk4cloud.audio;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;

import com.yy.yylivesdk4cloud.helper.ThunderLog;

import org.json.JSONArray;
import org.json.JSONObject;


public class AudioJsonParseImp implements IAudioJsonParseInterface {
    private final static String TAG = "AudioJsonParseImp";
    private HandlerThread mProcessAudioJsonParseThread;
    private Handler mProcessAudioJsonParseHandler;
    private IAudioConfigCallbackInterface mCallback;
    private boolean mReady = false;

    private static final int MESSAGE_AUDIO_ENCODE_CONFIG = 0;
    private static final int MESSAGE_AUDIO_PREPROC_CONFIG = 1;
    private static final int MESSAGE_AUDIO_OPENSLES_CONFIG = 2;
    private static final int MESSAGE_AUDIO_DEVICE_MODE_CONFIG = 3;
    private static final int MESSAGE_AUDIO_KARAOKE_COMP_CONFIG = 4;
	private static final int MESSAGE_AUDIO_EFFECT_CONFIG = 5;

    public AudioJsonParseImp(IAudioConfigCallbackInterface callback ) {
        mCallback = callback;
        mProcessAudioJsonParseThread = new HandlerThread("AudioJsonParseThread");
        mProcessAudioJsonParseThread.start();
        mProcessAudioJsonParseHandler = new Handler(mProcessAudioJsonParseThread.getLooper()){
            @Override
            public void handleMessage(Message msg) {
                if (!mReady) {
                    ThunderLog.warn(TAG, " ProcessAudioJsonParseHandler not Ready !");
                    return;
                }

                try {
                    String data = (String) msg.obj;
                    switch (msg.what) {
                        case MESSAGE_AUDIO_ENCODE_CONFIG:
                            handleParseAudioEncodeConfig(data);
                            break;
                        case MESSAGE_AUDIO_PREPROC_CONFIG:
                            handleParseAudioPreProcConfig(data);
                            break;
                        case MESSAGE_AUDIO_OPENSLES_CONFIG:
                            handleParseAudioOpenSlEsConfig(data);
                            break;
                        case MESSAGE_AUDIO_DEVICE_MODE_CONFIG:
                            handleParseAudioDeviceModeConfig(data);
                            break;
                        case MESSAGE_AUDIO_KARAOKE_COMP_CONFIG:
                            handleParseAudioKaraokeCompConfig(data);
                            break;
						case MESSAGE_AUDIO_EFFECT_CONFIG:
                            handleParseAudioEffectConfig(data);
                            break;
                        default:
                            break;
                    }
                }catch (Exception e){
                    ThunderLog.error(TAG, " mProcessAudioJsonParseHandler deal error :"+ e.toString());
                }
            }
        };
        mReady = true;
    }

    private void handleParseAudioEncodeConfig(final String response) {
        //服务器下发配置为空，立刻清空配置
        if (response.length() == 0) {
            if(mCallback != null){
                mCallback.notifyAudioEncodeJsonConfigResult(null);
            }
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(response);
            JSONArray jsonArray = jsonObject.optJSONArray("codecConfig");

            JSONObject item;
            AudioCodecConfig[] configs = new AudioCodecConfig[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); i++) {
                AudioCodecConfig config = new AudioCodecConfig();
                item = jsonArray.getJSONObject(i);
                config.codecId = item.optInt("codecId");
                config.bitRate = item.optInt("bitRate");
                config.sampleRate = item.optInt("sampleRate");
                config.channels = item.optInt("channels");
                configs[i] = config;
            }
            if(mCallback != null){
                mCallback.notifyAudioEncodeJsonConfigResult(configs);
            }else {
                ThunderLog.error(TAG," handlderParseAudioEncodeConfig no callback");
            }
        }catch (Exception e){
            ThunderLog.error(TAG, " handlderParseAudioEncodeConfig error :" + e.toString());
        }
    }

    private void handleParseAudioPreProcConfig(final String response) {
        //服务器下发配置为空，立刻清空配置
        if (response.length() == 0) {
            if(mCallback != null){
                mCallback.notifyAudioPreProcJsonConfigResult(null);
            }
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(response);
            JSONArray jsonArray = jsonObject.optJSONArray("preProcConfig");

            JSONObject item;
            AudioPreProcConfig[] configs = new AudioPreProcConfig[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); i++) {
                AudioPreProcConfig config = new AudioPreProcConfig();
                item = jsonArray.getJSONObject(i);
                config.sceneId = item.optInt("sceneId");
                config.aec = item.optInt("aec");
                config.agc = item.optInt("agc");
                config.vad = item.optInt("vad");
                configs[i] = config;
            }
            if(mCallback != null){
                mCallback.notifyAudioPreProcJsonConfigResult(configs);
            }else {
                ThunderLog.error(TAG," handleParseAudioPreProcConfig no callback");
            }
        }catch (Exception e){
            ThunderLog.error(TAG, " handleParseAudioPreProcConfig error :" + e.toString());
        }
    }

    private void handleParseAudioOpenSlEsConfig(final String response) {
        //服务器下发配置为空，立刻清空配置
        if (response.length() == 0) {
            if (mCallback != null) {
                mCallback.notifyAudioOpenSlEsJsonConfigResult(null);
            }
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(response);
            JSONArray jsonArray = jsonObject.optJSONArray("openslesConfig");

            JSONObject item;
            AudioOpenSlEsConfig[] configs = new AudioOpenSlEsConfig[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); i++) {
                AudioOpenSlEsConfig config = new AudioOpenSlEsConfig();
                item = jsonArray.getJSONObject(i);
                config.inputNumSLBuffer = item.optInt("inputNumSLBuffer");
                config.inputNum10msBuffer = item.optInt("inputNum10msBuffer");
                config.outputNumSLBuffer = item.optInt("outputNumSLBuffer");
                config.outputNum10msBuffer = item.optInt("outputNum10msBuffer");
                config.openslesPlayerBuffers = item.optInt("openslesPlayerBuffers");
                config.enableOpenSlEsOutputNewLogic = item.optBoolean("openslesOutputNewLogic");
                configs[i] = config;
            }
            if (mCallback != null) {
                mCallback.notifyAudioOpenSlEsJsonConfigResult(configs);
            }else {
                ThunderLog.error(TAG," handleParseAudioOpenSlEsConfig no callback");
            }
        } catch (Exception e) {
            ThunderLog.error(TAG, " handleParseAudioOpenSlEsConfig error :" + e.toString());
        }
    }


    private void handleParseAudioDeviceModeConfig(String response) {
        //服务器下发配置为空，立刻清空配置
        if (response.length() == 0) {
            if(mCallback != null){
                mCallback.notifyAudioDeviceModeJsonConfigResult(null);
            }
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(response);
            JSONArray jsonArray = jsonObject.optJSONArray("deviceModeConfig");

            JSONObject item;
            AudioDeviceModeConfig[] configs = new AudioDeviceModeConfig[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); i++) {
                AudioDeviceModeConfig config = new AudioDeviceModeConfig();
                item = jsonArray.getJSONObject(i);
                config.audioLoudMode = item.optInt("audioLoudMode");
                config.inputLoudStreamType = item.optInt("inputLoudStreamType");
                config.outputLoudStreamType = item.optInt("outputLoudStreamType");
                config.audioMode = item.optInt("audioMode");
                config.inputStreamType = item.optInt("inputStreamType");
                config.outputStreamType = item.optInt("outputStreamType");
                config.audioHDMode = item.optInt("audioHDMode");
                config.inputHDStreamType = item.optInt("inputHDStreamType");
                config.outputHDStreamType = item.optInt("outputHDStreamType");
                config.openScraPreduction = item.optInt("openScraPreduction");
                config.useJavaInputOpenslesOutput = item.optInt("useJavaInputOpenslesOutput");
                config.oldSoftAecLogicOnLiveBroadcast = item.optInt("oldSoftAecLogicOnLiveBroadcast");
                configs[i] = config;
            }
            if(mCallback != null){
                mCallback.notifyAudioDeviceModeJsonConfigResult(configs);
            }else {
                ThunderLog.error(TAG," handleParseAudioDeviceModeConfig no callback");
            }
        } catch (Exception e){
            ThunderLog.error(TAG, " handleParseAudioDeviceModeConfig error :" + e.toString());
        }
    }

    private void handleParseAudioKaraokeCompConfig(String response) {
        //服务器下发配置为空，立刻清空配置
        if (response.length() == 0) {
            if(mCallback != null){
                mCallback.notifyAudioKaraokeCompJsonConfigResult(null);
            }
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(response);
            JSONArray jsonArray = jsonObject.optJSONArray("karaokeCompConfig");

            JSONObject item;
            AudioKaraokeCompensateConfig[] configs = new AudioKaraokeCompensateConfig[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); i++) {
                AudioKaraokeCompensateConfig config = new AudioKaraokeCompensateConfig();
                item = jsonArray.getJSONObject(i);
                config.compValue = item.optInt("compValue");
                configs[i] = config;
            }
            if(mCallback != null){
                mCallback.notifyAudioKaraokeCompJsonConfigResult(configs);
            }else {
                ThunderLog.error(TAG," handleParseAudioKaraokeCompConfig no callback");
            }
        } catch (Exception e){
            ThunderLog.error(TAG, " handleParseAudioKaraokeCompConfig error :" + e.toString());
        }
    }

    private void handleParseAudioEffectConfig(String response) {
        //服务器下发配置为空，立刻清空配置
        if (response.length() == 0) {
            if(mCallback != null){
                mCallback.notifyAudioEffectJsonConfigResult(null);
            }
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(response);
            boolean useHighProfile = jsonObject.optBoolean("useHighProfile");
            AudioEffectConfig[] configs = null;
            if (useHighProfile) {
                JSONArray jsonArray = jsonObject.optJSONArray("effectConfig_high");
                JSONObject item;
                configs = new AudioEffectConfig[jsonArray.length()];
                for (int i = 0; i < jsonArray.length(); i++) {
                    AudioEffectConfig config = new AudioEffectConfig();
                    item = jsonArray.getJSONObject(i);

                    JSONArray jsonArr;
                    jsonArr = item.getJSONArray("Reverb");
                    for(int index = 0; index < jsonArr.length(); index++) {
                        config.reverbHigh[index] = Float.valueOf(jsonArr.get(index).toString());
                    }

                    jsonArr = item.getJSONArray("EQ");
                    for(int index = 0; index < jsonArr.length(); index++) {
                        config.eqgainHigh[index] = Float.valueOf(jsonArr.get(index).toString());
                    }

                    jsonArr = item.getJSONArray("Limiter");
                    for(int index = 0; index < jsonArr.length(); index++) {
                        config.limiterHigh[index] = Float.valueOf(jsonArr.get(index).toString());
                    }
                    config.id = item.optInt("id");
                    config.useHighProfile = true;
                    configs[i] = config;
                }
            } else {
                JSONArray jsonArray = jsonObject.optJSONArray("effectConfig_low");
                JSONObject item;
                configs = new AudioEffectConfig[jsonArray.length()];
                for (int i = 0; i < jsonArray.length(); i++) {
                    AudioEffectConfig config = new AudioEffectConfig();
                    item = jsonArray.getJSONObject(i);

                    JSONArray jsonArr;
                    jsonArr = item.getJSONArray("Reverb");
                    for(int index = 0; index < jsonArr.length(); index++) {
                        config.reverbLow[index] = Float.valueOf(jsonArr.get(index).toString());
                    }

                    jsonArr = item.getJSONArray("EQ");
                    for(int index = 0; index < jsonArr.length(); index++) {
                        config.eqgainLow[index] = Float.valueOf(jsonArr.get(index).toString());
                    }

                    jsonArr = item.getJSONArray("Limiter");
                    for(int index = 0; index < jsonArr.length(); index++) {
                        config.limiterLow[index] = Float.valueOf(jsonArr.get(index).toString());
                    }
                    config.id = item.optInt("id");
                    config.useHighProfile = false;
                    configs[i] = config;
                }
            }

            if(mCallback != null){
                mCallback.notifyAudioEffectJsonConfigResult(configs);
            }else {
                ThunderLog.error(TAG," handleParseAudioEffectConfig no callback");
            }
        } catch (Exception e){
            ThunderLog.error(TAG, " handleParseAudioEffectConfig error :" + e.toString());
        }
    }

    @Override
    public void parseAudioEncodeConfig(String response) {
        if(mReady){
            Message msg = Message.obtain();
            msg.what = MESSAGE_AUDIO_ENCODE_CONFIG;
            msg.obj = response;
            mProcessAudioJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseAudioPreProcConfig(String response) {
        if(mReady){
            Message msg = Message.obtain();
            msg.what = MESSAGE_AUDIO_PREPROC_CONFIG;
            msg.obj = response;
            mProcessAudioJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseAudioOpensSlEsConfig(String response) {
        if(mReady){
            Message msg = Message.obtain();
            msg.what = MESSAGE_AUDIO_OPENSLES_CONFIG;
            msg.obj = response;
            mProcessAudioJsonParseHandler.sendMessage(msg);
        }
    }
    @Override
    public void parseAudioDeviceModeConfig(String response) {
        if(mReady){
            Message msg = Message.obtain();
            msg.what = MESSAGE_AUDIO_DEVICE_MODE_CONFIG;
            msg.obj = response;
            mProcessAudioJsonParseHandler.sendMessage(msg);
        }
    }
    @Override
    public void parseAudioKaraokeCompConfig(String response) {
        if(mReady){
            Message msg = Message.obtain();
            msg.what = MESSAGE_AUDIO_KARAOKE_COMP_CONFIG;
            msg.obj = response;
            mProcessAudioJsonParseHandler.sendMessage(msg);
        }
    }

    @Override
    public void parseAudioEffectConfig(String response) {
        if(mReady){
            Message msg = Message.obtain();
            msg.what = MESSAGE_AUDIO_EFFECT_CONFIG;
            msg.obj = response;
            mProcessAudioJsonParseHandler.sendMessage(msg);
        }
    }
}
