package com.yy.yylivesdk4cloud;

/**
 * Created by xiongxiong on 2017/11/1.
 */

public class ThunderStream {
	/**
	 * 此流所属的appId, 无符号32位
	 */
	public long appId;
	/**
	 * 流名称
	 */
	public String streamName;
	/**
	 * 渲染的目标view，只对视频生效<br/>
	 * 使用渲染组件 {@link ThunderPlayerView}
	 */
	public Object toView;
	/**
	 * 渲染模式，只对视频生效 {@link ThunderConstant.ThunderVideoViewScaleMode}
	 */
	public int scaleMode;
	/**
	 * 音频or视频
	 */
	public boolean bVideo;
	/**
	 * 开播此流的主播uid, 无符号32位
	 */
	public long speakerUid;

	/**
	 * 线路 通过通知kYYLiveAPINotification_StreamStatusInfo获取播放时候才需要设置
	 */
	public int lineSeq = -1;

	/**
	 * 只判断appId 和 streamName 是否相等
	 *
	 * @param other 待比较的流
	 */
	public boolean isEqualToStream(ThunderStream other) {
		return (this.appId == other.appId) && (this.streamName.equals(other.streamName));
	}
}
