package com.yy.yylivesdk4cloud;

public final class ThunderRtcConstant {
    public ThunderRtcConstant(){
    }

    public static final class RoomConfig {
        public static final int THUNDER_ROOMCONFIG_LIVE = 0; //直播 （音质高、交互模式无）（连麦时切换到音质中、交互模式强）
        public static final int THUNDER_ROOMCONFIG_COMMUNICATION = 1; //通信 （音质中、交互模式强）
        public static final int THUNDER_ROOMCONFIG_GAME = 3; //游戏 （音质低、交互模式强）
        public static final int THUNDER_ROOMCONFIG_MULTIAUDIOROOM = 4; //多人语音房间 （音质中、省流量、交互模式强）

        public RoomConfig(){
        }
    }

    public static final class AudioConfig {
        public static final int THUNDER_AUDIO_CONFIG_DEFAULT = 0; //默认设置。通信模式下为 1，直播模式下为 2
        public static final int THUNDER_AUDIO_CONFIG_SPEECH_STANDARD = 1; //指定 16 KHz采样率，语音编码, 单声道，编码码率约 18 kbps, SILK
        public static final int THUNDER_AUDIO_CONFIG_MUSIC_STANDARD_STEREO = 2; //指定 44.1 KHz采样率，音乐编码, 双声道，编码码率约 24 kbps，编码延迟高,EAAC+
        public static final int THUNDER_AUDIO_CONFIG_MUSIC_STANDARD = 3; //指定 44.1 KHz采样率，音乐编码, 双声道，编码码率约 40 kbps，编码延迟低,ELD AAC
        public static final int THUNDER_AUDIO_CONFIG_MUSIC_HIGH_QUALITY_STEREO = 4; //指定 44.1KHz采样率，音乐编码, 双声道，编码码率约 128kbps,AAC LC
        public static final int THUNDER_AUDIO_CONFIG_MUSIC_HIGH_QUALITY_STEREO_192 = 5; //指定 44.1KHz采样率，音乐编码, 双声道，编码码率约 192kbps
    }

    public static final class CommutMode {
        public static final int THUNDER_COMMUT_MODE_DEFAULT = 0; //默认=1
        public static final int THUNDER_COMMUT_MODE_HIGH = 1; //强交互模式
        public static final int THUNDER_COMMUT_MODE_LOW = 2; //弱交互模式
    }



    public static final class ScenarioMode {
        public static final int THUNDER_SCENARIO_MODE_DEFAULT = 0; //默认=1
        public static final int THUNDER_SCENARIO_MODE_STABLE_FIRST = 1; //流畅优先：推荐注重稳定的教育
        public static final int THUNDER_SCENARIO_MODE_QUALITY_FIRST = 2; //音质优先：推荐很少或者不连麦的秀场
    }



    public static final class LogLevel {
        public static final int THUNDER_LOG_LEVEL_TRACE = 0;
        public static final int THUNDER_LOG_LEVEL_DEBUG = 1;
        public static final int THUNDER_LOG_LEVEL_INFO = 2;
        public static final int THUNDER_LOG_LEVEL_WARN = 3;
        public static final int THUNDER_LOG_LEVEL_ERROR = 4;

        public LogLevel() {
        }
    }

    public static final class AreaType{
        public static final int THUNDER_AREA_DEFAULT = 0; //默认值(国内)
        public static final int THUNDER_AREA_FOREIGN = 1; //国外
        public static final int THUNDER_AREA_RESERVED = 2; //yy-reserved
    }

    public static final class AuthResult{
        public static final int THUNDER_AUTHRES_SUCCUSS = 0;     //鉴权成功
        public static final int THUNDER_AUTHRES_ERR_SERVER_INTERNAL = 10000; //服务器内部错误，可以重试
        public static final int THUNDER_AUTHRES_ERR_NO_TOKEN = 10001; //没有带token，需要调用[ThunderAPI updateToken:]
        public static final int THUNDER_AUTHRES_ERR_TOKEN_ERR = 10002; //token校验失败（数字签名不对），可能使用的appSecret不对
        public static final int THUNDER_AUTHRES_ERR_APPID = 10003; //token中appid跟鉴权时带的appid不一致
        public static final int THUNDER_AUTHRES_ERR_UID = 10004; //token中uid跟鉴权时带的uid不一致
        public static final int THUNDER_AUTHRES_ERR_TOKEN_EXPIRE = 10005; //token已过期
        public static final int THUNDER_AUTHRES_ERR_NO_APP = 10006; //app不存在，没有在管理后台注册
        public static final int THUNDER_AUTHRES_ERR_TOKEN_WILL_EXPIRE = 10007; //token即将过期
        public static final int THUNDER_AUTHRES_ERR_BAND = 10008; //用户被封禁
    }

    public static final class UserOfflineReason {
        public static final int THUNDER_OFFLINE_QUIT = 1;     			// 用户主动离开
        public static final int THUNDER_OFFLINE_DROPPED = 2;     		// 因过长时间收不到对方数据包，超时掉线。注意：由于 SDK 使用的是不可靠通道，也有可能对方主动离开本方没收到对方离开消息而误判为超时掉线
        public static final int THUNDER_OFFLINE_BECOME_AUDIENCE = 3;     // 用户身份从主播切换为观众（直播模式下）
    }

    public static final class NetworkQuality {
        public static final int THUNDER_QUALITY_UNKNOWN = 0;        // 质量未知
        public static final int THUNDER_QUALITY_EXCELLENT = 1;        // 网络质量极好
        public static final int THUNDER_QUALITY_GOOD = 2;        // 网络质量好
        public static final int THUNDER_QUALITY_POOR = 3;        // 网络质量较好，用户感受有瑕疵但不影响沟通
        public static final int THUNDER_QUALITY_BAD = 4;        // 网络质量一般，勉强能沟通但不顺畅
        public static final int THUNDER_QUALITY_VBAD = 5;        // 网络质量非常差，基本不能沟通
    }

    public static final class SourceType {
        public static final int THUNDER_PUBLISH_MODE_MIC = 0; //麦克风
        public static final int THUNDER_PUBLISH_MODE_FILE = 1; //文件
        public static final int THUNDER_PUBLISH_MODE_MIX = 2; //文件+麦克风
        public static final int THUNDER_PUBLISH_MODE_NONE = 10; // 停止所有音频数据上行
        public SourceType(){
        }
    }

    public static final class SoundEffectMode{
        public static final int THUNDER_SOUND_EFFECT_MODE_NONE = 0; //关闭模式
        public static final int THUNDER_SOUND_EFFECT_MODE_VALLEY = 1; //VALLEY模式
        public static final int THUNDER_SOUND_EFFECT_MODE_RANDB = 2; //R&B模式
        public static final int THUNDER_SOUND_EFFECT_MODE_KTV = 3; //KTV模式
        public static final int THUNDER_SOUND_EFFECT_MODE_CHARMING = 4; // CHARMING模式
        public static final int THUNDER_SOUND_EFFECT_MODE_POP = 5; // 流行模式
        public static final int THUNDER_SOUND_EFFECT_MODE_HIPHOP = 6; // 嘻哈模式
        public static final int THUNDER_SOUND_EFFECT_MODE_ROCK = 7; // 摇滚模式
        public static final int THUNDER_SOUND_EFFECT_MODE_CONCERT = 8; // 演唱会模式
        public static final int THUNDER_SOUND_EFFECT_MODE_STUDIO = 9; // 录音棚模式
        public SoundEffectMode(){
        }
    }

    public static final class VoiceChangerMode{
        public static final int THUNDER_VOICE_CHANGER_MODE_NONE = 0; //关闭模式
        public static final int THUNDER_VOICE_CHANGER_MODE_ETHEREAL = 1; //空灵
        public static final int THUNDER_VOICE_CHANGER_MODE_THRILLER = 2; //惊悚
        public static final int THUNDER_VOICE_CHANGER_MODE_LUBAN  = 3; //鲁班
        public static final int THUNDER_VOICE_CHANGER_MODE_LORIE = 4; // 萝莉
        public static final int THUNDER_VOICE_CHANGER_MODE_UNCLE = 5; // 大叔
        public static final int THUNDER_VOICE_CHANGER_MODE_DIEFAT = 6; // 死肥仔
        public static final int THUNDER_VOICE_CHANGER_MODE_BADBOY = 7; // 熊孩子
        public static final int THUNDER_VOICE_CHANGER_MODE_WRACRAFT = 8; // 魔兽农民
        public static final int THUNDER_VOICE_CHANGER_MODE_HEAVYMETAL = 9; // 重金属
        public static final int THUNDER_VOICE_CHANGER_MODE_COLD = 10; // 感冒
        public static final int THUNDER_VOICE_CHANGER_MODE_HEAVYMECHINERY = 11; // 重机械
        public static final int THUNDER_VOICE_CHANGER_MODE_TRAPPEDBEAST = 12; // 困兽
        public static final int THUNDER_VOICE_CHANGER_MODE_POWERCURRENT = 13; // 强电流
        public VoiceChangerMode(){
        }
    }
	
	 public static final class AudioSaverMode{
        public static final int THUNDER_AUDIO_SAVER_ONLY_CAPTURE = 0; //只保存频道内所有的上行的音频数据。上行的音频数据指的是：无论是主播的音频数据还是是伴奏的音频数据，只有被设置成上行，才被保存
        public static final int THUNDER_AUDIO_SAVER_ONLY_RENDER = 1; //保存除主播以外的音频数据，例如伴奏的音频数据和观众端的音频数据
        public static final int THUNDER_AUDIO_SAVER_BOTH = 2; //保存所有的音频数据

        public AudioSaverMode(){
        }
    }

    public static final class AudioSaverWfMode{
        public static final int THUNDER_AUDIO_SAVER_FILE_APPEND = 0; //追加打开一个文本文件，并在文件末尾写数据
        public static final int THUNDER_AUDIO_SAVER_FILE_OVERRIDE = 1; //打开一个文本文件，写入的数据会覆盖文件本身的内容

        public AudioSaverWfMode(){
        }
    }

    public static final class ThunderAudioRawFrameOperationMode {

        public static final int THUNDER_AUDIO_RAW_FRAME_OPERATION_MODE_READ_ONLY = 1;  //只读模式，用户仅从 AudioFrame 获取原始音频数据
        public static final int THUNDER_AUDIO_RAW_FRAME_OPERATION_MODE_WRITE_ONLY = 2; //只写模式，用户替换 AudioFrame 中的数据以供 Thunder SDK 编码传输
        public static final int THUNDER_AUDIO_RAW_FRAME_OPERATION_MODE_READ_WRITE = 3; //读写模式，用户从 AudioFrame 获取并修改数据，并返回给 Thunder SDK 进行编码传输

        public ThunderAudioRawFrameOperationMode() {

        }
    }
}