package com.yy.yylivesdk4cloud;


/**
 * Created by xiongxiong on 2017/10/31.
 */

public class ThunderPublishVideoConfig {
	/**
	 * 玩法 playType
	 */
	public static final int YYPUBLISH_PLAYTYPE_SINGLE = 0;             //单人开播
	public static final int YYPUBLISH_PLAYTYPE_LIANMAI = 1;        	   //连麦
	//public static final int YYPUBLISH_PLAYTYPE_LIANMAI_2st = 2;        //连麦 二麦开播
	public static final int YYPUBLISH_PLAYTYPE_ACROSS      = 3;        //跨直播间连麦
	public static final int YYPUBLISH_PLAYTYPE_ARENA_CROSS = 4;        //竞技场跨频道直播
	public static final int YYPUBLISH_PLAYTYPE_SCREEN_CAPTURE = 5;     //手游录屏
	public static final int YYPUBLISH_PLAYTYPE_MULIT_LIVE  = 6;        // 多人音视频房主开播
	public static final int YYPUBLISH_PLAYTYPE_MULIT_LIVE_LIANMAI = 7; // 多人音视频连麦开播
	public static final int YYPUBLISH_PLAYTYPE_ONE_TO_ONE  = 8;        //一对一音视频聊天

	/**	 * 预设帧率，[1,30]，<= 预览时设置的采集帧率	 * <br>实际开播过程中可能会根据网络情况有所调整，
	 * <br>可以监听{@link ThunderNotification#kYYLiveAPINotification_PublishRunTimeInfo}得到实际帧率
	 */
	public int encodeFrameRate;

	/**
	 * 初始码率，单位：bps
	 * <br>实际开播过程中可能会根据网络情况有所调整，
	 * <br>可以监听{@link ThunderNotification#kYYLiveAPINotification_PublishRunTimeInfo}得到实际码率
	 */
	public int encodeBitrate;

	/**
	 * 编码分辨率 - 宽
	 */
	public int encodeResolutionWidth;

	/**
	 * 编码分辨率 - 高
	 */
	public int encodeResolutionHeight;
	/**
	 * 编码类型 {@link ThunderConstant.ThunderVideoEncodeType}
	 */
	public int encodeType;
	/**
	 * 是否使用硬编
	 */
	public boolean hardwareEncoder;
	/**
	 * 前置摄像头编码镜像，默认为false
	 * <br> false - 观众和主播看到的画面相反
	 * <br> true - 观众和主播看到的画面相同
	 */
	public boolean mirrorFrontCamera;
	/**
	 * 是否同时开播到流名称，默认为false
	 * <br> true - 开播到群组的同时也开播到流名称
	 * <br> false - 开播时填了群组则只开播到群组不开播到流名称
	 */
	public boolean pubToGroupAndName;
	/**
	 * 开播模式，默认为-1
	 */
	public int mode;
	/**
	 * 玩法
	 */
	public int playType;
	/**
	 * 横屏竖屏
	 */
	public int screenOrientation;

	public ThunderPublishVideoConfig() {
		this.hardwareEncoder = true;
		this.mirrorFrontCamera = false;
		this.pubToGroupAndName = false;
		this.mode = -1;
		this.playType = ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_SINGLE;	//单人开播玩法
		this.screenOrientation = ThunderConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_PORTRAIT;
	}

	/**
	 * 输出字符串形式的配置信息
	 * @return 返回字符串形式的配置信息，用于日志输出
	 */
	@Override
	public String toString() {
		return	"{encW=" + this.encodeResolutionWidth +
				" encH=" + this.encodeResolutionHeight +
				" fps=" + this.encodeFrameRate +
				" bitrate=" + this.encodeBitrate +
				" encType=" + this.encodeType +
				" hard=" + this.hardwareEncoder +
				" mirror=" + this.mirrorFrontCamera +
				" pubToGroupAndName=" + this.pubToGroupAndName +
				" mdoe=" + this.mode +
				" playType=" + this.playType +
				"}";
	}
}
