package com.yy.yylivesdk4cloud;

import android.graphics.Bitmap;
import android.graphics.Rect;

import com.yy.mediaframework.gpuimage.custom.OrangeFilterWrapper;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * Created by aoe on 2018/12/19.
 */

 class ThunderPublishRoomImp implements ThunderPublishRoom {
    private ThunderVideoCapture mVideoCapture = null;
    private ThunderAudioCapture mAudioCapture = null;
    private ThunderDefaultCamera mDefaultCamera = new ThunderDefaultCamera();
    private ThunderDefaultMic mDefaultMic = new ThunderDefaultMic();

    private String mChannelId = null;
    private String mUidString = null;
    private long mUid = 0;
    private boolean mOwner = false;
    private boolean mPublishing = false;
    private boolean mAudioOnly = false;
    private int mPublishMode = ThunderConstant.ThunderPublishVideoMode.THUNDERPUBLISH_VIDEO_MODE_DEFAULT;
    private int mPlayType = ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_SINGLE;
    private int mCamaraPosition = ThunderConstant.ThunderCameraPosition.THUNDERCAMERA_POSITION_FRONT;
    private int mPubOrientation = ThunderConstant.ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_PORTRAIT;

    public int startPreview(Object view, int playType, int publishMode) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }
        if (mVideoCapture == null) {
            this.attachVideoCapture(mDefaultCamera);
        }
        ThunderLog.info(ThunderLog.kLogTagCall, "startPreview view:%s", view.toString());
        int convertType = convertPlayType(playType);
        return ThunderNative.startVideoPreview(view, convertType, publishMode);
    }


    public int stopPreview() {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }
        ThunderLog.info(ThunderLog.kLogTagCall, "stopVideoPreview");
        return ThunderNative.stopVideoPreview();
    }

    public int startLiveInteract(ThunderLayout layout) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }
        if (mChannelId == null) {
            ThunderLog.info(ThunderLog.kLogTagCall, "startLiveInteract channelId null");
            return -1;
        }
        if (layout == null) {
            ThunderLog.info(ThunderLog.kLogTagCall, "startLiveInteract layout error");
            return -1;
        }
        if (layout.layouts.size() == 0 || layout.speakers.size() == 0) {
            ThunderLog.info(ThunderLog.kLogTagCall, "startLiveInteract param error");
            return -1;
        }

        mAudioOnly = false;
        mPlayType = ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_INTERACT;
        ThunderPublishVideoConfig videoConfig = convertVideoConfig();
        ThunderPublishAudioConfig audioConfig = convertAudioConfig();
        if (layout.layouts.size() == 1) { //同频道
            ThunderRoomlLayout channelLayout = layout.layouts.get(0);
            if (mPublishing) {
                ThunderNative.updatePublishLive(channelLayout.channelId, true,  videoConfig, audioConfig, layout);
            } else {
                mPublishing = true;
                if (mAudioCapture == null) {
                    ThunderNative.attachAudioCapture(mDefaultMic);
                }
                ThunderNative.startPublishLive(channelLayout.channelId, true, videoConfig, audioConfig, layout);
            }
            mOwner = channelLayout.owner;
        }else { //跨频道
            for (ThunderRoomlLayout channelLayout : layout.layouts) {
                ThunderLayout liveLayout = convertLayout(layout, channelLayout);
                ThunderNative.updatePublishLive(channelLayout.channelId, false, videoConfig, audioConfig, liveLayout);
            }
            mOwner = true;
        }

        ThunderLog.info(ThunderLog.kLogTagCall, "startLiveInteract %s", layout.toString());
        return 0;
    }

    public int stopLiveInteract() {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }

        ThunderLog.info(ThunderLog.kLogTagCall, "stopLiveInteract %b", mOwner);
        if (mOwner) {
            mAudioOnly = false;
            mPlayType = ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_SINGLE;
            ThunderPublishVideoConfig videoConfig = convertVideoConfig();
            ThunderPublishAudioConfig audioConfig = convertAudioConfig();
            ThunderLayout layout = makeLayout(null);
            return ThunderNative.updatePublishLive(mChannelId, false, videoConfig, audioConfig, layout);
        }else {
            return stopSinglePublish();
        }
    }

    public int startAudioInteract(ArrayList<String> speakers) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }
        if (mChannelId == null) {
            ThunderLog.info(ThunderLog.kLogTagCall, "startAudioInteract channelId null");
            return -1;
        }
        if (speakers == null) {
            ThunderLog.info(ThunderLog.kLogTagCall, "startAudioInteract speakers error");
            return -1;
        }
        mAudioOnly = true;
        mPlayType = ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_INTERACT;
        ThunderPublishVideoConfig videoConfig = convertVideoConfig();
        ThunderPublishAudioConfig audioConfig = convertAudioConfig();
        ThunderLayout layout = makeLayout(speakers);
        if (mPublishing) {
            ThunderNative.updatePublishLive(mChannelId, true,  videoConfig, audioConfig, layout);
        } else {
            mPublishing = true;
            if (mAudioCapture == null) {
                ThunderNative.attachAudioCapture(mDefaultMic);
            }
            ThunderNative.startPublishLive(mChannelId, true, videoConfig, audioConfig, layout);
        }
        ThunderRoomlLayout channelLayout = layout.getChannelLayout(0);
        mOwner = channelLayout.owner;
        return 0;
    }

    public int stopAudioInteract() {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }

        ThunderLog.info(ThunderLog.kLogTagCall, "stopAudioInteract %b", mOwner);
        if (mOwner) {
            mAudioOnly = false;
            mPlayType = ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_SINGLE;
            ThunderPublishVideoConfig videoConfig = convertVideoConfig();
            ThunderPublishAudioConfig audioConfig = convertAudioConfig();
            ThunderLayout layout = makeLayout(null);
            return ThunderNative.updatePublishLive(mChannelId, false, videoConfig, audioConfig, layout);
        }else {
            return stopSinglePublish();
        }
    }

    public int startSinglePublish(int playType, int publishMode) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }
        if (mChannelId == null) {
            ThunderLog.info(ThunderLog.kLogTagCall, "startPublish channelId null");
            return -1;
        }

        mPlayType = playType;
        mPublishMode = publishMode;
        mPublishing = true;
        mAudioOnly = false;

        if (mAudioCapture == null) {
            ThunderNative.attachAudioCapture(mDefaultMic);
        }

        ThunderPublishVideoConfig videoConfig = convertVideoConfig();
        ThunderPublishAudioConfig audioConfig = convertAudioConfig();
        ThunderLayout layout = makeLayout(null);

        ThunderLog.info(ThunderLog.kLogTagCall, "startPublish %s", layout.toString());
        return ThunderNative.startPublishLive(mChannelId, false, videoConfig, audioConfig, layout);
    }

    public int stopSinglePublish() {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }
        ThunderLog.info(ThunderLog.kLogTagCall, "stopPublish %s", mChannelId);
        if (mChannelId == null) {
            return 0;
        }

        mPublishing = false;
        mOwner = false;
        mAudioOnly = false;
        return ThunderNative.stopPublishLive(mChannelId);
    }

    public int updatePublishMode(int publishMode) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }

        if (mPublishMode == publishMode) {
            ThunderLog.info(ThunderLog.kLogTagCall, "updatePublishMode ignore same");
            return 0;
        }
        if (!mPublishing) {
            mPublishMode = publishMode;
            ThunderLog.info(ThunderLog.kLogTagCall, "updatePublishMode not publishing");
            return 0;
        }

        boolean bSuport = false;
        int convertType = convertPlayType(mPlayType);
        HashMap<Integer, String> modeMap = ThunderNative.getSupportModeInfoWithPlayType(convertType);
        if (modeMap.size() == 0) {
            ThunderLog.info(ThunderLog.kLogTagCall, "updatePublishMode empty");
            return -1;
        }
        for (Integer key : modeMap.keySet()) {
            if (key == publishMode) {
                bSuport = true;
                break;
            }
        }
        if (bSuport) {
            mPublishMode = publishMode;
            ThunderPublishVideoConfig videoConfig = convertVideoConfig();
            if (mPlayType == ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_INTERACT) {
                ThunderNative.updateVideoConfig(videoConfig);
                return 0;
            }
            ThunderPublishAudioConfig audioConfig = convertAudioConfig();
            ThunderLayout layout = makeLayout(null);
            ThunderNative.updatePublishLive(mChannelId, false, videoConfig, audioConfig, layout);
        }
        ThunderLog.info(ThunderLog.kLogTagCall, "updatePublishMode %d %b", publishMode, bSuport);
        return 0;
    }

    public HashMap<Integer, String> getPublishMode(int playType) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return null;
        }

        int convertType = convertPlayType(playType);
        return ThunderNative.getSupportModeInfoWithPlayType(convertType);
    }

    public int getDefaultPublishMode(int playType){
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }
        int convertType = convertPlayType(playType);
        return ThunderNative.getDefaultPublishVideoMode(convertType);
    }

    public ThunderPublishInfo getCurrentPublishInfo() {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return null;
        }
        ThunderPublishInfo publishInfo = ThunderNative.getPublishInfo();

        if (publishInfo != null) {
            publishInfo.publishOrientation = mPubOrientation;
            publishInfo.cameraPosition = mCamaraPosition;
        }
        return publishInfo;
    }

    public boolean setCameraPosition(int position) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return false;
        }
        mCamaraPosition = position;
        ThunderLog.info(ThunderLog.kLogTagCall, "setCameraPosition %d", position);
        return ThunderNative.setCameraPosition(position);
    }

    public void setPublishOrientation(int orientation){
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return;
        }
        mPubOrientation = orientation;
        ThunderNative.setOrientation(orientation);
    }

    public int setWatermark(int posX, int posY, Bitmap image) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }

        if (image == null) {
            return -1;
        }
        ThunderLog.info(ThunderLog.kLogTagCall, "setWatermark in (%d,%d)", posX, posY);
        return ThunderNative.setWatermark(posX, posY, image);
    }

    public int setFaceBeautyLevel(float level) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return 0;
        }

        // float保证六位有效数字
        if (level >= 1.000001f) {
            level = 1.0f;
        } else if (level < 0.000001f) {
            level = 0.0f;
        }
        ThunderLog.info(ThunderLog.kLogTagCall, "setFaceBeautyLevel %f", level);
        return ThunderNative.setFaceBeautyLevel(level);
    }

    public boolean setMicVolume(int volume) {
        if (volume < 0) {
            volume  = 0;
        } else if (volume > 100) {
            volume = 100;
        }
        ThunderLog.info(ThunderLog.kLogTagCall, "setMicVolume %d", volume);

        return ThunderNative.setMicVolume(volume);
    }

    public OrangeFilterWrapper getBeautyFilter(){
        return ThunderBridgeLib.getInstance().getBeautyFilter();
    }

    public ThunderDefaultMic getDefaluteMic() {
        if (!BuildConfig.__YY_AUDIO_SUPPORT__) {
            return null;
        }
        return mDefaultMic;
    }

    public void attachAudioCapture(ThunderAudioCapture capture) {
        if (!BuildConfig.__YY_AUDIO_SUPPORT__) {
            return;
        }
        if (capture == null) {
            mAudioCapture = mDefaultMic;
        } else {
            mAudioCapture = capture;
        }
        ThunderLog.info(ThunderLog.kLogTagCall, "attachAudioCapture %s", mAudioCapture.toString());
        ThunderNative.attachAudioCapture(mAudioCapture);

    }

    public void attachVideoCapture(ThunderVideoCapture capture) {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return;
        }
        if (capture == null) {
            mVideoCapture = mDefaultCamera;
        } else {
            mVideoCapture = capture;
        }
        ThunderLog.info(ThunderLog.kLogTagCall, "attachVideoCapture %s", mVideoCapture.toString());
        ThunderNative.attachVideoCapture(mVideoCapture);
    }

    public void syncUserInfo(String channelId, String uid, boolean is32Bit, int userRole) {
        mChannelId = channelId;
        mUidString = uid;
        if (is32Bit) {
            if (uid == null) {
                mUid = 0;
            }else {
                mUid = Long.parseLong(uid);
            }
        }
    }

    private ThunderPublishVideoConfig convertVideoConfig() {
        int convertType = convertPlayType(mPlayType);
        ThunderPublishVideoConfig config = ThunderNative.getRemoteVideoConfig(convertType, mPublishMode);
        if (mAudioOnly) {
            config.encodeResolutionWidth = 0;
            config.encodeResolutionHeight = 0;
        }
        return config;
    }

    private ThunderPublishAudioConfig convertAudioConfig() {
        ThunderPublishAudioConfig config = new ThunderPublishAudioConfig(ThunderPublishAudioConfig.YYPUBLISH_AUDIO_MODE_NORMALDELAY_NORMALFLOW_HIGHQUALITY_BROADCAST);
        config.bUseAudioProfile = true;
        if (mPlayType == ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_SINGLE ||
                mPlayType == ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_SCREENCAP) {
            config.roomConfig = ThunderRtcConstant.RoomConfig.THUNDER_ROOMCONFIG_LIVE;
            config.audioConfig = ThunderRtcConstant.AudioConfig.THUNDER_AUDIO_CONFIG_MUSIC_STANDARD_STEREO;
            config.commutMode = ThunderRtcConstant.CommutMode.THUNDER_COMMUT_MODE_LOW;
            config.scenarioMode = ThunderRtcConstant.ScenarioMode.THUNDER_SCENARIO_MODE_QUALITY_FIRST;
        }else  if (mPlayType == ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_INTERACT) {
            config.roomConfig = ThunderRtcConstant.RoomConfig.THUNDER_ROOMCONFIG_LIVE;
            config.audioConfig = ThunderRtcConstant.AudioConfig.THUNDER_AUDIO_CONFIG_MUSIC_STANDARD_STEREO;
            config.commutMode = ThunderRtcConstant.CommutMode.THUNDER_COMMUT_MODE_HIGH;
            config.scenarioMode = ThunderRtcConstant.ScenarioMode.THUNDER_SCENARIO_MODE_STABLE_FIRST;
        }
        return config;
    }

    private ThunderLayout convertLayout(ThunderLayout liveLayout, ThunderRoomlLayout channelLayout) {
        ArrayList<ThunderRoomlLayout> layouts = new ArrayList<ThunderRoomlLayout>();
        layouts.add(channelLayout);
        ThunderLayout layout = new ThunderLayout();
        layout.width = liveLayout.width;
        layout.height = liveLayout.height;
        layout.layouts = layouts;
        layout.speakers = liveLayout.speakers;
        return layout;
    }

    private ThunderLayout makeLayout(ArrayList<String> speakers) {
        int convertType = convertPlayType(mPlayType);
        ThunderPublishVideoConfig config = ThunderNative.getRemoteVideoConfig(convertType, mPublishMode);
        Rect rect = new Rect(0, 0, config.encodeResolutionWidth, config.encodeResolutionHeight);

        ThunderRoomlLayout channelLayout = new ThunderRoomlLayout();
        channelLayout.channelId = mChannelId;
        //channelLayout.owner = true;
        channelLayout.layoutNo = 0;
        channelLayout.layout = rect;

        ArrayList<ThunderRoomlLayout> layouts = new ArrayList<ThunderRoomlLayout>();
        layouts.add(channelLayout);
        ThunderLayout layout = new ThunderLayout();
        layout.width = rect.width();
        layout.height = rect.height();
        layout.layouts = layouts;
        if (speakers == null || speakers.isEmpty()) {
            channelLayout.owner = mPublishing;
            ArrayList<String> spk = new ArrayList<String>();
            spk.add(mUidString);
            layout.speakers = spk;
        }else {
            channelLayout.owner = true;
            layout.speakers = speakers;
        }

        return layout;
    }

    private int convertPlayType(int playType) {
        if (mAudioOnly) {
            return ThunderPublishVideoConfig.YYPUBLISH_PLAYTYPE_SINGLE;
        }
        switch (playType) {
            case ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_SINGLE:
                playType = ThunderPublishVideoConfig.YYPUBLISH_PLAYTYPE_SINGLE;
                break;
            case ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_INTERACT:
                playType = ThunderPublishVideoConfig.YYPUBLISH_PLAYTYPE_LIANMAI;
                break;
            case ThunderConstant.ThunderPublishPlayType.THUNDERPUBLISH_PLAY_SCREENCAP:
                playType = ThunderPublishVideoConfig.YYPUBLISH_PLAYTYPE_SCREEN_CAPTURE;
                break;
            default:
                break;
        }
        return playType;
    }
}
