package com.yy.yylivesdk4cloud;

public interface ThunderEventHandler {

    /**
     * sdk错误信息回调(error定义待定)
     * @param error
     */
    public void onError(int error);

    /**
     * 加入频道回调
     * @param room
     * @param uid
     * @param elapsed 参数功能未实现
     */
    public void onJoinRoomSuccess(String room, String uid, int elapsed);

    /**
     * 离开频道回调
     * @param status 功能暂未实现
     */
    public void onLeaveRoom(RoomStats status);

    /**
     * 业务鉴权结果
      */
    public void onBizAuthResult(boolean bPublish, int result);

    /**
     * sdk鉴权结果
     * @param result  (0-鉴权成功 10000-服务器内部错误，可以重试 10001-没有带token，需要调用[ThunderAPI updateToken:]
     *                 10002-token校验失败（数字签名不对），可能使用的appSecret不对
     *                 10003-token中appid跟鉴权时带的appid不一致 10004-token中uid跟鉴权时带的uid不一致 10005-token已过期
     *                 10006-app不存在，没有在管理后台注册 10007-token即将过期 10008-用户被封禁
     *                {@link ThunderRtcConstant.AuthResult}
     */
    public void onSdkAuthResult(int result);

	/**
	 * 用户被封禁回调
	 * @param status 封禁状态 ture=封禁 false=解禁
	 */
	public void onUserBanned(boolean status);

    /**
     * 用户静音状态回调
     * @param uid 远端用户/主播 ID
     * @param stop 静该用户是否静音：true=该用户已静音音频 false=该用户已取消音频静音
     *
     */
    public void onRemoteAudioStopped(String uid, boolean stop);

    /**
     * 远端用户加入当前频道回调
     * @param uid 远端用户/主播 ID
     * @param elapsed 从本地用户调用 joinRoom 到触发该回调的延迟（毫秒）
     */
    public void onUserJoined(String uid, int elapsed);

    /**
     * 远端用户离开当前频道回调
     * @param uid 远端用户/主播 ID
     * @param reason (1-用户主动离开 2-因过长时间收不到对方数据包，超时掉线 3-用户身份从主播切换为观众（直播模式下))
     *               {@link ThunderRtcConstant.UserOfflineReason}
     */
    public void onUserOffline(String uid, int reason);

	/**
	 * Token 服务即将过期回调
	 * @param token 即将服务失效的Token
	 */
	public void onTokenWillExpire(byte[] token);

	/**
	 * Token 已过期回调
	 */
	public void onTokenRequest();

    /**
     * 网络上下行质量报告回调, 返回的是ID对应的用户的网络质量
     * @param uid  表示该回调报告的是持有该 ID 的用户的网络质量, 当 uid 为 0 时，返回的是本地用户的网络质量
     * @param txQuality (0-质量未知 1-质量极好 2-用户主观感觉和极好差不多，但码率可能略低于极好
     *                   3-用户主观感受有瑕疵但不影响沟通 4-勉强能沟通但不顺畅 5-网络质量非常差，基本不能沟通)
     *                   {@link ThunderRtcConstant.NetworkQuality}
     * @param rxQuality (0-质量未知 1-质量极好 2-用户主观感觉和极好差不多，但码率可能略低于极好
     *                   3-用户主观感受有瑕疵但不影响沟通 4-勉强能沟通但不顺畅 5-网络质量非常差，基本不能沟通)
     *                   {@link ThunderRtcConstant.NetworkQuality}
     */
    public void onNetworkQuality(String uid, int txQuality, int rxQuality);

    /**
     * 说话声音音量提示回调
     * @param speakers 用户音量和采集时间戳
     * @param totalVolume (混音后的)总音量
     * 默认关闭，开关：setAudioVolumeIndication
     */
    public void onPlayVolumeIndication(ThunderEventHandler.AudioVolumeInfo[] speakers, int totalVolume);

    /**
     * 采集音量回调
     * @param totalVolume 上行音量能量值[0-100]
     * @param cpt 采集时间戳
     * @param micVolume 仅麦克风采集的音量能量值[0-100]
     * 默认关闭，开关：enableCaptureVolumeIndication
     */
    public void onCaptureVolumeIndication(int totalVolume, int cpt, int micVolume);

    /**
     * 声网对标接口，功能暂未实现
     * @param uid
     * @param quality
     * @param delay
     * @param lost
     */
    public void onAudioQuality(String uid, int quality, short delay, short lost);

    /**
     * 声网对标接口，功能暂未实现
     */
    public void onConnectionLost();

    /**
     * 声网对标接口，功能暂未实现
     */
    public void onConnectionInterrupted();

    /**
     * 声网对标接口，功能暂未实现
     * @param routing
     */
    public void onAudioRouteChanged(int routing);

    /**
     * 音频播放数据回调
     * @param data
     * @param data 解码前数据
     * @param cpt 采集时间戳
     * @param pts 播放时间戳
     * @param uid 用户id
     * @param duration 时长
     * 默认关闭，开关：enableAudioDataIndication
     */
    public void onAudioPlayData(byte[] data, long cpt, long pts, String uid, long duration);


    /**
     * 音频播放频谱数据回调
     * @param data 数值范围[0-100]
     * 默认关闭，开关：enableAudioPlaySpectrum
     */
    public void onAudioPlaySpectrumData(byte[] data);

    /**
     * 音频采集数据回调
     * @param data 采集的pcm数据
     * @param dataSize 数据大小
     * @param sampleRate 数据的采样率
     * @param channel 数据的声道数
     * 默认关闭，开关：enableCapturePcmDataCallBack
     */
    public void onAudioCapturePcmData(byte[] data, int dataSize, int sampleRate, int channel);

    /**
     * 音频渲染数据回调
     * @param data 采集的pcm数据
     * @param dataSize 数据大小
     * @param sampleRate 数据的采样率
     * @param channel 数据的声道数
     * @param duration 数据时长 单位：ms
     * 默认关闭，开关：enableRenderPcmDataCallBack
     */
    public void onAudioRenderPcmData(byte[] data, int dataSize, long duration, int sampleRate, int channel);

    /**
     *  接收到的透传协议消息回调
     *  @param data 透传消息
     *  @param uid 发该消息的uid
     */
    public void onRecvUserAppMsgData(byte[] data, String uid);

    /**
     * 透传协议发送失败状态回调
     *  @param status 失败状态(1-频率太高 2-发送数据太大 3-未成功开播)
     *  目前规定透传频率2次/s,发送数据大小限制在<=200Byte
     */
    public void onSendAppMsgDataFailedStatus(int status);

    public static class AudioVolumeInfo {
        public String uid;
        public int volume;
        public int pts;

        public AudioVolumeInfo() {
        }
    }

    public static class RoomStats {
        public int temp;
        public RoomStats(){
        }
    }
}
