package com.yy.yylivesdk4cloud;

/**
 * Created by zhangfei on 2018/06/20.
 */

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.math.BigDecimal;

import com.yy.yylivesdk4cloud.audio.IAudioFrameObserver;
import com.yy.yylivesdk4cloud.helper.ThunderHttpsRequestHandler;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;

/**
 * YY音频简易接入SDK
 * 所有接口，int型返回值，未做特殊说明，0表示成功，<0 error
 */

public class ThunderEngine {
    private final static String TAG = "RtcEngine";
    private static boolean mIsInited = false;
    private static long mJoinRoomTimestamp;

    private static class NotificationHandler extends Handler {
        private final WeakReference<ThunderEngine> mRtcEngine;

        public NotificationHandler(ThunderEngine rtc) {
            mRtcEngine = new WeakReference<ThunderEngine>(rtc);
        }

        public NotificationHandler(ThunderEngine rtc, Looper loop) {
            super(loop);

            mRtcEngine = new WeakReference<ThunderEngine>(rtc);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case ThunderNotification.kYYLiveAPINotification_PublishStatus: {
                    ThunderNotification.PublishStatusInfo info = (ThunderNotification.PublishStatusInfo) msg.obj;
                    ThunderLog.release(TAG, String.format("ThunderNotification.PublishStatusInfo stream=%s status=%d",
                            info.getStreamName(), info.getStatus()));
                    break;
                }
                case ThunderNotification.kYYLiveAPINotification_PublishRunTimeInfo: {
                    ThunderNotification.PublishRunTimeInfo info = (ThunderNotification.PublishRunTimeInfo) msg.obj;
//                    ThunderLog.info(TAG, String.format("ThunderNotification.PublishRunTimeInfo stream=%s fps=%d " +
//                                    "bitrate=%d audioBitrate=%d resolution=%dx%d", info.getStreamName(),
//                            info.getInfo().getFps(), info.getInfo().getBitrate(), info.getInfo().getAudioBitrate(),
//                            info.getInfo().getWidth(), info.getInfo().getHeight()));
                    break;
                }
                case ThunderNotification.kYYLiveAPINotification_PlayStatus: {
                    ThunderNotification.PlayStatusInfo info = (ThunderNotification.PlayStatusInfo) msg.obj;
                    ThunderLog.release(TAG, String.format("ThunderNotification.PlayStatusInfo stream=%s status=%d",
                            info.getStream().streamName, info.getStatus()));

                    switch (info.getStatus()) {
                        case ThunderNotification.PlayStatusInfo.YYLIVE_PLAYSTATUS_PARAM_ERROR: {

                        }
                        break;
                        case ThunderNotification.PlayStatusInfo.YYLIVE_PLAYSTATUS_SUBSCRIBE_SUCCUSS: {
                            mJoinRoomTimestamp = System.currentTimeMillis();
                            if (mRtcEventHandler != null) {
                                mRtcEventHandler.onJoinRoomSuccess(mRtcEngine.get().getRoomName(),
                                        mRtcEngine.get().getMyUid(), 0);
                            }
                        }
                        break;
                        case ThunderNotification.PlayStatusInfo.YYLIVE_PLAYSTATUS_SUBSCRIBE_FAILED: {

                        }
                        break;
                        case ThunderNotification.PlayStatusInfo.YYLIVE_PLAYSTATUS_SUBSCRIBE_CANCEL: {
                            if (mRtcEventHandler != null) {
                                ThunderEventHandler.RoomStats status = new ThunderEventHandler.RoomStats();
                                mRtcEventHandler.onLeaveRoom(status);
                            }
                        }
                        break;
                        case ThunderNotification.PlayStatusInfo.YYLIVE_PLAYSTATUS_STREAM_ARRIVE: {

                        }
                        break;
                        case ThunderNotification.PlayStatusInfo.YYLIVE_PLAYSTATUS_STREAM_RENDERED: {

                        }
                        break;
                        case ThunderNotification.PlayStatusInfo.YYLIVE_PLAYSTATUS_STREAM_STOP: {

                        }
                        break;
                    }

                    break;
                }
                case ThunderNotification.kYYLiveAPINotification_PlayRunTimeInfo: {
//                    ThunderNotification.PlayRunTimeInfo info = (ThunderNotification.PlayRunTimeInfo) msg.obj;
//                    ThunderLog.info(TAG, String.format("ThunderNotification.PlayRunTimeInfo stream=%s fps=%d " +
//                                    "bitrate=%d audioBitrate=%d resolution=%dx%d", info.getStream().streamName,
//                            info.getInfo().getFps(), info.getInfo().getBitrate(), info.getInfo().getAudioBitrate(),
//                            info.getInfo().getWidth(), info.getInfo().getHeight()));
                    break;
                }
                case ThunderNotification.kYYLiveAPINotification_AudioCaptureVolume: {
                    ThunderNotification.YYAudioCaptureVolume info = (ThunderNotification.YYAudioCaptureVolume) msg.obj;

                    if (mRtcEventHandler != null) {
                        mRtcEventHandler.onCaptureVolumeIndication(info.mVolume, (int) info.mCpt, info.mMicVolume);
                    }
                    break;
                }
                case ThunderNotification.kYYLiveAPINotification_AudioPlayVolume: {
                    ThunderNotification.AudioVolumeInfo info = (ThunderNotification.AudioVolumeInfo) msg.obj;
                    if (info.getVolumeInfos() != null) {
                        int maxVol = 0;
                        int index = 0;
                        ArrayList<ThunderEventHandler.AudioVolumeInfo> volInfos = new ArrayList<>();
                        for (Map.Entry<Long, ThunderNotification.YYVolumeInfo> entry : info.getVolumeInfos().entrySet()) {
                            if (entry.getValue().mActualSpeakerUidList == null || entry.getValue().mActualSpeakerUidList.isEmpty()) {
                                continue;
                            }
                            for (long uid : entry.getValue().mActualSpeakerUidList) {
                                ThunderEventHandler.AudioVolumeInfo volInfo = new ThunderEventHandler.AudioVolumeInfo();
                                if (mRtcEngine.get().mIs32bitUid) {
                                    volInfo.uid = Long.toString(uid);
                                } else {
                                    volInfo.uid = mRtcEngine.get().getStringUid((int) uid);
                                    if (volInfo.uid == null || volInfo.uid.isEmpty()) {
                                        continue;
                                    }
                                }
                                volInfo.volume = entry.getValue().mVolume;
                                volInfo.pts = (int) entry.getValue().mPts;
                                if (maxVol < volInfo.volume) {
                                    maxVol = volInfo.volume;
                                }
                                ++index;
                                volInfos.add(volInfo);
                                if ((s_playVolumeNotifyCount % 200) == 0) {
                                    ThunderLog.release(TAG, String.format("ThunderNotification.AudioPlayVolume, [%d] uid %s, volume %d",
                                            index, volInfo.uid.toString(), volInfo.volume));
                                }
                            }
                        }

                        int volSize = volInfos.size();
                        if (volSize > 0) {
                            ThunderEventHandler.AudioVolumeInfo[] volList = new ThunderEventHandler.AudioVolumeInfo[volSize];
                            for (int i = 0; i < volSize; ++i) {
                                volList[i] = volInfos.get(i);
                            }
                            if (mRtcEventHandler != null) {
                                mRtcEventHandler.onPlayVolumeIndication(volList, maxVol);
                                ++s_playVolumeNotifyCount;
                            }
                        }
                    }

                    break;
                }
                case ThunderNotification.kYYLiveAPINotification_BizAuthRes: {
                    ThunderNotification.BizAuthResult result = (ThunderNotification.BizAuthResult) msg.obj;
                    ThunderLog.release(TAG, String.format("ThunderNotification.BizAuthResult stream=%s group=%s result=%d",
                            result.getAuthStream() != null ? result.getAuthStream().streamName : "null",
                            result.getAuthGroup() != null ? result.getAuthGroup().groupName : "null",
                            result.getBizAuthResult()));

                    if (mRtcEventHandler != null) {
                        mRtcEventHandler.onBizAuthResult(result.isPublishAuth(), result.getBizAuthResult());
                    }
                    break;
                }
                case ThunderNotification.kYYLiveAPINotification_SdkAuthRes: {
                    ThunderNotification.SdkAuthResult result = (ThunderNotification.SdkAuthResult) msg.obj;
                    ThunderLog.release(TAG, String.format("ThunderNotification.SdkAuthResult appId=%d uid=%d result=%d",
                            result.getAppId(), result.getUid(), result.getSdkAuthResult()));

                    if (mRtcEventHandler != null) {
                        int authResult = result.getSdkAuthResult();
                        switch (authResult) {
                            case 0: //success
                                if (mRtcEngine.get().mIsUserBanned) {
                                    mRtcEngine.get().mIsUserBanned = false;
                                    mRtcEventHandler.onUserBanned(false);
                                }
                                break;
                            case 10005: //token expire
                                mRtcEventHandler.onTokenRequest();
                                break;
                            case 10007: //token will expire
                                mRtcEventHandler.onTokenWillExpire(mRtcEngine.get().mToken);
                                break;
                            case 10008: //band
                                mRtcEngine.get().mIsUserBanned = true;
                                mRtcEventHandler.onUserBanned(true);
                                break;
                        }

                        mRtcEventHandler.onSdkAuthResult(authResult);
                    }
                    break;
                }
                case ThunderNotification.kYYLiveAPINotifioation_StringUid: {
                    ThunderNotification.UidInt2String result = (ThunderNotification.UidInt2String) msg.obj;
                    mRtcEngine.get().addUid2String(result.getUidInt(), result.getUidString());
                    ThunderLog.release(TAG, String.format("ThunderNotification.UidInt2String uid=%d str=%s",
                            result.getUidInt(), result.getUidString()));
                    break;
                }
                case ThunderNotification.kYYLiveAPINotification_AudioPlayData: {
                    ThunderNotification.AudioDataInfo result = (ThunderNotification.AudioDataInfo) msg.obj;

                    long uid = result.getUid();
                    String strUid = "";
                    if (mRtcEngine.get().mIs32bitUid) {
                        strUid = Long.toString(uid);
                    } else {
                        strUid = mRtcEngine.get().getStringUid((int) uid);
                        if (strUid == null || strUid.isEmpty()) {
                            strUid = Long.toString(uid);
                            if (strUid == null || strUid.isEmpty()) {
                                return;
                            }
                        }
                    }

                    int duration = result.getDuration();
                    int cpt = result.getCpt();
                    int pts = result.getPts();
                    byte[] data = result.getData();
                    int len = 0;
                    if (null != data) {
                        len = data.length;
                    }

                    if ((s_playDataNotifyCount % 500) == 0) {
                        ThunderLog.release(TAG, String.format("ThunderNotification.AudioPlayData,cpt:%d,pts:%d, len:%d", cpt, pts, len));
                    }
                    ++s_playDataNotifyCount;

                    if (mRtcEventHandler != null) {
                        mRtcEventHandler.onAudioPlayData(data, cpt, pts, strUid, duration);
                    }
                    break;
                }
                case ThunderNotification.kYYLiveAPINotification_AudioPlaySpectrumData: {
                    ThunderNotification.AudioPlaySpectrumData result = (ThunderNotification.AudioPlaySpectrumData) msg.obj;
                    if (mRtcEventHandler != null) {
                        mRtcEventHandler.onAudioPlaySpectrumData(result.getData());
                    }
                    break;
                }
                case ThunderNotification.kYYLiveAPINotification_AudioCapturePcmData: {
                    ThunderNotification.AudioCapturePcmData result = (ThunderNotification.AudioCapturePcmData) msg.obj;
                    if (mRtcEventHandler != null) {
                        mRtcEventHandler.onAudioCapturePcmData(result.getData(), result.getDataSize(), result.getSampleRate(), result.getChannel());
                    }
                    break;
                }
                case ThunderNotification.kYYLiveAPINotification_AudioRenderPcmData: {
                    ThunderNotification.AudioRenderPcmData result = (ThunderNotification.AudioRenderPcmData) msg.obj;
                    if (mRtcEventHandler != null) {
                        //duration = (result.getDataSize() * 1000) /  (result.getSampleRate() * result.getChannel() * 2) 单位：ms
                        mRtcEventHandler.onAudioRenderPcmData(result.getData(), result.getDataSize(), result.getDuration(), result.getSampleRate(), result.getChannel());
                    }
                    break;
                }
                case ThunderNotification.kYYLiveAPINotification_UserAppMsgData: {
                    ThunderNotification.UserAppMsgData result = (ThunderNotification.UserAppMsgData) msg.obj;

                    long uid = result.getUid();
                    String strUid = "";
                    strUid = Long.toString(uid);

                    //ThunderLog.info(TAG, String.format("ThunderNotification.UserAppMsgData uid %s msgSize %d",
                    //        strUid, result.getData().length));
                    if (mRtcEventHandler != null) {
                        mRtcEventHandler.onRecvUserAppMsgData(result.getData(), strUid);
                    }
                    break;
                }
                case ThunderNotification.kYYLiveAPINotification_AppMsgDataFailedStatus: {
                    ThunderNotification.AppMsgDataFailedStatus result = (ThunderNotification.AppMsgDataFailedStatus) msg.obj;
                    ThunderLog.info(TAG, String.format("ThunderNotification.AppMsgDataFailedStatus status=%d",
                            result.getFailedStatus()));
                    if (mRtcEventHandler != null) {
                        mRtcEventHandler.onSendAppMsgDataFailedStatus(result.getFailedStatus());
                    }
                    break;
                }
                case ThunderNotification.kYYLiveAPINotification_InitiateHttpsRequest: {
                    ThunderNotification.InitiateHttpsRequest result =
                            (ThunderNotification.InitiateHttpsRequest) msg.obj;
                    String reqUrl = result.getReqUrl();
                    int target = result.getTarget();
                    ThunderLog.info(TAG, String.format("ThunderNotification.InitiateHttpsRequest " +
                            "reqUrl=%s target=%d", reqUrl, target));
                    if (mHttpsRequestHandler != null) {
                        mHttpsRequestHandler.send(reqUrl, target);
                    }
                    break;
                }
                case ThunderNotification.kYYLiveAPINotification_UserMuteAudio: {
                    ThunderNotification.UserMuteAudio result = (ThunderNotification.UserMuteAudio) msg.obj;
                    if (mRtcEventHandler != null) {
                        mRtcEventHandler.onRemoteAudioStopped(Long.toString(result.getUid()), result.isMuted());
                    }
                    break;
                }
                case ThunderNotification.kYYLiveAPINotification_UserJoined: {
                    ThunderNotification.UserJoined result = (ThunderNotification.UserJoined) msg.obj;
                    if (mRtcEventHandler != null) {
                        int elapsed = (int) (System.currentTimeMillis() - mJoinRoomTimestamp);
                        mRtcEventHandler.onUserJoined(Long.toString(result.getUid()), elapsed);
                    }
                    break;
                }
                case ThunderNotification.kYYLiveAPINotification_UserOffline: {
                    ThunderNotification.UserOffline result = (ThunderNotification.UserOffline) msg.obj;
                    if (mRtcEventHandler != null) {
                        mRtcEventHandler.onUserOffline(Long.toString(result.getUid()), result.getReason());
                    }
                    break;
                }
                case ThunderNotification.kYYLiveAPINotification_NetworkQuality: {
                    ThunderNotification.NetworkQuality result = (ThunderNotification.NetworkQuality) msg.obj;
                    if (mRtcEventHandler != null) {
                        mRtcEventHandler.onNetworkQuality(Long.toString(result.getUid()),
                                result.getTxQuality(), result.getRxQuality());
                    }
                    break;
                }
                default:
                    //ThunderLog.info(TAG, String.format("unknown message type %d", msg.what));
            }
            //ThunderLog.info(TAG, String.format("receive notification %d", msg.what));
        }
    }

    // param type define

    /**
     * 混响参数
     */
    public static final class ReverbExParameter {
        /**
         * 房间大小; 范围: [0~100]
         */
        public float mRoomSize = 0;
        /**
         * 预延时; 范围: [0~200]
         */
        public float mPreDelay = 0;
        /**
         * 混响度; 范围: [0~100]
         */
        public float mReverberance = 0;
        /**
         * 高频因子; 范围: [0~100]
         */
        public float mHfDamping = 0;
        /**
         * 低频量; 范围: [0~100]
         */
        public float mToneLow = 0;
        /**
         * 高频量; 范围: [0~100]
         */
        public float mToneHigh = 0;
        /**
         * 湿增益; 范围: [-20~10]
         */
        public float mWetGain = 0;
        /**
         * 干增益; 范围: [-20~10]
         */
        public float mDryGain = 0;
        /**
         * 立体声宽度; 范围: [0~100]
         */
        public float mStereoWidth = 0;
    }

    /**
     * 压缩参数
     */
    public static final class CompressorParam {
        /**
         * 阈值; 范围: [-40~0]
         */
        public int mThreshold = 0;
        /**
         * 增益
         */
        public int mMakeupGain = 0;
        /**
         * 比例
         */
        public int mRatio = 0;
        /**
         * 斜率
         */
        public int mKnee = 0;
        /**
         * 释放时间; 范围: 大于0
         */
        public int mReleaseTime = 0;
        /**
         * 启动时间; 范围: 大于0
         */
        public int mAttackTime = 0;
    }

    /**
     * 限制器参数
     */
    public static final class LimterParam {
        /*
         *  -30 ~ 0
         */
        public float fCeiling = 0;
        /*
         *  -10 ~ 0
         */
        public float fThreshold = 0;
        /*
         *   0 ~ 30
         */
        public float fPreGain = 0;
        /*
         *  0 ~ 1000
         */
        public float fRelease = 0;
        /*
         *  0 ~ 1000
         */
        public float fAttack = 0;
        /*
         *   0 ~ 8
         */
        public float fLookahead = 0;
        /*
         * 0.5 ~ 2
         */
        public float fLookaheadRatio = 0;
        /*
         * 0 ~ 100
         */
        public float fRMS = 0;
        /*
         * 0 ~ 1
         */
        public float fStLink = 0;
    }

    //static info
    private static int sMyAppId = 0;
    private static long sMySceneId = 0;

    private static ThunderEventHandler mRtcEventHandler;

    // https request handler
    private static ThunderHttpsRequestHandler mHttpsRequestHandler;

    //my info
    private long mMyUid = 0;
    //uid info
    private Map<Integer, String> mUidToStringMap = new HashMap<Integer, String>();
    private boolean mIs32bitUid = true;
    private String mMyStrUid = "";

    //sdk auth info
    private boolean mIsUserBanned = false;
    private byte[] mToken;

    //log info
    private static String mLogPath = "";
    private static int mLogLevel = ThunderRtcConstant.LogLevel.THUNDER_LOG_LEVEL_TRACE;
    private static IThunderLogCallback mYyLogCallback = null;

    //audio srbscribe
    private boolean mBGroupSubscribe = false;
    private boolean mBAudioPublish = false;
    private String mStringName = "";

    //room info
    private int mRoomAppId = 0;
    private String mRoomName = "";

    //room profile
    private int mRoomConfig = ThunderRtcConstant.RoomConfig.THUNDER_ROOMCONFIG_LIVE;
    //audio profile
    private int mAudioConfig = ThunderRtcConstant.AudioConfig.THUNDER_AUDIO_CONFIG_DEFAULT;
    private int mCommutMode = ThunderRtcConstant.CommutMode.THUNDER_COMMUT_MODE_DEFAULT;
    private int mScenarioMode = ThunderRtcConstant.ScenarioMode.THUNDER_SCENARIO_MODE_DEFAULT;

    private boolean mBEnablePlayDataIndication = false;
    private static int s_playVolumeNotifyCount = 0;
    private static int s_playDataNotifyCount = 0;
    private static NotificationHandler mHandler = null;

    // Equalizer
    private int[] mEqGains = new int[11];
    private boolean mBEnableEqualizer = false;
    private boolean mBEnableCompressor = false;
    private boolean mBEnableLimiter = false;
    private boolean mBEnableReverbEx = false;
    private ReverbExParameter mReverbExGains = new ReverbExParameter();
    private CompressorParam mCompressorGains = new CompressorParam();
    private LimterParam mLimiterGins = new LimterParam();

    // audioFilePlayer
    private Set<ThunderAudioFilePlayer> mAudioFilePlayerSet = new TreeSet<ThunderAudioFilePlayer>();

    public String getRoomName() {
        return mRoomName;
    }

    public String getMyUid() {
        return mMyStrUid;
    }

    // End of Param


    private ThunderEngine() {
    }

    private static class SingleonHolder {
        private static final ThunderEngine INSTANCE = new ThunderEngine();
    }

    private static synchronized ThunderEngine createRtcEngine(Context context,
                                                              String appId,
                                                              long sceneId,
                                                              ThunderEventHandler handler) {
        // 如果已经被创建过，就不再初始化
        if (!mIsInited) {
            mRtcEventHandler = handler;
            mHttpsRequestHandler = new ThunderHttpsRequestHandler();

            sMyAppId = Integer.parseInt(appId);
            sMySceneId = sceneId;
            ThunderAPI.sharedInstance().initWithAppId(sMyAppId, sMySceneId, context);
            mIsInited = true;
        }

        return SingleonHolder.INSTANCE;
    }

    /**
     * 创建RtcEngine对象
     * <br>仅支持一个实例
     * <br>在yylivesdk.yy.com上创建app后，系统会分配唯一appId，初始化后appId不能修改
     *
     * @param context Andoird APP 的上下文
     * @param appId   接入app的唯一标识
     * @param handler ThunderEventHandler 是一个提供了缺省实现的抽象类，SDK 通过该抽象类向应用程序报告 SDK 运行时的各种事件\
     * @return YYLiveRtcEngine对象
     * @sceneId 场景Id
     */
    public static synchronized ThunderEngine createEngine(Context context,
                                                          String appId,
                                                          long sceneId,

                                                          ThunderEventHandler handler) {
        ThunderEngine rtcEngine = null;
        try {
            rtcEngine = createRtcEngine(context, appId, sceneId, handler);

            //rtcEngine 存在为空状态
            if (rtcEngine != null) {
                if (mHandler == null) {
                    mHandler = new NotificationHandler(rtcEngine);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return rtcEngine;
    }

    /**
     * 创建RtcEngine对象
     * <br>仅支持一个实例
     * <br>在yylivesdk.yy.com上创建app后，系统会分配唯一appId，初始化后appId不能修改
     *
     * @param context Andoird APP 的上下文
     * @param appId   接入app的唯一标识
     * @param handler ThunderEventHandler 是一个提供了缺省实现的抽象类，SDK 通过该抽象类向应用程序报告 SDK 运行时的各种事件
     * @return YYLiveRtcEngine对象
     * @sceneId 场景Id
     * @loop 回调执行线程
     */
    public static synchronized ThunderEngine createWithLoop(Context context,
                                                            String appId,
                                                            long sceneId,
                                                            ThunderEventHandler handler,
                                                            Looper loop) {
        ThunderEngine rtcEngine = createRtcEngine(context, appId, sceneId, handler);

        if (mHandler == null) {
            mHandler = new NotificationHandler(rtcEngine, loop);
        }

        return rtcEngine;
    }

    /**
     * 销毁RtcEngine对象
     */
    public static synchronized void destroyEngine() {

        try {
            // 如果已经被销毁，就不再卸载
            if (mIsInited) {
                ThunderAPI.sharedInstance().deInit();
                mIsInited = false;
                SingleonHolder.INSTANCE.resetRtcEngine();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * sdk版本号
     *
     * @return sdk版本号，非空
     */
    public static String getVersion() {
        return ThunderAPI.sharedInstance().getVersion();
    }


    /**
     * 设置日志文件路径（打开日志）
     *
     * @param filePath 日志文件路径（路径为空表示关闭日志）
     * @return
     */
    public static int setLogFilePath(String filePath) {
        mLogPath = filePath;
        if (filePath == null || filePath.isEmpty()) {
            ThunderAPI.enableLog(false, mLogLevel, mLogPath, null);
        } else {
            ThunderAPI.enableLog(true, mLogLevel, mLogPath, null);
        }
        return 0;
    }

    /**
     * 设置日志回调
     *
     * @praam IThunderLogCallback 日志回调(callback = null 表示关闭日志）
     * 设置了日志回调，则setLogFile无效；
     */
    public static int setLogCallback(IThunderLogCallback callback) {
        mYyLogCallback = callback;

        if (mYyLogCallback != null) {
            ThunderAPI.enableLog(true, mLogLevel, "", mYyLogCallback);
        } else {
            ThunderAPI.enableLog(false, mLogLevel, "", mYyLogCallback);
        }

        return 0;
    }

    /**
     * 设置日志级别
     *
     * @param level ThunderRtcConstant.LogLevel
     * @return
     */
    public static int setLogLevel(int level) {
        mLogLevel = level;
        return 0;
    }

    /**
     * 设置场景Id
     *
     * @param sceneId 自定义场景Id
     */
    public void setSceneId(long sceneId) {
        sMySceneId = sceneId;
        ThunderAPI.sharedInstance().setSceneId(sceneId);
    }

    /**
     * 设置频道属性
     *
     * @param config=ThunderRtcConstant.RoomConfig THUNDER_ROOMCONFIG_LIVE = 直播模式（流畅）
     *                                             THUNDER_ROOMCONFIG_COMMUNICATION = 通话模式（延时低）
     *                                             THUNDER_ROOMCONFIG_GAME = 游戏（省流量、延时低）
     * @return 成功或失败
     */
    public int setRoomConfig(int config) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setRoomConfig: profile=%d", config);

        mRoomConfig = config;
        boolean bLowLatency = false;
        switch (mRoomConfig) {
            case ThunderRtcConstant.RoomConfig.THUNDER_ROOMCONFIG_LIVE: {
                bLowLatency = false;
            }
            break;
            case ThunderRtcConstant.RoomConfig.THUNDER_ROOMCONFIG_COMMUNICATION:
            case ThunderRtcConstant.RoomConfig.THUNDER_ROOMCONFIG_GAME: {
                bLowLatency = true;
            }
            break;
            case ThunderRtcConstant.RoomConfig.THUNDER_ROOMCONFIG_MULTIAUDIOROOM: {
                bLowLatency = true;
            }
            break;
        }
        ThunderAPI.sharedInstance().setRoomConfig(config);
        ThunderAPI.sharedInstance().enableLowLatency(bLowLatency);
        return 0;
    }

    /**
     * 设置区域（国外用户必须调用此接口）
     *
     * @param area 取值范围YYLiveRtcConstant.AreaType
     * @return
     */
    public int setArea(int area) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setArea: area=%d", area);

        int iResult = 0;
        int transSdkArea = ThunderConstant.ThunderAreaType.THUNDERAREA_DEFAULT; //domestic;
        switch (area) {
            case ThunderRtcConstant.AreaType.THUNDER_AREA_DEFAULT:
                transSdkArea = ThunderConstant.ThunderAreaType.THUNDERAREA_DEFAULT; //default-domestic;
                break;
            case ThunderRtcConstant.AreaType.THUNDER_AREA_FOREIGN:
                transSdkArea = ThunderConstant.ThunderAreaType.THUNDERAREA_FOREIGN; //foreign;
                break;
            case ThunderRtcConstant.AreaType.THUNDER_AREA_RESERVED:
                transSdkArea = ThunderConstant.ThunderAreaType.THUNDERAREA_RESERVED;
                break;
            default:
                iResult = -1;
                break;
        }

        ThunderAPI.sharedInstance().setAreaType(transSdkArea);
        return iResult;
    }

    /**
     * 指定是否使用64位uid，要求进频道前调用
     *
     * @param is64bitUid 默认值:false，使用无符号32位uid
     * @return
     */
    public int setUse64bitUid(boolean is64bitUid) {
        mIs32bitUid = !is64bitUid;
        return 0;
    }

    /**
     * 加入频道，在同一个频道内的用户可以互相通话，多个用户加入同一个频道，可以群聊。不同appId不互通
     *
     * @param token    参见renewToken
     * @param joinRoom 频道名称
     * @param uid      用户id，32 位无符号整数，需要保证唯一
     * @return 成功或失败
     */
    public int joinRoom(byte[] token,
                        String joinRoom,
                        String uid
    ) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "joinRoom: joinRoom=%s, uid=%s, token=%s", getPrintString(joinRoom),
                getPrintString(uid), getPrintString(token));

        if (mBGroupSubscribe) {
            return -1;
        }

        if (!isValidRoomStream(joinRoom)) {
            return -2;
        }

        if (uid == null || uid.isEmpty()) {
            return -3;
        }

        mMyStrUid = uid;
        if (mIs32bitUid) {
            try {
                mMyUid = Long.parseLong(uid);
            } catch (NumberFormatException exception) {
                return -4;
            }
        }

        //voice only sdk
        ThunderNative.setVoiceOnlySdk(true);
        //set channel name
        ThunderNative.setChannelName(joinRoom);
        //register notification
        ThunderAPI.sharedInstance().registerNotificationHandler(mHandler);

        //token
        mToken = token;
        ThunderAPI.sharedInstance().updateToken(token);

        //join
        if (mIs32bitUid) {
            ThunderAPI.sharedInstance().joinMedia(mMyUid);
        } else {
            ThunderAPI.sharedInstance().joinMedia(mMyStrUid, 0, 0);
        }

        //user role
        ThunderAPI.sharedInstance().setUserRole(ThunderConstant.ThunderUserRole.THUNDERUSER_ROLE_ANCHOR);

        //subscribe
        ArrayList<ThunderGroup> audioGroup = new ArrayList<ThunderGroup>(0);
        ThunderGroup oneGroup = new ThunderGroup();
        mRoomName = joinRoom;
        mRoomAppId = sMyAppId;

        oneGroup.appId = mRoomAppId;
        oneGroup.groupName = "g_" + mRoomName;
        audioGroup.add(oneGroup);

        ThunderAPI.sharedInstance().getPlayer().startPlayStreams(null, audioGroup);

        mBGroupSubscribe = true;

        return 0;
    }

    private boolean isValidRoomStream(String roomName) {
        if (roomName == null || roomName.isEmpty()) {
            return false;
        }

        int length = roomName.length();
        if (length > 64) {
            return false;
        }
        int codePoint;
        int validCharCount = 0;
        for (int i = 0; i < length; i++) {
            codePoint = Character.codePointAt(roomName, i);
            if (codePoint == 45 || codePoint == 95         // - _
                    || (codePoint >= 48 && codePoint <= 57)    // [0,9]
                    || (codePoint >= 65 && codePoint <= 90)    // [A,Z]
                    || (codePoint >= 97 && codePoint <= 122))  // [a,z]
            {
                validCharCount += 1;
            }
        }
        if (validCharCount == length) {
            return true;
        }
        ThunderLog.error(ThunderLog.kLogTagRtcEngine, "found invalid char in roomname!");
        return false;
    }

    /**
     * 离开频道
     *
     * @return
     */
    public int leaveRoom() {
        //unregisterNotificationHandler会导致收不到离开频道消息
        //unregister notification
        //ThunderAPI.sharedInstance().unregisterNotificationHandler(mHandler);

        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "leaveRoom");

        //stop publish
        tryStopPublish();

        //stop subscribe
        tryStopSubscribe();

        //clear uids
        removeAllUid2String();

        ThunderAPI.sharedInstance().leaveMedia();

        return 0;
    }

    /**
     * 更新token，用于appid和业务功能鉴权
     * <br> token 格式
     * <br> -------------------------------------------------------------------------------------------------
     * <br> | TokenLen(uint16)    | AppId(uint32)        | uid (uint64)          | Timestamp(uint64)(ms)    |
     * <br> -------------------------------------------------------------------------------------------------
     * <br> | ValidTime(uint32)(s)| BizExtInfoLen(uint16)| BizExtInfoData(nBytes)| DigitalSignature(20Bytes)|
     * <br> -------------------------------------------------------------------------------------------------
     * <br> 1. 多字节整数使用网络字节序
     * <br> 2. TokenLen：整个token长度，包括自身2字节和摘要
     * <br> 3. 过期时间=Timestamp+ValidTime*1000, UTC时间距离1970的毫秒数
     * <br> 4. BizExtInfoData: 业务鉴权可能需要的扩展信息，透传
     * <br> 5. DigitalSignature：采用hmac-sha1算法对DigitalSignature前的所有数据运算得出[TokenLen,BizExtInfoData], 秘钥使用申请appId时分配的appSecret
     * <br> 6. 整个token 进行 url安全的 base64编码
     *
     * @param token 业务服务器生成的token，需要url base64编码
     *              <p>
     *              通过监听通知 kYYLiveAPINotification_BizAuthRes, kYYLiveAPINotification_SdkAuthRes获取鉴权结果
     *              {@link ThunderNotification#kYYLiveAPINotification_BizAuthRes}
     *              {@link ThunderNotification#kYYLiveAPINotification_SdkAuthRes}
     */
    public int updateToken(byte[] token) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "updateToken: %s ", getPrintString(token));

        mToken = token;
        ThunderAPI.sharedInstance().updateToken(token);
        return 0;
    }

    /**
     * 打开音频采集，并开播到频道
     *
     * @return
     */
    public int enableAudioEngine() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableAudioEngine ");

        //必须在joinRoom之后调用
        if (!mBGroupSubscribe) {
            return -1;
        }

        if (mBAudioPublish) {
            return -2;
        }

        mStringName = "a_" + mMyUid + "_" + mRoomName;
        String groupName = "g_" + mRoomName;

        ArrayList<String> groupList = new ArrayList<String>();
        groupList.add(groupName);
        ThunderPublishAudioConfig config = new ThunderPublishAudioConfig(ThunderPublishAudioConfig.YYPUBLISH_AUDIO_MODE_LOWDELAY_NORMALFLOW_MEDIUMQUALITY_VOIP);
        config.bUseAudioProfile = true;
        config.roomConfig = mRoomConfig;
        config.audioConfig = mAudioConfig;
        config.commutMode = mCommutMode;
        config.scenarioMode = mScenarioMode;

        mBAudioPublish = true;


        ThunderAPI.sharedInstance().getPublisher().startPublishAudio(mStringName, groupList, config);

        return 0;
    }

    /**
     * 关闭音频采集，停止开播到频道
     *
     * @return
     */
    public int disableAudioEngine() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "disableAudioEngine ");

        tryStopPublish();
        return 0;
    }

    /**
     * 设置音频属性，参数待定
     *
     * @param config       ThunderRtcConstant.AudioConfig
     * @param commutMode   ThunderRtcConstant.CommutMode
     * @param scenarioMode ThunderRtcConstant.ScenarioMode
     * @return
     */
    public int setAudioConfig(int config,
                              int commutMode,
                              int scenarioMode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setAudioConfig: config=%d, commutMode=%d, " +
                "scenarioMode=%d", config, commutMode, scenarioMode);

        mAudioConfig = config;
        mCommutMode = commutMode;
        mScenarioMode = scenarioMode;
        return 0;
    }

    /**
     * 设置是否外放
     *
     * @param enabled
     * @return
     */
    public int enableLoudspeaker(boolean enabled) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableLoudspeaker: %b", enabled);

        ThunderAPI.sharedInstance().getPlayer().enableLoudSpeaker(enabled);
        return 0;
    }

    /**
     * 是否是扬声器状态
     *
     * @return
     */
    public boolean isLoudspeakerEnabled() {
        return ThunderAPI.sharedInstance().getPlayer().getLoudSpeakerEnabled();
    }

    /**
     * 打开用户音量回调
     *
     * @param interval    <=0: 禁用音量提示功能 >0: 回调间隔，单位为毫秒
     * @param moreThanThd 从<moreThanThd到>=moreThanThd，立即回调一次 <=0无效
     * @param lessThanThd 从>=lessThanThd到<lessThanThd，立即回调一次 <=0无效
     * @param smooth      平滑系数，未实现
     * @return
     */
    public int setAudioVolumeIndication(int interval,
                                        int moreThanThd,
                                        int lessThanThd,
                                        int smooth) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setAudioVolumeIndication: interval=%d," +
                "moreThanThd=%d, lessThanThd=%d, smooth=%d", interval, moreThanThd, lessThanThd, smooth);

        ThunderAPI.sharedInstance().setPlayVolumeInterval(interval, moreThanThd, lessThanThd);
        return 0;
    }

    /**
     * 打开采集音量回调
     *
     * @param interval    <=0: 禁用音量提示功能 >0: 回调间隔，单位为毫秒
     * @param moreThanThd 从<moreThanThd到>=moreThanThd，立即回调一次 <=0无效
     * @param lessThanThd 从>=lessThanThd到<lessThanThd，立即回调一次 <=0无效
     * @param smooth      未实现
     * @return
     */
    public int enableCaptureVolumeIndication(int interval,
                                             int moreThanThd,
                                             int lessThanThd,
                                             int smooth) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableCaptureVolumeIndication: interval=%d," +
                "moreThanThd=%d, lessThanThd=%d, smooth=%d", interval, moreThanThd, lessThanThd, smooth);

        ThunderAPI.sharedInstance().setCaptureVolumeInterval(interval, moreThanThd, lessThanThd);
        return 0;
    }

    /**
     * 开始将音频数据保存成aac格式的文件
     *
     * @param fileName  文件保存路径,必须是完整路径，包括文件名，文件名的后缀必须是.aac。其中保存文件的文件夹必须是已经创建好的，该接口不提供创建文件夹的功能。例如：/sdcard/helloworld.aac
     * @param saverMode =ThunderRtcConstant.AudioSaverMode.
     *                  THUNDER_AUDIO_SAVER_ONLY_CAPTURE = 只保存频道内所有的上行的音频数据。上行的音频数据指的是：无论是主播的音频数据还是是伴奏的音频数据，只有被设置成上行，才被保存
     *                  THUNDER_AUDIO_SAVER_ONLY_RENDER = 保存频道内除主播以外的音频数据，例如：伴奏的音频数据和观众端的音频数据
     *                  THUNDER_AUDIO_SAVER_BOTH = 保存频道内所有的音频数据
     * @param fileMode  = ThunderRtcConstant.AudioSaverWfMode.
     *                  THUNDER_AUDIO_SAVER_FILE_APPEND = 追加打开一个文本文件，并在文件末尾写数据
     *                  THUNDER_AUDIO_SAVER_FILE_OVERRIDE = 打开一个文本文件，写入的数据会覆盖文件本身的内容
     * @return true:成功 false:失败
     */
    public boolean startAudioSaver(String fileName, int saverMode, int fileMode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "startAudioSaver: fileName=%s," +
                "saverMode=%d, fileMode=%d", getPrintString(fileName), saverMode, fileMode);

        if (fileName.isEmpty()) {
            return false;
        }
        return ThunderAPI.sharedInstance().startAudioSaver(fileName, saverMode, fileMode);
    }

    /**
     * 停止将音频数据保存成aac格式的文件
     *
     * @return true:成功 false:失败
     */
    public boolean stopAudioSaver() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopAudioSaver");

        return ThunderAPI.sharedInstance().stopAudioSaver();
    }

    /**
     * 设置不同的音效模式
     *
     * @param mode =ThunderRtcConstant.SoundEffectMode.
     *             THUNDER_SOUND_EFFECT_MODE_NONE               = 关闭模式
     *             THUNDER_SOUND_EFFECT_MODE_VALLEY             = VALLEY模式
     *             THUNDER_SOUND_EFFECT_MODE_RANDB              = R&B模式
     *             THUNDER_SOUND_EFFECT_MODE_KTV                = KTV模式
     *             THUNDER_SOUND_EFFECT_MODE_CHARMING           = CHARMING模式
     *             THUNDER_SOUND_EFFECT_MODE_POP                = 流行模式
     *             THUNDER_SOUND_EFFECT_MODE_HIPHOP             = 嘻哈模式
     *             THUNDER_SOUND_EFFECT_MODE_ROCK               = 摇滚模式
     *             THUNDER_SOUND_EFFECT_MODE_CONCERT            = 演唱会模式
     *             THUNDER_SOUND_EFFECT_MODE_STUDIO             = 录音棚模式
     */
    public void setSoundEffect(int mode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "ThunderEngine::setSoundEffect %d", mode);

        ThunderAPI.sharedInstance().getPublisher().setSoundEffect(mode);
    }

    /**
     * 设置变声模式
     *
     * @param mode =ThunderRtcConstant.VoiceChangerMode.
     *             THUNDER_VOICE_CHANGER_NONE                = 关闭模式
     *             THUNDER_VOICE_CHANGER_ETHEREAL            = 空灵
     *             THUNDER_VOICE_CHANGER_THRILLER            = 惊悚
     *             THUNDER_VOICE_CHANGER_LUBAN               = 鲁班
     *             THUNDER_VOICE_CHANGER_LORIE               = 萝莉
     *             THUNDER_VOICE_CHANGER_UNCLE               = 大叔
     *             THUNDER_VOICE_CHANGER_DIEFAT              = 死肥仔
     *             THUNDER_VOICE_CHANGER_BADBOY              = 熊孩子
     *             THUNDER_VOICE_CHANGER_WRACRAFT            = 魔兽农民
     *             THUNDER_VOICE_CHANGER_HEAVYMETAL          = 重金属
     *             THUNDER_VOICE_CHANGER_COLD                = 感冒
     *             THUNDER_VOICE_CHANGER_HEAVYMECHINERY      = 重机械
     *             THUNDER_VOICE_CHANGER_TRAPPEDBEAST        = 困兽
     *             THUNDER_VOICE_CHANGER_POWERCURRENT        = 强电流
     */
    public void setVoiceChanger(int mode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "ThunderEngine::setVoiceChanger %d", mode);
        ThunderAPI.sharedInstance().getPublisher().setVoiceChanger(mode);
    }

    /*
     * 是否静音自己
     * @param stop
     * @return
     */
    public int stopLocalAudioStream(boolean stop) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopLocalAudioStream: %b", stop);

        int volume = 80;
        if (stop) {
            volume = 0;
        }
        ThunderAPI.sharedInstance().getPublisher().setMicVolume(volume);

        return 0;
    }

    /**
     * 是否静音所有播放声音
     *
     * @param stop
     * @return
     */
    public int stopAllRemoteAudioStreams(boolean stop) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopAllRemoteAudioStreams: %b", stop);

        ThunderAPI.sharedInstance().getPlayer().enableAllMute(stop);
        return 0;
    }

    /**
     * 是否静音某个用户的声音
     *
     * @param uid
     * @param stop
     * @return
     */
    public int stopRemoteAudioStream(String uid, boolean stop) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopRemoteAudioStream: uid=%s, %b", getPrintString(uid), stop);

        ThunderStream stream = new ThunderStream();
        if (mIs32bitUid) {
            try {
                stream.speakerUid = Long.parseLong(uid);
            } catch (NumberFormatException exception) {
                return -1;
            }
        } else {
            if (uid == null) {
                return -2;
            }
            ThunderAPI.sharedInstance().getPlayer().enableMute(stop, uid);
            stream.speakerUid = getIntUid(uid);
            if (stream.speakerUid == 0) {
                return 0;
            }
        }
        ThunderAPI.sharedInstance().getPlayer().enableMute(stop, stream);
        return 0;
    }

    /**
     * 该方法设定外放(扬声器)音量。
     *
     * @param volume
     * @return
     */
    public int setLoudSpeakerVolume(int volume) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setLoudSpeakerVolume: %d", volume);

        boolean bResult = ThunderAPI.sharedInstance().getPlayer().setSpeakerVolume(volume);

        if (bResult) {
            return 0;
        } else {
            return -1;
        }
    }

    /**
     * 设置麦克风音量
     *
     * @param volume
     * @return
     */
    public int setMicVolume(int volume) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setMicVolume: %d", volume);

        boolean bResult = ThunderAPI.sharedInstance().getPublisher().setMicVolume(volume);
        if (bResult) {
            return 0;
        } else {
            return -1;
        }
    }

    /**
     * @param uid
     * @param volume
     * @return
     */
    public int setRemoteAudioStreamsVolume(String uid, int volume) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setRemoteAudioStreamsVolume: uid=%s, volume=%d",
                getPrintString(uid), volume);

        if (!mBGroupSubscribe) {
            return -1;
        }
        ThunderStream stream = new ThunderStream();
        if (mIs32bitUid) {
            try {
                stream.speakerUid = Long.parseLong(uid);
            } catch (NumberFormatException exception) {
                return -1;
            }
        } else {
            stream.speakerUid = getIntUid(uid);
            if (stream.speakerUid == 0) {
                if (isNumeric(uid)) {
                    try {
                        stream.speakerUid = Long.parseLong(uid);
                    } catch (NumberFormatException exception) {
                        return -2;
                    }
                } else {
                    return -3;
                }
            }
        }
        if (ThunderAPI.sharedInstance().getPlayer().setPlayVolume(volume, stream)) {
            return 0;
        }
        return -4;

    }


    /**
     * 创建文件播放对象
     *
     * @return 播放器对象
     */
    public ThunderAudioFilePlayer createAudioFilePlayer() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "createAudioFilePlayer");

        ThunderAudioFilePlayer audioFilePlayer = new ThunderAudioFilePlayer();
        mAudioFilePlayerSet.add(audioFilePlayer);
        return audioFilePlayer;
    }

    /**
     * 销毁文件播放对象
     *
     * @param audioFilePlayer
     */
    public void destroyAudioFilePlayer(ThunderAudioFilePlayer audioFilePlayer) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "destroyAudioFilePlayer: %s", getPrintString(audioFilePlayer));

        if (audioFilePlayer == null) {
            return;
        }
        audioFilePlayer.destroyAudioFilePlayer();
        mAudioFilePlayerSet.remove(audioFilePlayer);
    }

    /**
     * 使能均衡器
     *
     * @param enabled
     * @return
     */
    public int setEnableEqualizer(boolean enabled) {
        mBEnableEqualizer = enabled;
        ThunderAPI.sharedInstance().getPublisher().EnableEqualizer(enabled);
        return 0;
    }

    /**
     * 设置均衡器参数
     *
     * @param gains -12 <= gains[i] <= 12, 0<=i<=10
     * @return
     */
    public int setEqGains(final int[] gains) {
        if (gains == null) {
            return -1;
        }

        if (gains.length < 11) {
            return -2;
        }

        for (int i = 0; i <= 10; ++i) {
            if (gains[i] < -12 || gains[i] > 12) {
                return -3;
            }
        }

        mEqGains = gains;
        ThunderAPI.sharedInstance().getPublisher().SetGqGains(gains);
        return 0;
    }

    /**
     * 使能混响
     *
     * @param enabled
     * @return
     */
    public int setEnableReverb(boolean enabled) {
        mBEnableReverbEx = enabled;
        ThunderAPI.sharedInstance().getPublisher().EnableReverb(enabled);
        return 0;
    }

    /**
     * 设置混响参数
     *
     * @param param
     * @return
     * @see ReverbExParameter
     */
    public int setReverbExParameter(ReverbExParameter param) {
        if (param == null) {
            return -1;
        }

        if ((param.mRoomSize < 0.0 || param.mRoomSize > 100.0) ||
                (param.mPreDelay < 0.0 || param.mPreDelay > 200.0) ||
                (param.mReverberance < 0.0 || param.mReverberance > 100.0) ||
                (param.mHfDamping < 0.0 || param.mHfDamping > 100.0) ||
                (param.mToneLow < 0.0 || param.mToneLow > 100.0) ||
                (param.mToneHigh < 0.0 || param.mToneHigh > 100.0) ||
                (param.mWetGain < -20.0 || param.mWetGain > 10.0) ||
                (param.mDryGain < -20.0 || param.mDryGain > 10.0) ||
                (param.mStereoWidth < 0.0 || param.mStereoWidth > 100.0)
        ) {
            return -2;
        }

        mReverbExGains = param;
        ThunderAPI.sharedInstance().getPublisher().setReverbExParameter(
                param.mRoomSize,
                param.mPreDelay,
                param.mReverberance,
                param.mHfDamping,
                param.mToneLow,
                param.mToneHigh,
                param.mWetGain,
                param.mDryGain,
                param.mStereoWidth);
        return 0;
    }

    /**
     * 使能压缩器
     *
     * @param enabled
     * @return
     */
    public int setEnableCompressor(boolean enabled) {
        mBEnableCompressor = enabled;
        ThunderAPI.sharedInstance().getPublisher().EnableCompressor(enabled);
        return 0;
    }

    /**
     * 设置压缩器参数
     *
     * @param param
     * @return
     * @see CompressorParam
     */
    public int setCompressorParam(CompressorParam param) {
        if (param == null) {
            return -1;
        }

        if ((param.mThreshold < -10 || param.mThreshold > 0) ||
                (param.mReleaseTime <= 0) || (param.mAttackTime <= 0)) {
            return -2;
        }

        mCompressorGains = param;
        ThunderAPI.sharedInstance().getPublisher().SetCompressorParam(
                param.mThreshold,
                param.mMakeupGain,
                param.mRatio,
                param.mKnee,
                param.mReleaseTime,
                param.mAttackTime);
        return 0;
    }

    /**
     * 使能压限器
     *
     * @param enabled
     * @return
     */
    public int setEnableLimiter(boolean enabled) {
        mBEnableLimiter = enabled;
        ThunderAPI.sharedInstance().getPublisher().EnableLimiter(enabled);
        return 0;
    }

    /**
     * 设置压限器参数
     *
     * @param param
     * @return
     * @see LimterParam
     */
    public int setLimiterParam(LimterParam param) {
        if (param == null) {
            return -1;
        }

        mLimiterGins = param;
        ThunderAPI.sharedInstance().getPublisher().SetLimiterParam(
                param.fCeiling,
                param.fThreshold,
                param.fPreGain,
                param.fRelease,
                param.fAttack,
                param.fLookahead,
                param.fLookaheadRatio,
                param.fRMS,
                param.fStLink);
        return 0;
    }

    /**
     * 设置外部音频处理器
     *
     * @param eap, eap是个C 函数指针数组，长度为6，每个函数的类型为：
     *             typedef void (*OnCaptureStartFun)(void*obj);
     *             typedef void (*OnCaptureDataFun)(void*obj, void* pData, uint32_t len, uint32_t sampleRate, uint32_t channelCount, uint32_t bitPerSample);
     *             typedef void (*OnCaptureStopFun)(void*obj);
     *             typedef void (*OnRenderStartFun)(void*obj);
     *             typedef void (*OnRenderDataFun)(void*obj, void* pData, uint32_t len, uint32_t sampleRate, uint32_t channelCount, uint32_t bitPerSample);
     *             typedef void (*OnRenderStopFun)(void*obj);
     */
    public void setExternalAudioProcessor(long eap) {
        ThunderAPI.sharedInstance().setExternalAudioProcessor(eap);
    }

    /**
     * 打开关闭音频播放频谱数据回调
     * 如果打开了，会收到{@link ThunderEventHandler#onAudioPlaySpectrumData} 回调
     */
    public void enableAudioPlaySpectrum(boolean enable) {
        ThunderAPI.sharedInstance().enableAudioPlaySpectrum(enable);
    }

    /**
     * 设置音频播放频谱数据回调信息
     *
     * @param spectrumLen      频谱数据的长度 [12 - 256]，默认是256
     * @param notifyIntervalMS 频谱回调的间隔，必须是10的倍数，默认是30MS
     */
    public void setAudioPlaySpectrumInfo(int spectrumLen, int notifyIntervalMS) {
        ThunderAPI.sharedInstance().setAudioPlaySpectrumInfo(spectrumLen, notifyIntervalMS);
    }

    /**
     * 用户发送透传消息
     *
     * @param msgData 发送的消息
     *                <br> 调用此接口条件:
     *                1、用户在频道内
     *                2、开麦成功后调用(纯观众和开播鉴权失败都不能发)
     *                3、调用该接口的频率每秒不能超过2次,msgData的大小不能超过200Byte
     *                <br> 不满足以上条件msg都会被丢弃
     *                <br> 通过监听YYLiveRtcEventHandler中的onRecvUserAppMsgData接收其他透传的消息
     *                <br> 通过监听YYLiveRtcEventHandler中的onSendAppMsgDataFailedStatus获得发送该msg发送失败的原因
     */
    public int sendUserAppMsgData(byte[] msgData) {
        ThunderAPI.sharedInstance().sendUserAppMsgData(msgData);
        return 0;
    }

    /**
     * 打开关闭音频数据回调
     *
     * @param enablePlay 打开播放数据回调
     */
    public void enableAudioDataIndication(boolean enablePlay) {
        mBEnablePlayDataIndication = enablePlay;

        ThunderAPI.sharedInstance().enableAudioDataIndication(enablePlay);
    }

    /**
     * 打开关闭音频采集回调
     *
     * @param enable     打开采集数据回调
     * @param sampleRate 设置需要回调数据的采样率，取值范围[-1,8000,16000,44100,48000]
     * @param room       设置需要回调数据的声道数，取值范围[-1,1,2]
     *                   <br> 只要sampleRate和room其中一个参数的取值为-1，回调的数据是没有经过重采样的原始数据
     */
    public void enableCapturePcmDataCallBack(boolean enable, int sampleRate, int room) {
        ThunderAPI.sharedInstance().enableCapturePcmDataCallBack(enable, sampleRate, room);
    }

    /**
     * 打开关闭渲染音频数据回调
     *
     * @param enable     打开渲染音频数据回调
     * @param sampleRate 设置需要回调数据的采样率，取值范围[-1,8000,16000,44100,48000]
     * @param room       设置需要回调数据的声道数，取值范围[-1,1,2]
     *                   <br> 只要sampleRate和room其中一个参数的取值为-1，回调的数据是没有经过重采样的原始数据
     */
    public boolean enableRenderPcmDataCallBack(boolean enable, int sampleRate, int room) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableRenderPcmDataCallBack enable = %b sampleRate: %d, room = %d ", enable, sampleRate, room);

        return ThunderAPI.sharedInstance().enableRenderPcmDataCallBack(enable, sampleRate, room);

    }

    /**
     * 是否将当前播放的文件作为直播伴奏使用(可替代enablePublish)
     * <br>
     *
     * @param sourceType {@link ThunderRtcConstant.SourceType }
     *                   THUNDER_PUBLISH_MODE_MIC   = 0; //麦克风
     *                   THUNDER_PUBLISH_MODE_FILE  = 1; //文件
     *                   THUNDER_PUBLISH_MODE_MIX   = 2; //文件+麦克风
     *                   THUNDER_PUBLISH_MODE_NONE  = 10, //停止所有音频数据上行
     */
    public void setAudioSourceType(int sourceType) {
        ThunderLog.release(ThunderLog.kLogTagCall, "setAudioSourceType: sourceType=%d", sourceType);

        ThunderAPI.sharedInstance().getPublisher().setAudioSourceType(sourceType);
    }

    /**
     * 打开关闭耳返
     *
     * @param enable true=打开，false=关闭；默认为关闭状态
     * @return
     */
    public int setEnableInEarMonitor(boolean enable) {
        ThunderLog.release(ThunderLog.kLogTagCall, "setEnableInEarMonitor: %b", enable);

        if (ThunderAPI.sharedInstance().getPublisher().enableInEarMonitor(enable)) {
            return 0;
        } else {
            return -1;
        }
    }

    /**
     * {@link IAudioFrameObserver} 接口对象实例；如果传入 null，则取消注册
     *
     * @param observer
     * @return
     */
    public int registerAudioFrameObserver(IAudioFrameObserver observer) {

        return ThunderAPI.sharedInstance().registerAudioFrameObserver(observer);
    }

    /**
     * 设置回调采集数据的格式
     *
     * @param sampleRate     指定 onRecordFrame 中返回数据的采样率，可设置为 8000，16000，32000，44100 或 48000
     * @param room           指定 onRecordFrame 中返回数据的通道数，可设置为 1（单声道） 或 2（双声道）
     * @param mode           指定 onRecordFrame 的使用模式:{@link ThunderRtcConstant.ThunderAudioRawFrameOperationMode}
     * @param samplesPerCall 指定 onRecordFrame 中返回数据的采样点数，如 RTMP 推流应用中通常为 1024。
     * @return
     */
    public int setRecordingAudioFrameParameters(int sampleRate, int room, int mode, int samplesPerCall) {

        return ThunderAPI.sharedInstance().setRecordingAudioFrameParameters(sampleRate, room, mode, samplesPerCall);
    }

    /**
     * 设置回调播放数据的格式
     *
     * @param sampleRate     指定 onPlaybackFrame 中返回数据的采样率，可设置为 8000，16000，32000，44100 或 48000
     * @param room           指定 onPlaybackFrame 中返回数据的通道数，可设置为 1（单声道） 或 2（双声道）
     * @param mode           指定 onPlaybackFrame 的使用模式:{@link ThunderRtcConstant.ThunderAudioRawFrameOperationMode}
     * @param samplesPerCall 指定 onPlaybackFrame 中返回数据的采样点数，如 RTMP 推流应用中通常为 1024。
     * @return
     */
    public int setPlaybackAudioFrameParameters(int sampleRate, int room, int mode, int samplesPerCall) {
        return ThunderAPI.sharedInstance().setPlaybackAudioFrameParameters(sampleRate, room, mode, samplesPerCall);
    }

    private void tryStopPublish() {
        if (mBAudioPublish) {
            ThunderAPI.sharedInstance().getPublisher().stopPublishAudio();
            mBAudioPublish = false;
            mStringName = "";
        }
    }

    private boolean isNumeric(String strNum) {

        Pattern pattern = Pattern.compile("^\\d+$");
        String bigStr;
        try {
            bigStr = new BigDecimal(strNum).toString();
        } catch (Exception e) {
            return false;
        }

        Matcher isNum = pattern.matcher(bigStr);
        if (!isNum.matches()) {
            return false;
        }
        return true;
    }

    private void tryStopSubscribe() {
        if (mBGroupSubscribe) {
            ArrayList<ThunderGroup> audioGroup = new ArrayList<ThunderGroup>(0);
            ThunderGroup oneGroup = new ThunderGroup();
            oneGroup.appId = mRoomAppId;
            oneGroup.groupName = "g_" + mRoomName;
            audioGroup.add(oneGroup);
            ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(null, audioGroup);
            mBGroupSubscribe = false;
        }
    }

    private void addUid2String(int iUid, String strUid) {
        removeUid2String(strUid);
        synchronized (this) {
            mUidToStringMap.put(iUid, strUid);
        }
    }

    private String getStringUid(int iUid) {
        synchronized (this) {
            return mUidToStringMap.get(iUid);
        }
    }

    private int getIntUid(String strUid) {
        int iUid = 0;
        synchronized (this) {
            if (strUid != null && strUid.length() != 0) {
                Iterator<Integer> iter = mUidToStringMap.keySet().iterator();
                Integer key;
                while (iter.hasNext()) {
                    key = iter.next();
                    if (strUid.equals(mUidToStringMap.get(key))) {
                        iUid = key;
                        break;
                    }
                }
            }
        }
        return iUid;
    }

    private void removeUid2String(int iUid) {
        synchronized (this) {
            mUidToStringMap.remove(iUid);
        }
    }

    private void removeUid2String(String strUid) {
        synchronized (this) {
            if (strUid != null && strUid.length() != 0) {
                Iterator<Integer> iter = mUidToStringMap.keySet().iterator();
                Integer key;
                while (iter.hasNext()) {
                    key = iter.next();
                    if (strUid.equals(mUidToStringMap.get(key))) {
                        mUidToStringMap.remove(key);
                        break;
                    }
                }
            }
        }
    }

    private void removeAllUid2String() {
        synchronized (this) {
            mUidToStringMap.clear();
        }
    }

    private void resetRtcEngine() {
        //static info
        mHandler = null;
        sMyAppId = 0;
        sMySceneId = 0;

        mRtcEventHandler = null;
        mHttpsRequestHandler = null;

        //my info
        mMyUid = 0;
        mIs32bitUid = false;
        mMyStrUid = "";
        //uid info
        mUidToStringMap = new HashMap<Integer, String>();

        //log info
        mLogLevel = ThunderRtcConstant.LogLevel.THUNDER_LOG_LEVEL_TRACE;
        mLogPath = "";
        mYyLogCallback = null;

        //audio srbscribe
        mBGroupSubscribe = false;
        mBAudioPublish = false;

        //room info
        mRoomAppId = 0;
        mRoomName = "";

        //room config
        mRoomConfig = ThunderRtcConstant.RoomConfig.THUNDER_ROOMCONFIG_LIVE;
        //audio config
        mAudioConfig = ThunderRtcConstant.AudioConfig.THUNDER_AUDIO_CONFIG_DEFAULT;
        mCommutMode = ThunderRtcConstant.CommutMode.THUNDER_COMMUT_MODE_DEFAULT;
        mScenarioMode = ThunderRtcConstant.ScenarioMode.THUNDER_SCENARIO_MODE_DEFAULT;

        //switch
        s_playVolumeNotifyCount = 0;
        s_playDataNotifyCount = 0;
        mBEnablePlayDataIndication = false;

        // Equalizer
        mEqGains = new int[11];
        mBEnableEqualizer = false;
        mBEnableCompressor = false;
        mBEnableLimiter = false;
        mBEnableReverbEx = false;
        mReverbExGains = new ReverbExParameter();
        mCompressorGains = new CompressorParam();
        mLimiterGins = new LimterParam();

        // audioFilePlayer
        for (ThunderAudioFilePlayer audioFilePlayer : mAudioFilePlayerSet) {
            audioFilePlayer.destroyAudioFilePlayer();
        }
        mAudioFilePlayerSet.clear();
    }

    private String getPrintString(String str) {
        String result = "";
        if (str != null) {
            result = str;
        }

        return result;
    }

    private String getPrintString(byte[] data) {
        String result = "";
        if (data != null) {
            result = data.toString();
        }

        return result;
    }

    private String getPrintString(Object obj) {
        String result = "";
        if (obj != null) {
            result = obj.toString();
        }

        return result;
    }
}

