package com.yy.yylivesdk4cloud;

import android.view.MotionEvent;

import com.yy.mediaframework.VideoPublish;
import com.yy.mediaframework.YYCamera;
import com.yy.mediaframework.gpuimage.custom.OrangeFilterWrapper;

/**
 * Created by jping on 2019/1/22.
 *
 * 该类用于直接访问算法库中的方法
 */

public class ThunderBridgeLib {


    private ThunderBridgeLib() {

    }

    private static class SingletonHolder {
        private static final ThunderBridgeLib INSTANCE = new ThunderBridgeLib();
    }

    public static ThunderBridgeLib getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /**
     * 获取美颜接口
     * @return
     */
    public OrangeFilterWrapper getBeautyFilter(){
        return VideoPublish.getInstance().getOrangeFilterWrapperObject();
    }

    /**
     * 判断当前打开的摄像头是否支持zoom功能
     * @return
     */
    public boolean isCameraZoomSupport() {
        return YYCamera.getInstance().isZoomSupport();
    }

    /**
     * 获取当前打开摄像头的最大zoom参数
     * @return
     */
    public int getCameraMaxZoom() {
        return YYCamera.getInstance().getMaxZoom();
    }


    /**
     * 设置当前摄像头的zoom参数
     * @param zoom 目标zoom参数
     * @return 设置后 实际的zoom参数
     */
    public float setCameraZoom(final int zoom) {

        return YYCamera.getInstance().setZoom(zoom);
    }

    /**
     * 聚焦以及测光
     * @param event
     */
    public void handleFocusMetering(final MotionEvent event) {
        YYCamera.getInstance().handleFocusMetering(event);
    }

}
