/*
 * Decompiled with CFR 0.152.
 */
package org.android.agoo.oppo;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.coloros.mcssdk.PushManager;
import com.coloros.mcssdk.callback.PushAdapter;
import com.coloros.mcssdk.callback.PushCallback;
import com.coloros.mcssdk.mode.SubscribeResult;
import com.taobao.accs.utl.ALog;
import com.taobao.accs.utl.UtilityImpl;
import com.taobao.agoo.BaseNotifyClickActivity;
import java.util.List;
import org.android.agoo.control.NotifManager;
import org.android.agoo.oppo.OppoMsgParseImpl;

public class OppoRegister {
    public static final String TAG = "OppoPush";
    private static final String OPPO_TOKEN = "OPPO_TOKEN";
    private static Context mContext;
    private static PushCallback mPushCallback;

    public static void register(Context context, String appKey, String appSecret) {
        try {
            mContext = context.getApplicationContext();
            if (!UtilityImpl.isMainProcess((Context)mContext)) {
                ALog.i((String)TAG, (String)"not in main process, return", (Object[])new Object[0]);
                return;
            }
            if (PushManager.isSupportPush((Context)mContext)) {
                BaseNotifyClickActivity.addNotifyListener((BaseNotifyClickActivity.INotifyListener)new OppoMsgParseImpl());
                PushCallback pushCallback = mPushCallback;
                ALog.i((String)TAG, (String)"register oppo begin ", (Object[])new Object[0]);
                PushManager.getInstance().register(mContext, appKey, appSecret, pushCallback);
            } else {
                ALog.i((String)TAG, (String)"not support oppo push", (Object[])new Object[0]);
            }
        }
        catch (Throwable t) {
            ALog.e((String)TAG, (String)"register error", (Throwable)t, (Object[])new Object[0]);
        }
    }

    public static void unregister() {
        ALog.i((String)TAG, (String)"unregister", (Object[])new Object[0]);
        PushManager.getInstance().unRegister();
    }

    public static void setPushCallback(PushCallback pushCallback) {
        ALog.i((String)TAG, (String)"setPushCallback", (Object[])new Object[0]);
        PushManager.getInstance().setPushCallback(pushCallback);
    }

    public static void pausePush() {
        ALog.w((String)TAG, (String)"pausePush", (Object[])new Object[0]);
        PushManager.getInstance().pausePush();
    }

    public static void resumePush() {
        ALog.w((String)TAG, (String)"resumePush", (Object[])new Object[0]);
        PushManager.getInstance().resumePush();
    }

    private static void reportToken(Context context, String token) {
        if (!TextUtils.isEmpty((CharSequence)token) && context != null) {
            NotifManager notifyManager = new NotifManager();
            notifyManager.init(context.getApplicationContext());
            notifyManager.reportThirdPushToken(token, OPPO_TOKEN, false);
        }
    }

    static {
        mPushCallback = new PushAdapter(){

            public void onRegister(int code, String regid) {
                if (code == 0) {
                    ALog.i((String)OppoRegister.TAG, (String)("onRegister regid=" + regid), (Object[])new Object[0]);
                    OppoRegister.reportToken(mContext, regid);
                } else {
                    ALog.e((String)OppoRegister.TAG, (String)("onRegister code=" + code + ",regid=" + regid), (Object[])new Object[0]);
                }
            }

            public void onUnRegister(int code) {
                Log.i((String)OppoRegister.TAG, (String)("onUnRegister code=" + code));
            }

            public void onGetAliases(int code, List<SubscribeResult> list) {
            }

            public void onSetAliases(int code, List<SubscribeResult> list) {
            }

            public void onUnsetAliases(int code, List<SubscribeResult> list) {
            }

            public void onSetUserAccounts(int code, List<SubscribeResult> list) {
            }

            public void onUnsetUserAccounts(int code, List<SubscribeResult> list) {
            }

            public void onGetUserAccounts(int code, List<SubscribeResult> list) {
            }

            public void onSetTags(int code, List<SubscribeResult> list) {
            }

            public void onUnsetTags(int code, List<SubscribeResult> list) {
            }

            public void onGetTags(int code, List<SubscribeResult> list) {
            }

            public void onGetPushStatus(int code, int status) {
            }

            public void onGetNotificationStatus(int code, int status) {
            }

            public void onSetPushTime(int code, String s) {
            }
        };
    }
}

