/*
 * Decompiled with CFR 0.152.
 */
package org.libpag;

import android.graphics.SurfaceTexture;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.Surface;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

public class VideoSurface
implements SurfaceTexture.OnFrameAvailableListener {
    private static HandlerThread handlerThread;
    private static int HandlerThreadCount;
    private static final Object handlerLock;
    private int width = 0;
    private int height = 0;
    private Surface outputSurface;
    private SurfaceTexture surfaceTexture;
    private final Object frameSyncObject = new Object();
    private boolean frameAvailable = false;
    private boolean released = false;
    private int retainCount = 1;

    private static synchronized void StartHandlerThread() {
        ++HandlerThreadCount;
        if (handlerThread == null) {
            handlerThread = new HandlerThread("libpag_VideoSurface");
            handlerThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VideoSurface Make(int width, int height) {
        VideoSurface videoSurface = new VideoSurface();
        videoSurface.width = width;
        videoSurface.height = height;
        Object object = handlerLock;
        synchronized (object) {
            VideoSurface.StartHandlerThread();
            if (Build.VERSION.SDK_INT >= 26) {
                videoSurface.surfaceTexture = new SurfaceTexture(false);
            } else {
                videoSurface.surfaceTexture = new SurfaceTexture(0);
                videoSurface.surfaceTexture.detachFromGLContext();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                videoSurface.surfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)videoSurface, new Handler(handlerThread.getLooper()));
            } else {
                videoSurface.surfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)videoSurface);
                videoSurface.reflectLooper();
            }
        }
        videoSurface.outputSurface = new Surface(videoSurface.surfaceTexture);
        return videoSurface;
    }

    private void reflectLooper() {
        Class<?>[] innerClassArray = SurfaceTexture.class.getDeclaredClasses();
        Class<?> eventHandlerClass = null;
        for (Class<?> innerC : innerClassArray) {
            if (!innerC.getName().toLowerCase().contains("handler")) continue;
            eventHandlerClass = innerC;
            break;
        }
        if (eventHandlerClass == null) {
            return;
        }
        Class[] paramTypes = new Class[]{SurfaceTexture.class, Looper.class};
        try {
            Constructor<?> eventHandlerConstructor = eventHandlerClass.getConstructor(paramTypes);
            Object eventHandlerObj = eventHandlerConstructor.newInstance(this.surfaceTexture, handlerThread.getLooper());
            Class<?> classType = this.surfaceTexture.getClass();
            Field field = classType.getDeclaredField("mEventHandler");
            field.setAccessible(true);
            field.set(this.surfaceTexture, eventHandlerObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture st) {
        Object object = this.frameSyncObject;
        synchronized (object) {
            if (this.frameAvailable) {
                new RuntimeException("frameAvailable already set, frame could be dropped").printStackTrace();
                return;
            }
            this.frameAvailable = true;
            this.frameSyncObject.notifyAll();
        }
    }

    public Surface getOutputSurface() {
        return this.outputSurface;
    }

    private int videoWidth() {
        float[] matrix = new float[16];
        this.surfaceTexture.getTransformMatrix(matrix);
        float scale = Math.abs(matrix[0]);
        if (scale > 0.0f) {
            return Math.round((float)this.width / (scale + matrix[12] * 2.0f));
        }
        return this.width;
    }

    private int videoHeight() {
        float[] matrix = new float[16];
        this.surfaceTexture.getTransformMatrix(matrix);
        float scale = Math.abs(matrix[5]);
        if (scale > 0.0f) {
            return Math.round((float)this.height / (scale + (matrix[13] - scale) * 2.0f));
        }
        return this.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateTexImage() {
        int TIMEOUT_MS = 50;
        int needRetryTimes = 10;
        Object object = this.frameSyncObject;
        synchronized (object) {
            while (!this.frameAvailable && needRetryTimes > 0) {
                try {
                    --needRetryTimes;
                    this.frameSyncObject.wait(50L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
            this.frameAvailable = false;
            if (needRetryTimes == 0) {
                return false;
            }
        }
        try {
            this.surfaceTexture.updateTexImage();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean attachToGLContext(int texName) {
        try {
            this.surfaceTexture.attachToGLContext(texName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void retain() {
        ++this.retainCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        --this.retainCount;
        if (this.released || this.retainCount > 0) {
            return;
        }
        this.released = true;
        Object object = handlerLock;
        synchronized (object) {
            if (--HandlerThreadCount == 0) {
                handlerThread.quit();
                handlerThread = null;
            }
        }
        if (this.outputSurface != null) {
            this.outputSurface.release();
            this.outputSurface = null;
        }
        if (this.surfaceTexture != null) {
            this.surfaceTexture.release();
            this.surfaceTexture = null;
        }
    }

    static {
        HandlerThreadCount = 0;
        handlerLock = new Object();
    }
}

