/*
 * Decompiled with CFR 0.152.
 */
package org.libpag;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;

class SynchronizeHandler
extends Handler {
    public SynchronizeHandler(Looper looper) {
        super(looper);
    }

    public final boolean runSync(TimeoutRunnable r, long timeout) {
        if (r == null) {
            throw new IllegalArgumentException("runnable must not be null");
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must be non-negative");
        }
        if (Looper.myLooper() == this.getLooper()) {
            r.run();
            return true;
        }
        BlockingRunnable br = new BlockingRunnable(r);
        return br.postAndWait(this, timeout);
    }

    private static final class BlockingRunnable
    implements Runnable {
        private final TimeoutRunnable mTask;
        private boolean mDone;
        private boolean isTimeout = false;

        public BlockingRunnable(TimeoutRunnable task) {
            this.mTask = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.mTask.run();
            }
            finally {
                BlockingRunnable blockingRunnable = this;
                synchronized (blockingRunnable) {
                    this.mDone = true;
                    this.notifyAll();
                    this.mTask.afterRun(this.isTimeout);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean postAndWait(Handler handler, long timeout) {
            if (!handler.post((Runnable)this)) {
                return false;
            }
            BlockingRunnable blockingRunnable = this;
            synchronized (blockingRunnable) {
                if (timeout > 0L) {
                    long expirationTime = SystemClock.uptimeMillis() + timeout;
                    while (!this.mDone) {
                        long delay = expirationTime - SystemClock.uptimeMillis();
                        if (delay <= 0L) {
                            this.isTimeout = true;
                            return false;
                        }
                        try {
                            this.wait(delay);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else {
                    while (!this.mDone) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            return true;
        }
    }

    static interface TimeoutRunnable
    extends Runnable {
        public void afterRun(boolean var1);
    }
}

